/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.Replaceable;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeSet;

final class NormalizationTransliterator
extends Transliterator {
    static final boolean DEBUG = false;
    private Normalizer.Mode mode;
    private int options;
    static final UnicodeSet[] UNSAFE_STARTS = new UnicodeSet[4];
    static final UnicodeSet[] SKIPPABLES = new UnicodeSet[4];
    static final int D = 0;
    static final int C = 1;
    static final int KD = 2;
    static final int KC = 3;
    final UnicodeSet UNSAFE_START;
    final UnicodeSet SKIPPABLE;
    private char[] buffer = new char[30];

    static void register() {
        Transliterator.registerFactory("Any-NFC", new Transliterator.Factory(){

            public Transliterator getInstance(String ID) {
                return NormalizationTransliterator.getInstance(Normalizer.COMPOSE);
            }
        });
        Transliterator.registerFactory("Any-NFD", new Transliterator.Factory(){

            public Transliterator getInstance(String ID) {
                return NormalizationTransliterator.getInstance(Normalizer.DECOMP);
            }
        });
        Transliterator.registerFactory("Any-NFKC", new Transliterator.Factory(){

            public Transliterator getInstance(String ID) {
                return NormalizationTransliterator.getInstance(Normalizer.COMPOSE_COMPAT);
            }
        });
        Transliterator.registerFactory("Any-NFKD", new Transliterator.Factory(){

            public Transliterator getInstance(String ID) {
                return NormalizationTransliterator.getInstance(Normalizer.DECOMP_COMPAT);
            }
        });
        Transliterator.registerSpecialInverse("NFC", "NFD", true);
        Transliterator.registerSpecialInverse("NFKC", "NFKD", true);
    }

    public static NormalizationTransliterator getInstance(Normalizer.Mode m, int opt) {
        StringBuffer id = new StringBuffer("NF");
        int choice = 0;
        if (m.compat()) {
            id.append('K');
            choice |= 2;
        }
        if (m.compose()) {
            id.append('C');
            choice |= 1;
        } else {
            id.append('D');
        }
        return new NormalizationTransliterator(id.toString(), m, choice, opt);
    }

    public static NormalizationTransliterator getInstance(Normalizer.Mode m) {
        return NormalizationTransliterator.getInstance(m, 0);
    }

    private NormalizationTransliterator(String id, Normalizer.Mode m, int startChoice, int opt) {
        super(id, null);
        this.mode = m;
        this.options = opt;
        this.UNSAFE_START = UNSAFE_STARTS[startChoice];
        this.SKIPPABLE = SKIPPABLES[startChoice];
    }

    protected void handleTransliterate(Replaceable text, Transliterator.Position offsets, boolean isIncremental) {
        int delta;
        int start = offsets.start;
        int limit = offsets.limit;
        if (start >= limit) {
            return;
        }
        int overallDelta = 0;
        int lastSafe = start;
        int i = start + 1;
        while (i < limit) {
            int cp = text.char32At(i);
            if (UCharacter.getCombiningClass(cp) == 0 && !this.UNSAFE_START.contains(cp)) {
                delta = this.convert(text, lastSafe, i, null);
                limit += delta;
                overallDelta += delta;
                lastSafe = i += delta;
            }
            i += UTF16.getCharCount(cp);
        }
        if (!isIncremental) {
            delta = this.convert(text, lastSafe, limit, null);
            overallDelta += delta;
            lastSafe = limit + delta;
        } else {
            delta = this.convert(text, lastSafe, limit, this.SKIPPABLE);
            if (delta != Integer.MIN_VALUE) {
                overallDelta += delta;
                lastSafe = limit + delta;
            }
        }
        offsets.contextLimit += overallDelta;
        offsets.limit += overallDelta;
        offsets.start = lastSafe;
    }

    int convert(Replaceable text, int lastSafe, int limit, UnicodeSet verify) {
        int len = limit - lastSafe;
        if (this.buffer.length < len) {
            this.buffer = new char[len];
        }
        text.getChars(lastSafe, limit, this.buffer, 0);
        String input = new String(this.buffer, 0, len);
        String output = Normalizer.normalize(input, this.mode, this.options);
        if (verify != null) {
            boolean skip;
            boolean bl = skip = !this.SKIPPABLE.containsAll(output);
            if (skip) {
                return Integer.MIN_VALUE;
            }
        }
        if (output.equals(input)) {
            return 0;
        }
        text.replace(lastSafe, limit, output);
        return output.length() - len;
    }

    static {
        NormalizationTransliterator.UNSAFE_STARTS[0] = new UnicodeSet("[\u0f73\u0f75\u0f81]", false);
        NormalizationTransliterator.UNSAFE_STARTS[1] = new UnicodeSet("[\u09be\u09d7\u0b3e\u0b56-\u0b57\u0bbe\u0bd7\u0cc2\u0cd5-\u0cd6\u0d3e\u0d57\u0dcf\u0ddf\u0f73\u0f75\u0f81\u102e\u1161-\u1175\u11a8-\u11c2]", false);
        NormalizationTransliterator.UNSAFE_STARTS[2] = new UnicodeSet("[\u0f73\u0f75\u0f81\uff9e-\uff9f]", false);
        NormalizationTransliterator.UNSAFE_STARTS[3] = new UnicodeSet("[\u09be\u09d7\u0b3e\u0b56-\u0b57\u0bbe\u0bd7\u0cc2\u0cd5-\u0cd6\u0d3e\u0d57\u0dcf\u0ddf\u0f73\u0f75\u0f81\u102e\u1161-\u1175\u11a8-\u11c2\u3133\u3135-\u3136\u313a-\u313f\u314f-\u3163\uff9e-\uff9f\uffa3\uffa5-\uffa6\uffaa-\uffaf\uffc2-\uffc7\uffca-\uffcf\uffd2-\uffd7\uffda-\uffdc]", false);
        NormalizationTransliterator.SKIPPABLES[0] = new UnicodeSet("[^\u00c0-\u00c5\u00c7-\u00cf\u00d1-\u00d6\u00d9-\u00dd\u00e0-\u00e5\u00e7-\u00ef\u00f1-\u00f6\u00f9-\u00fd\u00ff-\u010f\u0112-\u0125\u0128-\u0130\u0134-\u0137\u0139-\u013e\u0143-\u0148\u014c-\u0151\u0154-\u0165\u0168-\u017e\u01a0-\u01a1\u01af-\u01b0\u01cd-\u01dc\u01de-\u01e3\u01e6-\u01f0\u01f4-\u01f5\u01f8-\u021b\u021e-\u021f\u0226-\u0233\u0300-\u034e\u0360-\u0362\u0374\u037e\u0385-\u038a\u038c\u038e-\u0390\u03aa-\u03b0\u03ca-\u03ce\u03d3-\u03d4\u0400-\u0401\u0403\u0407\u040c-\u040e\u0419\u0439\u0450-\u0451\u0453\u0457\u045c-\u045e\u0476-\u0477\u0483-\u0486\u04c1-\u04c2\u04d0-\u04d3\u04d6-\u04d7\u04da-\u04df\u04e2-\u04e7\u04ea-\u04f5\u04f8-\u04f9\u0591-\u05a1\u05a3-\u05b9\u05bb-\u05bd\u05bf\u05c1-\u05c2\u05c4\u0622-\u0626\u064b-\u0655\u0670\u06c0\u06c2\u06d3\u06d6-\u06dc\u06df-\u06e4\u06e7-\u06e8\u06ea-\u06ed\u0711\u0730-\u074a\u0929\u0931\u0934\u093c\u094d\u0951-\u0954\u0958-\u095f\u09bc\u09cb-\u09cd\u09dc-\u09dd\u09df\u0a33\u0a36\u0a3c\u0a4d\u0a59-\u0a5b\u0a5e\u0abc\u0acd\u0b3c\u0b48\u0b4b-\u0b4d\u0b5c-\u0b5d\u0b94\u0bca-\u0bcd\u0c48\u0c4d\u0c55-\u0c56\u0cc0\u0cc7-\u0cc8\u0cca-\u0ccb\u0ccd\u0d4a-\u0d4d\u0dca\u0dda\u0ddc-\u0dde\u0e38-\u0e3a\u0e48-\u0e4b\u0eb8-\u0eb9\u0ec8-\u0ecb\u0f18-\u0f19\u0f35\u0f37\u0f39\u0f43\u0f4d\u0f52\u0f57\u0f5c\u0f69\u0f71-\u0f76\u0f78\u0f7a-\u0f7d\u0f80-\u0f84\u0f86-\u0f87\u0f93\u0f9d\u0fa2\u0fa7\u0fac\u0fb9\u0fc6\u1026\u1037\u1039\u17d2\u18a9\u1e00-\u1e99\u1e9b\u1ea0-\u1ef9\u1f00-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fbc\u1fbe\u1fc1-\u1fc4\u1fc6-\u1fd3\u1fd6-\u1fdb\u1fdd-\u1fef\u1ff2-\u1ff4\u1ff6-\u1ffd\u2000-\u2001\u20d0-\u20dc\u20e1\u2126\u212a-\u212b\u219a-\u219b\u21ae\u21cd-\u21cf\u2204\u2209\u220c\u2224\u2226\u2241\u2244\u2247\u2249\u2260\u2262\u226d-\u2271\u2274-\u2275\u2278-\u2279\u2280-\u2281\u2284-\u2285\u2288-\u2289\u22ac-\u22af\u22e0-\u22e3\u22ea-\u22ed\u2329-\u232a\u302a-\u302f\u304c\u304e\u3050\u3052\u3054\u3056\u3058\u305a\u305c\u305e\u3060\u3062\u3065\u3067\u3069\u3070-\u3071\u3073-\u3074\u3076-\u3077\u3079-\u307a\u307c-\u307d\u3094\u3099-\u309a\u309e\u30ac\u30ae\u30b0\u30b2\u30b4\u30b6\u30b8\u30ba\u30bc\u30be\u30c0\u30c2\u30c5\u30c7\u30c9\u30d0-\u30d1\u30d3-\u30d4\u30d6-\u30d7\u30d9-\u30da\u30dc-\u30dd\u30f4\u30f7-\u30fa\u30fe\uac00-\ud7a3\uf900-\ufa0d\ufa10\ufa12\ufa15-\ufa1e\ufa20\ufa22\ufa25-\ufa26\ufa2a-\ufa2d\ufb1d-\ufb1f\ufb2a-\ufb36\ufb38-\ufb3c\ufb3e\ufb40-\ufb41\ufb43-\ufb44\ufb46-\ufb4e\ufe20-\ufe23\\U0001D15E-\\U0001D169\\U0001D16D-\\U0001D172\\U0001D17B-\\U0001D182\\U0001D185-\\U0001D18B\\U0001D1AA-\\U0001D1AD\\U0001D1BB-\\U0001D1C0\\U0002F800-\\U0002FA1D]", false);
        NormalizationTransliterator.SKIPPABLES[1] = new UnicodeSet("[^<->A-PR-Za-pr-z\u00a8\u00c0-\u00cf\u00d1-\u00d6\u00d8-\u00dd\u00e0-\u00ef\u00f1-\u00f6\u00f8-\u00fd\u00ff-\u0103\u0106-\u010f\u0112-\u0117\u011a-\u0121\u0124-\u0125\u0128-\u012d\u0130\u0139-\u013a\u013d-\u013e\u0143-\u0144\u0147-\u0148\u014c-\u0151\u0154-\u0155\u0158-\u015d\u0160-\u0161\u0164-\u0165\u0168-\u0171\u0174-\u017f\u01a0-\u01a1\u01af-\u01b0\u01b7\u01cd-\u01dc\u01de-\u01e1\u01e6-\u01eb\u01f4-\u01f5\u01f8-\u01fb\u0200-\u021b\u021e-\u021f\u0226-\u0233\u0292\u0300-\u034e\u0360-\u0362\u0374\u037e\u0387\u0391\u0395\u0397\u0399\u039f\u03a1\u03a5\u03a9\u03ac\u03ae\u03b1\u03b5\u03b7\u03b9\u03bf\u03c1\u03c5\u03c9-\u03cb\u03ce\u03d2\u0406\u0410\u0413\u0415-\u0418\u041a\u041e\u0423\u0427\u042b\u042d\u0430\u0433\u0435-\u0438\u043a\u043e\u0443\u0447\u044b\u044d\u0456\u0474-\u0475\u0483-\u0486\u04d8-\u04d9\u04e8-\u04e9\u0591-\u05a1\u05a3-\u05b9\u05bb-\u05bd\u05bf\u05c1-\u05c2\u05c4\u0622-\u0623\u0627\u0648\u064a-\u0655\u0670\u06c1\u06d2\u06d5-\u06dc\u06df-\u06e4\u06e7-\u06e8\u06ea-\u06ed\u0711\u0730-\u074a\u0928\u0930\u0933\u093c\u094d\u0951-\u0954\u0958-\u095f\u09bc\u09be\u09c7\u09cd\u09d7\u09dc-\u09dd\u09df\u0a33\u0a36\u0a3c\u0a4d\u0a59-\u0a5b\u0a5e\u0abc\u0acd\u0b3c\u0b3e\u0b47\u0b4d\u0b56-\u0b57\u0b5c-\u0b5d\u0b92\u0bbe\u0bc6-\u0bc7\u0bcd\u0bd7\u0c46\u0c4d\u0c55-\u0c56\u0cbf\u0cc2\u0cc6\u0cca\u0ccd\u0cd5-\u0cd6\u0d3e\u0d46-\u0d47\u0d4d\u0d57\u0dca\u0dcf\u0dd9\u0ddc\u0ddf\u0e38-\u0e3a\u0e48-\u0e4b\u0eb8-\u0eb9\u0ec8-\u0ecb\u0f18-\u0f19\u0f35\u0f37\u0f39\u0f43\u0f4d\u0f52\u0f57\u0f5c\u0f69\u0f71-\u0f76\u0f78\u0f7a-\u0f7d\u0f80-\u0f84\u0f86-\u0f87\u0f93\u0f9d\u0fa2\u0fa7\u0fac\u0fb9\u0fc6\u1025\u102e\u1037\u1039\u1100-\u1112\u1161-\u1175\u11a8-\u11c2\u17d2\u18a9\u1e00-\u1e03\u1e0a-\u1e0f\u1e12-\u1e1b\u1e20-\u1e27\u1e2a-\u1e41\u1e44-\u1e53\u1e58-\u1e7d\u1e80-\u1e87\u1e8e-\u1e91\u1e96-\u1e99\u1ea0-\u1ef3\u1ef6-\u1ef9\u1f00-\u1f11\u1f18-\u1f19\u1f20-\u1f31\u1f38-\u1f39\u1f40-\u1f41\u1f48-\u1f49\u1f50-\u1f51\u1f59\u1f60-\u1f71\u1f73-\u1f75\u1f77\u1f79\u1f7b-\u1f7d\u1f80-\u1f81\u1f88-\u1f89\u1f90-\u1f91\u1f98-\u1f99\u1fa0-\u1fa1\u1fa8-\u1fa9\u1fb3\u1fb6\u1fbb-\u1fbc\u1fbe-\u1fbf\u1fc3\u1fc6\u1fc9\u1fcb-\u1fcc\u1fd3\u1fdb\u1fe3\u1feb\u1fee-\u1fef\u1ff3\u1ff6\u1ff9\u1ffb-\u1ffe\u2000-\u2001\u20d0-\u20dc\u20e1\u2126\u212a-\u212b\u2190\u2192\u2194\u21d0\u21d2\u21d4\u2203\u2208\u220b\u2223\u2225\u223c\u2243\u2245\u2248\u224d\u2261\u2264-\u2265\u2272-\u2273\u2276-\u2277\u227a-\u227d\u2282-\u2283\u2286-\u2287\u2291-\u2292\u22a2\u22a8-\u22a9\u22ab\u22b2-\u22b5\u2329-\u232a\u302a-\u302f\u3046\u304b\u304d\u304f\u3051\u3053\u3055\u3057\u3059\u305b\u305d\u305f\u3061\u3064\u3066\u3068\u306f\u3072\u3075\u3078\u307b\u3099-\u309a\u309d\u30a6\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30cf\u30d2\u30d5\u30d8\u30db\u30ef-\u30f2\u30fd\uac00\uac1c\uac38\uac54\uac70\uac8c\uaca8\uacc4\uace0\uacfc\uad18\uad34\uad50\uad6c\uad88\uada4\uadc0\uaddc\uadf8\uae14\uae30\uae4c\uae68\uae84\uaea0\uaebc\uaed8\uaef4\uaf10\uaf2c\uaf48\uaf64\uaf80\uaf9c\uafb8\uafd4\uaff0\ub00c\ub028\ub044\ub060\ub07c\ub098\ub0b4\ub0d0\ub0ec\ub108\ub124\ub140\ub15c\ub178\ub194\ub1b0\ub1cc\ub1e8\ub204\ub220\ub23c\ub258\ub274\ub290\ub2ac\ub2c8\ub2e4\ub300\ub31c\ub338\ub354\ub370\ub38c\ub3a8\ub3c4\ub3e0\ub3fc\ub418\ub434\ub450\ub46c\ub488\ub4a4\ub4c0\ub4dc\ub4f8\ub514\ub530\ub54c\ub568\ub584\ub5a0\ub5bc\ub5d8\ub5f4\ub610\ub62c\ub648\ub664\ub680\ub69c\ub6b8\ub6d4\ub6f0\ub70c\ub728\ub744\ub760\ub77c\ub798\ub7b4\ub7d0\ub7ec\ub808\ub824\ub840\ub85c\ub878\ub894\ub8b0\ub8cc\ub8e8\ub904\ub920\ub93c\ub958\ub974\ub990\ub9ac\ub9c8\ub9e4\uba00\uba1c\uba38\uba54\uba70\uba8c\ubaa8\ubac4\ubae0\ubafc\ubb18\ubb34\ubb50\ubb6c\ubb88\ubba4\ubbc0\ubbdc\ubbf8\ubc14\ubc30\ubc4c\ubc68\ubc84\ubca0\ubcbc\ubcd8\ubcf4\ubd10\ubd2c\ubd48\ubd64\ubd80\ubd9c\ubdb8\ubdd4\ubdf0\ube0c\ube28\ube44\ube60\ube7c\ube98\ubeb4\ubed0\ubeec\ubf08\ubf24\ubf40\ubf5c\ubf78\ubf94\ubfb0\ubfcc\ubfe8\uc004\uc020\uc03c\uc058\uc074\uc090\uc0ac\uc0c8\uc0e4\uc100\uc11c\uc138\uc154\uc170\uc18c\uc1a8\uc1c4\uc1e0\uc1fc\uc218\uc234\uc250\uc26c\uc288\uc2a4\uc2c0\uc2dc\uc2f8\uc314\uc330\uc34c\uc368\uc384\uc3a0\uc3bc\uc3d8\uc3f4\uc410\uc42c\uc448\uc464\uc480\uc49c\uc4b8\uc4d4\uc4f0\uc50c\uc528\uc544\uc560\uc57c\uc598\uc5b4\uc5d0\uc5ec\uc608\uc624\uc640\uc65c\uc678\uc694\uc6b0\uc6cc\uc6e8\uc704\uc720\uc73c\uc758\uc774\uc790\uc7ac\uc7c8\uc7e4\uc800\uc81c\uc838\uc854\uc870\uc88c\uc8a8\uc8c4\uc8e0\uc8fc\uc918\uc934\uc950\uc96c\uc988\uc9a4\uc9c0\uc9dc\uc9f8\uca14\uca30\uca4c\uca68\uca84\ucaa0\ucabc\ucad8\ucaf4\ucb10\ucb2c\ucb48\ucb64\ucb80\ucb9c\ucbb8\ucbd4\ucbf0\ucc0c\ucc28\ucc44\ucc60\ucc7c\ucc98\uccb4\uccd0\uccec\ucd08\ucd24\ucd40\ucd5c\ucd78\ucd94\ucdb0\ucdcc\ucde8\uce04\uce20\uce3c\uce58\uce74\uce90\uceac\ucec8\ucee4\ucf00\ucf1c\ucf38\ucf54\ucf70\ucf8c\ucfa8\ucfc4\ucfe0\ucffc\ud018\ud034\ud050\ud06c\ud088\ud0a4\ud0c0\ud0dc\ud0f8\ud114\ud130\ud14c\ud168\ud184\ud1a0\ud1bc\ud1d8\ud1f4\ud210\ud22c\ud248\ud264\ud280\ud29c\ud2b8\ud2d4\ud2f0\ud30c\ud328\ud344\ud360\ud37c\ud398\ud3b4\ud3d0\ud3ec\ud408\ud424\ud440\ud45c\ud478\ud494\ud4b0\ud4cc\ud4e8\ud504\ud520\ud53c\ud558\ud574\ud590\ud5ac\ud5c8\ud5e4\ud600\ud61c\ud638\ud654\ud670\ud68c\ud6a8\ud6c4\ud6e0\ud6fc\ud718\ud734\ud750\ud76c\ud788\uf900-\ufa0d\ufa10\ufa12\ufa15-\ufa1e\ufa20\ufa22\ufa25-\ufa26\ufa2a-\ufa2d\ufb1d-\ufb1f\ufb2a-\ufb36\ufb38-\ufb3c\ufb3e\ufb40-\ufb41\ufb43-\ufb44\ufb46-\ufb4e\ufe20-\ufe23\\U0001D15E-\\U0001D169\\U0001D16D-\\U0001D172\\U0001D17B-\\U0001D182\\U0001D185-\\U0001D18B\\U0001D1AA-\\U0001D1AD\\U0001D1BB-\\U0001D1C0\\U0002F800-\\U0002FA1D]", false);
        NormalizationTransliterator.SKIPPABLES[2] = new UnicodeSet("[^\u00a0\u00a8\u00aa\u00af\u00b2-\u00b5\u00b8-\u00ba\u00bc-\u00be\u00c0-\u00c5\u00c7-\u00cf\u00d1-\u00d6\u00d9-\u00dd\u00e0-\u00e5\u00e7-\u00ef\u00f1-\u00f6\u00f9-\u00fd\u00ff-\u010f\u0112-\u0125\u0128-\u0130\u0132-\u0137\u0139-\u0140\u0143-\u0149\u014c-\u0151\u0154-\u0165\u0168-\u017f\u01a0-\u01a1\u01af-\u01b0\u01c4-\u01dc\u01de-\u01e3\u01e6-\u01f5\u01f8-\u021b\u021e-\u021f\u0226-\u0233\u02b0-\u02b8\u02d8-\u02dd\u02e0-\u02e4\u0300-\u034e\u0360-\u0362\u0374\u037a\u037e\u0384-\u038a\u038c\u038e-\u0390\u03aa-\u03b0\u03ca-\u03ce\u03d0-\u03d6\u03f0-\u03f2\u03f4-\u03f5\u0400-\u0401\u0403\u0407\u040c-\u040e\u0419\u0439\u0450-\u0451\u0453\u0457\u045c-\u045e\u0476-\u0477\u0483-\u0486\u04c1-\u04c2\u04d0-\u04d3\u04d6-\u04d7\u04da-\u04df\u04e2-\u04e7\u04ea-\u04f5\u04f8-\u04f9\u0587\u0591-\u05a1\u05a3-\u05b9\u05bb-\u05bd\u05bf\u05c1-\u05c2\u05c4\u0622-\u0626\u064b-\u0655\u0670\u0675-\u0678\u06c0\u06c2\u06d3\u06d6-\u06dc\u06df-\u06e4\u06e7-\u06e8\u06ea-\u06ed\u0711\u0730-\u074a\u0929\u0931\u0934\u093c\u094d\u0951-\u0954\u0958-\u095f\u09bc\u09cb-\u09cd\u09dc-\u09dd\u09df\u0a33\u0a36\u0a3c\u0a4d\u0a59-\u0a5b\u0a5e\u0abc\u0acd\u0b3c\u0b48\u0b4b-\u0b4d\u0b5c-\u0b5d\u0b94\u0bca-\u0bcd\u0c48\u0c4d\u0c55-\u0c56\u0cc0\u0cc7-\u0cc8\u0cca-\u0ccb\u0ccd\u0d4a-\u0d4d\u0dca\u0dda\u0ddc-\u0dde\u0e33\u0e38-\u0e3a\u0e48-\u0e4b\u0eb3\u0eb8-\u0eb9\u0ec8-\u0ecb\u0edc-\u0edd\u0f0c\u0f18-\u0f19\u0f35\u0f37\u0f39\u0f43\u0f4d\u0f52\u0f57\u0f5c\u0f69\u0f71-\u0f7d\u0f80-\u0f84\u0f86-\u0f87\u0f93\u0f9d\u0fa2\u0fa7\u0fac\u0fb9\u0fc6\u1026\u1037\u1039\u17d2\u18a9\u1e00-\u1e9b\u1ea0-\u1ef9\u1f00-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fc4\u1fc6-\u1fd3\u1fd6-\u1fdb\u1fdd-\u1fef\u1ff2-\u1ff4\u1ff6-\u1ffe\u2000-\u200a\u2011\u2017\u2024-\u2026\u202f\u2033-\u2034\u2036-\u2037\u203c\u203e\u2048-\u2049\u2070\u2074-\u208e\u20a8\u20d0-\u20dc\u20e1\u2100-\u2103\u2105-\u2107\u2109-\u2113\u2115-\u2116\u2119-\u211d\u2120-\u2122\u2124\u2126\u2128\u212a-\u212d\u212f-\u2131\u2133-\u2139\u2153-\u217f\u219a-\u219b\u21ae\u21cd-\u21cf\u2204\u2209\u220c\u2224\u2226\u222c-\u222d\u222f-\u2230\u2241\u2244\u2247\u2249\u2260\u2262\u226d-\u2271\u2274-\u2275\u2278-\u2279\u2280-\u2281\u2284-\u2285\u2288-\u2289\u22ac-\u22af\u22e0-\u22e3\u22ea-\u22ed\u2329-\u232a\u2460-\u24ea\u2e9f\u2ef3\u2f00-\u2fd5\u3000\u302a-\u302f\u3036\u3038-\u303a\u304c\u304e\u3050\u3052\u3054\u3056\u3058\u305a\u305c\u305e\u3060\u3062\u3065\u3067\u3069\u3070-\u3071\u3073-\u3074\u3076-\u3077\u3079-\u307a\u307c-\u307d\u3094\u3099-\u309c\u309e\u30ac\u30ae\u30b0\u30b2\u30b4\u30b6\u30b8\u30ba\u30bc\u30be\u30c0\u30c2\u30c5\u30c7\u30c9\u30d0-\u30d1\u30d3-\u30d4\u30d6-\u30d7\u30d9-\u30da\u30dc-\u30dd\u30f4\u30f7-\u30fa\u30fe\u3131-\u318e\u3192-\u319f\u3200-\u321c\u3220-\u3243\u3260-\u327b\u3280-\u32b0\u32c0-\u32cb\u32d0-\u32fe\u3300-\u3376\u337b-\u33dd\u33e0-\u33fe\uac00-\ud7a3\uf900-\ufa0d\ufa10\ufa12\ufa15-\ufa1e\ufa20\ufa22\ufa25-\ufa26\ufa2a-\ufa2d\ufb00-\ufb06\ufb13-\ufb17\ufb1d-\ufb36\ufb38-\ufb3c\ufb3e\ufb40-\ufb41\ufb43-\ufb44\ufb46-\ufbb1\ufbd3-\ufd3d\ufd50-\ufd8f\ufd92-\ufdc7\ufdf0-\ufdfb\ufe20-\ufe23\ufe30-\ufe44\ufe49-\ufe52\ufe54-\ufe66\ufe68-\ufe6b\ufe70-\ufe72\ufe74\ufe76-\ufefc\uff01-\uff5e\uff61-\uffbe\uffc2-\uffc7\uffca-\uffcf\uffd2-\uffd7\uffda-\uffdc\uffe0-\uffe6\uffe8-\uffee\\U0001D15E-\\U0001D169\\U0001D16D-\\U0001D172\\U0001D17B-\\U0001D182\\U0001D185-\\U0001D18B\\U0001D1AA-\\U0001D1AD\\U0001D1BB-\\U0001D1C0\\U0001D400-\\U0001D454\\U0001D456-\\U0001D49C\\U0001D49E-\\U0001D49F\\U0001D4A2\\U0001D4A5-\\U0001D4A6\\U0001D4A9-\\U0001D4AC\\U0001D4AE-\\U0001D4B9\\U0001D4BB\\U0001D4BD-\\U0001D4C0\\U0001D4C2-\\U0001D4C3\\U0001D4C5-\\U0001D505\\U0001D507-\\U0001D50A\\U0001D50D-\\U0001D514\\U0001D516-\\U0001D51C\\U0001D51E-\\U0001D539\\U0001D53B-\\U0001D53E\\U0001D540-\\U0001D544\\U0001D546\\U0001D54A-\\U0001D550\\U0001D552-\\U0001D6A3\\U0001D6A8-\\U0001D7C9\\U0001D7CE-\\U0001D7FF\\U0002F800-\\U0002FA1D]", false);
        NormalizationTransliterator.SKIPPABLES[3] = new UnicodeSet("[^<->A-PR-Za-pr-z\u00a0\u00a8\u00aa\u00af\u00b2-\u00b5\u00b8-\u00ba\u00bc-\u00be\u00c0-\u00cf\u00d1-\u00d6\u00d8-\u00dd\u00e0-\u00ef\u00f1-\u00f6\u00f8-\u00fd\u00ff-\u0103\u0106-\u010f\u0112-\u0117\u011a-\u0121\u0124-\u0125\u0128-\u012d\u0130\u0132-\u0133\u0139-\u013a\u013d-\u0140\u0143-\u0144\u0147-\u0149\u014c-\u0151\u0154-\u0155\u0158-\u015d\u0160-\u0161\u0164-\u0165\u0168-\u0171\u0174-\u017f\u01a0-\u01a1\u01af-\u01b0\u01b7\u01c4-\u01dc\u01de-\u01e1\u01e6-\u01eb\u01f1-\u01f5\u01f8-\u01fb\u0200-\u021b\u021e-\u021f\u0226-\u0233\u0292\u02b0-\u02b8\u02d8-\u02dd\u02e0-\u02e4\u0300-\u034e\u0360-\u0362\u0374\u037a\u037e\u0384-\u0385\u0387\u0391\u0395\u0397\u0399\u039f\u03a1\u03a5\u03a9\u03ac\u03ae\u03b1\u03b5\u03b7\u03b9\u03bf\u03c1\u03c5\u03c9-\u03cb\u03ce\u03d0-\u03d6\u03f0-\u03f2\u03f4-\u03f5\u0406\u0410\u0413\u0415-\u0418\u041a\u041e\u0423\u0427\u042b\u042d\u0430\u0433\u0435-\u0438\u043a\u043e\u0443\u0447\u044b\u044d\u0456\u0474-\u0475\u0483-\u0486\u04d8-\u04d9\u04e8-\u04e9\u0587\u0591-\u05a1\u05a3-\u05b9\u05bb-\u05bd\u05bf\u05c1-\u05c2\u05c4\u0622-\u0623\u0627\u0648\u064a-\u0655\u0670\u0675-\u0678\u06c1\u06d2\u06d5-\u06dc\u06df-\u06e4\u06e7-\u06e8\u06ea-\u06ed\u0711\u0730-\u074a\u0928\u0930\u0933\u093c\u094d\u0951-\u0954\u0958-\u095f\u09bc\u09be\u09c7\u09cd\u09d7\u09dc-\u09dd\u09df\u0a33\u0a36\u0a3c\u0a4d\u0a59-\u0a5b\u0a5e\u0abc\u0acd\u0b3c\u0b3e\u0b47\u0b4d\u0b56-\u0b57\u0b5c-\u0b5d\u0b92\u0bbe\u0bc6-\u0bc7\u0bcd\u0bd7\u0c46\u0c4d\u0c55-\u0c56\u0cbf\u0cc2\u0cc6\u0cca\u0ccd\u0cd5-\u0cd6\u0d3e\u0d46-\u0d47\u0d4d\u0d57\u0dca\u0dcf\u0dd9\u0ddc\u0ddf\u0e33\u0e38-\u0e3a\u0e48-\u0e4b\u0eb3\u0eb8-\u0eb9\u0ec8-\u0ecb\u0edc-\u0edd\u0f0c\u0f18-\u0f19\u0f35\u0f37\u0f39\u0f43\u0f4d\u0f52\u0f57\u0f5c\u0f69\u0f71-\u0f7d\u0f80-\u0f84\u0f86-\u0f87\u0f93\u0f9d\u0fa2\u0fa7\u0fac\u0fb9\u0fc6\u1025\u102e\u1037\u1039\u1100-\u1112\u1161-\u1175\u11a8-\u11c2\u17d2\u18a9\u1e00-\u1e03\u1e0a-\u1e0f\u1e12-\u1e1b\u1e20-\u1e27\u1e2a-\u1e41\u1e44-\u1e53\u1e58-\u1e7d\u1e80-\u1e87\u1e8e-\u1e91\u1e96-\u1e9b\u1ea0-\u1ef3\u1ef6-\u1ef9\u1f00-\u1f11\u1f18-\u1f19\u1f20-\u1f31\u1f38-\u1f39\u1f40-\u1f41\u1f48-\u1f49\u1f50-\u1f51\u1f59\u1f60-\u1f71\u1f73-\u1f75\u1f77\u1f79\u1f7b-\u1f7d\u1f80-\u1f81\u1f88-\u1f89\u1f90-\u1f91\u1f98-\u1f99\u1fa0-\u1fa1\u1fa8-\u1fa9\u1fb3\u1fb6\u1fbb-\u1fc1\u1fc3\u1fc6\u1fc9\u1fcb-\u1fcf\u1fd3\u1fdb\u1fdd-\u1fdf\u1fe3\u1feb\u1fed-\u1fef\u1ff3\u1ff6\u1ff9\u1ffb-\u1ffe\u2000-\u200a\u2011\u2017\u2024-\u2026\u202f\u2033-\u2034\u2036-\u2037\u203c\u203e\u2048-\u2049\u2070\u2074-\u208e\u20a8\u20d0-\u20dc\u20e1\u2100-\u2103\u2105-\u2107\u2109-\u2113\u2115-\u2116\u2119-\u211d\u2120-\u2122\u2124\u2126\u2128\u212a-\u212d\u212f-\u2131\u2133-\u2139\u2153-\u217f\u2190\u2192\u2194\u21d0\u21d2\u21d4\u2203\u2208\u220b\u2223\u2225\u222c-\u222d\u222f-\u2230\u223c\u2243\u2245\u2248\u224d\u2261\u2264-\u2265\u2272-\u2273\u2276-\u2277\u227a-\u227d\u2282-\u2283\u2286-\u2287\u2291-\u2292\u22a2\u22a8-\u22a9\u22ab\u22b2-\u22b5\u2329-\u232a\u2460-\u24ea\u2e9f\u2ef3\u2f00-\u2fd5\u3000\u302a-\u302f\u3036\u3038-\u303a\u3046\u304b\u304d\u304f\u3051\u3053\u3055\u3057\u3059\u305b\u305d\u305f\u3061\u3064\u3066\u3068\u306f\u3072\u3075\u3078\u307b\u3099-\u309d\u30a6\u30ab\u30ad\u30af\u30b1\u30b3\u30b5\u30b7\u30b9\u30bb\u30bd\u30bf\u30c1\u30c4\u30c6\u30c8\u30cf\u30d2\u30d5\u30d8\u30db\u30ef-\u30f2\u30fd\u3131-\u318e\u3192-\u319f\u3200-\u321c\u3220-\u3243\u3260-\u327b\u3280-\u32b0\u32c0-\u32cb\u32d0-\u32fe\u3300-\u3376\u337b-\u33dd\u33e0-\u33fe\uac00\uac1c\uac38\uac54\uac70\uac8c\uaca8\uacc4\uace0\uacfc\uad18\uad34\uad50\uad6c\uad88\uada4\uadc0\uaddc\uadf8\uae14\uae30\uae4c\uae68\uae84\uaea0\uaebc\uaed8\uaef4\uaf10\uaf2c\uaf48\uaf64\uaf80\uaf9c\uafb8\uafd4\uaff0\ub00c\ub028\ub044\ub060\ub07c\ub098\ub0b4\ub0d0\ub0ec\ub108\ub124\ub140\ub15c\ub178\ub194\ub1b0\ub1cc\ub1e8\ub204\ub220\ub23c\ub258\ub274\ub290\ub2ac\ub2c8\ub2e4\ub300\ub31c\ub338\ub354\ub370\ub38c\ub3a8\ub3c4\ub3e0\ub3fc\ub418\ub434\ub450\ub46c\ub488\ub4a4\ub4c0\ub4dc\ub4f8\ub514\ub530\ub54c\ub568\ub584\ub5a0\ub5bc\ub5d8\ub5f4\ub610\ub62c\ub648\ub664\ub680\ub69c\ub6b8\ub6d4\ub6f0\ub70c\ub728\ub744\ub760\ub77c\ub798\ub7b4\ub7d0\ub7ec\ub808\ub824\ub840\ub85c\ub878\ub894\ub8b0\ub8cc\ub8e8\ub904\ub920\ub93c\ub958\ub974\ub990\ub9ac\ub9c8\ub9e4\uba00\uba1c\uba38\uba54\uba70\uba8c\ubaa8\ubac4\ubae0\ubafc\ubb18\ubb34\ubb50\ubb6c\ubb88\ubba4\ubbc0\ubbdc\ubbf8\ubc14\ubc30\ubc4c\ubc68\ubc84\ubca0\ubcbc\ubcd8\ubcf4\ubd10\ubd2c\ubd48\ubd64\ubd80\ubd9c\ubdb8\ubdd4\ubdf0\ube0c\ube28\ube44\ube60\ube7c\ube98\ubeb4\ubed0\ubeec\ubf08\ubf24\ubf40\ubf5c\ubf78\ubf94\ubfb0\ubfcc\ubfe8\uc004\uc020\uc03c\uc058\uc074\uc090\uc0ac\uc0c8\uc0e4\uc100\uc11c\uc138\uc154\uc170\uc18c\uc1a8\uc1c4\uc1e0\uc1fc\uc218\uc234\uc250\uc26c\uc288\uc2a4\uc2c0\uc2dc\uc2f8\uc314\uc330\uc34c\uc368\uc384\uc3a0\uc3bc\uc3d8\uc3f4\uc410\uc42c\uc448\uc464\uc480\uc49c\uc4b8\uc4d4\uc4f0\uc50c\uc528\uc544\uc560\uc57c\uc598\uc5b4\uc5d0\uc5ec\uc608\uc624\uc640\uc65c\uc678\uc694\uc6b0\uc6cc\uc6e8\uc704\uc720\uc73c\uc758\uc774\uc790\uc7ac\uc7c8\uc7e4\uc800\uc81c\uc838\uc854\uc870\uc88c\uc8a8\uc8c4\uc8e0\uc8fc\uc918\uc934\uc950\uc96c\uc988\uc9a4\uc9c0\uc9dc\uc9f8\uca14\uca30\uca4c\uca68\uca84\ucaa0\ucabc\ucad8\ucaf4\ucb10\ucb2c\ucb48\ucb64\ucb80\ucb9c\ucbb8\ucbd4\ucbf0\ucc0c\ucc28\ucc44\ucc60\ucc7c\ucc98\uccb4\uccd0\uccec\ucd08\ucd24\ucd40\ucd5c\ucd78\ucd94\ucdb0\ucdcc\ucde8\uce04\uce20\uce3c\uce58\uce74\uce90\uceac\ucec8\ucee4\ucf00\ucf1c\ucf38\ucf54\ucf70\ucf8c\ucfa8\ucfc4\ucfe0\ucffc\ud018\ud034\ud050\ud06c\ud088\ud0a4\ud0c0\ud0dc\ud0f8\ud114\ud130\ud14c\ud168\ud184\ud1a0\ud1bc\ud1d8\ud1f4\ud210\ud22c\ud248\ud264\ud280\ud29c\ud2b8\ud2d4\ud2f0\ud30c\ud328\ud344\ud360\ud37c\ud398\ud3b4\ud3d0\ud3ec\ud408\ud424\ud440\ud45c\ud478\ud494\ud4b0\ud4cc\ud4e8\ud504\ud520\ud53c\ud558\ud574\ud590\ud5ac\ud5c8\ud5e4\ud600\ud61c\ud638\ud654\ud670\ud68c\ud6a8\ud6c4\ud6e0\ud6fc\ud718\ud734\ud750\ud76c\ud788\uf900-\ufa0d\ufa10\ufa12\ufa15-\ufa1e\ufa20\ufa22\ufa25-\ufa26\ufa2a-\ufa2d\ufb00-\ufb06\ufb13-\ufb17\ufb1d-\ufb36\ufb38-\ufb3c\ufb3e\ufb40-\ufb41\ufb43-\ufb44\ufb46-\ufbb1\ufbd3-\ufd3d\ufd50-\ufd8f\ufd92-\ufdc7\ufdf0-\ufdfb\ufe20-\ufe23\ufe30-\ufe44\ufe49-\ufe52\ufe54-\ufe66\ufe68-\ufe6b\ufe70-\ufe72\ufe74\ufe76-\ufefc\uff01-\uff5e\uff61-\uffbe\uffc2-\uffc7\uffca-\uffcf\uffd2-\uffd7\uffda-\uffdc\uffe0-\uffe6\uffe8-\uffee\\U0001D15E-\\U0001D169\\U0001D16D-\\U0001D172\\U0001D17B-\\U0001D182\\U0001D185-\\U0001D18B\\U0001D1AA-\\U0001D1AD\\U0001D1BB-\\U0001D1C0\\U0001D400-\\U0001D454\\U0001D456-\\U0001D49C\\U0001D49E-\\U0001D49F\\U0001D4A2\\U0001D4A5-\\U0001D4A6\\U0001D4A9-\\U0001D4AC\\U0001D4AE-\\U0001D4B9\\U0001D4BB\\U0001D4BD-\\U0001D4C0\\U0001D4C2-\\U0001D4C3\\U0001D4C5-\\U0001D505\\U0001D507-\\U0001D50A\\U0001D50D-\\U0001D514\\U0001D516-\\U0001D51C\\U0001D51E-\\U0001D539\\U0001D53B-\\U0001D53E\\U0001D540-\\U0001D544\\U0001D546\\U0001D54A-\\U0001D550\\U0001D552-\\U0001D6A3\\U0001D6A8-\\U0001D7C9\\U0001D7CE-\\U0001D7FF\\U0002F800-\\U0002FA1D]", false);
    }
}

