/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.text.Replaceable;
import com.ibm.icu.text.Transliterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.text.UnicodeFilter;

class NameUnicodeTransliterator
extends Transliterator {
    char openDelimiter;
    char closeDelimiter;
    static final String _ID = "Name-Any";

    static void register() {
        Transliterator.registerFactory(_ID, new Transliterator.Factory(){

            public Transliterator getInstance(String ID) {
                return new NameUnicodeTransliterator(null);
            }
        });
    }

    public NameUnicodeTransliterator(char openDelimiter, char closeDelimiter, UnicodeFilter filter) {
        super(_ID, filter);
        this.openDelimiter = openDelimiter;
        this.closeDelimiter = closeDelimiter;
    }

    public NameUnicodeTransliterator(UnicodeFilter filter) {
        this('{', '}', filter);
    }

    protected void handleTransliterate(Replaceable text, Transliterator.Position offsets, boolean isIncremental) {
        char[] buf = new char[91];
        int cursor = offsets.start;
        int limit = offsets.limit;
        int mode = 0;
        int ibuf = 0;
        int openPos = offsets.start;
        while (cursor < limit) {
            int c = text.char32At(cursor);
            switch (mode) {
                case 0: {
                    if (c != this.openDelimiter) break;
                    openPos = cursor;
                    mode = 1;
                    ibuf = 0;
                    break;
                }
                case 1: {
                    if (UCharacter.isWhitespace(c)) {
                        if (ibuf == 0 || buf[ibuf - 1] == ' ') break;
                        buf[ibuf++] = 32;
                        if (ibuf != 87) break;
                        mode = 0;
                        break;
                    }
                    if (c == this.closeDelimiter) {
                        int ch;
                        if (ibuf > 0 && buf[ibuf - 1] == ' ') {
                            --ibuf;
                        }
                        if ((ch = UCharacter.getCharFromExtendedName(new String(buf, 0, ibuf))) != -1) {
                            String str = UTF16.valueOf(ch);
                            text.replace(openPos, cursor + 1, str);
                            int delta = cursor + 1 - openPos - str.length();
                            cursor -= delta;
                            limit -= delta;
                        }
                        mode = 0;
                        break;
                    }
                    if (c >= 97 && c <= 122) {
                        c -= 32;
                    }
                    if (c == 45 || c >= 65 && c <= 90 || c >= 97 && c <= 122 || c >= 48 && c <= 57 || c == 60 || c == 62) {
                        buf[ibuf++] = (char)c;
                        if (ibuf != 87) break;
                        mode = 0;
                        break;
                    }
                    --cursor;
                    mode = 0;
                }
            }
            cursor += UTF16.getCharCount(c);
        }
        offsets.contextLimit += limit - offsets.limit;
        offsets.limit = limit;
        offsets.start = mode == 1 && isIncremental ? openPos : cursor;
    }
}

