/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.lang;

import com.ibm.icu.impl.ICULocaleData;
import com.ibm.icu.impl.LocaleUtility;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class UScript {
    private static final String copyrightNotice = "Copyright \u00a92001 IBM Corp.  All rights reserved.";
    public static final int INVALID_CODE = -1;
    public static final int COMMON = 0;
    public static final int INHERITED = 1;
    public static final int ARABIC = 2;
    public static final int ARMENIAN = 3;
    public static final int BENGALI = 4;
    public static final int BOPOMOFO = 5;
    public static final int CHEROKEE = 6;
    public static final int COPTIC = 7;
    public static final int CYRILLIC = 8;
    public static final int DESERET = 9;
    public static final int DEVANAGARI = 10;
    public static final int ETHIOPIC = 11;
    public static final int GEORGIAN = 12;
    public static final int GOTHIC = 13;
    public static final int GREEK = 14;
    public static final int GUJARATI = 15;
    public static final int GURMUKHI = 16;
    public static final int HAN = 17;
    public static final int HANGUL = 18;
    public static final int HEBREW = 19;
    public static final int HIRAGANA = 20;
    public static final int KANNADA = 21;
    public static final int KATAKANA = 22;
    public static final int KHMER = 23;
    public static final int LAO = 24;
    public static final int LATIN = 25;
    public static final int MALAYALAM = 26;
    public static final int MONGOLIAN = 27;
    public static final int MYANMAR = 28;
    public static final int OGHAM = 29;
    public static final int OLD_ITALIC = 30;
    public static final int ORIYA = 31;
    public static final int RUNIC = 32;
    public static final int SINHALA = 33;
    public static final int SYRIAC = 34;
    public static final int TAMIL = 35;
    public static final int TELUGU = 36;
    public static final int THAANA = 37;
    public static final int THAI = 38;
    public static final int TIBETAN = 39;
    public static final int UCAS = 40;
    public static final int YI = 41;
    public static final int CODE_LIMIT = 42;
    private static final String[] scriptNames = new String[]{"ARABIC", "ARMENIAN", "BENGALI", "BOPOMOFO", "CANADIAN-ABORIGINAL", "CHEROKEE", "COMMON", "CYRILLIC", "DESERET", "DEVANAGARI", "ETHIOPIC", "GEORGIAN", "GOTHIC", "GREEK", "GUJARATI", "GURMUKHI", "HAN", "HANGUL", "HEBREW", "HIRAGANA", "INHERITED", "KANNADA", "KATAKANA", "KHMER", "LATIN", "MALAYALAM", "MONGOLIAN", "MYANMAR", "OGHAM", "OLD-ITALIC", "ORIYA", "RUNIC", "SINHALA", "SYRIAC", "TAMIL", "TELUGU", "THAANA", "THAI", "TIBETAN", "UCAS", "YI"};
    private static final String[] scriptAbbr = new String[]{"Arab", "Armn", "Beng", "Bopo", "Cans", "Cher", "Cyrl", "Deva", "Dsrt", "Ethi", "Geor", "Goth", "Grek", "Gujr", "Guru", "Hang", "Hani", "Hebr", "Hira", "Ital", "Kana", "Khmr", "Knda", "Lao", "Latn", "Mlym", "Mong", "Mymr", "Ogam", "Orya", "Qaac", "Qaai", "Runr", "Sinh", "Syrc", "Taml", "Telu", "Thaa", "Thai", "Tibt", "Yiii", "Zyyy"};
    private static final int[] scriptNameCodes = new int[]{2, 3, 4, 5, 40, 6, 0, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 1, 21, 22, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41};
    private static final int[] scriptAbbrCodes = new int[]{2, 3, 4, 5, 40, 6, 8, 10, 9, 11, 12, 13, 14, 15, 16, 18, 17, 19, 20, 30, 22, 23, 21, 24, 25, 26, 27, 28, 29, 31, 7, 1, 32, 33, 34, 35, 36, 37, 38, 39, 41, 0};
    private static final UScriptCodeMap[] scriptCodeIndex = new UScriptCodeMap[]{new UScriptCodeMap(0, 0, 0), new UScriptCodeMap(65, 90, 25), new UScriptCodeMap(97, 122, 25), new UScriptCodeMap(170, 170, 25), new UScriptCodeMap(181, 181, 14), new UScriptCodeMap(186, 186, 25), new UScriptCodeMap(192, 214, 25), new UScriptCodeMap(216, 246, 25), new UScriptCodeMap(248, 442, 25), new UScriptCodeMap(443, 443, 25), new UScriptCodeMap(444, 447, 25), new UScriptCodeMap(448, 451, 25), new UScriptCodeMap(452, 543, 25), new UScriptCodeMap(546, 563, 25), new UScriptCodeMap(592, 685, 25), new UScriptCodeMap(688, 696, 25), new UScriptCodeMap(736, 740, 25), new UScriptCodeMap(768, 846, 1), new UScriptCodeMap(864, 866, 1), new UScriptCodeMap(890, 890, 14), new UScriptCodeMap(902, 902, 14), new UScriptCodeMap(904, 906, 14), new UScriptCodeMap(908, 908, 14), new UScriptCodeMap(910, 929, 14), new UScriptCodeMap(931, 974, 14), new UScriptCodeMap(976, 983, 14), new UScriptCodeMap(986, 1013, 14), new UScriptCodeMap(1024, 1153, 8), new UScriptCodeMap(1155, 1158, 8), new UScriptCodeMap(1160, 1161, 1), new UScriptCodeMap(1164, 1220, 8), new UScriptCodeMap(1223, 1224, 8), new UScriptCodeMap(1227, 1228, 8), new UScriptCodeMap(1232, 1269, 8), new UScriptCodeMap(1272, 1273, 8), new UScriptCodeMap(1329, 1366, 3), new UScriptCodeMap(1369, 1369, 3), new UScriptCodeMap(1377, 1415, 3), new UScriptCodeMap(1425, 1441, 1), new UScriptCodeMap(1443, 1465, 1), new UScriptCodeMap(1467, 1469, 1), new UScriptCodeMap(1471, 1471, 1), new UScriptCodeMap(1473, 1474, 1), new UScriptCodeMap(1476, 1476, 1), new UScriptCodeMap(1488, 1514, 19), new UScriptCodeMap(1520, 1522, 19), new UScriptCodeMap(1569, 1594, 2), new UScriptCodeMap(1601, 1610, 2), new UScriptCodeMap(1611, 1621, 1), new UScriptCodeMap(1648, 1648, 1), new UScriptCodeMap(1649, 1747, 2), new UScriptCodeMap(1749, 1749, 2), new UScriptCodeMap(1750, 1756, 1), new UScriptCodeMap(1757, 1758, 1), new UScriptCodeMap(1759, 1764, 1), new UScriptCodeMap(1765, 1766, 2), new UScriptCodeMap(1767, 1768, 1), new UScriptCodeMap(1770, 1773, 1), new UScriptCodeMap(1786, 1788, 2), new UScriptCodeMap(1808, 1808, 34), new UScriptCodeMap(1809, 1809, 34), new UScriptCodeMap(1810, 1836, 34), new UScriptCodeMap(1840, 1866, 34), new UScriptCodeMap(1920, 1957, 37), new UScriptCodeMap(1958, 1968, 37), new UScriptCodeMap(2305, 2306, 10), new UScriptCodeMap(2307, 2307, 10), new UScriptCodeMap(2309, 2361, 10), new UScriptCodeMap(2364, 2364, 10), new UScriptCodeMap(2365, 2365, 10), new UScriptCodeMap(2366, 2368, 10), new UScriptCodeMap(2369, 2376, 10), new UScriptCodeMap(2377, 2380, 10), new UScriptCodeMap(2381, 2381, 10), new UScriptCodeMap(2384, 2384, 10), new UScriptCodeMap(2385, 2388, 10), new UScriptCodeMap(2392, 2401, 10), new UScriptCodeMap(2402, 2403, 10), new UScriptCodeMap(2406, 2415, 10), new UScriptCodeMap(2433, 2433, 4), new UScriptCodeMap(2437, 2444, 4), new UScriptCodeMap(2447, 2448, 4), new UScriptCodeMap(2451, 2472, 4), new UScriptCodeMap(2474, 2480, 4), new UScriptCodeMap(2482, 2482, 4), new UScriptCodeMap(2486, 2489, 4), new UScriptCodeMap(2492, 2492, 4), new UScriptCodeMap(2494, 2496, 4), new UScriptCodeMap(2497, 2500, 4), new UScriptCodeMap(2503, 2504, 4), new UScriptCodeMap(2507, 2508, 4), new UScriptCodeMap(2509, 2509, 4), new UScriptCodeMap(2519, 2519, 4), new UScriptCodeMap(2524, 2525, 4), new UScriptCodeMap(2527, 2529, 4), new UScriptCodeMap(2530, 2531, 4), new UScriptCodeMap(2534, 2543, 4), new UScriptCodeMap(2544, 2545, 4), new UScriptCodeMap(2562, 2562, 16), new UScriptCodeMap(2565, 2570, 16), new UScriptCodeMap(2575, 2576, 16), new UScriptCodeMap(2579, 2600, 16), new UScriptCodeMap(2602, 2608, 16), new UScriptCodeMap(2610, 2611, 16), new UScriptCodeMap(2613, 2614, 16), new UScriptCodeMap(2616, 2617, 16), new UScriptCodeMap(2620, 2620, 16), new UScriptCodeMap(2622, 2624, 16), new UScriptCodeMap(2625, 2626, 16), new UScriptCodeMap(2631, 2632, 16), new UScriptCodeMap(2635, 2637, 16), new UScriptCodeMap(2649, 2652, 16), new UScriptCodeMap(2654, 2654, 16), new UScriptCodeMap(2662, 2671, 16), new UScriptCodeMap(2672, 2673, 16), new UScriptCodeMap(2674, 2676, 16), new UScriptCodeMap(2689, 2690, 15), new UScriptCodeMap(2691, 2691, 15), new UScriptCodeMap(2693, 2699, 15), new UScriptCodeMap(2701, 2701, 15), new UScriptCodeMap(2703, 2705, 15), new UScriptCodeMap(2707, 2728, 15), new UScriptCodeMap(2730, 2736, 15), new UScriptCodeMap(2738, 2739, 15), new UScriptCodeMap(2741, 2745, 15), new UScriptCodeMap(2748, 2748, 15), new UScriptCodeMap(2749, 2749, 15), new UScriptCodeMap(2750, 2752, 15), new UScriptCodeMap(2753, 2757, 15), new UScriptCodeMap(2759, 2760, 15), new UScriptCodeMap(2761, 2761, 15), new UScriptCodeMap(2763, 2764, 15), new UScriptCodeMap(2765, 2765, 15), new UScriptCodeMap(2768, 2768, 15), new UScriptCodeMap(2784, 2784, 15), new UScriptCodeMap(2790, 2799, 15), new UScriptCodeMap(2817, 2817, 31), new UScriptCodeMap(2818, 2819, 31), new UScriptCodeMap(2821, 2828, 31), new UScriptCodeMap(2831, 2832, 31), new UScriptCodeMap(2835, 2856, 31), new UScriptCodeMap(2858, 2864, 31), new UScriptCodeMap(2866, 2867, 31), new UScriptCodeMap(2870, 2873, 31), new UScriptCodeMap(2876, 2876, 31), new UScriptCodeMap(2877, 2877, 31), new UScriptCodeMap(2878, 2878, 31), new UScriptCodeMap(2879, 2879, 31), new UScriptCodeMap(2880, 2880, 31), new UScriptCodeMap(2881, 2883, 31), new UScriptCodeMap(2887, 2888, 31), new UScriptCodeMap(2891, 2892, 31), new UScriptCodeMap(2893, 2893, 31), new UScriptCodeMap(2902, 2902, 31), new UScriptCodeMap(2903, 2903, 31), new UScriptCodeMap(2908, 2909, 31), new UScriptCodeMap(2911, 2913, 31), new UScriptCodeMap(2918, 2927, 31), new UScriptCodeMap(2946, 2946, 35), new UScriptCodeMap(2947, 2947, 35), new UScriptCodeMap(2949, 2954, 35), new UScriptCodeMap(2958, 2960, 35), new UScriptCodeMap(2962, 2965, 35), new UScriptCodeMap(2969, 2970, 35), new UScriptCodeMap(2972, 2972, 35), new UScriptCodeMap(2974, 2975, 35), new UScriptCodeMap(2979, 2980, 35), new UScriptCodeMap(2984, 2986, 35), new UScriptCodeMap(2990, 2997, 35), new UScriptCodeMap(2999, 3001, 35), new UScriptCodeMap(3006, 3007, 35), new UScriptCodeMap(3008, 3008, 35), new UScriptCodeMap(3009, 3010, 35), new UScriptCodeMap(3014, 3016, 35), new UScriptCodeMap(3018, 3020, 35), new UScriptCodeMap(3021, 3021, 35), new UScriptCodeMap(3031, 3031, 35), new UScriptCodeMap(3047, 3055, 35), new UScriptCodeMap(3056, 3058, 35), new UScriptCodeMap(3073, 3075, 36), new UScriptCodeMap(3077, 3084, 36), new UScriptCodeMap(3086, 3088, 36), new UScriptCodeMap(3090, 3112, 36), new UScriptCodeMap(3114, 3123, 36), new UScriptCodeMap(3125, 3129, 36), new UScriptCodeMap(3134, 3136, 36), new UScriptCodeMap(3137, 3140, 36), new UScriptCodeMap(3142, 3144, 36), new UScriptCodeMap(3146, 3149, 36), new UScriptCodeMap(3157, 3158, 36), new UScriptCodeMap(3168, 3169, 36), new UScriptCodeMap(3174, 3183, 36), new UScriptCodeMap(3202, 3203, 21), new UScriptCodeMap(3205, 3212, 21), new UScriptCodeMap(3214, 3216, 21), new UScriptCodeMap(3218, 3240, 21), new UScriptCodeMap(3242, 3251, 21), new UScriptCodeMap(3253, 3257, 21), new UScriptCodeMap(3262, 3262, 21), new UScriptCodeMap(3263, 3263, 21), new UScriptCodeMap(3264, 3268, 21), new UScriptCodeMap(3270, 3270, 21), new UScriptCodeMap(3271, 3272, 21), new UScriptCodeMap(3274, 3275, 21), new UScriptCodeMap(3276, 3277, 21), new UScriptCodeMap(3285, 3286, 21), new UScriptCodeMap(3294, 3294, 21), new UScriptCodeMap(3296, 3297, 21), new UScriptCodeMap(3302, 3311, 21), new UScriptCodeMap(3330, 3331, 26), new UScriptCodeMap(3333, 3340, 26), new UScriptCodeMap(3342, 3344, 26), new UScriptCodeMap(3346, 3368, 26), new UScriptCodeMap(3370, 3385, 26), new UScriptCodeMap(3390, 3392, 26), new UScriptCodeMap(3393, 3395, 26), new UScriptCodeMap(3398, 3400, 26), new UScriptCodeMap(3402, 3404, 26), new UScriptCodeMap(3405, 3405, 26), new UScriptCodeMap(3415, 3415, 26), new UScriptCodeMap(3424, 3425, 26), new UScriptCodeMap(3430, 3439, 26), new UScriptCodeMap(3458, 3459, 33), new UScriptCodeMap(3461, 3478, 33), new UScriptCodeMap(3482, 3505, 33), new UScriptCodeMap(3507, 3515, 33), new UScriptCodeMap(3517, 3517, 33), new UScriptCodeMap(3520, 3526, 33), new UScriptCodeMap(3530, 3530, 33), new UScriptCodeMap(3535, 3537, 33), new UScriptCodeMap(3538, 3540, 33), new UScriptCodeMap(3542, 3542, 33), new UScriptCodeMap(3544, 3551, 33), new UScriptCodeMap(3570, 3571, 33), new UScriptCodeMap(3585, 3632, 38), new UScriptCodeMap(3633, 3633, 38), new UScriptCodeMap(3634, 3635, 38), new UScriptCodeMap(3636, 3642, 38), new UScriptCodeMap(3648, 3653, 38), new UScriptCodeMap(3654, 3654, 38), new UScriptCodeMap(3655, 3662, 38), new UScriptCodeMap(3664, 3673, 38), new UScriptCodeMap(3713, 3714, 24), new UScriptCodeMap(3716, 3716, 24), new UScriptCodeMap(3719, 3720, 24), new UScriptCodeMap(3722, 3722, 24), new UScriptCodeMap(3725, 3725, 24), new UScriptCodeMap(3732, 3735, 24), new UScriptCodeMap(3737, 3743, 24), new UScriptCodeMap(3745, 3747, 24), new UScriptCodeMap(3749, 3749, 24), new UScriptCodeMap(3751, 3751, 24), new UScriptCodeMap(3754, 3755, 24), new UScriptCodeMap(3757, 3760, 24), new UScriptCodeMap(3761, 3761, 24), new UScriptCodeMap(3762, 3763, 24), new UScriptCodeMap(3764, 3769, 24), new UScriptCodeMap(3771, 3772, 24), new UScriptCodeMap(3773, 3773, 24), new UScriptCodeMap(3776, 3780, 24), new UScriptCodeMap(3782, 3782, 24), new UScriptCodeMap(3784, 3789, 24), new UScriptCodeMap(3792, 3801, 24), new UScriptCodeMap(3804, 3805, 24), new UScriptCodeMap(3840, 3840, 39), new UScriptCodeMap(3864, 3865, 39), new UScriptCodeMap(3872, 3881, 39), new UScriptCodeMap(3882, 3891, 39), new UScriptCodeMap(3893, 3893, 39), new UScriptCodeMap(3895, 3895, 39), new UScriptCodeMap(3897, 3897, 39), new UScriptCodeMap(3904, 3911, 39), new UScriptCodeMap(3913, 3946, 39), new UScriptCodeMap(3953, 3966, 39), new UScriptCodeMap(3967, 3967, 39), new UScriptCodeMap(3968, 3972, 39), new UScriptCodeMap(3974, 3975, 39), new UScriptCodeMap(3976, 3979, 39), new UScriptCodeMap(3984, 3991, 39), new UScriptCodeMap(3993, 4028, 39), new UScriptCodeMap(4038, 4038, 39), new UScriptCodeMap(4096, 4129, 28), new UScriptCodeMap(4131, 4135, 28), new UScriptCodeMap(4137, 4138, 28), new UScriptCodeMap(4140, 4140, 28), new UScriptCodeMap(4141, 4144, 28), new UScriptCodeMap(4145, 4145, 28), new UScriptCodeMap(4146, 4146, 28), new UScriptCodeMap(4150, 4151, 28), new UScriptCodeMap(4152, 4152, 28), new UScriptCodeMap(4153, 4153, 28), new UScriptCodeMap(4160, 4169, 28), new UScriptCodeMap(4176, 4181, 28), new UScriptCodeMap(4182, 4183, 28), new UScriptCodeMap(4184, 4185, 28), new UScriptCodeMap(4256, 4293, 12), new UScriptCodeMap(4304, 4342, 12), new UScriptCodeMap(4352, 4441, 18), new UScriptCodeMap(4447, 4514, 18), new UScriptCodeMap(4520, 4601, 18), new UScriptCodeMap(4608, 4614, 11), new UScriptCodeMap(4616, 4678, 11), new UScriptCodeMap(4680, 4680, 11), new UScriptCodeMap(4682, 4685, 11), new UScriptCodeMap(4688, 4694, 11), new UScriptCodeMap(4696, 4696, 11), new UScriptCodeMap(4698, 4701, 11), new UScriptCodeMap(4704, 4742, 11), new UScriptCodeMap(4744, 4744, 11), new UScriptCodeMap(4746, 4749, 11), new UScriptCodeMap(4752, 4782, 11), new UScriptCodeMap(4784, 4784, 11), new UScriptCodeMap(4786, 4789, 11), new UScriptCodeMap(4792, 4798, 11), new UScriptCodeMap(4800, 4800, 11), new UScriptCodeMap(4802, 4805, 11), new UScriptCodeMap(4808, 4814, 11), new UScriptCodeMap(4816, 4822, 11), new UScriptCodeMap(4824, 4846, 11), new UScriptCodeMap(4848, 4878, 11), new UScriptCodeMap(4880, 4880, 11), new UScriptCodeMap(4882, 4885, 11), new UScriptCodeMap(4888, 4894, 11), new UScriptCodeMap(4896, 4934, 11), new UScriptCodeMap(4936, 4954, 11), new UScriptCodeMap(4969, 4977, 11), new UScriptCodeMap(4978, 4988, 11), new UScriptCodeMap(5024, 5108, 6), new UScriptCodeMap(5121, 5740, 40), new UScriptCodeMap(5743, 5750, 40), new UScriptCodeMap(5761, 5786, 29), new UScriptCodeMap(5792, 5866, 32), new UScriptCodeMap(5870, 5872, 32), new UScriptCodeMap(6016, 6067, 23), new UScriptCodeMap(6068, 6070, 23), new UScriptCodeMap(6071, 6077, 23), new UScriptCodeMap(6078, 6085, 23), new UScriptCodeMap(6086, 6086, 23), new UScriptCodeMap(6087, 6088, 23), new UScriptCodeMap(6089, 6099, 23), new UScriptCodeMap(6112, 6121, 23), new UScriptCodeMap(6160, 6169, 27), new UScriptCodeMap(6176, 6210, 27), new UScriptCodeMap(6211, 6211, 27), new UScriptCodeMap(6212, 6263, 27), new UScriptCodeMap(6272, 6312, 27), new UScriptCodeMap(6313, 6313, 27), new UScriptCodeMap(7680, 7835, 25), new UScriptCodeMap(7840, 7929, 25), new UScriptCodeMap(7936, 7957, 14), new UScriptCodeMap(7960, 7965, 14), new UScriptCodeMap(7968, 8005, 14), new UScriptCodeMap(8008, 8013, 14), new UScriptCodeMap(8016, 8023, 14), new UScriptCodeMap(8025, 8025, 14), new UScriptCodeMap(8027, 8027, 14), new UScriptCodeMap(8029, 8029, 14), new UScriptCodeMap(8031, 8061, 14), new UScriptCodeMap(8064, 8116, 14), new UScriptCodeMap(8118, 8124, 14), new UScriptCodeMap(8126, 8126, 14), new UScriptCodeMap(8130, 8132, 14), new UScriptCodeMap(8134, 8140, 14), new UScriptCodeMap(8144, 8147, 14), new UScriptCodeMap(8150, 8155, 14), new UScriptCodeMap(8160, 8172, 14), new UScriptCodeMap(8178, 8180, 14), new UScriptCodeMap(8182, 8188, 14), new UScriptCodeMap(8319, 8319, 25), new UScriptCodeMap(8400, 8412, 1), new UScriptCodeMap(8413, 8416, 1), new UScriptCodeMap(8417, 8417, 1), new UScriptCodeMap(8418, 8419, 1), new UScriptCodeMap(8486, 8486, 14), new UScriptCodeMap(8490, 8491, 25), new UScriptCodeMap(11904, 11929, 17), new UScriptCodeMap(11931, 12019, 17), new UScriptCodeMap(12032, 12245, 17), new UScriptCodeMap(12293, 12293, 17), new UScriptCodeMap(12295, 12295, 17), new UScriptCodeMap(12321, 12329, 17), new UScriptCodeMap(12330, 12335, 1), new UScriptCodeMap(12344, 12346, 17), new UScriptCodeMap(12353, 12436, 20), new UScriptCodeMap(12441, 12442, 1), new UScriptCodeMap(12445, 12446, 20), new UScriptCodeMap(12449, 12538, 22), new UScriptCodeMap(12541, 12542, 22), new UScriptCodeMap(12549, 12588, 5), new UScriptCodeMap(12593, 12686, 18), new UScriptCodeMap(12704, 12727, 5), new UScriptCodeMap(13312, 19893, 17), new UScriptCodeMap(19968, 40869, 17), new UScriptCodeMap(40960, 42124, 41), new UScriptCodeMap(42128, 42145, 41), new UScriptCodeMap(42148, 42163, 41), new UScriptCodeMap(42165, 42176, 41), new UScriptCodeMap(42178, 42180, 41), new UScriptCodeMap(42182, 42182, 41), new UScriptCodeMap(44032, 55203, 18), new UScriptCodeMap(63744, 64045, 17), new UScriptCodeMap(64256, 64262, 25), new UScriptCodeMap(64275, 64279, 3), new UScriptCodeMap(64285, 64285, 19), new UScriptCodeMap(64286, 64286, 1), new UScriptCodeMap(64287, 64296, 19), new UScriptCodeMap(64298, 64310, 19), new UScriptCodeMap(64312, 64316, 19), new UScriptCodeMap(64318, 64318, 19), new UScriptCodeMap(64320, 64321, 19), new UScriptCodeMap(64323, 64324, 19), new UScriptCodeMap(64326, 64335, 19), new UScriptCodeMap(64336, 64433, 2), new UScriptCodeMap(64467, 64829, 2), new UScriptCodeMap(64848, 64911, 2), new UScriptCodeMap(64914, 64967, 2), new UScriptCodeMap(65008, 65019, 2), new UScriptCodeMap(65056, 65059, 1), new UScriptCodeMap(65136, 65138, 2), new UScriptCodeMap(65140, 65140, 2), new UScriptCodeMap(65142, 65276, 2), new UScriptCodeMap(65313, 65338, 25), new UScriptCodeMap(65345, 65370, 25), new UScriptCodeMap(65382, 65391, 22), new UScriptCodeMap(65393, 65437, 22), new UScriptCodeMap(65440, 65470, 18), new UScriptCodeMap(65474, 65479, 18), new UScriptCodeMap(65482, 65487, 18), new UScriptCodeMap(65490, 65495, 18), new UScriptCodeMap(65498, 65500, 18), new UScriptCodeMap(66304, 66334, 30), new UScriptCodeMap(66352, 66377, 13), new UScriptCodeMap(66378, 66378, 13), new UScriptCodeMap(66560, 66597, 9), new UScriptCodeMap(66600, 66637, 9), new UScriptCodeMap(119143, 119145, 1), new UScriptCodeMap(119163, 119170, 1), new UScriptCodeMap(119173, 119179, 1), new UScriptCodeMap(119210, 119213, 1), new UScriptCodeMap(131072, 173782, 17)};

    private static int findStringIndex(String[] sortedArr, String target) {
        int size = sortedArr.length;
        int left = 0;
        int right = size - 1;
        target = target.toUpperCase();
        while (left <= right) {
            int middle = (left + right) / 2;
            int rc = sortedArr[middle].toUpperCase().compareTo(target);
            if (rc < 0) {
                left = middle + 1;
                continue;
            }
            if (rc > 0) {
                right = middle - 1;
                continue;
            }
            return middle;
        }
        return -1;
    }

    private static int findCodeIndex(int[] unsorted, int target) {
        int size = unsorted.length;
        int i = 0;
        while (i < size) {
            if (target == unsorted[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int[] findCodeFromLocale(Locale locale) {
        ResourceBundle rb = ICULocaleData.getLocaleElements(locale);
        if (!LocaleUtility.isFallbackOf(rb.getLocale(), locale)) {
            return null;
        }
        String[] scripts = rb.getStringArray("LocaleScript");
        int[] result = new int[scripts.length];
        int w = 0;
        int i = 0;
        while (i < scripts.length) {
            int strIndex = UScript.findStringIndex(scriptAbbr, scripts[i]);
            if (strIndex != -1) {
                result[w++] = scriptAbbrCodes[strIndex];
            }
            ++i;
        }
        if (w < result.length) {
            throw new InternalError("bad locale data, listed " + scripts.length + " scripts but found only " + w);
        }
        return result;
    }

    private static int findScriptCode(int codepoint) {
        int left = 0;
        int right = scriptCodeIndex.length - 1;
        while (left <= right) {
            int middle = (left + right) / 2;
            int rc = UScript.scriptCodeIndex[middle].firstCodepoint <= codepoint && UScript.scriptCodeIndex[middle].lastCodepoint >= codepoint ? 0 : (codepoint > UScript.scriptCodeIndex[middle].lastCodepoint ? -1 : 1);
            if (rc < 0) {
                left = middle + 1;
                continue;
            }
            if (rc > 0) {
                right = middle - 1;
                continue;
            }
            return UScript.scriptCodeIndex[middle].scriptCode;
        }
        return 0;
    }

    public static final int[] getCode(Locale locale) throws MissingResourceException {
        return UScript.findCodeFromLocale(locale);
    }

    public static final int[] getCode(String nameOrAbbrOrLocale) {
        int[] code = new int[]{-1};
        int strIndex = 0;
        strIndex = UScript.findStringIndex(scriptNames, nameOrAbbrOrLocale);
        if (strIndex >= 0 && strIndex < scriptNames.length) {
            code[0] = scriptNameCodes[strIndex];
        }
        if (code[0] == -1 && (strIndex = UScript.findStringIndex(scriptAbbr, nameOrAbbrOrLocale)) >= 0 && strIndex < scriptAbbr.length) {
            code[0] = scriptAbbrCodes[strIndex];
        }
        if (code[0] == -1) {
            code = UScript.findCodeFromLocale(LocaleUtility.getLocaleFromName(nameOrAbbrOrLocale));
        }
        return code;
    }

    public static final int getScript(int codepoint) {
        if (codepoint >= 0 & codepoint <= 0x10FFFF) {
            return UScript.findScriptCode(codepoint);
        }
        throw new IllegalArgumentException(Integer.toString(codepoint));
    }

    public static final String getName(int scriptCode) {
        int index = -1;
        if (scriptCode > 42) {
            throw new IllegalArgumentException(Integer.toString(scriptCode));
        }
        index = UScript.findCodeIndex(scriptNameCodes, scriptCode);
        if (index >= 0) {
            return scriptNames[index];
        }
        throw new IllegalArgumentException(Integer.toString(scriptCode));
    }

    public static final String getShortName(int scriptCode) {
        int index = -1;
        if (scriptCode > 42) {
            throw new IllegalArgumentException(Integer.toString(scriptCode));
        }
        index = UScript.findCodeIndex(scriptAbbrCodes, scriptCode);
        if (index >= 0) {
            return scriptAbbr[index];
        }
        throw new IllegalArgumentException(Integer.toString(scriptCode));
    }

    private static final class UScriptCodeMap {
        int firstCodepoint;
        int lastCodepoint;
        int scriptCode;

        public UScriptCodeMap(int firstCp, int lastCp, int code) {
            this.firstCodepoint = firstCp;
            this.lastCodepoint = lastCp;
            this.scriptCode = code;
        }
    }
}

