/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.lang;

import com.ibm.icu.impl.Utility;
import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UCharacterCategory;
import com.ibm.icu.lang.UCharacterNameReader;
import com.ibm.icu.lang.UCharacterUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

final class UCharacterName {
    protected int m_groupcount_ = 0;
    protected int m_groupsize_ = 0;
    protected static final int LINES_PER_GROUP_ = 32;
    private char[] m_tokentable_;
    private byte[] m_tokenstring_;
    private char[] m_groupinfo_;
    private byte[] m_groupstring_;
    private AlgorithmName[] m_algorithm_;
    private char[] m_groupoffsets_ = new char[33];
    private char[] m_grouplengths_ = new char[33];
    private static final String NAME_FILE_NAME_ = "/com/ibm/icu/impl/data/unames.dat";
    private static final int GROUP_SHIFT_ = 5;
    private static final int GROUP_MASK_ = 31;
    private static final int NAME_BUFFER_SIZE_ = 100000;
    private static final int OFFSET_HIGH_OFFSET_ = 1;
    private static final int OFFSET_LOW_OFFSET_ = 2;
    private static final int SINGLE_NIBBLE_MAX_ = 11;

    public String toString() {
        StringBuffer result = new StringBuffer("names content \n");
        return result.toString();
    }

    protected UCharacterName() throws IOException {
        InputStream i = this.getClass().getResourceAsStream(NAME_FILE_NAME_);
        BufferedInputStream b = new BufferedInputStream(i, 100000);
        UCharacterNameReader reader = new UCharacterNameReader(b);
        reader.read(this);
        i.close();
    }

    protected String getName(int ch, int choice) {
        if (ch < 0 || ch > 0x10FFFF || choice >= 3) {
            return null;
        }
        String result = null;
        result = this.getAlgName(ch, choice);
        if (result == null || result.length() == 0) {
            result = choice == 2 ? this.getExtendedName(ch) : this.getGroupName(ch, choice);
        }
        return result;
    }

    protected int getCharFromName(int choice, String name) {
        if (choice >= 3 || name == null || name.length() == 0) {
            return -1;
        }
        int result = this.getExtendedChar(name.toLowerCase(), choice);
        if (result >= -1) {
            return result;
        }
        String upperCaseName = name.toUpperCase();
        if (choice != 1) {
            int count = 0;
            if (this.m_algorithm_ != null) {
                count = this.m_algorithm_.length;
            }
            --count;
            while (count >= 0) {
                result = this.m_algorithm_[count].getAlgorithmChar(upperCaseName);
                if (result >= 0) {
                    return result;
                }
                --count;
            }
        }
        if (choice == 2) {
            result = this.getGroupChar(upperCaseName, 0);
            if (result == -1) {
                result = this.getGroupChar(upperCaseName, 1);
            }
        } else {
            result = this.getGroupChar(upperCaseName, choice);
        }
        return result;
    }

    protected boolean setToken(char[] token, byte[] tokenstring) {
        if (token != null && tokenstring != null && token.length > 0 && tokenstring.length > 0) {
            this.m_tokentable_ = token;
            this.m_tokenstring_ = tokenstring;
            return true;
        }
        return false;
    }

    protected boolean setAlgorithm(AlgorithmName[] alg) {
        if (alg != null && alg.length != 0) {
            this.m_algorithm_ = alg;
            return true;
        }
        return false;
    }

    protected boolean setGroupCountSize(int count, int size) {
        if (count <= 0 || size <= 0) {
            return false;
        }
        this.m_groupcount_ = count;
        this.m_groupsize_ = size;
        return true;
    }

    protected boolean setGroup(char[] group, byte[] groupstring) {
        if (group != null && groupstring != null && group.length > 0 && groupstring.length > 0) {
            this.m_groupinfo_ = group;
            this.m_groupstring_ = groupstring;
            return true;
        }
        return false;
    }

    protected int getGroupLengths(int index, char[] offsets, char[] lengths) {
        int length = 65535;
        byte b = 0;
        byte n = 0;
        int stringoffset = UCharacterUtil.toInt(this.m_groupinfo_[(index *= this.m_groupsize_) + 1], this.m_groupinfo_[index + 2]);
        offsets[0] = '\u0000';
        int i = 0;
        while (i < 32) {
            b = this.m_groupstring_[stringoffset];
            int shift = 4;
            while (shift >= 0) {
                n = (byte)(b >> shift & 0xF);
                if (length == 65535 && n > 11) {
                    length = (char)(n - 12 << 4);
                } else {
                    lengths[i] = length != 65535 ? (char)((length | n) + 12) : (char)n;
                    if (i < 32) {
                        offsets[i + 1] = (char)(offsets[i] + lengths[i]);
                    }
                    length = 65535;
                    ++i;
                }
                shift -= 4;
            }
            ++stringoffset;
        }
        return stringoffset;
    }

    protected String getGroupName(int index, int length, int choice) {
        if (choice == 1) {
            int oldindex = index;
            index += UCharacterUtil.skipByteSubString(this.m_groupstring_, index, length, (byte)59);
            length -= index - oldindex;
        }
        StringBuffer s = new StringBuffer();
        int i = 0;
        while (i < length) {
            byte b = this.m_groupstring_[index + i];
            ++i;
            if (b >= this.m_tokentable_.length) {
                if (b == 59) break;
                s.append(b);
                continue;
            }
            char token = this.m_tokentable_[b & 0xFF];
            if (token == '\ufffe') {
                token = this.m_tokentable_[b << 8 | this.m_groupstring_[index + i] & 0xFF];
                ++i;
            }
            if (token == '\uffff') {
                if (b == 59) {
                    if (s.length() != 0 || choice != 2) break;
                    continue;
                }
                s.append((char)(b & 0xFF));
                continue;
            }
            UCharacterUtil.getNullTermByteSubString(s, this.m_tokenstring_, token);
        }
        if (s.length() == 0) {
            return null;
        }
        return s.toString();
    }

    protected String getExtendedName(int ch) {
        String result = this.getName(ch, 0);
        if (result == null) {
            if (this.getType(ch) == 15) {
                result = this.getName(ch, 1);
            }
            if (result == null) {
                result = this.getExtendedOr10Name(ch);
            }
        }
        return result;
    }

    protected int getGroup(int codepoint) {
        int endGroup = this.m_groupcount_;
        int msb = this.getCodepointMSB(codepoint);
        int result = 0;
        while (result < endGroup - 1) {
            int gindex = result + endGroup >> 1;
            if (msb < this.getGroupMSB(gindex)) {
                endGroup = gindex;
                continue;
            }
            result = gindex;
        }
        return result;
    }

    protected String getExtendedOr10Name(int ch) {
        String result = null;
        if (this.getType(ch) == 15) {
            result = this.getName(ch, 1);
        }
        if (result == null) {
            int type = this.getType(ch);
            result = type >= UCharacterCategory.TYPE_NAMES_.length ? "unknown" : UCharacterCategory.TYPE_NAMES_[type];
            StringBuffer tempResult = new StringBuffer(result);
            tempResult.insert(0, '<');
            tempResult.append('-');
            String chStr = Integer.toHexString(ch).toUpperCase();
            int zeros = 4 - chStr.length();
            while (zeros > 0) {
                tempResult.append('0');
                --zeros;
            }
            tempResult.append(chStr);
            tempResult.append('>');
            result = tempResult.toString();
        }
        return result;
    }

    protected int getGroupMSB(int gindex) {
        if (gindex >= this.m_groupcount_) {
            return -1;
        }
        return this.m_groupinfo_[gindex * this.m_groupsize_];
    }

    protected int getCodepointMSB(int codepoint) {
        return codepoint >> 5;
    }

    protected int getGroupLimit(int msb) {
        return (msb << 5) + 32;
    }

    protected int getGroupMin(int msb) {
        return msb << 5;
    }

    protected int getGroupOffset(int codepoint) {
        return codepoint & 0x1F;
    }

    protected int getGroupMinFromCodepoint(int codepoint) {
        return codepoint & 0xFFFFFFE0;
    }

    protected int getAlgorithmLength() {
        return this.m_algorithm_.length;
    }

    protected int getAlgorithmStart(int index) {
        return this.m_algorithm_[index].m_rangestart_;
    }

    protected int getAlgorithmEnd(int index) {
        return this.m_algorithm_[index].m_rangeend_;
    }

    protected String getAlgorithmName(int index, int codepoint) {
        StringBuffer result = new StringBuffer();
        this.m_algorithm_[index].appendName(codepoint, result);
        return result.toString();
    }

    private String getAlgName(int ch, int choice) {
        if (choice != 1) {
            StringBuffer s = new StringBuffer();
            int index = this.m_algorithm_.length - 1;
            while (index >= 0) {
                if (this.m_algorithm_[index].contains(ch)) {
                    this.m_algorithm_[index].appendName(ch, s);
                    return s.toString();
                }
                --index;
            }
        }
        return null;
    }

    private synchronized int getGroupChar(String name, int choice) {
        int i = 0;
        while (i < this.m_groupcount_) {
            int startgpstrindex = this.getGroupLengths(i, this.m_groupoffsets_, this.m_grouplengths_);
            int result = this.getGroupChar(startgpstrindex, this.m_grouplengths_, name, choice);
            if (result != -1) {
                return this.m_groupinfo_[i * this.m_groupsize_] << 5 | result;
            }
            ++i;
        }
        return -1;
    }

    private int getGroupChar(int index, char[] length, String name, int choice) {
        byte b = 0;
        int namelen = name.length();
        int result = 0;
        while (result <= 32) {
            int nindex = 0;
            int len = length[result];
            if (choice == 1) {
                int oldindex = index;
                index += UCharacterUtil.skipByteSubString(this.m_groupstring_, index, len, (byte)59);
                len -= index - oldindex;
            }
            int count = 0;
            while (count < len && nindex != -1 && nindex < namelen) {
                b = this.m_groupstring_[index + count];
                ++count;
                if (b >= this.m_tokentable_.length) {
                    if (name.charAt(nindex++) == (b & 0xFF)) continue;
                    nindex = -1;
                    continue;
                }
                char token = this.m_tokentable_[b & 0xFF];
                if (token == '\ufffe') {
                    token = this.m_tokentable_[b << 8 | this.m_groupstring_[index + count] & 0xFF];
                    ++count;
                }
                if (token == '\uffff') {
                    if (name.charAt(nindex++) == (b & 0xFF)) continue;
                    nindex = -1;
                    continue;
                }
                nindex = UCharacterUtil.compareNullTermByteSubString(name, this.m_tokenstring_, nindex, token);
            }
            if (namelen == nindex && (count == len || this.m_groupstring_[index + count] == 59)) {
                return result;
            }
            index += len;
            ++result;
        }
        return -1;
    }

    private int getGroupStringIndex(int ch) {
        int msb = ch >> 5;
        int end = this.m_groupcount_;
        int gindex = 0;
        int start = 0;
        while (start < end - 1) {
            gindex = start + end >> 1;
            if (msb < this.m_groupinfo_[gindex * this.m_groupsize_]) {
                end = gindex;
                continue;
            }
            start = gindex;
        }
        if (msb == this.m_groupinfo_[start * this.m_groupsize_]) {
            return UCharacterUtil.toInt(this.m_groupinfo_[(start *= this.m_groupsize_) + 1], this.m_groupinfo_[start + 2]);
        }
        return -1;
    }

    private synchronized String getGroupName(int ch, int choice) {
        int group;
        int msb = this.getCodepointMSB(ch);
        if (msb == this.m_groupinfo_[(group = this.getGroup(ch)) * this.m_groupsize_]) {
            int index = this.getGroupLengths(group, this.m_groupoffsets_, this.m_grouplengths_);
            int offset = ch & 0x1F;
            return this.getGroupName(index + this.m_groupoffsets_[offset], this.m_grouplengths_[offset], choice);
        }
        return null;
    }

    private int getType(int ch) {
        if (UCharacter.isNonCharacter(ch)) {
            return 30;
        }
        int result = UCharacter.getType(ch);
        if (result == 18) {
            result = ch <= 56319 ? 31 : 32;
        }
        return result;
    }

    private int getExtendedChar(String name, int choice) {
        if (name.charAt(0) == '<') {
            int startIndex;
            int endIndex;
            if (choice == 2 && name.charAt(endIndex = name.length() - 1) == '>' && (startIndex = name.lastIndexOf(45)) >= 0) {
                ++startIndex;
                int result = -1;
                try {
                    result = Integer.parseInt(name.substring(startIndex, endIndex), 16);
                }
                catch (NumberFormatException e) {
                    return -1;
                }
                String type = name.substring(1, startIndex - 1);
                int length = UCharacterCategory.TYPE_NAMES_.length;
                int i = 0;
                while (i < length) {
                    if (type.compareTo(UCharacterCategory.TYPE_NAMES_[i]) == 0) {
                        if (this.getType(result) != i) break;
                        return result;
                    }
                    ++i;
                }
            }
            return -1;
        }
        return -2;
    }

    static final class AlgorithmName {
        protected static final int TYPE_0_ = 0;
        protected static final int TYPE_1_ = 1;
        private int m_rangestart_;
        private int m_rangeend_;
        private byte m_type_;
        private byte m_variant_;
        private char[] m_factor_;
        private String m_prefix_;
        private byte[] m_factorstring_;

        protected AlgorithmName() {
        }

        protected boolean setInfo(int rangestart, int rangeend, byte type, byte variant) {
            if (rangestart >= 0 && rangestart <= rangeend && rangeend <= 0x10FFFF && (type == 0 || type == 1)) {
                this.m_rangestart_ = rangestart;
                this.m_rangeend_ = rangeend;
                this.m_type_ = type;
                this.m_variant_ = variant;
                return true;
            }
            return false;
        }

        protected boolean setFactor(char[] factor) {
            if (factor.length == this.m_variant_) {
                this.m_factor_ = factor;
                return true;
            }
            return false;
        }

        protected boolean setPrefix(String prefix) {
            if (prefix != null && prefix.length() > 0) {
                this.m_prefix_ = prefix;
                return true;
            }
            return false;
        }

        protected boolean setFactorString(byte[] string) {
            this.m_factorstring_ = string;
            return true;
        }

        protected boolean contains(int ch) {
            return this.m_rangestart_ <= ch && ch <= this.m_rangeend_;
        }

        protected void appendName(int ch, StringBuffer str) {
            str.append(this.m_prefix_);
            switch (this.m_type_) {
                case 0: {
                    Utility.hex(ch, this.m_variant_, str);
                    break;
                }
                case 1: {
                    int offset = ch - this.m_rangestart_;
                    int[] indexes = new int[this.m_variant_];
                    int i = this.m_variant_ - 1;
                    while (i > 0) {
                        int factor = this.m_factor_[i] & 0xFF;
                        indexes[i] = offset % factor;
                        offset /= factor;
                        --i;
                    }
                    indexes[0] = offset;
                    String[] s = this.getFactorString(indexes);
                    if (s == null || s.length <= 0) break;
                    int size = s.length;
                    int i2 = 0;
                    while (i2 < size) {
                        str.append(s[i2]);
                        ++i2;
                    }
                    break;
                }
            }
        }

        protected int getAlgorithmChar(String name) {
            int prefixlen = this.m_prefix_.length();
            if (name.length() < prefixlen || !this.m_prefix_.equals(name.substring(0, prefixlen))) {
                return -1;
            }
            switch (this.m_type_) {
                case 0: {
                    try {
                        int result = Integer.parseInt(name.substring(prefixlen), 16);
                        if (this.m_rangestart_ > result || result > this.m_rangeend_) break;
                        return result;
                    }
                    catch (NumberFormatException e) {
                        return -1;
                    }
                }
                case 1: {
                    int ch = this.m_rangestart_;
                    while (ch <= this.m_rangeend_) {
                        int offset = ch - this.m_rangestart_;
                        int[] indexes = new int[this.m_variant_];
                        int i = this.m_variant_ - 1;
                        while (i > 0) {
                            int factor = this.m_factor_[i] & 0xFF;
                            indexes[i] = offset % factor;
                            offset /= factor;
                            --i;
                        }
                        indexes[0] = offset;
                        if (this.compareFactorString(indexes, name, prefixlen)) {
                            return ch;
                        }
                        ++ch;
                    }
                    break;
                }
            }
            return -1;
        }

        private String[] getFactorString(int[] index) {
            int size = this.m_factor_.length;
            if (index == null || index.length != size) {
                return null;
            }
            String[] result = new String[size];
            StringBuffer str = new StringBuffer();
            int count = 0;
            --size;
            int i = 0;
            while (i <= size) {
                char factor = this.m_factor_[i];
                count = UCharacterUtil.skipNullTermByteSubString(this.m_factorstring_, count, index[i]);
                count = UCharacterUtil.getNullTermByteSubString(str, this.m_factorstring_, count);
                if (i != size) {
                    count = UCharacterUtil.skipNullTermByteSubString(this.m_factorstring_, count, factor - index[i] - 1);
                }
                result[i] = str.toString();
                str.delete(0, str.length());
                ++i;
            }
            return result;
        }

        private boolean compareFactorString(int[] index, String str, int offset) {
            int size = this.m_factor_.length;
            if (index == null || index.length != size) {
                return false;
            }
            int count = 0;
            int strcount = offset;
            --size;
            int i = 0;
            while (i <= size) {
                char factor = this.m_factor_[i];
                if ((strcount = UCharacterUtil.compareNullTermByteSubString(str, this.m_factorstring_, strcount, count = UCharacterUtil.skipNullTermByteSubString(this.m_factorstring_, count, index[i]))) < 0) {
                    return false;
                }
                if (i != size) {
                    count = UCharacterUtil.skipNullTermByteSubString(this.m_factorstring_, count, factor - index[i]);
                }
                ++i;
            }
            return strcount == str.length();
        }
    }
}

