/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.CharTrie;
import com.ibm.icu.impl.NormalizerImpl;
import com.ibm.icu.impl.Trie;
import com.ibm.icu.impl.UCharacterIterator;
import com.ibm.icu.impl.UCharacterPropertyReader;
import com.ibm.icu.text.BreakIterator;
import com.ibm.icu.text.UTF16;
import com.ibm.icu.util.VersionInfo;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;

public final class UCharacterProperty
implements Trie.DataManipulate {
    public CharTrie m_trie_;
    public int[] m_property_;
    public VersionInfo m_unicodeVersion_;
    public static final int EXC_UPPERCASE_ = 0;
    public static final int EXC_LOWERCASE_ = 1;
    public static final int EXC_TITLECASE_ = 2;
    public static final int EXC_UNUSED_ = 3;
    public static final int EXC_NUMERIC_VALUE_ = 4;
    public static final int EXC_DENOMINATOR_VALUE_ = 5;
    public static final int EXC_MIRROR_MAPPING_ = 6;
    public static final int EXC_SPECIAL_CASING_ = 7;
    public static final int EXC_CASE_FOLDING_ = 8;
    public static final int EXC_COMBINING_CLASS_ = 9;
    public static final int NON_NUMERIC_TYPE_ = 0;
    public static final int DECIMAL_DIGIT_NUMERIC_TYPE_ = 1;
    public static final int DIGIT_NUMERIC_TYPE_ = 2;
    public static final int NON_DIGIT_NUMERIC_TYPE_ = 3;
    public static final int MAX_CASE_MAP_SIZE = 10;
    public static final String TURKISH_ = "tr";
    public static final String AZERBAIJANI_ = "az";
    public static final String LITHUANIAN_ = "lt";
    public static final char LATIN_CAPITAL_LETTER_I_WITH_DOT_ABOVE_ = '\u0130';
    public static final char LATIN_SMALL_LETTER_DOTLESS_I_ = '\u0131';
    public static final char LATIN_SMALL_LETTER_I_ = 'i';
    protected char[] m_case_;
    protected int[] m_exception_;
    protected CharTrie m_additionalTrie_;
    protected int[] m_additionalVectors_;
    protected int m_additionalColumnsCount_;
    public static UCharacterProperty INSTANCE_ = null;
    private static final String DATA_FILE_NAME_ = "data/uprops.dat";
    private static final int DATA_BUFFER_SIZE_ = 25000;
    private static final int EXC_GROUP_ = 8;
    private static final int EXC_GROUP_MASK_ = 255;
    private static final int EXC_DIGIT_MASK_ = 65535;
    private static final byte[] FLAGS_OFFSET_ = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
    private static final int VALUE_SHIFT_ = 20;
    private static final int EXCEPTION_MASK_ = 32;
    private static final int UNSIGNED_VALUE_MASK_AFTER_SHIFT_ = 2047;
    private static final int BIDI_SHIFT_ = 6;
    private static final int BIDI_MASK_AFTER_SHIFT_ = 31;
    private static final int MIRROR_MASK_ = 2048;
    private static final int NUMERIC_TYPE_SHIFT_ = 12;
    private static final int NUMERIC_TYPE_MASK_ = 7;
    private static final int RESERVED_SHIFT_ = 15;
    private static final int EXCEPTION_BIT = 32;
    private static final int VALUE_BITS_ = 65516;
    private static final int MIN_VALUE_ = -2048;
    private static final int MAX_VALUE_ = 2047;
    private static int MAX_EXCEPTIONS_COUNT_ = 4096;
    private static final int LAST_5_BIT_MASK_ = 31;
    private static final int SHIFT_5_ = 5;
    private static final int SHIFT_10_ = 10;
    private static final int SUPPLEMENTARY_FOLD_INDICATOR_MASK_ = 32768;
    private static final int SUPPLEMENTARY_FOLD_OFFSET_MASK_ = Short.MAX_VALUE;
    private static final int LEAD_SURROGATE_SHIFT_ = 10;
    private static final int SURROGATE_OFFSET_ = -56613888;
    private static final char LATIN_CAPITAL_LETTER_I_ = 'I';
    private static final char COMBINING_DOT_ABOVE_ = '\u0307';
    private static final int LATIN_SMALL_LETTER_J_ = 106;
    private static final int LATIN_SMALL_LETTER_I_WITH_OGONEK_ = 303;
    private static final int LATIN_SMALL_LETTER_I_WITH_TILDE_BELOW_ = 7725;
    private static final int LATIN_SMALL_LETTER_I_WITH_DOT_BELOW_ = 7883;
    private static final int COMBINING_MARK_ABOVE_CLASS_ = 230;
    private static final int LATIN_CAPITAL_LETTER_J_ = 74;
    private static final int LATIN_CAPITAL_I_WITH_OGONEK_ = 302;
    private static final int LATIN_CAPITAL_I_WITH_TILDE_ = 296;
    private static final int LATIN_CAPITAL_I_WITH_GRAVE_ = 204;
    private static final int LATIN_CAPITAL_I_WITH_ACUTE_ = 205;
    private static final int COMBINING_GRAVE_ACCENT_ = 768;
    private static final int COMBINING_ACUTE_ACCENT_ = 769;
    private static final int COMBINING_TILDE_ = 771;
    private static final char GREEK_CAPITAL_LETTER_SIGMA_ = '\u03a3';
    private static final char GREEK_SMALL_LETTER_SIGMA_ = '\u03c3';
    private static final char GREEK_SMALL_LETTER_RHO_ = '\u03c2';
    private static final int HYPHEN_ = 8208;
    private static final int SOFT_HYPHEN_ = 173;
    private static final int LAST_CHAR_MASK_ = 65535;
    private static final int LAST_BYTE_MASK_ = 255;
    private static final int SHIFT_16_ = 16;
    private static final int WHITE_SPACE_PROPERTY_ = 0;
    private static final int BIDI_CONTROL_PROPERTY_ = 1;
    private static final int JOIN_CONTROL_PROPERTY_ = 2;
    private static final int DASH_PROPERTY_ = 3;
    private static final int HYPHEN_PROPERTY_ = 4;
    private static final int QUOTATION_MARK_PROPERTY_ = 5;
    private static final int TERMINAL_PUNCTUATION_PROPERTY_ = 6;
    private static final int OTHER_MATH_PROPERTY_ = 7;
    private static final int HEX_DIGIT_PROPERTY_ = 8;
    private static final int ASCII_HEX_DIGIT_PROPERTY_ = 9;
    private static final int OTHER_ALPHABETIC_PROPERTY_ = 10;
    private static final int IDEOGRAPHIC_PROPERTY_ = 11;
    private static final int DIACRITIC_PROPERTY_ = 12;
    private static final int EXTENDER_PROPERTY_ = 13;
    private static final int OTHER_LOWERCASE_PROPERTY_ = 14;
    private static final int OTHER_UPPERCASE_PROPERTY_ = 15;
    private static final int NONCHARACTER_CODE_POINT_PROPERTY_ = 16;
    private static final int OTHER_GRAPHEME_EXTEND_PROPERTY_ = 17;
    private static final int GRAPHEME_LINK_PROPERTY_ = 18;
    private static final int IDS_BINARY_OPERATOR_PROPERTY_ = 19;
    private static final int IDS_TRINARY_OPERATOR_PROPERTY_ = 20;
    private static final int RADICAL_PROPERTY_ = 21;
    private static final int UNIFIED_IDEOGRAPH_PROPERTY_ = 22;
    private static final int OTHER_DEFAULT_IGNORABLE_CODE_POINT_PROPERTY_ = 23;
    private static final int DEPRECATED_PROPERTY_ = 24;
    private static final int SOFT_DOTTED_PROPERTY_ = 25;
    private static final int LOGICAL_ORDER_EXCEPTION_PROPERTY_ = 26;
    private static final int XID_START_PROPERTY_ = 27;
    private static final int XID_CONTINUE_PROPERTY_ = 28;
    private static final int BINARY_1_TOP_PROPERTY_ = 29;
    private static final int FIRST_NIBBLE_SHIFT_ = 4;
    private static final int LAST_NIBBLE_MASK_ = 15;
    private static final int AGE_SHIFT_ = 24;

    public String toString() {
        StringBuffer result = new StringBuffer("Property block\n");
        result.append(super.toString());
        result.append("\nsize of property data ");
        result.append(this.m_property_.length);
        result.append("\nsize of exception data ");
        result.append(this.m_exception_.length);
        result.append("\nsize of case data ");
        result.append(this.m_case_.length);
        return result.toString();
    }

    public int extract(int value) {
        return UCharacterProperty.getPropType(this.m_property_[value]);
    }

    public int getFoldingOffset(int value) {
        if ((value & 0x8000) != 0) {
            return value & Short.MAX_VALUE;
        }
        return 0;
    }

    public int getProperty(int ch) {
        return this.m_property_[this.m_trie_.getCodePointValue(ch)];
    }

    public static int getPropType(int prop) {
        return prop & 0x1F;
    }

    public static boolean isExceptionIndicator(int prop) {
        return (prop & 0x20) != 0;
    }

    public static int getNumericType(int prop) {
        return prop >> 12 & 7;
    }

    public static int getSignedValue(int prop) {
        return prop >> 20;
    }

    public static int getExceptionIndex(int prop) {
        return prop >> 20 & 0x7FF;
    }

    public static boolean isMirrored(int prop) {
        return (prop & 0x800) != 0;
    }

    public static int getDirection(int prop) {
        return prop >> 6 & 0x1F;
    }

    public static int getUnsignedValue(int prop) {
        return prop >> 20 & 0x7FF;
    }

    public boolean hasExceptionValue(int index, int indicator) {
        return (this.m_exception_[index] & 1 << indicator) != 0;
    }

    public int getException(int index, int etype) {
        int evalue = this.m_exception_[index];
        switch (etype) {
            case 9: {
                return evalue;
            }
        }
        ++index;
        index = this.addExceptionOffset(evalue, etype, index);
        return this.m_exception_[index];
    }

    public int getFoldCase(int index) {
        char single = this.m_case_[index];
        if ('\ud800' <= single && single <= '\udfff') {
            if (single <= '\udbff') {
                char trail = this.m_case_[index + 1];
                if ('\ud800' <= trail && trail <= '\udfff') {
                    return UCharacterProperty.getRawSupplementary(single, trail);
                }
            } else {
                char lead = this.m_case_[index - 1];
                if ('\ud800' <= lead && lead <= '\udbff') {
                    return UCharacterProperty.getRawSupplementary(lead, single);
                }
            }
        }
        return single;
    }

    public void getFoldCase(int index, int count, StringBuffer str) {
        index += 2;
        while (count > 0) {
            str.append(this.m_case_[index]);
            ++index;
            --count;
        }
    }

    public void getUpperCase(int index, StringBuffer buffer) {
        int count = this.m_case_[index];
        index += (count & 0x1F) + 1;
        count = count >> 5 & 0x1F;
        int j = 0;
        while (j < count) {
            buffer.append(this.m_case_[index + j]);
            ++j;
        }
    }

    public void getTitleCase(int index, StringBuffer buffer) {
        int count = this.m_case_[index];
        index += (count & 0x1F) + 1 + (count >> 5 & 0x1F);
        count = count >> 10 & 0x1F;
        int j = 0;
        while (j < count) {
            buffer.append(this.m_case_[index + j]);
            ++j;
        }
    }

    public void getLowerCase(int index, StringBuffer buffer) {
        int count = this.m_case_[index] & 0x1F;
        ++index;
        int j = 0;
        while (j < count) {
            buffer.append(this.m_case_[index + j]);
            ++j;
        }
    }

    public int getAdditional(int codepoint, int column) {
        if (column < 0 || column >= this.m_additionalColumnsCount_) {
            return 0;
        }
        return this.m_additionalVectors_[this.m_additionalTrie_.getCodePointValue(codepoint) + column];
    }

    public VersionInfo getAge(int codepoint) {
        int version = this.getAdditional(codepoint, 0) >> 24;
        return VersionInfo.getInstance(version >> 4 & 0xF, version & 0xF, 0, 0);
    }

    public boolean hasBinaryProperty(int codepoint, int property) {
        switch (property) {
            case 0: {
                int generaltype = UCharacterProperty.getPropType(this.getProperty(codepoint));
                boolean generalmatch = generaltype == 1 || generaltype == 2 || generaltype == 3 || generaltype == 4 || generaltype == 5;
                return generalmatch || this.compareAdditionalType(this.getAdditional(codepoint, 1), 10);
            }
            case 1: {
                return this.compareAdditionalType(this.getAdditional(codepoint, 1), 9);
            }
            case 2: {
                return this.compareAdditionalType(this.getAdditional(codepoint, 1), 1);
            }
            case 3: {
                return UCharacterProperty.isMirrored(this.getProperty(codepoint));
            }
            case 4: {
                return this.compareAdditionalType(this.getAdditional(codepoint, 1), 3);
            }
            case 5: {
                int generaltype = UCharacterProperty.getPropType(this.getProperty(codepoint));
                if (generaltype == 16 || generaltype == 15 || generaltype == 18) {
                    return true;
                }
                int additionalproperty = this.getAdditional(codepoint, 1);
                return this.compareAdditionalType(additionalproperty, 23) || this.compareAdditionalType(additionalproperty, 0) || this.compareAdditionalType(additionalproperty, 23);
            }
            case 6: {
                return this.compareAdditionalType(this.getAdditional(codepoint, 1), 24);
            }
            case 7: {
                return this.compareAdditionalType(this.getAdditional(codepoint, 1), 12);
            }
            case 8: {
                return this.compareAdditionalType(this.getAdditional(codepoint, 1), 13);
            }
            case 9: {
                return NormalizerImpl.isFullCompositionExclusion(codepoint);
            }
            case 10: {
                int generaltype = UCharacterProperty.getPropType(this.getProperty(codepoint));
                if (generaltype == 16 || generaltype == 18 || generaltype == 17 || generaltype == 0 || generaltype == 13 || generaltype == 14 || generaltype == 7 || generaltype == 6 || generaltype == 8) {
                    return true;
                }
                int additionalproperty = this.getAdditional(codepoint, 1);
                return this.compareAdditionalType(additionalproperty, 18) || this.compareAdditionalType(additionalproperty, 17);
            }
            case 11: {
                int generaltype = UCharacterProperty.getPropType(this.getProperty(codepoint));
                if (generaltype == 7 || generaltype == 6 || generaltype == 8) {
                    return true;
                }
                int additionalproperty = this.getAdditional(codepoint, 1);
                return this.compareAdditionalType(additionalproperty, 17) || this.compareAdditionalType(additionalproperty, 18) || this.compareAdditionalType(additionalproperty, 17);
            }
            case 12: {
                return this.compareAdditionalType(this.getAdditional(codepoint, 1), 18);
            }
            case 13: {
                return this.compareAdditionalType(this.getAdditional(codepoint, 1), 8);
            }
            case 14: {
                return this.compareAdditionalType(this.getAdditional(codepoint, 1), 4);
            }
            case 15: {
                int generaltype = UCharacterProperty.getPropType(this.getProperty(codepoint));
                return generaltype == 1 || generaltype == 2 || generaltype == 3 || generaltype == 4 || generaltype == 5 || generaltype == 10 || generaltype == 6 || generaltype == 8 || generaltype == 9 || generaltype == 22;
            }
            case 16: {
                int generaltype = UCharacterProperty.getPropType(this.getProperty(codepoint));
                return generaltype == 1 || generaltype == 2 || generaltype == 3 || generaltype == 4 || generaltype == 5 || generaltype == 10;
            }
            case 17: {
                return this.compareAdditionalType(this.getAdditional(codepoint, 1), 11);
            }
            case 18: {
                return this.compareAdditionalType(this.getAdditional(codepoint, 1), 19);
            }
            case 19: {
                return this.compareAdditionalType(this.getAdditional(codepoint, 1), 20);
            }
            case 20: {
                return this.compareAdditionalType(this.getAdditional(codepoint, 1), 2);
            }
            case 21: {
                return this.compareAdditionalType(this.getAdditional(codepoint, 1), 26);
            }
            case 22: {
                int generaltype = UCharacterProperty.getPropType(this.getProperty(codepoint));
                if (generaltype == 2) {
                    return true;
                }
                return this.compareAdditionalType(this.getAdditional(codepoint, 1), 14);
            }
            case 23: {
                int generaltype = UCharacterProperty.getPropType(this.getProperty(codepoint));
                if (generaltype == 24) {
                    return true;
                }
                return this.compareAdditionalType(this.getAdditional(codepoint, 1), 7);
            }
            case 24: {
                return this.compareAdditionalType(this.getAdditional(codepoint, 1), 16);
            }
            case 25: {
                return this.compareAdditionalType(this.getAdditional(codepoint, 1), 5);
            }
            case 26: {
                return this.compareAdditionalType(this.getAdditional(codepoint, 1), 21);
            }
            case 27: {
                return this.compareAdditionalType(this.getAdditional(codepoint, 1), 25);
            }
            case 28: {
                return this.compareAdditionalType(this.getAdditional(codepoint, 1), 6);
            }
            case 29: {
                return this.compareAdditionalType(this.getAdditional(codepoint, 1), 22);
            }
            case 30: {
                int generaltype = UCharacterProperty.getPropType(this.getProperty(codepoint));
                if (generaltype == 1) {
                    return true;
                }
                return this.compareAdditionalType(this.getAdditional(codepoint, 1), 15);
            }
            case 31: {
                return this.compareAdditionalType(this.getAdditional(codepoint, 1), 0);
            }
            case 32: {
                return this.compareAdditionalType(this.getAdditional(codepoint, 1), 28);
            }
            case 33: {
                return this.compareAdditionalType(this.getAdditional(codepoint, 1), 27);
            }
        }
        return false;
    }

    public static int getRawSupplementary(char lead, char trail) {
        return (lead << 10) + trail + -56613888;
    }

    public static UCharacterProperty getInstance() throws RuntimeException {
        if (INSTANCE_ == null) {
            try {
                INSTANCE_ = new UCharacterProperty();
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        return INSTANCE_;
    }

    public int getSpecialLowerCase(Locale locale, int index, int ch, UCharacterIterator uchariter, StringBuffer buffer) {
        int exception = this.getException(index, 7);
        if (exception < 0) {
            String language;
            int offset = uchariter.getIndex();
            if (locale.getLanguage().equals(LITHUANIAN_) && ((ch == 73 || ch == 74 || ch == 302) && UCharacterProperty.isFollowedByMOREABOVE(uchariter, offset) || ch == 204 || ch == 205 || ch == 296)) {
                switch (ch) {
                    case 73: {
                        buffer.append('i');
                        buffer.append('\u0307');
                        return 2;
                    }
                    case 74: {
                        buffer.append('j');
                        buffer.append('\u0307');
                        return 2;
                    }
                    case 302: {
                        buffer.append('\u012f');
                        buffer.append('\u0307');
                        return 2;
                    }
                    case 204: {
                        buffer.append('i');
                        buffer.append('\u0307');
                        buffer.append('\u0300');
                        return 3;
                    }
                    case 205: {
                        buffer.append('i');
                        buffer.append('\u0307');
                        buffer.append('\u0301');
                        return 3;
                    }
                    case 296: {
                        buffer.append('i');
                        buffer.append('\u0307');
                        buffer.append('\u0303');
                        return 3;
                    }
                }
            }
            if (((language = locale.getLanguage()).equals(TURKISH_) || language.equals(AZERBAIJANI_)) && ch == 73 && !UCharacterProperty.isFollowedByDotAbove(uchariter, offset)) {
                buffer.append('\u0131');
                return 1;
            }
            if (ch == 775 && UCharacterProperty.isAFTER_I(uchariter, offset) && !UCharacterProperty.isFollowedByMOREABOVE(uchariter, offset)) {
                return 0;
            }
            if (ch == 931 && this.isCFINAL(uchariter, offset) && this.isNotCINITIAL(uchariter, offset)) {
                buffer.append('\u03c2');
                return 1;
            }
            if (this.hasExceptionValue(index, 1)) {
                int oldlength = buffer.length();
                UTF16.append(buffer, this.getException(index, 1));
                return buffer.length() - oldlength;
            }
            UTF16.append(buffer, ch);
            return UTF16.getCharCount(ch);
        }
        index = exception & 0xFFFF;
        int oldlength = buffer.length();
        this.getLowerCase(index, buffer);
        return buffer.length() - oldlength;
    }

    public int toLowerCase(Locale locale, int ch, UCharacterIterator uchariter, StringBuffer buffer) {
        int props = this.getProperty(ch);
        if (!UCharacterProperty.isExceptionIndicator(props)) {
            int type = UCharacterProperty.getPropType(props);
            if (type == 1 || type == 3) {
                ch += UCharacterProperty.getSignedValue(props);
            }
        } else {
            int index = UCharacterProperty.getExceptionIndex(props);
            if (this.hasExceptionValue(index, 7)) {
                return this.getSpecialLowerCase(locale, index, ch, uchariter, buffer);
            }
            if (this.hasExceptionValue(index, 1)) {
                ch = this.getException(index, 1);
            }
        }
        UTF16.append(buffer, ch);
        return UTF16.getCharCount(ch);
    }

    public int toLowerCase(Locale locale, int ch, UCharacterIterator uchariter, char[] buffer) {
        int props = this.getProperty(ch);
        if (!UCharacterProperty.isExceptionIndicator(props)) {
            int type = UCharacterProperty.getPropType(props);
            if (type == 1 || type == 3) {
                ch += UCharacterProperty.getSignedValue(props);
            }
        } else {
            int index = UCharacterProperty.getExceptionIndex(props);
            if (this.hasExceptionValue(index, 7)) {
                StringBuffer strbuffer = new StringBuffer(1);
                int result = this.getSpecialLowerCase(locale, index, ch, uchariter, strbuffer);
                strbuffer.getChars(0, result, buffer, 0);
                return result;
            }
            if (this.hasExceptionValue(index, 1)) {
                ch = this.getException(index, 1);
            }
        }
        if (ch < 65536) {
            buffer[0] = (char)ch;
            return 1;
        }
        buffer[0] = UTF16.getLeadSurrogate(ch);
        buffer[1] = UTF16.getTrailSurrogate(ch);
        return 2;
    }

    public void toLowerCase(Locale locale, String str, int start, int limit, StringBuffer result) {
        UCharacterIterator ucharIter = new UCharacterIterator(str);
        int strIndex = start;
        while (strIndex < limit) {
            ucharIter.setIndex(strIndex);
            int ch = ucharIter.currentCodePoint();
            this.toLowerCase(locale, ch, ucharIter, result);
            ++strIndex;
            if (ch <= 65536) continue;
            ++strIndex;
        }
    }

    public int getSpecialUpperOrTitleCase(Locale locale, int index, int ch, UCharacterIterator uchariter, boolean upperflag, StringBuffer buffer) {
        int exception = this.getException(index, 7);
        if (exception < 0) {
            String language = locale.getLanguage();
            if ((language.equals(TURKISH_) || language.equals(AZERBAIJANI_)) && ch == 105) {
                buffer.append('\u0130');
                return 1;
            }
            if (language.equals(LITHUANIAN_) && ch == 775 && UCharacterProperty.isAFTER_i(uchariter, uchariter.getIndex())) {
                return 0;
            }
            if (!upperflag && this.hasExceptionValue(index, 2)) {
                ch = this.getException(index, 2);
            } else if (this.hasExceptionValue(index, 0)) {
                ch = this.getException(index, 0);
            }
            UTF16.append(buffer, ch);
            return UTF16.getCharCount(ch);
        }
        index = exception & 0xFFFF;
        int oldlength = buffer.length();
        if (upperflag) {
            this.getUpperCase(index, buffer);
        } else {
            this.getTitleCase(index, buffer);
        }
        return buffer.length() - oldlength;
    }

    public int toUpperOrTitleCase(Locale locale, int ch, UCharacterIterator uchariter, boolean upperflag, StringBuffer buffer) {
        int props = this.getProperty(ch);
        if (!UCharacterProperty.isExceptionIndicator(props)) {
            int type = UCharacterProperty.getPropType(props);
            if (type == 2) {
                ch -= UCharacterProperty.getSignedValue(props);
            }
        } else {
            int index = UCharacterProperty.getExceptionIndex(props);
            if (this.hasExceptionValue(index, 7)) {
                return this.getSpecialUpperOrTitleCase(locale, index, ch, uchariter, upperflag, buffer);
            }
            if (!upperflag && this.hasExceptionValue(index, 2)) {
                ch = this.getException(index, 2);
            } else if (this.hasExceptionValue(index, 0)) {
                ch = this.getException(index, 0);
            }
        }
        UTF16.append(buffer, ch);
        return UTF16.getCharCount(ch);
    }

    public int toUpperOrTitleCase(Locale locale, int ch, UCharacterIterator uchariter, boolean upperflag, char[] buffer) {
        int props = this.getProperty(ch);
        if (!UCharacterProperty.isExceptionIndicator(props)) {
            int type = UCharacterProperty.getPropType(props);
            if (type == 2) {
                ch -= UCharacterProperty.getSignedValue(props);
            }
        } else {
            int index = UCharacterProperty.getExceptionIndex(props);
            if (this.hasExceptionValue(index, 7)) {
                StringBuffer strbuffer = new StringBuffer(1);
                int result = this.getSpecialUpperOrTitleCase(locale, index, ch, uchariter, upperflag, strbuffer);
                strbuffer.getChars(0, result, buffer, 0);
                return result;
            }
            if (!upperflag && this.hasExceptionValue(index, 2)) {
                ch = this.getException(index, 2);
            } else if (this.hasExceptionValue(index, 0)) {
                ch = this.getException(index, 0);
            }
        }
        if (ch < 65536) {
            buffer[0] = (char)ch;
            return 1;
        }
        buffer[0] = UTF16.getLeadSurrogate(ch);
        buffer[1] = UTF16.getTrailSurrogate(ch);
        return 2;
    }

    public String toUpperCase(Locale locale, String str, int start, int limit) {
        UCharacterIterator ucharIter = new UCharacterIterator(str);
        int strIndex = start;
        StringBuffer result = new StringBuffer(limit - start);
        while (strIndex < limit) {
            ucharIter.setIndex(strIndex);
            int ch = ucharIter.currentCodePoint();
            this.toUpperOrTitleCase(locale, ch, ucharIter, true, result);
            ++strIndex;
            if (ch <= 65536) continue;
            ++strIndex;
        }
        return result.toString();
    }

    public String toTitleCase(Locale locale, String str, BreakIterator breakiter) {
        UCharacterIterator ucharIter = new UCharacterIterator(str);
        int length = str.length();
        StringBuffer result = new StringBuffer();
        breakiter.setText(str);
        int index = breakiter.first();
        while (index != -1 && index < length) {
            int ch = UTF16.charAt(str, index);
            ucharIter.setIndex(index);
            int size = this.toUpperOrTitleCase(locale, ch, ucharIter, false, result);
            int next = breakiter.next();
            if ((index += UTF16.getCharCount(ch)) != -1 && index < next) {
                this.toLowerCase(locale, str, index, next, result);
            }
            index = next;
        }
        return result.toString();
    }

    private UCharacterProperty() throws IOException {
        InputStream i = this.getClass().getResourceAsStream(DATA_FILE_NAME_);
        BufferedInputStream b = new BufferedInputStream(i, 25000);
        UCharacterPropertyReader reader = new UCharacterPropertyReader(b);
        reader.read(this);
        b.close();
        i.close();
    }

    private static int setCodePoint(char[] target, int char32) {
        if (char32 >= 65536) {
            target[0] = UTF16.getLeadSurrogate(char32);
            target[1] = UTF16.getTrailSurrogate(char32);
            return 2;
        }
        target[0] = (char)char32;
        return 1;
    }

    private int getType(int ch) {
        return UCharacterProperty.getPropType(this.getProperty(ch));
    }

    private static boolean isAFTER_i(UCharacterIterator uchariter, int offset) {
        uchariter.setIndex(offset);
        int ch = uchariter.previousCodePoint();
        while (ch != -1) {
            if (ch == 105 || ch == 106 || ch == 303 || ch == 7725 || ch == 7883) {
                return true;
            }
            int cc = NormalizerImpl.getCombiningClass(ch);
            if (cc == 0 || cc == 230) {
                return false;
            }
            ch = uchariter.previousCodePoint();
        }
        return false;
    }

    private static boolean isAFTER_I(UCharacterIterator uchariter, int offset) {
        uchariter.setIndex(offset);
        int ch = uchariter.previousCodePoint();
        while (ch != -1) {
            if (ch == 73) {
                return true;
            }
            int cc = NormalizerImpl.getCombiningClass(ch);
            if (cc == 0 || cc == 230) {
                return false;
            }
            ch = uchariter.previousCodePoint();
        }
        return false;
    }

    private boolean isCFINAL(UCharacterIterator uchariter, int offset) {
        uchariter.setIndex(offset);
        uchariter.nextCodePoint();
        int ch = uchariter.nextCodePoint();
        while (ch != -1) {
            int cat = this.getType(ch);
            if (cat == 2 || cat == 1 || cat == 3) {
                return false;
            }
            if (!UCharacterProperty.isIgnorable(ch, cat)) {
                return true;
            }
            ch = uchariter.nextCodePoint();
        }
        return true;
    }

    private boolean isNotCINITIAL(UCharacterIterator uchariter, int offset) {
        uchariter.setIndex(offset);
        int ch = uchariter.previousCodePoint();
        while (ch != -1) {
            int cat = this.getType(ch);
            if (cat == 2 || cat == 1 || cat == 3) {
                return true;
            }
            if (!UCharacterProperty.isIgnorable(ch, cat)) {
                return false;
            }
            ch = uchariter.previousCodePoint();
        }
        return false;
    }

    private static boolean isFollowedByMOREABOVE(UCharacterIterator uchariter, int offset) {
        uchariter.setIndex(offset);
        uchariter.nextCodePoint();
        int ch = uchariter.nextCodePoint();
        while (ch != -1) {
            int cc = NormalizerImpl.getCombiningClass(ch);
            if (cc == 230) {
                return true;
            }
            if (cc == 0) {
                return false;
            }
            ch = uchariter.nextCodePoint();
        }
        return false;
    }

    private static boolean isFollowedByDotAbove(UCharacterIterator uchariter, int offset) {
        uchariter.setIndex(offset);
        uchariter.nextCodePoint();
        int ch = uchariter.nextCodePoint();
        while (ch != -1) {
            if (ch == 775) {
                return true;
            }
            int cc = NormalizerImpl.getCombiningClass(ch);
            if (cc == 0 || cc == 230) {
                return false;
            }
            ch = uchariter.nextCodePoint();
        }
        return false;
    }

    private static boolean isIgnorable(int ch, int cat) {
        return cat == 6 || ch == 8208 || ch == 173;
    }

    private int addExceptionOffset(int evalue, int indicator, int address) {
        int result = address;
        if (indicator >= 8) {
            result += FLAGS_OFFSET_[evalue & 0xFF];
            evalue >>= 8;
            indicator -= 8;
        }
        int mask = (1 << indicator) - 1;
        return result += FLAGS_OFFSET_[evalue & mask];
    }

    private boolean compareAdditionalType(int property, int type) {
        return (property & 1 << type) != 0;
    }
}

