/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.UCharacterProperty;
import com.ibm.icu.text.Replaceable;
import com.ibm.icu.text.ReplaceableString;
import java.text.CharacterIterator;

public final class UCharacterIterator
implements CharacterIterator {
    public static final int DONE = 65535;
    public static final int DONE_CODEPOINT = -1;
    private Replaceable m_replaceable_;
    private int m_index_;
    private int m_length_;

    public UCharacterIterator(Replaceable replaceable) {
        this.m_replaceable_ = replaceable;
        this.m_index_ = 0;
        this.m_length_ = replaceable.length();
    }

    public UCharacterIterator(String str) {
        this.m_replaceable_ = new ReplaceableString(str);
        this.m_index_ = 0;
        this.m_length_ = this.m_replaceable_.length();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("Cloning by the super class java.text.CharacterIterator is not supported");
        }
    }

    public char current() {
        if (this.m_index_ >= 0 && this.m_index_ < this.m_length_) {
            return this.m_replaceable_.charAt(this.m_index_);
        }
        return '\uffff';
    }

    public int currentCodePoint() {
        if (this.m_index_ >= 0 && this.m_index_ < this.m_length_) {
            return this.m_replaceable_.char32At(this.m_index_);
        }
        return -1;
    }

    public char first() {
        this.m_index_ = 0;
        return this.current();
    }

    public int getBeginIndex() {
        return 0;
    }

    public int getEndIndex() {
        return this.m_length_;
    }

    public int getIndex() {
        return this.m_index_;
    }

    public char last() {
        if (this.m_length_ != 0) {
            this.m_index_ = this.m_length_ - 1;
            return this.m_replaceable_.charAt(this.m_index_);
        }
        this.m_index_ = this.m_length_;
        return '\uffff';
    }

    public char next() {
        if (this.m_index_ < this.m_length_) {
            char result = this.m_replaceable_.charAt(this.m_index_);
            ++this.m_index_;
            return result;
        }
        return '\uffff';
    }

    public int nextCodePoint() {
        if (this.m_index_ < this.m_length_) {
            char trail;
            char ch = this.m_replaceable_.charAt(this.m_index_);
            ++this.m_index_;
            if (ch >= '\ud800' && ch <= '\udbff' && this.m_index_ < this.m_length_ && (trail = this.m_replaceable_.charAt(this.m_index_)) >= '\udc00' && trail <= '\udfff') {
                ++this.m_index_;
                return UCharacterProperty.getRawSupplementary(ch, trail);
            }
            return ch;
        }
        return -1;
    }

    public char previous() {
        if (this.m_index_ > 0) {
            --this.m_index_;
            return this.m_replaceable_.charAt(this.m_index_);
        }
        return '\uffff';
    }

    public int previousCodePoint() {
        if (this.m_index_ > 0) {
            char lead;
            --this.m_index_;
            char ch = this.m_replaceable_.charAt(this.m_index_);
            if (ch >= '\udc00' && ch <= '\udfff' && this.m_index_ > 0 && (lead = this.m_replaceable_.charAt(this.m_index_)) >= '\ud800' && lead <= '\udbff') {
                --this.m_index_;
                return UCharacterProperty.getRawSupplementary(ch, lead);
            }
            return ch;
        }
        return -1;
    }

    public char setIndex(int index) {
        int length = this.m_replaceable_.length();
        if (index < 0 || index > length) {
            throw new IllegalArgumentException("Index index out of bounds");
        }
        this.m_index_ = index;
        return this.current();
    }
}

