/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.CharTrie;
import com.ibm.icu.impl.IntTrie;
import com.ibm.icu.impl.NormalizerDataReader;
import com.ibm.icu.impl.Trie;
import com.ibm.icu.impl.USerializedSet;
import com.ibm.icu.text.UTF16;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class NormalizerImpl {
    static NormalizerImpl IMPL = null;
    static final int UNSIGNED_BYTE_MASK = 255;
    private static final String DATA_FILE_NAME_ = "data/unorm.dat";
    static final int QC_NFC = 17;
    static final int QC_NFKC = 34;
    static final int QC_NFD = 4;
    static final int QC_NFKD = 8;
    static final int QC_ANY_NO = 15;
    static final int QC_MAYBE = 16;
    static final int QC_ANY_MAYBE = 48;
    static final int QC_MASK = 63;
    static final int COMBINES_FWD = 64;
    static final int COMBINES_BACK = 128;
    static final int COMBINES_ANY = 192;
    static final int CC_SHIFT = 8;
    static final int CC_MASK = 65280;
    static final int EXTRA_SHIFT = 16;
    static final int EXTRA_INDEX_TOP = 64512;
    static final int EXTRA_SURROGATE_MASK = 1023;
    static final int EXTRA_SURROGATE_TOP = 1008;
    static final int EXTRA_HANGUL = 1008;
    static final int EXTRA_JAMO_L = 1009;
    static final int EXTRA_JAMO_V = 1010;
    static final int EXTRA_JAMO_T = 1011;
    static final int UNSIGNED_INT_MASK = Integer.MAX_VALUE;
    static final int MIN_SPECIAL = 0x7C000000;
    static final int SURROGATES_TOP = 0x7FF00000;
    static final int MIN_HANGUL = 0x7FF00000;
    static final int MIN_JAMO_V = 2146566144;
    static final int JAMO_V_TOP = 2146631680;
    static final int INDEX_TRIE_SIZE = 0;
    static final int INDEX_CHAR_COUNT = 1;
    static final int INDEX_COMBINE_DATA_COUNT = 2;
    static final int INDEX_COMBINE_FWD_COUNT = 3;
    static final int INDEX_COMBINE_BOTH_COUNT = 4;
    static final int INDEX_COMBINE_BACK_COUNT = 5;
    static final int INDEX_MIN_NFC_NO_MAYBE = 6;
    static final int INDEX_MIN_NFKC_NO_MAYBE = 7;
    static final int INDEX_MIN_NFD_NO_MAYBE = 8;
    static final int INDEX_MIN_NFKD_NO_MAYBE = 9;
    static final int INDEX_FCD_TRIE_SIZE = 10;
    static final int INDEX_AUX_TRIE_SIZE = 11;
    static final int INDEX_CANON_SET_COUNT = 12;
    static final int INDEX_TOP = 32;
    static final int AUX_UNSAFE_SHIFT = 11;
    static final int AUX_COMP_EX_SHIFT = 10;
    static final int AUX_MAX_FNC = 1024;
    static final int AUX_UNSAFE_MASK = 2048;
    static final int AUX_FNC_MASK = 1023;
    static final int AUX_COMP_EX_MASK = 1024;
    static final int SET_INDEX_CANON_SETS_LENGTH = 0;
    static final int SET_INDEX_CANON_BMP_TABLE_LENGTH = 1;
    static final int SET_INDEX_CANON_SUPP_TABLE_LENGTH = 2;
    static final int SET_INDEX_TOP = 32;
    static final int CANON_SET_INDICIES_INDEX = 0;
    static final int CANON_SET_START_SETS_INDEX = 1;
    static final int CANON_SET_BMP_TABLE_INDEX = 2;
    static final int CANON_SET_SUPP_TABLE_INDEX = 3;
    static final int CANON_SET_MAX_CANON_SETS = 4;
    static final int CANON_SET_BMP_MASK = 49152;
    static final int CANON_SET_BMP_IS_INDEX = 16384;
    static FCDTrieImpl fcdTrieImpl;
    static NormTrieImpl normTrieImpl;
    static AuxTrieImpl auxTrieImpl;
    static int[] indexes;
    static char[] combiningTable;
    static char[] extraData;
    static Object[] canonStartSets;
    static boolean isDataLoaded;
    static boolean isFormatVersion_2_1;
    private static final int DATA_BUFFER_SIZE_ = 25000;
    public static final int MIN_WITH_LEAD_CC = 768;
    static final int DECOMP_FLAG_LENGTH_HAS_CC = 128;
    static final int DECOMP_LENGTH_MASK = 127;
    private static final int JAMO_L_BASE = 4352;
    private static final int JAMO_V_BASE = 4449;
    private static final int JAMO_T_BASE = 4519;
    private static final int HANGUL_BASE = 44032;
    private static final int JAMO_L_COUNT = 19;
    private static final int JAMO_V_COUNT = 21;
    private static final int JAMO_T_COUNT = 28;
    private static final int HANGUL_COUNT = 11172;

    private static boolean isHangulWithoutJamoT(char c) {
        return (c = (char)(c - 44032)) < '\u2ba4' && c % 28 == 0;
    }

    private static boolean isNorm32Regular(int norm32) {
        return norm32 < 0x7C000000;
    }

    private static boolean isNorm32LeadSurrogate(int norm32) {
        return 0x7C000000 <= norm32 && norm32 < 0x7FF00000;
    }

    private static boolean isNorm32HangulOrJamo(int norm32) {
        return norm32 >= 0x7FF00000;
    }

    private static boolean isHangulJamoNorm32HangulOrJamoL(int norm32) {
        return norm32 < 2146566144;
    }

    private static boolean isJamoVTNorm32JamoV(int norm32) {
        return norm32 < 2146631680;
    }

    static int getExtraDataIndex(int norm32) {
        return norm32 >> 16;
    }

    private NormalizerImpl() throws IOException {
        if (!isDataLoaded) {
            indexes = null;
            combiningTable = null;
            extraData = null;
            fcdTrieImpl = new FCDTrieImpl();
            normTrieImpl = new NormTrieImpl();
            auxTrieImpl = new AuxTrieImpl();
            InputStream i = this.getClass().getResourceAsStream(DATA_FILE_NAME_);
            BufferedInputStream b = new BufferedInputStream(i, 25000);
            NormalizerDataReader reader = new NormalizerDataReader(b);
            reader.read(this);
            b.close();
            i.close();
        }
    }

    public static boolean checkFCD(char[] src) {
        int prevCC = 0;
        int i = 0;
        int length = src.length;
        while (i != length) {
            int cc;
            int c;
            if ((c = src[i++]) < 768) {
                prevCC = -c;
                continue;
            }
            char fcd16 = FCDTrieImpl.fcdTrie.getBMPValue((char)c);
            if (fcd16 == '\u0000') {
                prevCC = 0;
                continue;
            }
            if (UTF16.isLeadSurrogate((char)c)) {
                fcd16 = i != length && UTF16.isTrailSurrogate(src[i]) ? FCDTrieImpl.fcdTrie.getSurrogateValue(fcd16, src[++i]) : (char)'\u0000';
            }
            if ((cc = fcd16 >> 8) != 0) {
                if (prevCC < 0) {
                    prevCC = FCDTrieImpl.fcdTrie.getBMPValue((char)(-prevCC)) & 0xFF;
                }
                if (cc < prevCC) {
                    return false;
                }
            }
            prevCC = fcd16 & 0xFF;
        }
        return true;
    }

    public static int getCombiningClass(int c) {
        int norm32;
        if (c <= 65535) {
            norm32 = NormTrieImpl.normTrie.getBMPValue((char)c);
        } else {
            norm32 = NormTrieImpl.normTrie.getBMPValue(UTF16.getLeadSurrogate(c));
            if ((norm32 & 0xFF00) != 0) {
                norm32 = NormTrieImpl.normTrie.getRawOffset(norm32, UTF16.getTrailSurrogate(c));
            }
        }
        return (char)(norm32 >> 8 & 0xFF);
    }

    public static boolean isFullCompositionExclusion(int c) {
        if (isFormatVersion_2_1) {
            char aux = AuxTrieImpl.auxTrie.getCodePointValue(c);
            return (aux & 0x400) != 0;
        }
        return false;
    }

    public static boolean isCanonSafeStart(int c) {
        if (isFormatVersion_2_1) {
            char aux = AuxTrieImpl.auxTrie.getCodePointValue(c);
            return (aux & 0x800) == 0;
        }
        return false;
    }

    public static boolean getCanonStartSet(int c, USerializedSet fillSet) {
        if (fillSet != null && canonStartSets != null) {
            if (c <= 65535) {
                int i;
                char[] table = (char[])canonStartSets[2];
                int start = 0;
                int limit = table.length;
                while (start < limit) {
                    i = (start + limit) / 2;
                    if (c < table[i]) {
                        limit = i;
                        continue;
                    }
                    start = i;
                }
                if (c == table[start]) {
                    i = table[start + 1];
                    if ((i & 0xC000) == 16384) {
                        return fillSet.getSet(table, i &= 3);
                    }
                    fillSet.setSerializedToOne(i);
                    return true;
                }
            } else {
                char h;
                int i;
                char[] table = (char[])canonStartSets[3];
                int start = 0;
                int limit = table.length;
                char high = (char)(c >> 16);
                char low = (char)c;
                while (start < limit - 3) {
                    i = (start + limit) / 6 * 3;
                    h = (char)(table[i] & 0x1F);
                    if (high < h || high == h && low < table[i + '\u0001']) {
                        limit = i;
                        continue;
                    }
                    start = i;
                }
                h = table[start];
                if (high == (h & 0x1F) && low == table[start + 1]) {
                    i = table[start + 2];
                    if ((h & 0x8000) == 0) {
                        return fillSet.getSet(table, i);
                    }
                    fillSet.setSerializedToOne(i |= (h & 0x1F00) << 8);
                    return true;
                }
            }
        }
        return false;
    }

    public CharTrie getFCDTrie() {
        return FCDTrieImpl.fcdTrie;
    }

    static {
        try {
            IMPL = new NormalizerImpl();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    static final class AuxTrieImpl
    implements Trie.DataManipulate {
        static CharTrie auxTrie = null;

        AuxTrieImpl() {
        }

        public int getFoldingOffset(int value) {
            return (value & 0x3FF) << 5;
        }
    }

    static final class FCDTrieImpl
    implements Trie.DataManipulate {
        static CharTrie fcdTrie = null;

        FCDTrieImpl() {
        }

        public int getFoldingOffset(int value) {
            return 0;
        }
    }

    static final class NormTrieImpl
    implements Trie.DataManipulate {
        static IntTrie normTrie = null;

        NormTrieImpl() {
        }

        public int getFoldingOffset(int value) {
            return 65536 >> 5 + (value >> 11 & 0x7FE0);
        }
    }
}

