/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUDebug;
import com.ibm.icu.impl.LocaleUtility;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ICULocaleData {
    private static Locale[] localeList;
    private static final String PACKAGE1 = "com.ibm.icu.impl.data";
    private static final String[] packageNames;
    private static boolean debug;
    static /* synthetic */ Class class$com$ibm$icu$impl$ICULocaleData;

    public static Locale[] getAvailableLocales(String key) {
        return ICULocaleData.getAvailableLocales();
    }

    public static Locale[] getAvailableLocales() {
        if (localeList == null) {
            Class clazz = class$com$ibm$icu$impl$ICULocaleData == null ? (class$com$ibm$icu$impl$ICULocaleData = ICULocaleData.class$("com.ibm.icu.impl.ICULocaleData")) : class$com$ibm$icu$impl$ICULocaleData;
            synchronized (clazz) {
                if (localeList == null) {
                    localeList = ICULocaleData.createLocaleList();
                }
            }
        }
        return (Locale[])localeList.clone();
    }

    public static ResourceBundle getLocaleElements(Locale locale) {
        return ICULocaleData.getResourceBundle("LocaleElements", locale);
    }

    private static ResourceBundle instantiateBundle(String name, Locale l) {
        return ResourceBundle.getBundle(name, l);
    }

    public static ResourceBundle getResourceBundle(String bundleName, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle rb = null;
        int i = 0;
        while (i < packageNames.length && rb == null) {
            block5: {
                try {
                    String path = packageNames[i] + "." + bundleName;
                    if (debug) {
                        System.out.println("calling getBundle: " + path + "_" + locale);
                    }
                    rb = ICULocaleData.instantiateBundle(path, locale);
                }
                catch (MissingResourceException e) {
                    if (!debug) break block5;
                    System.out.println(bundleName + "_" + locale + " not found in " + packageNames[i]);
                }
            }
            ++i;
        }
        return rb;
    }

    private static Locale[] createLocaleList() {
        try {
            ResourceBundle index = ICULocaleData.getLocaleElements(LocaleUtility.getLocaleFromName("index"));
            String[] localeNames = index.getStringArray("InstalledLocales");
            Locale[] locales = new Locale[localeNames.length];
            int i = 0;
            while (i < localeNames.length) {
                locales[i] = LocaleUtility.getLocaleFromName(localeNames[i]);
                ++i;
            }
            return locales;
        }
        catch (MissingResourceException missingResourceException) {
            return new Locale[0];
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        packageNames = new String[]{PACKAGE1};
        debug = ICUDebug.enabled("localedata");
    }
}

