/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ListResourceBundle;

public class ICUListResourceBundle
extends ListResourceBundle {
    protected static final Integer RESOURCE_BINARY = new Integer(2);
    protected static final Integer RESOURCE_UNICODE = new Integer(5);
    protected Object[][] contents;
    private Object[][] realContents;

    protected ICUListResourceBundle() {
    }

    protected Object[][] getContents() {
        if (this.realContents == null) {
            this.realContents = this.contents;
            int i = 0;
            while (i < this.contents.length) {
                Object newValue = this.getRedirectedValue(this.contents[i][1]);
                if (newValue != null) {
                    if (this.realContents == this.contents) {
                        this.realContents = (Object[][])this.contents.clone();
                    }
                    this.realContents[i] = new Object[]{this.contents[i][0], newValue};
                }
                ++i;
            }
        }
        return this.realContents;
    }

    private Object getRedirectedValue(Object value) {
        Object[][] aValue;
        if (value instanceof Object[][] && (aValue = (Object[][])value).length == 1) {
            Object[] bValue = aValue[0];
            String resName = (String)bValue[1];
            try {
                if (bValue[0] == RESOURCE_BINARY) {
                    InputStream stream = this.getClass().getResourceAsStream(resName);
                    byte[] data = new byte[stream.available()];
                    stream.read(data);
                    return data;
                }
                if (bValue[0] == RESOURCE_UNICODE) {
                    InputStream stream = this.getClass().getResourceAsStream(resName);
                    InputStreamReader reader = new InputStreamReader(stream);
                    char[] data = new char[stream.available() / 2];
                    reader.read(data, 0, data.length);
                    return data;
                }
            }
            catch (IOException e) {
                System.out.println("could not load: " + resName);
                System.out.println(e);
                return null;
            }
        }
        return null;
    }
}

