/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.TrieBuilder;

public final class ByteTrie {
    private int[] m_stage1_;
    private int[] m_stage2_;
    private byte[] m_stage3_;
    private static final int STAGE_1_SHIFT_ = 10;
    private static final int STAGE_2_SHIFT_ = 4;
    private static final int STAGE_2_MASK_AFTER_SHIFT_ = 63;
    private static final int STAGE_3_MASK_ = 15;
    private static final int COUNT_4_BIT_ = 16;
    private static final int COUNT_6_BIT_ = 64;
    private static final int COUNT_CODEPOINT_FIRST_17_BIT_ = 69632;
    private static final int COUNT_CODEPOINT_FIRST_11_BIT_ = 1088;

    public ByteTrie(byte[] array) {
        this.build(array);
    }

    public ByteTrie(int[] stage1, int[] stage2, byte[] stage3) {
        this.m_stage1_ = stage1;
        this.m_stage2_ = stage2;
        this.m_stage3_ = stage3;
    }

    public byte getValue(int index) {
        int index1 = index >> 10;
        int index2 = this.m_stage1_[index1] + (index >> 4 & 0x3F);
        int index3 = this.m_stage2_[index2] + (index & 0xF);
        return this.m_stage3_[index3];
    }

    private void build(byte[] array) {
        int[] stage2 = new int[69632];
        byte[] stage3 = new byte[557055];
        int size = TrieBuilder.build(array, 0, array.length, 16, stage2, stage3);
        this.m_stage3_ = new byte[size];
        System.arraycopy(stage3, 0, this.m_stage3_, 0, size);
        this.m_stage1_ = new int[1088];
        size = TrieBuilder.build(stage2, 0, stage2.length, 64, this.m_stage1_, stage2);
        this.m_stage2_ = new int[size];
        System.arraycopy(stage2, 0, this.m_stage2_, 0, size);
    }

    public String toString() {
        int size = this.m_stage1_.length;
        int count = 0;
        StringBuffer result = new StringBuffer("int m_stage1_[] = {\n");
        int i = 0;
        while (i < size) {
            result.append("0x" + Integer.toHexString(this.m_stage1_[i]));
            if (i != size - 1) {
                result.append(", ");
            }
            if (++count == 10) {
                count = 0;
                result.append("\n");
            }
            ++i;
        }
        result.append("\n}\n\n");
        size = this.m_stage2_.length;
        result.append("int m_stage2_[] = {\n");
        count = 0;
        int i2 = 0;
        while (i2 < size) {
            result.append("0x" + Integer.toHexString(this.m_stage2_[i2]));
            if (i2 != size - 1) {
                result.append(", ");
            }
            if (++count == 10) {
                count = 0;
                result.append("\n");
            }
            ++i2;
        }
        result.append("\n}\n\n");
        size = this.m_stage3_.length;
        result.append("byte m_stage3_[] = {\n");
        count = 0;
        int i3 = 0;
        while (i3 < size) {
            result.append("0x" + Integer.toHexString((char)this.m_stage3_[i3]));
            if (i3 != size - 1) {
                result.append(", ");
            }
            if (++count == 10) {
                count = 0;
                result.append("\n");
            }
            ++i3;
        }
        result.append("\n}");
        return result.toString();
    }
}

