/*
 * Decompiled with CFR 0.152.
 */
package jena;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import com.hp.hpl.jena.n3.N3ErrorPrinter;
import com.hp.hpl.jena.n3.N3EventPrinter;
import com.hp.hpl.jena.n3.N3JenaWriter;
import com.hp.hpl.jena.n3.N3Parser;
import com.hp.hpl.jena.n3.N3ParserEventHandler;
import com.hp.hpl.mesa.rdf.jena.mem.ModelMem;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import jena.cmdline.ArgDecl;
import jena.cmdline.CommandLine;

public class n3 {
    static boolean firstOutput = true;
    static boolean doNodeTest = true;
    static boolean doErrorTests = false;
    static int testCount = 0;
    static boolean doRDF = false;
    static boolean printRDF = false;
    static String outputLang = "N-TRIPLE";
    static boolean printN3 = true;
    static boolean debug = false;
    static boolean verbose = false;
    static final String NL = System.getProperty("line.separator", "\n");
    static /* synthetic */ Class class$jena$n3;

    public static void main(String[] stringArray) {
        String string = System.getProperty("user.dir");
        String string2 = System.getProperty("line.separator", "\n");
        String string3 = (class$jena$n3 == null ? (class$jena$n3 = n3.class$("jena.n3")) : class$jena$n3).getName() + " [-rdf] [-base URI] [filename]";
        CommandLine commandLine = new CommandLine();
        commandLine.setUsage(string3);
        commandLine.setOutput(System.err);
        ArgDecl argDecl = new ArgDecl(false, "-v", "--verbose");
        ArgDecl argDecl2 = new ArgDecl(false, "-h", "--help");
        ArgDecl argDecl3 = new ArgDecl(false, "-rdf", "--rdf");
        ArgDecl argDecl4 = new ArgDecl(false, "--rdf-n3");
        ArgDecl argDecl5 = new ArgDecl(false, "--rdf-xml");
        ArgDecl argDecl6 = new ArgDecl(false, "--rdf-nt");
        ArgDecl argDecl7 = new ArgDecl(false, "-simple");
        ArgDecl argDecl8 = new ArgDecl(false, "-debug");
        ArgDecl argDecl9 = new ArgDecl(true, "-base");
        ArgDecl argDecl10 = new ArgDecl(false, "-n", "--check");
        commandLine.add(argDecl);
        commandLine.add(argDecl2);
        commandLine.add(argDecl3);
        commandLine.add(argDecl4);
        commandLine.add(argDecl5);
        commandLine.add(argDecl6);
        commandLine.add(argDecl7);
        commandLine.add(argDecl8);
        commandLine.add(argDecl9);
        commandLine.add(argDecl10);
        try {
            commandLine.process(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.exit(1);
        }
        verbose = commandLine.contains(argDecl);
        if (commandLine.contains(argDecl2)) {
            System.out.println(string3);
            System.out.println("Default action: parse an N3 file");
            System.out.println("    --rdf           Read into an RDF and print");
            System.out.println("    --rdf-n3        Read into an RDF and print in N3");
            System.out.println("    --rdf-xml       Read into an RDF and print in XML");
            System.out.println("    --rdf-nt        Read into an RDF and print in N-Triples");
            System.out.println("    --check | -n    Just check: no output");
            System.out.println("    --base URI      Set the base URI");
            System.exit(0);
        }
        String string4 = null;
        if (commandLine.contains(argDecl3)) {
            doRDF = true;
            printRDF = true;
            printN3 = false;
        }
        if (commandLine.contains(argDecl4)) {
            doRDF = true;
            printRDF = true;
            outputLang = "N3";
            printN3 = false;
        }
        if (commandLine.contains(argDecl5)) {
            doRDF = true;
            printRDF = true;
            outputLang = "RDF/XML-ABBREV";
            printN3 = false;
        }
        if (commandLine.contains(argDecl6)) {
            doRDF = true;
            printRDF = true;
            outputLang = "N-TRIPLE";
            printN3 = false;
        }
        if (commandLine.contains(argDecl7)) {
            System.setProperty("com.hp.hpl.jena.n3.N3JenaWriter.writeSimple", "true");
        }
        if (commandLine.contains(argDecl8)) {
            debug = true;
            N3JenaWriter.DEBUG = true;
        }
        if (commandLine.contains(argDecl10)) {
            printRDF = false;
            printN3 = false;
        }
        if (commandLine.contains(argDecl)) {
            verbose = true;
            printN3 = true;
        }
        if (commandLine.contains(argDecl9)) {
            string4 = commandLine.getArg(argDecl9).getValue();
        }
        if (commandLine.items().size() == 0) {
            if (string4 == null) {
                string4 = "stdin:/";
            }
            n3.doOneFile(System.in, System.out, string4, string4);
            System.exit(0);
        }
        Iterator iterator = commandLine.items().iterator();
        while (iterator.hasNext()) {
            String string5 = (String)iterator.next();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(string5);
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("File not found: " + string5);
                System.exit(2);
            }
            if (string4 == null) {
                File file = new File(string5);
                string4 = "file:///" + file.getAbsolutePath();
                string4 = string4.replace('\\', '/');
            }
            n3.doOneFile(fileInputStream, System.out, string4, string5);
        }
    }

    static void doOneFile(InputStream inputStream, OutputStream outputStream, String string, String string2) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println("UnsupportedEncodingException: " + unsupportedEncodingException);
            System.exit(8);
        }
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (doRDF) {
            n3.rdfOneFile(bufferedReader, bufferedWriter, string, string2);
        } else {
            n3.parseOneFile(bufferedReader, bufferedWriter, string, string2);
        }
    }

    static void rdfOneFile(Reader reader, Writer writer, String string, String string2) {
        try {
            ModelMem modelMem = new ModelMem();
            modelMem.read(reader, string, "N3");
            if (printRDF) {
                if (outputLang.equals("N3")) {
                    writer.write("# Jena N3->RDF->" + outputLang + " : " + string2);
                    writer.write(NL);
                    writer.write(NL);
                }
                modelMem.write(writer, outputLang, string);
                writer.flush();
            }
        }
        catch (RDFException rDFException) {
            rDFException.printStackTrace(System.err);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            System.exit(8);
        }
    }

    private static void parseOneFile(Reader reader, Writer writer, String string, String string2) {
        Object object;
        N3ParserEventHandler n3ParserEventHandler = null;
        n3ParserEventHandler = null;
        if (printN3 || debug) {
            object = new N3EventPrinter(writer);
            if (verbose) {
                ((N3EventPrinter)object).printStartFinish = true;
            }
            n3ParserEventHandler = object;
        } else {
            n3ParserEventHandler = new N3ErrorPrinter(writer);
        }
        try {
            object = new N3Parser(reader, n3ParserEventHandler);
            ((N3Parser)object).parse();
        }
        catch (RecognitionException recognitionException) {
            System.exit(9);
        }
        catch (TokenStreamException tokenStreamException) {
            System.exit(9);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

