/*
 * Decompiled with CFR 0.152.
 */
package jena.cmdline;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jena.cmdline.Arg;
import jena.cmdline.ArgDecl;
import jena.cmdline.ArgHandler;

public class CommandLine {
    protected ArgHandler argHook = null;
    protected String usage = null;
    protected Map argMap = new HashMap();
    protected Set argValue = new HashSet();
    protected PrintStream out = System.err;
    protected List args = new ArrayList();
    protected List items = new ArrayList();

    public void setHook(ArgHandler argHandler) {
        this.argHook = argHandler;
    }

    public void setOutput(PrintStream printStream) {
        this.out = printStream;
    }

    public PrintStream getOutput() {
        return this.out;
    }

    public void setUsage(String string) {
        this.usage = string;
    }

    public List args() {
        return this.args;
    }

    public List items() {
        return this.items;
    }

    public void process(String[] stringArray) throws IllegalArgumentException {
        try {
            int n = 0;
            while (n < stringArray.length) {
                ArgDecl argDecl;
                Arg arg;
                String string = stringArray[n];
                if (!string.startsWith("-") || string.equals("--") || string.equals("-")) break;
                string = ArgDecl.canonicalForm(string);
                String string2 = null;
                if (this.argMap.containsKey(string)) {
                    arg = new Arg(string);
                    argDecl = (ArgDecl)this.argMap.get(string);
                    if (argDecl.takesValue()) {
                        if (n == stringArray.length - 1) {
                            throw new IllegalArgumentException("No value for argument: " + arg.getName());
                        }
                        string2 = stringArray[++n];
                        arg.setValue(string2);
                    }
                    if (this.argHook != null) {
                        this.argHook.action(string, string2);
                    }
                } else {
                    throw new IllegalArgumentException("Unknown argument: " + string);
                }
                argDecl.trigger(arg);
                this.args.add(arg);
                ++n;
            }
            if (n < stringArray.length) {
                if (stringArray[n].equals("-") || stringArray[n].equals("--")) {
                    ++n;
                }
                while (n < stringArray.length) {
                    this.items.add(stringArray[n]);
                    ++n;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this.out != null) {
                if (this.usage != null) {
                    this.out.println(this.usage);
                }
                this.out.println(illegalArgumentException.getMessage());
            }
            throw illegalArgumentException;
        }
    }

    public boolean contains(ArgDecl argDecl) {
        return this.getArg(argDecl) != null;
    }

    public boolean contains(String string) {
        return this.getArg(string) != null;
    }

    public Arg getArg(ArgDecl argDecl) {
        Arg arg = null;
        Iterator iterator = this.args.iterator();
        while (iterator.hasNext()) {
            Arg arg2 = (Arg)iterator.next();
            if (!argDecl.matches(arg2)) continue;
            arg = arg2;
        }
        return arg;
    }

    public Arg getArg(String string) {
        string = ArgDecl.canonicalForm(string);
        Arg arg = null;
        Iterator iterator = this.args.iterator();
        while (iterator.hasNext()) {
            Arg arg2 = (Arg)iterator.next();
            if (!arg2.getName().equals(string)) continue;
            arg = arg2;
        }
        return arg;
    }

    public CommandLine add(String string, boolean bl) {
        return this.add(new ArgDecl(bl, string));
    }

    public CommandLine add(ArgDecl argDecl) {
        Iterator iterator = argDecl.getNames();
        while (iterator.hasNext()) {
            this.argMap.put(iterator.next(), argDecl);
        }
        return this;
    }

    public ArgHandler trace() {
        final PrintStream printStream = this.out;
        return new ArgHandler(){

            public void action(String string, String string2) {
                if (printStream != null) {
                    printStream.println("Seen: " + string + (string2 != null ? " = " + string2 : ""));
                }
            }
        };
    }

    public static void main(String[] stringArray) {
        CommandLine commandLine = new CommandLine();
        commandLine.setOutput(System.out);
        ArgDecl argDecl = new ArgDecl(false, "-a");
        commandLine.add(argDecl);
        commandLine.add("-b", false);
        commandLine.add("-file", true);
        ArgDecl argDecl2 = new ArgDecl(false, "-v", "--verbose");
        argDecl2.addHook(commandLine.trace());
        commandLine.add(argDecl2);
        String[] stringArray2 = new String[]{"-a", "--b", "--a", "--file", "value1", "--file", "value2", "--v", "rest"};
        try {
            Object object;
            commandLine.process(stringArray2);
            System.out.println("PROCESSED");
            if (commandLine.getArg("file") == null) {
                System.out.println("No --file seen");
            } else {
                System.out.println("--file => " + commandLine.getArg("file").getValue());
            }
            if (commandLine.getArg(argDecl) == null) {
                System.out.println("No --a seen");
            } else {
                System.out.println("--a seen " + commandLine.getArg(argDecl2).getValue());
            }
            System.out.println("DUMP");
            Iterator iterator = commandLine.args().iterator();
            while (iterator.hasNext()) {
                object = (Arg)iterator.next();
                String string = ((Arg)object).hasValue() ? " = " + ((Arg)object).getValue() : "";
                System.out.println("Arg: " + ((Arg)object).getName() + string);
            }
            object = commandLine.items().iterator();
            while (object.hasNext()) {
                System.out.println("Item: " + (String)object.next());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Illegal argument: " + illegalArgumentException.getMessage());
        }
    }
}

