/*
 * Decompiled with CFR 0.152.
 */
package jena.cmdline;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jena.cmdline.Arg;
import jena.cmdline.ArgHandler;

public class ArgDecl {
    boolean takesValue;
    Set names = new HashSet();
    boolean takesArg = false;
    List argHooks = new ArrayList();
    public static final int FLAG = 1;
    public static final int OPTION = 2;

    public ArgDecl(boolean bl) {
        this.takesValue = bl;
    }

    public ArgDecl(boolean bl, String string) {
        this(bl);
        this.addName(string);
    }

    public ArgDecl(boolean bl, String string, String string2) {
        this(bl);
        this.addName(string);
        this.addName(string2);
    }

    public ArgDecl(boolean bl, String string, String string2, String string3) {
        this(bl);
        this.addName(string);
        this.addName(string2);
        this.addName(string3);
    }

    public void addName(String string) {
        string = ArgDecl.canonicalForm(string);
        this.names.add(string);
    }

    public Iterator getNames() {
        return this.names.iterator();
    }

    public void addHook(ArgHandler argHandler) {
        this.argHooks.add(argHandler);
    }

    protected void trigger(Arg arg) {
        Iterator iterator = this.argHooks.iterator();
        while (iterator.hasNext()) {
            ArgHandler argHandler = (ArgHandler)iterator.next();
            argHandler.action(arg.getName(), arg.getValue());
        }
    }

    public boolean takesValue() {
        return this.takesValue;
    }

    public boolean matches(Arg arg) {
        Iterator iterator = this.names.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!arg.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(String string) {
        string = ArgDecl.canonicalForm(string);
        return this.names.contains(string);
    }

    static String canonicalForm(String string) {
        if (string.startsWith("--")) {
            return string.substring(2);
        }
        if (string.startsWith("-")) {
            return string.substring(1);
        }
        return string;
    }
}

