/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.sample;

import com.hp.hpl.mesa.rdf.jena.mem.ModelMem;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.ResIterator;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;

public class Sample3 {
    static String base = "http://aldabaran.hpl.hp.com/wordnet/";
    static String ssBase = base + "synset/";
    static String wordBase = base + "word/";
    static int ssIdLength = 9;
    static Resource nounR;
    static Resource verbR;
    static Resource adjectiveR;
    static Resource adjSateliteR;
    static Resource adverbR;
    static Resource unknownR;
    static Property ssTypeP;
    static Property glossP;
    static Property hypernymP;
    static Property entailmentP;
    static Property similarP;
    static Property membMeronymP;
    static Property subsMeronymP;
    static Property partMeronymP;
    static Property causeP;
    static Property verbGroupP;
    static Property valueOfP;
    static Property antonymP;
    static Property seeAlsoP;
    static Property participleP;
    static Property perP;
    static Property frameP;

    public static void main(String[] stringArray) {
        try {
            String string = stringArray[0];
            ModelMem modelMem = new ModelMem();
            nounR = modelMem.createResource(base + "noun");
            verbR = modelMem.createResource(base + "verb");
            adjectiveR = modelMem.createResource(base + "adjective");
            adjSateliteR = modelMem.createResource(base + "adjectiveSatelite");
            adverbR = modelMem.createResource(base + "adverb");
            adverbR = modelMem.createResource(base + "unknown");
            ssTypeP = modelMem.createProperty(base, "ssType");
            glossP = modelMem.createProperty(base, "gloss");
            hypernymP = modelMem.createProperty(base, "hypernym");
            entailmentP = modelMem.createProperty(base, "entailment");
            similarP = modelMem.createProperty(base, "similar");
            membMeronymP = modelMem.createProperty(base, "memberMeronym");
            subsMeronymP = modelMem.createProperty(base, "substanceMeronym");
            partMeronymP = modelMem.createProperty(base, "partMeronym");
            causeP = modelMem.createProperty(base, "cause");
            verbGroupP = modelMem.createProperty(base, "verbGroup");
            valueOfP = modelMem.createProperty(base, "valueOf");
            antonymP = modelMem.createProperty(base, "antonym");
            seeAlsoP = modelMem.createProperty(base, "seeAlso");
            participleP = modelMem.createProperty(base, "participle");
            perP = modelMem.createProperty(base, "per");
            frameP = modelMem.createProperty(base, "frame");
            Sample3.readSFile(modelMem, string + "/wn_s.txt");
            Sample3.readGFile(modelMem, string + "/wn_g.txt");
            Sample3.readSsPairFile(modelMem, string + "/wn_hyp.txt", "hyp", hypernymP);
            Sample3.readSsPairFile(modelMem, string + "/wn_ent.txt", "ent", entailmentP);
            Sample3.readSsPairFile(modelMem, string + "/wn_sim.txt", "sim", similarP);
            Sample3.readSsPairFile(modelMem, string + "/wn_mm.txt", "mm", membMeronymP);
            Sample3.readSsPairFile(modelMem, string + "/wn_ms.txt", "ms", subsMeronymP);
            Sample3.readSsPairFile(modelMem, string + "/wn_mp.txt", "mp", partMeronymP);
            Sample3.readSsPairFile(modelMem, string + "/wn_cs.txt", "cs", causeP);
            Sample3.readSsPairFile(modelMem, string + "/wn_vgp.txt", "vgp", verbGroupP);
            Sample3.readSsPairFile(modelMem, string + "/wn_at.txt", "at", valueOfP);
            Sample3.readWordPairFile(modelMem, string + "/wn_ant.txt", "ant", antonymP);
            Sample3.readWordPairFile(modelMem, string + "/wn_sa.txt", "sa", seeAlsoP);
            Sample3.readWordPairFile(modelMem, string + "/wn_ppl.txt", "ppl", participleP);
            Sample3.readWordPairFile(modelMem, string + "/wn_per.txt", "per", perP);
            Sample3.readFrFile(modelMem, string + "/wn_fr.txt");
            System.out.println("Created " + modelMem.size() + " statements.");
            ResIterator resIterator = modelMem.listSubjectsWithProperty(ssTypeP, nounR);
            int n = 0;
            while (resIterator.hasNext()) {
                ++n;
                resIterator.next();
            }
            System.out.println("There are " + n + " noun synsets in Wordnet.");
        }
        catch (Exception exception) {
            System.out.println("exception: " + exception);
        }
    }

    protected static void createSRelation(Model model, String string, String string2, int n, char c) {
        try {
            Resource resource;
            if (c == 'n') {
                resource = nounR;
            } else if (c == 'v') {
                resource = verbR;
            } else if (c == 'a') {
                resource = adjectiveR;
            } else if (c == 's') {
                resource = adjSateliteR;
            } else if (c == 'r') {
                resource = adverbR;
            } else {
                System.out.println("unknown ss_type: " + c);
                resource = unknownR;
            }
            Resource resource2 = model.createSeq(ssBase + string).add(model.createResource(wordBase + string2)).addProperty(ssTypeP, resource);
        }
        catch (Exception exception) {
            System.out.println("exception: " + exception);
        }
    }

    protected static void createGRelation(Model model, String string, String string2) {
        try {
            Resource resource = model.getSeq(ssBase + string).addProperty(glossP, string2);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    protected static void createSsPairRelation(Model model, String string, String string2, Property property) {
        try {
            model.getResource(ssBase + string).addProperty(property, model.getProperty(ssBase + string2));
        }
        catch (Exception exception) {
            System.out.println("exception: " + exception);
        }
    }

    protected static void createWordPairRelation(Model model, String string, int n, String string2, int n2, Property property) {
        try {
            Resource resource = n == 0 ? model.getResource(ssBase + string) : model.getSeq(ssBase + string).getResource(n);
            Resource resource2 = n2 == 0 ? model.getResource(ssBase + string2) : model.getSeq(ssBase + string2).getResource(n2);
            resource.addProperty(property, resource2);
        }
        catch (Exception exception) {
            System.out.println(string + ":" + n + " " + string2 + ":" + n2);
            System.out.println(exception);
        }
    }

    protected static void createFrRelation(Model model, String string, int n, int n2) {
        try {
            if (n2 == 0) {
                model.getResource(ssBase + string).addProperty(frameP, n);
            } else {
                model.getSeq(ssBase + string).getResource(n2).addProperty(frameP, n);
            }
        }
        catch (Exception exception) {
            System.out.println("exception: " + exception);
        }
    }

    protected static void readSFile(Model model, String string) {
        try {
            char[] cArray = new char[ssIdLength];
            int n = 1;
            FileReader fileReader = new FileReader(string);
            while (fileReader.read() != -1) {
                fileReader.read();
                fileReader.read(cArray, 0, ssIdLength);
                fileReader.read();
                int n2 = Sample3.readInt(fileReader);
                String string2 = Sample3.readWord(fileReader);
                char c = (char)fileReader.read();
                Sample3.skipToEndOfLine(fileReader);
                Sample3.createSRelation(model, new String(cArray), string2, n2, c);
                if (n++ % 10000 != 0) continue;
                System.out.println("s: Done " + n);
            }
            fileReader.close();
            System.out.println("s: completed:");
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    protected static void readGFile(Model model, String string) {
        try {
            char[] cArray = new char[ssIdLength];
            int n = 1;
            FileReader fileReader = new FileReader(string);
            while (fileReader.read() != -1) {
                fileReader.read();
                fileReader.read(cArray, 0, ssIdLength);
                fileReader.read();
                String string2 = Sample3.readWord(fileReader);
                Sample3.skipToEndOfLine(fileReader);
                Sample3.createGRelation(model, new String(cArray), string2);
                if (n++ % 10000 != 0) continue;
                System.out.println("g: Done " + n);
            }
            fileReader.close();
            System.out.println("g: completed:");
        }
        catch (Exception exception) {
            System.out.println("exception: " + exception);
        }
    }

    protected static void readSsPairFile(Model model, String string, String string2, Property property) {
        try {
            int n = string2.length();
            int n2 = 1;
            char[] cArray = new char[ssIdLength];
            char[] cArray2 = new char[ssIdLength];
            FileReader fileReader = new FileReader(string);
            while (fileReader.read() != -1) {
                int n4 = 0;
                while (n4 < n) {
                    fileReader.read();
                    ++n4;
                }
                fileReader.read(cArray, 0, ssIdLength);
                fileReader.read();
                fileReader.read(cArray2, 0, ssIdLength);
                Sample3.skipToEndOfLine(fileReader);
                Sample3.createSsPairRelation(model, new String(cArray), new String(cArray2), property);
                if (n2++ % 10000 != 0) continue;
                System.out.println(string2 + ": Done " + n2);
            }
            fileReader.close();
            System.out.println(string2 + ": completed:");
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    protected static void readWordPairFile(Model model, String string, String string2, Property property) {
        try {
            int n = string2.length();
            int n2 = 1;
            char[] cArray = new char[ssIdLength];
            char[] cArray2 = new char[ssIdLength];
            FileReader fileReader = new FileReader(string);
            while (fileReader.read() != -1) {
                int n4 = 0;
                while (n4 < n) {
                    fileReader.read();
                    ++n4;
                }
                fileReader.read(cArray, 0, ssIdLength);
                fileReader.read();
                int n5 = Sample3.readInt(fileReader);
                fileReader.read(cArray2, 0, ssIdLength);
                fileReader.read();
                int n6 = Sample3.readInt(fileReader);
                Sample3.skipToEndOfLine(fileReader);
                Sample3.createWordPairRelation(model, new String(cArray), n5, new String(cArray2), n6, property);
                if (n2++ % 10000 != 0) continue;
                System.out.println(string2 + ": Done " + n2);
            }
            fileReader.close();
            System.out.println(string2 + ": completed:");
        }
        catch (Exception exception) {
            System.out.println("exception: " + exception);
        }
    }

    protected static void readFrFile(Model model, String string) {
        try {
            char[] cArray = new char[ssIdLength];
            int n = 1;
            FileReader fileReader = new FileReader(string);
            while (fileReader.read() != -1) {
                fileReader.read();
                fileReader.read();
                fileReader.read(cArray, 0, ssIdLength);
                fileReader.read();
                int n2 = Sample3.readInt(fileReader);
                int n4 = Sample3.readInt(fileReader);
                Sample3.skipToEndOfLine(fileReader);
                Sample3.createFrRelation(model, new String(cArray), n2, n4);
                if (n++ % 10000 != 0) continue;
                System.out.println("fr: Done " + n);
            }
            fileReader.close();
            System.out.println("fr: completed");
        }
        catch (Exception exception) {
            System.out.println("exception: " + exception);
        }
    }

    protected static int readInt(Reader reader) throws IOException {
        int n = 0;
        char c = (char)reader.read();
        while ('0' <= c && c <= '9') {
            n = n * 10 + (c - 48);
            c = (char)reader.read();
        }
        return n;
    }

    protected static String readWord(Reader reader) throws IOException {
        String string = "";
        reader.read();
        char c;
        while ((c = (char)reader.read()) != '\'' || (c = (char)reader.read()) == '\'') {
            string = string + c;
        }
        return string;
    }

    protected static void skipToEndOfLine(Reader reader) throws IOException {
        while ((char)reader.read() != '\n') {
        }
    }
}

