/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.sample;

import com.hp.hpl.mesa.rdf.jena.common.EnhSeq;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Seq;
import com.hp.hpl.mesa.rdf.jena.sample.Date;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDF;

class Month
extends EnhSeq {
    static final int JAN = 1;
    static final int FEB = 2;
    static final int MAR = 3;
    static final int APR = 4;
    static final int MAY = 5;
    static final int JUN = 6;
    static final int JUL = 7;
    static final int AUG = 8;
    static final int SEP = 9;
    static final int OCT = 10;
    static final int NOV = 11;
    static final int DEC = 12;
    static final String[] monthNames = new String[]{"", "January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    int month;
    int year;
    static final int[] numDays = new int[]{0, 31, 0, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    protected Month(int n, int n2, Model model) throws RDFException {
        super(model);
        this.month = n;
        this.year = n2;
        this.resource.addProperty(RDF.type, Date.Month).addProperty(Date.name, monthNames[n]).addProperty(Date.num, n).addProperty(Date.year, n2).addProperty(Date.numDays, this.numDays(n));
        int n4 = 1;
        while (n4 <= this.numDays(n)) {
            this.seq.add(model.createResource().addProperty(RDF.type, Date.Day).addProperty(Date.num, n4));
            ++n4;
        }
    }

    public Month(Resource resource) throws RDFException {
        super(resource);
        this.month = this.seq.getProperty(Date.num).getInt();
        this.year = this.seq.getProperty(Date.year).getInt();
        this.seq = (Seq)this.resource;
    }

    protected int numDays(int n) {
        if (n != 2) {
            return numDays[n];
        }
        if (this.year % 4 != 0 || this.year % 100 == 0 && this.year % 400 != 0) {
            return 28;
        }
        return 29;
    }
}

