/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.rdb;

import com.hp.hpl.mesa.rdf.jena.rdb.TestDBConnection;
import com.hp.hpl.mesa.rdf.jena.rdb.TestGenericDriver;
import com.hp.hpl.mesa.rdf.jena.rdb.TestJenaRegression;
import com.hp.hpl.mesa.rdf.jena.rdb.TestStoreRDB;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TestRDB
extends TestCase {
    private static String TEST_LAYOUT = "Generic";
    private static String TEST_DB = "Generic";
    static final String DBBASE_PROP = "jena.rdb.test.dbbase";
    static final String DBFULL_PROP = "jena.rdb.test.dbfull";
    static final String DBUSER_PROP = "jena.rdb.test.user";
    static final String DBPASSWORD_PROP = "jena.rdb.test.password";
    private static boolean fullRegression = false;
    private static boolean legacyRegression = false;

    public TestRDB(String string) {
        super(string);
    }

    public static TestSuite suite() {
        TestSuite testSuite = new TestSuite();
        if (!legacyRegression) {
            testSuite.addTest((Test)TestDBConnection.suite(TEST_LAYOUT, TEST_DB));
            testSuite.addTest((Test)TestGenericDriver.suite(TEST_LAYOUT, TEST_DB));
            testSuite.addTest((Test)TestStoreRDB.suite(TEST_LAYOUT, TEST_DB));
        }
        if (fullRegression | legacyRegression) {
            testSuite.addTest((Test)TestJenaRegression.suite(TEST_LAYOUT, TEST_DB, legacyRegression));
        }
        return testSuite;
    }

    private static void usage() {
        System.out.println("Usage: : TestRDF layoutType databaseType [full | legacyFull]");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 2 || stringArray.length > 3) {
            TestRDB.usage();
        }
        TEST_LAYOUT = stringArray[0];
        TEST_DB = stringArray[1];
        if (stringArray.length == 3) {
            if (stringArray[2].equalsIgnoreCase("full")) {
                fullRegression = true;
            } else if (stringArray[2].equalsIgnoreCase("legacyFull")) {
                legacyRegression = true;
            } else {
                TestRDB.usage();
            }
        }
        try {
            if (System.getProperty(DBBASE_PROP) == null) {
                if (TEST_DB.equals("Mysql")) {
                    System.setProperty(DBBASE_PROP, "jdbc:mysql://morte.hpl.hp.com/");
                } else if (TEST_DB.equals("Postgresql")) {
                    System.setProperty(DBBASE_PROP, "jdbc:postgresql:");
                } else if (TEST_DB.equals("Interbase")) {
                    System.setProperty(DBBASE_PROP, "jdbc:interbase://reynolds-d-3.hpl.hp.com/c:/der/java/databases/");
                }
            }
            if (System.getProperty(DBFULL_PROP) == null) {
                System.setProperty(DBFULL_PROP, System.getProperty(DBBASE_PROP) + "testrdf");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        TestRunner.run((Test)TestRDB.suite());
    }
}

