/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.rdb;

import com.hp.hpl.jena.util.Log;
import com.hp.hpl.mesa.rdf.jena.common.regression.TestCaseBasic;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.StmtIterator;
import com.hp.hpl.mesa.rdf.jena.rdb.DBConnection;
import com.hp.hpl.mesa.rdf.jena.rdb.IRDBDriver;
import com.hp.hpl.mesa.rdf.jena.rdb.ModelRDB;
import com.hp.hpl.mesa.rdf.jena.rdb.RDFRDBException;
import java.sql.SQLException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;

public class TestJenaRegression {
    public static TestSuite suite(String string, String string2, boolean bl) {
        String string3 = System.getProperty("jena.rdb.test.dbbase");
        String string4 = System.getProperty("jena.rdb.test.user", "DER");
        String string5 = System.getProperty("jena.rdb.test.password", "key");
        ConfigTestCaseRDB configTestCaseRDB = new ConfigTestCaseRDB(string3, string4, string5, string, string2, bl);
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new TestCaseRDB("test0", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test1", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test2", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test3", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test4", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test5", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test6", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test7", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test8", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test9", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test10", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test11", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test12", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test13", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test14", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test15", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test16", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test17", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test18", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test19", configTestCaseRDB));
        testSuite.addTest((Test)new TestCaseRDB("test97", configTestCaseRDB));
        return testSuite;
    }

    protected static class TestCaseRDB
    extends TestCaseBasic {
        ConfigTestCaseRDB m_config;

        public TestCaseRDB(String string, ConfigTestCaseRDB configTestCaseRDB) {
            super(string);
            this.m_config = configTestCaseRDB;
        }

        public void setUp() throws RDFException {
            this.m1 = this.m_config.createModel("jr1");
            this.m2 = this.m_config.createModel("jr2");
            this.m3 = this.m_config.createModel("jr3");
            this.m4 = this.m_config.createModel("jr4");
        }

        public void tearDown() {
            if (this.m_config.supportsMultipleModels && !this.m_config.noReformat) {
                this.cleanModel((ModelRDB)this.m1);
                this.m2.close();
                this.m3.close();
                this.m4.close();
                try {
                    this.m_config.m_dbconn.close();
                }
                catch (SQLException sQLException) {
                    System.out.println("Problem during db clean up in regression test");
                }
                this.m_config.m_dbconn = null;
            } else {
                this.cleanModel((ModelRDB)this.m1);
                this.cleanModel((ModelRDB)this.m2);
                this.cleanModel((ModelRDB)this.m3);
                this.cleanModel((ModelRDB)this.m4);
            }
        }

        private void cleanModel(ModelRDB modelRDB) {
            try {
                if (this.m_config.noReformat) {
                    StmtIterator stmtIterator = modelRDB.listStatements();
                    while (stmtIterator.hasNext()) {
                        stmtIterator.next();
                        stmtIterator.remove();
                    }
                } else {
                    int n = Log.getInstance().getLevel();
                    Log.getInstance().setLevel(7);
                    IRDBDriver iRDBDriver = modelRDB.getStore().getDriver();
                    iRDBDriver.cleanDB();
                    iRDBDriver.close();
                    modelRDB.close();
                    Log.getInstance().setLevel(n);
                }
            }
            catch (RDFException rDFException) {
                Assert.assertTrue((String)("Problem clearning up regression databases: " + rDFException), (boolean)false);
            }
        }
    }

    protected static class ConfigTestCaseRDB {
        String m_baseuri;
        String m_user;
        String m_password;
        String m_layout;
        String m_databaseType;
        boolean supportsMultipleModels;
        boolean supportsJenaReification;
        boolean noReformat;
        DBConnection m_dbconn = null;

        ConfigTestCaseRDB(String string, String string2, String string3, String string4, String string5) {
            this.m_baseuri = string;
            this.m_user = string2;
            this.m_password = string3;
            this.m_layout = string4;
            this.m_databaseType = string5;
            try {
                DBConnection dBConnection = new DBConnection(string, string2, string3);
                IRDBDriver iRDBDriver = dBConnection.getDriver(string4, string5);
                this.supportsMultipleModels = iRDBDriver.supportsMultipleModels();
                this.supportsJenaReification = iRDBDriver.supportsJenaReification();
            }
            catch (RDFRDBException rDFRDBException) {
                this.supportsMultipleModels = false;
            }
            this.noReformat = false;
        }

        ConfigTestCaseRDB(String string, String string2, String string3, String string4, String string5, boolean bl) {
            this(string, string2, string3, string4, string5);
            this.noReformat = bl;
        }

        ModelRDB createModel(String string) throws RDFException {
            if (this.supportsMultipleModels) {
                if (this.m_dbconn == null) {
                    this.m_dbconn = new DBConnection(System.getProperty("jena.rdb.test.dbfull"), this.m_user, this.m_password);
                    if (!this.m_dbconn.isFormatOK()) {
                        IRDBDriver iRDBDriver = this.m_dbconn.getDriver(this.m_layout, this.m_databaseType);
                        iRDBDriver.formatDB();
                    }
                }
                return ModelRDB.createModel(this.m_dbconn, string);
            }
            DBConnection dBConnection = new DBConnection(this.m_baseuri + string, this.m_user, this.m_password);
            return ModelRDB.create(dBConnection, this.m_layout, this.m_databaseType);
        }
    }
}

