/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.rdb;

import com.hp.hpl.mesa.rdf.jena.common.LiteralImpl;
import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.rdb.DriverGenericMMGeneric;
import com.hp.hpl.mesa.rdf.jena.rdb.HasRDBID;
import com.hp.hpl.mesa.rdf.jena.rdb.IDBID;
import com.hp.hpl.mesa.rdf.jena.rdb.IRDBDriver;
import com.hp.hpl.mesa.rdf.jena.rdb.RDFRDBException;
import com.hp.hpl.mesa.rdf.jena.rdb.ResultSetIterator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public class DriverOracleMMGeneric
extends DriverGenericMMGeneric
implements IRDBDriver {
    protected static Properties m_defaultMMSQL = null;
    protected static String EMPTY_LITERAL_MARKER = "empty-literal";

    public DriverOracleMMGeneric() {
        this.DRIVER_NAME = "oracle.jdbc.driver.OracleDriver";
        this.LAYOUT_TYPE = "MMGeneric";
        this.DATABASE_TYPE = "Oracle";
        this.SQL_FILE = "etc/oracle_mmgeneric.sql";
        this.MAX_LITERAL = 1000;
        this.ID_SQL_TYPE = "INTEGER";
    }

    public IDBID getLiteralID(Literal literal) throws RDFRDBException {
        try {
            String string;
            String string2;
            String string3 = literal.toString();
            int n = string3.length();
            if (n >= this.MAX_LITERAL) {
                string3 = this.getLiteralIdx(string3);
            }
            boolean bl = (string2 = literal.getLanguage()) == null || string2.equals("");
            String string4 = string = bl ? "getLiteralIDNoLang" : "getLiteralID";
            if (n == 0) {
                string = string + "NullLiteral";
                string3 = EMPTY_LITERAL_MARKER;
            }
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement(string);
            preparedStatement.setString(1, string3);
            if (!bl) {
                preparedStatement.setString(2, string2);
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            IDBID iDBID = null;
            if (resultSet.next()) {
                iDBID = this.wrapDBID(resultSet.getObject(1));
            }
            resultSet.close();
            this.m_sql.returnPreparedSQLStatement(preparedStatement, string);
            return iDBID;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to find literal", (Exception)sQLException);
        }
    }

    public Object wrapFlag(boolean bl) {
        return bl ? new Integer(1) : new Integer(0);
    }

    public Literal getLiteral(IDBID iDBID) throws RDFException {
        Literal literal = super.getLiteral(iDBID);
        if (literal != null && literal.getLanguage() == null) {
            return new LiteralImpl(literal.getString(), "", literal.getWellFormed());
        }
        return literal;
    }

    public IDBID getResourceID(Resource resource) throws RDFException {
        try {
            Object[] objectArray;
            String string;
            HasRDBID hasRDBID = (HasRDBID)((Object)resource);
            IDBID iDBID = hasRDBID.getRDBId();
            if (iDBID != null) {
                return iDBID;
            }
            String string2 = resource.isAnon() ? "_" : resource.getNameSpace();
            IDBID iDBID2 = this.getNamespaceID(string2);
            if (iDBID2 == null) {
                return null;
            }
            hasRDBID.setRDBNSId(iDBID2);
            String string3 = resource.isAnon() ? resource.getId().toString() : resource.getLocalName();
            boolean bl = string3 == null || string3.equals("");
            String string4 = string = bl ? "getResourceIDNoName" : "getResourceID";
            if (bl) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = iDBID2.getID();
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = string3;
                objectArray = objectArray3;
                objectArray3[1] = iDBID2.getID();
            }
            Object[] objectArray4 = objectArray;
            ResultSetIterator resultSetIterator = this.m_sql.runSQLQuery(string, objectArray4);
            if (resultSetIterator.hasNext()) {
                iDBID = this.wrapDBID(resultSetIterator.getSingleton());
                hasRDBID.setRDBId(iDBID);
                return iDBID;
            }
            return null;
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to find resource", (Exception)sQLException);
        }
    }

    protected IDBID addLiteral(Literal literal) throws RDFRDBException {
        IDBID iDBID = null;
        if (!this.SKIP_DUPLICATE_CHECK && (iDBID = this.getLiteralID(literal)) != null) {
            return iDBID;
        }
        try {
            Object object;
            String string;
            int n;
            String string2;
            int n2 = 0;
            boolean bl = false;
            try {
                n2 = Integer.parseInt(literal.toString());
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            String string3 = string2 = bl ? "insertLiteralInt" : "insertLiteral";
            if (this.INSERT_BY_PROCEDURE) {
                string2 = string2 + "Proc";
            }
            PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement(string2);
            int n4 = 1;
            if (!this.SKIP_ALLOCATE_ID) {
                iDBID = this.allocateLiteralID(literal);
                preparedStatement.setObject(n4++, iDBID.getID());
            }
            if ((n = (string = literal.toString()).length()) >= this.MAX_LITERAL || n == 0) {
                preparedStatement.setString(n4++, n == 0 ? EMPTY_LITERAL_MARKER : this.getLiteralIdx(string));
                object = string.getBytes("UTF-8");
                int n5 = ((byte[])object).length;
                byte[] byArray = new byte[n5 + 4];
                byArray[0] = (byte)(n5 & 0xFF);
                byArray[1] = (byte)(n5 >> 8 & 0xFF);
                byArray[2] = (byte)(n5 >> 16 & 0xFF);
                byArray[3] = (byte)(n5 >> 24 & 0xFF);
                System.arraycopy(object, 0, byArray, 4, n5);
                preparedStatement.setBinaryStream(n4++, (InputStream)new ByteArrayInputStream(byArray), byArray.length);
            } else {
                preparedStatement.setString(n4++, string);
                preparedStatement.setNull(n4++, 2004);
            }
            preparedStatement.setString(n4++, literal.getLanguage());
            preparedStatement.setInt(n4++, literal.getWellFormed() ? 1 : 0);
            if (bl) {
                preparedStatement.setInt(n4++, n2);
            }
            if (this.INSERT_BY_PROCEDURE) {
                object = preparedStatement.executeQuery();
                ResultSetIterator resultSetIterator = new ResultSetIterator((ResultSet)object, preparedStatement, this.m_sql, string2);
                if (resultSetIterator != null && resultSetIterator.hasNext()) {
                    iDBID = this.wrapDBID(resultSetIterator.getSingleton());
                }
            } else {
                preparedStatement.executeUpdate();
                this.m_sql.returnPreparedSQLStatement(preparedStatement, string2);
            }
            if (iDBID == null) {
                iDBID = this.getLiteralID(literal);
            }
            return iDBID;
        }
        catch (Exception exception) {
            System.out.println("Problem on literal (l=" + literal.toString().length() + ") ");
            System.out.println("ID is: " + iDBID);
            throw new RDFRDBException("Failed to register literal", exception);
        }
    }
}

