/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.model;

public class RDFException
extends Exception {
    protected int errorCode = 0;
    protected int otherCode = 0;
    protected Exception nestedException = null;
    protected String message = null;
    public static final int NOTRELATEDTOMODEL = 1;
    public static final int INVALIDPROPERTYURI = 2;
    public static final int UNSUPPORTEDOPERATION = 3;
    public static final int OBJECTNOTRESOURCE = 4;
    public static final int OBJECTNOTLITERAL = 5;
    public static final int PROPERTYNOTFOUND = 6;
    public static final int NOTANONRESOURCE = 7;
    public static final int ITERATORCLOSED = 8;
    public static final int INVALIDERRORCODE = 9;
    public static final int NESTEDEXCEPTION = 10;
    public static final int INVALIDBOOLEANFORMAT = 11;
    public static final int LITERALNOTCHAR = 12;
    public static final int ALTHASNODEFAULT = 13;
    public static final int SELECTOREXCEPTION = 14;
    public static final int OBJECTWRONGTYPE = 15;
    public static final int NOSUCHELEMENT = 16;
    public static final int ASSERTIONFAILURE = 17;
    public static final int SEQINDEXBOUNDS = 18;
    public static final int NORESOURCECONSTRUCTOR = 19;
    public static final int NOREADERFORLANG = 20;
    public static final int NOWRITERFORLANG = 21;
    public static final int UNKNOWNPROPERTY = 22;
    public static final int STATEMENTNOTPRESENT = 23;
    public static final int SYNTAXERROR = 24;
    protected static final int MAXERRORCODE = 24;
    protected static final String[] errorMessage = new String[]{"not used", "Object is not related to a model", "Invalid property URI", "Unsupported operation", "Object of statement is not a resource", "Object of statement is not a literal", "Subject does not have that property", "Resource is not anonymous", "Iterator has been closed", "Invalid error code", "Nested Exception", "Literal is not a boolean", "Literal is not a single character", "Alt container has no default", "Selector threw exception", "Statement object does match requested type", "Iterator does not have an element", "Assertion failure", "Sequence index out of range", "Enhanced Resource lacks Resource constructor", "No RDFReader is defined for that language", "No RDFWriter is defined for that lanaguage", "Property not known", "Statement not present", "Syntax errors in input stream"};

    protected RDFException() {
    }

    public RDFException(int n) {
        if (1 <= n && n <= 24) {
            this.errorCode = n;
        } else {
            this.errorCode = 9;
            this.otherCode = n;
        }
        this.message = errorMessage[this.errorCode];
    }

    public RDFException(Exception exception) {
        this.errorCode = 10;
        this.message = errorMessage[this.errorCode];
        this.nestedException = exception;
    }

    public RDFException(int n, Exception exception) {
        this.errorCode = n;
        this.message = errorMessage[10];
        this.nestedException = exception;
    }

    public RDFException(int n, String string) {
        this.errorCode = n;
        this.message = string;
    }

    public String toString() {
        String string = this.getMessage();
        if (string == null) {
            return this.getClass().getName();
        }
        return this.getClass().getName() + ": " + string;
    }

    public String getMessage() {
        String string = Integer.toString(this.errorCode) + " " + this.message;
        if (this.errorCode == 9) {
            string = string + " = " + Integer.toString(this.otherCode);
        } else if (this.errorCode == 10 || this.errorCode == 14) {
            string = this.message + " = " + this.nestedException.toString();
        }
        return string;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public Exception getNestedException() {
        return this.nestedException;
    }
}

