/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.common.regression;

import com.hp.hpl.mesa.rdf.jena.common.regression.MakeAnon;
import com.hp.hpl.mesa.rdf.jena.common.regression.ResourceReader;
import com.hp.hpl.mesa.rdf.jena.mem.ModelMem;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFError;
import com.hp.hpl.mesa.rdf.jena.model.RDFErrorHandler;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.RDFReader;
import com.hp.hpl.mesa.rdf.jena.model.RDFWriter;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import com.hp.hpl.mesa.rdf.jena.model.StmtIterator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.BitSet;
import java.util.Random;

public class testWriterAndReader
implements RDFErrorHandler {
    private static boolean showProgress = false;
    private static boolean keepFiles = false;
    private static boolean errorDetail = false;
    private static int firstTest = 5;
    private static int lastTest = 9;
    private static int repetitionsJ = 6;
    private String test = " test testWriterAndReader initialization";
    private int n = 0;
    static final String[] baseUris = new String[]{"http://foo.com/Hello", "http://foo.com/Hello", "http://daml.umbc.edu/ontologies/calendar-ont", "http://www.daml.org/2001/03/daml+oil-ex"};
    BitSet seenError = new BitSet();

    protected static void doTest(Model model, Model model2, Model model3, Model model4) {
        if (showProgress) {
            System.out.println("Each + below corresponds to 80 tests.");
        }
        new testWriterAndReader().test(model, model2, model3, model4);
    }

    public void test(Model model, Model model2, Model model3, Model model4) {
        try {
            this.test("N-TRIPLE", 25, 1, 1, model, model2, model3, model4, null, null);
            this.test("RDF/XML-ABBREV", 35, 1, 1, model, model2, model3, model4, null, null);
            this.test("RDF/XML", 35, 1, 1, model, model2, model3, model4, null, null);
            String[] stringArray = new String[]{"longId"};
            Object[] objectArray = new Object[]{new Boolean(true)};
            this.test("RDF/XML", 35, 1, 1, model, model2, model3, model4, stringArray, objectArray);
        }
        catch (Exception exception) {
            this.error(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void test(String string, int n, int n2, int n4, Model model, Model model2, Model model3, Model model4, String[] stringArray, Object[] objectArray) throws RDFException {
        int n5;
        this.test = "testWriterAndReader lang=" + string + " seed=" + n;
        String string2 = "modules/rdf/regression/testWriterAndReader/";
        if (showProgress) {
            System.out.println("Beginning " + this.test);
        }
        this.seenError = new BitSet();
        Random random = new Random(n);
        MakeAnon makeAnon = new MakeAnon(string);
        RDFReader rDFReader = model.getReader(string);
        RDFWriter rDFWriter = model.getWriter(string);
        if (stringArray != null) {
            n5 = 0;
            while (n5 < stringArray.length) {
                rDFWriter.setProperty(stringArray[n5], objectArray[n5]);
                ++n5;
            }
        }
        rDFReader.setErrorHandler(this);
        rDFWriter.setErrorHandler(this);
        n5 = 0;
        block5: while (true) {
            if (n5 >= n2) {
                if (showProgress) {
                    System.out.println("End of " + this.test);
                }
                return;
            }
            int n6 = 0;
            while (true) {
                if (n6 >= n4) {
                    if (showProgress) {
                        System.out.println();
                    }
                    ++n5;
                    continue block5;
                }
                try {
                    int n7 = firstTest;
                    block7: while (n7 <= lastTest) {
                        this.n = 1000 * n7;
                        ++this.n;
                        String string3 = "t" + n7 * 1000 + ".rdf";
                        ++this.n;
                        testWriterAndReader.empty(model);
                        ++this.n;
                        String string4 = n7 < baseUris.length ? baseUris[n7] : "http://foo.com/Hello";
                        ++this.n;
                        InputStreamReader inputStreamReader = new ResourceReader(string2 + string3);
                        ++this.n;
                        model.read(inputStreamReader, string4);
                        ++this.n;
                        ((Reader)inputStreamReader).close();
                        boolean bl = false;
                        int n8 = 0;
                        while (true) {
                            File file;
                            block26: {
                                Object var41_41;
                                Model model5;
                                Model model6;
                                if (n8 >= repetitionsJ) {
                                    ++n7;
                                    continue block7;
                                }
                                this.n = 1000 * n7 + n8 * 100 + 20;
                                file = File.createTempFile("j" + this.n + "t", ".txt");
                                ++this.n;
                                String string5 = n8 % 2 == 0 ? string4 : "http://bar.com/irrelevant";
                                int n9 = (int)model.size();
                                ++this.n;
                                if (n8 % 2 == 0 && n8 > 0) {
                                    this.prune(model, random, 1 + n9 / 10);
                                }
                                ++this.n;
                                if (n8 % 2 == 0 && n8 > 0) {
                                    this.expand(model, random, 1 + n9 / 10);
                                }
                                ++this.n;
                                PrintWriter printWriter = new PrintWriter(new FileWriter(file));
                                ++this.n;
                                rDFWriter.write(model, printWriter, string5);
                                ++this.n;
                                printWriter.close();
                                ++this.n;
                                testWriterAndReader.empty(model2);
                                ++this.n;
                                FileInputStream fileInputStream = new FileInputStream(file);
                                ++this.n;
                                inputStreamReader = new InputStreamReader(fileInputStream);
                                ++this.n;
                                rDFReader.read(model2, inputStreamReader, string5);
                                ++this.n;
                                ((InputStream)fileInputStream).close();
                                ++this.n;
                                ((Reader)inputStreamReader).close();
                                ++this.n;
                                Model model7 = makeAnon.makeAnon(model, string5, model3);
                                int n10 = makeAnon.lastCnt();
                                ++this.n;
                                Model model8 = makeAnon.makeAnon(model2, string5, model4);
                                int n11 = makeAnon.lastCnt();
                                if (n10 > 50) {
                                    System.out.println(n10);
                                }
                                ++this.n;
                                if (n10 == n11 && model7.equals(model8)) break block26;
                                bl = true;
                                this.error();
                                printWriter = new PrintWriter(new FileWriter(File.createTempFile("j" + this.n + "b", ".txt")));
                                model.write(printWriter);
                                printWriter.close();
                                printWriter = new PrintWriter(new FileWriter(File.createTempFile("j" + this.n + "b", ".txt")));
                                model2.write(printWriter);
                                printWriter.close();
                                printWriter = new PrintWriter(new FileWriter(File.createTempFile("j" + this.n + "b", ".txt")));
                                model7.write(printWriter);
                                printWriter.close();
                                printWriter = new PrintWriter(new FileWriter(File.createTempFile("j" + this.n + "b", ".txt")));
                                model8.write(printWriter);
                                printWriter.close();
                                if (!errorDetail) break block26;
                                int n12 = (int)(model7.size() - model8.size());
                                System.out.print("Diff is " + n12);
                                int n13 = 0;
                                if (n12 >= 0) {
                                    model6 = model7;
                                    model5 = model8;
                                } else {
                                    model6 = model8;
                                    model5 = model7;
                                }
                                StmtIterator stmtIterator = model6.listStatements();
                                try {
                                    while (true) {
                                        RDFNode rDFNode;
                                        block28: {
                                            block27: {
                                                if (n13 >= 10) break block27;
                                                if (stmtIterator.hasNext()) break block28;
                                            }
                                            var41_41 = null;
                                            break;
                                        }
                                        Statement statement = stmtIterator.next();
                                        if (model5.contains(statement) || statement.getSubject().isAnon() || (rDFNode = statement.getObject()) instanceof Resource && ((Resource)rDFNode).isAnon()) continue;
                                        ++n13;
                                        System.out.println(statement);
                                    }
                                }
                                catch (Throwable throwable) {
                                    var41_41 = null;
                                    stmtIterator.close();
                                    throw throwable;
                                }
                                stmtIterator.close();
                            }
                            if (!keepFiles && !bl) {
                                ++this.n;
                                file.delete();
                            }
                            ++n8;
                        }
                    }
                }
                catch (Exception exception) {
                    this.error(exception);
                }
                if (showProgress) {
                    System.out.print("+");
                    System.out.flush();
                }
                ++n6;
            }
            break;
        }
    }

    private void prune(Model model, Random random, int n) throws RDFException {
        int n2;
        Statement[] statementArray = new Statement[n];
        int n4 = (int)model.size();
        StmtIterator stmtIterator = model.listStatements();
        try {
            n2 = 0;
            while (n2 < n) {
                statementArray[n2] = stmtIterator.next();
                ++n2;
            }
            while (stmtIterator.hasNext()) {
                int n5 = random.nextInt(n4);
                if (n5 >= n) continue;
                statementArray[n5] = stmtIterator.next();
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            stmtIterator.close();
            throw throwable;
        }
        stmtIterator.close();
        n2 = 0;
        while (n2 < n) {
            model.remove(statementArray[n2]);
            ++n2;
        }
    }

    private void expand(Model model, Random random, int n) throws RDFException {
        int n2;
        Resource[] resourceArray = new Resource[n];
        Property[] propertyArray = new Property[n];
        RDFNode[] rDFNodeArray = new RDFNode[n];
        int n4 = (int)model.size();
        StmtIterator stmtIterator = model.listStatements();
        try {
            Statement statement;
            n2 = 0;
            while (n2 < n) {
                statement = stmtIterator.next();
                resourceArray[n2] = statement.getSubject();
                propertyArray[n2] = statement.getPredicate();
                rDFNodeArray[n2] = statement.getObject();
                ++n2;
            }
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.next();
                Resource resource = statement.getSubject();
                RDFNode rDFNode = statement.getObject();
                int n5 = random.nextInt(n4);
                if (n5 < n) {
                    resourceArray[n5] = resource;
                }
                if ((n5 = random.nextInt(n4)) < n) {
                    rDFNodeArray[n5] = resource;
                }
                if ((n5 = random.nextInt(n4)) < n) {
                    propertyArray[n5] = statement.getPredicate();
                }
                if ((n5 = random.nextInt(n4)) < n) {
                    rDFNodeArray[n5] = rDFNode;
                }
                if (!(rDFNode instanceof Resource) || (n5 = random.nextInt(n4)) >= n) continue;
                resourceArray[n5] = (Resource)rDFNode;
            }
            Object var15_14 = null;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            stmtIterator.close();
            throw throwable;
        }
        stmtIterator.close();
        n2 = 0;
        while (n2 < n) {
            model.add(resourceArray[n2], propertyArray[n2], rDFNodeArray[n2]);
            ++n2;
        }
    }

    private void error() {
        if (!this.seenError.get(this.n)) {
            System.out.println(this.test + ": failed test " + Integer.toString(this.n));
        }
        this.seenError.set(this.n);
    }

    public void error(Exception exception) {
        if (!this.seenError.get(this.n)) {
            System.out.println("Test Failed: " + this.test + " " + this.n + " " + exception.toString());
        }
        this.seenError.set(this.n);
    }

    public boolean getErrors() {
        return !this.seenError.equals(new BitSet());
    }

    public void warning(Exception exception) {
    }

    public void fatalError(Exception exception) {
        this.error(exception);
        throw new RDFError(exception);
    }

    public static void empty(Model model) throws RDFException {
        StmtIterator stmtIterator = model.listStatements();
        while (stmtIterator.hasNext()) {
            stmtIterator.next();
            stmtIterator.remove();
        }
    }

    static ModelMem load(String string) throws RDFException, IOException {
        ModelMem modelMem = new ModelMem();
        ModelMem modelMem2 = new ModelMem();
        RDFReader rDFReader = modelMem.getReader();
        FileInputStream fileInputStream = new FileInputStream("c:\\" + string);
        InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
        rDFReader.read(modelMem, inputStreamReader, "http://should.not.see.me/");
        ((InputStream)fileInputStream).close();
        ((Reader)inputStreamReader).close();
        MakeAnon makeAnon = new MakeAnon("RDF/XML");
        return (ModelMem)makeAnon.makeAnon(modelMem, "http://should.not.see.me/", modelMem2);
    }

    public static void main(String[] stringArray) throws RDFException, IOException {
        showProgress = true;
        testWriterAndReader testWriterAndReader2 = new testWriterAndReader();
        ModelMem modelMem = new ModelMem();
        ModelMem modelMem2 = new ModelMem();
        ModelMem modelMem3 = new ModelMem();
        ModelMem modelMem4 = new ModelMem();
        try {
            testWriterAndReader2.test("N-TRIPLE", 25, 1, 1, modelMem, modelMem2, modelMem3, modelMem4, null, null);
            testWriterAndReader2.test("RDF/XML-ABBREV", 35, 1, 1, modelMem, modelMem2, modelMem3, modelMem4, null, null);
            testWriterAndReader2.test("RDF/XML", 35, 1, 1, modelMem, modelMem2, modelMem3, modelMem4, null, null);
            String[] stringArray2 = new String[]{"longId"};
            Object[] objectArray = new Object[]{new Boolean(true)};
            testWriterAndReader2.test("RDF/XML", 35, 1, 1, modelMem, modelMem2, modelMem3, modelMem4, stringArray2, objectArray);
        }
        catch (Exception exception) {
            testWriterAndReader2.error(exception);
        }
    }
}

