/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.common.regression;

import com.hp.hpl.mesa.rdf.jena.mem.ModelMem;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestWriterXMLBaseProp
extends TestCase {
    protected Model model = null;
    String base1 = "http://example/foobar";
    String base2 = "http://example/barfoo";
    static /* synthetic */ Class class$com$hp$hpl$mesa$rdf$jena$common$regression$TestWriterXMLBaseProp;

    public TestWriterXMLBaseProp(String string) {
        super(string);
    }

    public static Test suite() {
        return new TestSuite(class$com$hp$hpl$mesa$rdf$jena$common$regression$TestWriterXMLBaseProp == null ? (class$com$hp$hpl$mesa$rdf$jena$common$regression$TestWriterXMLBaseProp = TestWriterXMLBaseProp.class$("com.hp.hpl.mesa.rdf.jena.common.regression.TestWriterXMLBaseProp")) : class$com$hp$hpl$mesa$rdf$jena$common$regression$TestWriterXMLBaseProp);
    }

    public void testBasicXMLBase() {
        this.doTest("RDF/XML");
    }

    public void testAbbrevXMLBase() {
        this.doTest("RDF/XML-ABBREV");
    }

    public void testAbbrevPropertyURI() {
        this.doBadPropTest("RDF/XML-ABBREV");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doTest(String string) {
        File file = null;
        try {
            try {
                this.model = new ModelMem();
                RDFWriter rDFWriter = this.model.getWriter(string);
                String string2 = (String)rDFWriter.setProperty("xmlbase", this.base1);
                Assert.assertTrue((String)"xmlbase valued non-null", (string2 == null ? (byte)1 : 0) != 0);
                string2 = (String)rDFWriter.setProperty("xmlbase", this.base2);
                Assert.assertEquals((String)"xmlbase valued incorrect.", (Object)this.base1, (Object)string2);
                file = File.createTempFile("rdf", ".xml");
                file.deleteOnExit();
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8");
                rDFWriter.write(this.model, outputStreamWriter, "");
                ((Writer)outputStreamWriter).close();
                FileReader fileReader = new FileReader(file);
                String string3 = "";
                int n = fileReader.read();
                while (true) {
                    if (n < 0) {
                        fileReader.close();
                        if (string3.indexOf("xml:base=\"" + this.base2 + "\"") < 0 && string3.indexOf("xml:base='" + this.base2 + "'") < 0) {
                            Assert.assertTrue((String)"xml:base not found", (boolean)false);
                        }
                        break;
                    }
                    string3 = string3 + (char)n;
                    n = fileReader.read();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
                Assert.assertTrue((String)exception.toString(), (boolean)false);
                Object var10_11 = null;
                if (file == null) return;
                file.delete();
                return;
            }
            Object var10_10 = null;
            if (file == null) return;
            file.delete();
            return;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (file == null) throw throwable;
            file.delete();
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    void doBadPropTest(String var1_1) {
        try {
            block5: {
                var2_2 = new ModelMem();
                var2_2.add(var2_2.createResource(), var2_2.createProperty("http://example/", "foo#"), "foo");
                var3_4 = File.createTempFile("rdf", ".xml");
                var3_4.deleteOnExit();
                var4_5 = new FileWriter(var3_4);
                try {
                    var2_2.write(var4_5, var1_1);
                    Assert.fail((String)"Writer did not detect bad property URI");
                    break block5;
                }
                catch (RDFException var5_6) {
                    ** while (var5_7.getErrorCode() == 10 && var5_7.getNestedException() instanceof RDFException)
                }
lbl-1000:
                // 1 sources

                {
                    var5_7 = (RDFException)var5_7.getNestedException();
                    continue;
                }
lbl17:
                // 1 sources

                Assert.assertEquals((String)("Inappropriate exception: " + var5_7.getMessage()), (int)var5_7.getErrorCode(), (int)2);
            }
            var4_5.close();
            var3_4.delete();
        }
        catch (Exception var2_3) {
            var2_3.printStackTrace();
            Assert.fail((String)("Unexpected exception: " + var2_3.toString()));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

