/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.common.regression;

import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDF;
import java.math.BigInteger;

class DiHyperCube {
    private final Resource[] corners;
    private final int dim;
    private final Model model;
    private int id = 2000;

    public DiHyperCube(int n, Model model) throws RDFException {
        this.dim = n;
        this.model = model;
        this.corners = new Resource[1 << this.dim];
        int n2 = 0;
        while (n2 < this.corners.length) {
            this.corners[n2] = model.createResource();
            ++n2;
        }
        int n4 = 0;
        while (n4 < this.corners.length) {
            this.addDown(n4, this.corners[n4]);
            ++n4;
        }
    }

    private void addDown(int n, Resource resource) throws RDFException {
        int n2 = 0;
        while (n2 < this.dim) {
            int n4 = 1 << n2;
            if ((n & n4) != 0) {
                this.model.add(resource, RDF.value, this.corners[n ^ n4]);
            }
            ++n2;
        }
    }

    DiHyperCube dupe(int n) throws RDFException {
        Resource resource = this.model.createResource();
        int n2 = 0;
        while (n2 < this.dim) {
            int n4 = 1 << n2;
            if ((n & n4) != 0) {
                this.model.add(resource, RDF.value, this.corners[n ^ n4]);
            } else {
                this.model.add(this.corners[n ^ n4], RDF.value, resource);
            }
            ++n2;
        }
        return this;
    }

    static int bitCount(int n) {
        return BigInteger.valueOf(n).bitCount();
    }

    static boolean equal(int n, int n2) {
        return DiHyperCube.bitCount(n) == DiHyperCube.bitCount(n2);
    }

    static boolean equal(int n, int n2, int n4, int n5) {
        return DiHyperCube.bitCount(n ^ n2) == DiHyperCube.bitCount(n4 ^ n5) && DiHyperCube.bitCount(n & n2) == DiHyperCube.bitCount(n4 & n5) && DiHyperCube.bitCount(n | n2) == DiHyperCube.bitCount(n4 | n5) && Math.min(DiHyperCube.bitCount(n), DiHyperCube.bitCount(n2)) == Math.min(DiHyperCube.bitCount(n4), DiHyperCube.bitCount(n5));
    }
}

