/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.common;

import com.hp.hpl.mesa.rdf.jena.common.RDFDefaultErrorHandler;
import com.hp.hpl.mesa.rdf.jena.common.SelectorImpl;
import com.hp.hpl.mesa.rdf.jena.common.Util;
import com.hp.hpl.mesa.rdf.jena.common.XMLChar;
import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.NsIterator;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFErrorHandler;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.RDFWriter;
import com.hp.hpl.mesa.rdf.jena.model.ResIterator;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import com.hp.hpl.mesa.rdf.jena.model.StmtIterator;
import com.hp.hpl.mesa.rdf.jena.vocabulary.DC;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDF;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDFS;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RSS;
import com.hp.hpl.mesa.rdf.jena.vocabulary.VCARD;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;

public class RDFXMLWriter
implements RDFWriter {
    Properties nsMap = new Properties();
    String xmlBase = null;
    boolean longId = false;
    HashMap anonMap = new HashMap();
    int anonCount = 0;
    static String RDFNS = RDF.getURI();
    RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();
    final char ESCAPE = (char)88;

    public RDFXMLWriter() {
        this.nsMap.setProperty(RDF.getURI(), "rdf");
        this.nsMap.setProperty(RDFS.getURI(), "rdfs");
        this.nsMap.setProperty(DC.getURI(), "dc");
        this.nsMap.setProperty(RSS.getURI(), "rss");
        this.nsMap.setProperty("http://www.daml.org/2001/03/daml+oil.daml#", "daml");
        this.nsMap.setProperty(VCARD.getURI(), "vcard");
    }

    public void write(Model model, Writer writer, String string) throws RDFException {
        try {
            PrintWriter printWriter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
            this.listNameSpaces(model);
            this.writeRDFHeader(model, printWriter, string);
            this.writeRDFStatements(model, printWriter);
            this.writeRDFTrailer(printWriter, string);
            writer.flush();
        }
        catch (Exception exception) {
            this.errorHandler.error(exception);
        }
    }

    public void setNsPrefix(String string, String string2) {
        this.nsMap.setProperty(string2, string);
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler rDFErrorHandler) {
        RDFErrorHandler rDFErrorHandler2 = this.errorHandler;
        this.errorHandler = rDFErrorHandler;
        return rDFErrorHandler2;
    }

    protected void listNameSpaces(Model model) throws RDFException {
        NsIterator nsIterator = model.listNameSpaces();
        int n = 0;
        while (nsIterator.hasNext()) {
            String string = nsIterator.next();
            String string2 = Util.getProperty("com.hp.hpl.mesa.rdf.jena.nsprefix." + string);
            if (string2 != null) {
                this.nsMap.setProperty(string, string2);
                continue;
            }
            if (this.nsMap.getProperty(string) != null) continue;
            ((Hashtable)this.nsMap).put(string, "NS" + Integer.toString(n++));
        }
    }

    protected void writeRDFHeader(Model model, PrintWriter printWriter, String string) throws RDFException {
        NsIterator nsIterator = model.listNameSpaces();
        printWriter.println("<" + this.nsPrefix(RDFNS) + ":RDF");
        printWriter.println("  xmlns:" + this.nsPrefix(RDFNS) + "='" + RDFNS + "'");
        if (null != this.xmlBase && this.xmlBase.length() > 0) {
            printWriter.println("  xml:base=\"" + this.xmlBase + "\"");
        }
        while (nsIterator.hasNext()) {
            String string2 = nsIterator.next();
            if (string2.equals(RDFNS)) continue;
            printWriter.println("  xmlns:" + this.nsPrefix(string2) + "='" + string2 + "'");
        }
        printWriter.println(" >");
    }

    protected void writeRDFStatements(Model model, PrintWriter printWriter) throws RDFException {
        ResIterator resIterator = model.listSubjects();
        while (resIterator.hasNext()) {
            this.writeRDFStatements(model, resIterator.next(), printWriter);
        }
    }

    protected void writeRDFTrailer(PrintWriter printWriter, String string) {
        printWriter.println("</" + this.nsPrefix(RDFNS) + ":RDF>");
    }

    protected void writeRDFStatements(Model model, Resource resource, PrintWriter printWriter) throws RDFException {
        StmtIterator stmtIterator = model.listStatements(new SelectorImpl(resource, null, (RDFNode)null));
        this.writeDescriptionHeader(resource, printWriter);
        if (resource instanceof Statement && !model.contains((Statement)resource)) {
            this.writeReifiedProperties((Statement)resource, printWriter);
        }
        while (stmtIterator.hasNext()) {
            this.writePredicate(stmtIterator.next(), printWriter);
        }
        this.writeDescriptionTrailer(printWriter);
        if (resource instanceof Statement) {
            RDFNode rDFNode;
            Resource resource2 = ((Statement)resource).getSubject();
            if (resource2 instanceof Statement && !model.contains((Statement)resource2)) {
                this.writeRDFStatements(model, resource2, printWriter);
            }
            if ((rDFNode = ((Statement)resource).getObject()) instanceof Statement && !model.contains((Statement)rDFNode)) {
                this.writeRDFStatements(model, (Resource)rDFNode, printWriter);
            }
        }
    }

    protected void writeDescriptionHeader(Resource resource, PrintWriter printWriter) throws RDFException {
        printWriter.print("  <" + this.nsPrefix(RDFNS) + ":Description ");
        this.writeResourceId(resource, printWriter);
        printWriter.println(">");
    }

    protected void writePredicate(Statement statement, PrintWriter printWriter) throws RDFException {
        Property property = statement.getPredicate();
        RDFNode rDFNode = statement.getObject();
        printWriter.print("    <" + this.transNS(property));
        if (statement.isReified()) {
            printWriter.print(" " + this.nsPrefix(RDFNS) + ":ID='" + this.anonId(statement) + "'");
        }
        if (rDFNode instanceof Resource) {
            printWriter.print(" ");
            this.writeResourceReference((Resource)rDFNode, printWriter);
            printWriter.println("/>");
        } else {
            this.writeLiteral((Literal)rDFNode, printWriter);
            printWriter.println("</" + this.transNS(property) + ">");
        }
    }

    protected void writeDescriptionTrailer(PrintWriter printWriter) {
        printWriter.println("  </" + this.nsPrefix(RDFNS) + ":Description>");
    }

    protected void writeReifiedProperties(Statement statement, PrintWriter printWriter) throws RDFException {
        printWriter.println("    <" + this.nsPrefix(RDFNS) + ":type " + this.nsPrefix(RDFNS) + ":resource='" + RDFNS + "Statement'/>");
        printWriter.print("    <" + this.nsPrefix(RDFNS) + ":subject ");
        this.writeResourceReference(statement.getSubject(), printWriter);
        printWriter.println("/>");
        printWriter.println("    <" + this.nsPrefix(RDFNS) + ":predicate " + this.nsPrefix(RDFNS) + ":resource='" + Util.substituteStandardEntities(statement.getPredicate().getURI()) + "'/>");
        printWriter.print("    <" + this.nsPrefix(RDFNS) + ":object ");
        RDFNode rDFNode = statement.getObject();
        if (rDFNode instanceof Resource) {
            this.writeResourceReference((Resource)statement.getObject(), printWriter);
            printWriter.println("/>");
        } else {
            this.writeLiteral((Literal)rDFNode, printWriter);
            printWriter.println("</" + this.nsPrefix(RDFNS) + ":object>");
        }
    }

    protected void writeResourceId(Resource resource, PrintWriter printWriter) throws RDFException {
        if (resource.isAnon()) {
            printWriter.print(this.nsPrefix(RDFNS) + ":nodeID='" + this.anonId(resource));
        } else {
            printWriter.print(this.nsPrefix(RDFNS) + ":about='" + Util.substituteStandardEntities(resource.getURI()));
        }
        printWriter.print("'");
    }

    protected void writeResourceReference(Resource resource, PrintWriter printWriter) throws RDFException {
        if (resource.isAnon()) {
            printWriter.print(this.nsPrefix(RDFNS) + ":nodeID='" + this.anonId(resource));
        } else {
            printWriter.print(this.nsPrefix(RDFNS) + ":resource='" + Util.substituteStandardEntities(resource.getURI()));
        }
        printWriter.print("'");
    }

    protected void writeLiteral(Literal literal, PrintWriter printWriter) {
        String string = literal.getLanguage();
        if (!string.equals("")) {
            printWriter.print(" xml:lang='" + string + "'");
        }
        if (literal.getWellFormed()) {
            printWriter.print(" " + this.nsPrefix(RDFNS) + ":parseType='Literal'>");
            printWriter.print(literal.toString());
        } else {
            printWriter.print(">");
            printWriter.print(Util.substituteStandardEntities(literal.toString()));
        }
    }

    protected String anonId(Resource resource) throws RDFException {
        if (this.longId) {
            return this.longAnonId(resource);
        }
        return this.shortAnonId(resource);
    }

    protected String shortAnonId(Resource resource) throws RDFException {
        String string = (String)this.anonMap.get(resource.getId());
        if (string == null) {
            string = "A" + Integer.toString(this.anonCount++);
            this.anonMap.put(resource.getId(), string);
        }
        return string;
    }

    protected String longAnonId(Resource resource) throws RDFException {
        String string = resource.getId().toString();
        if (XMLChar.isValidNmtoken(string)) {
            return string;
        }
        return this.escapedId(string);
    }

    protected String escapedId(String string) {
        String string2 = new String();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            string2 = XMLChar.isName(c) && c != 'X' ? string2 + c : string2 + this.escape(c);
            ++n;
        }
        return string2;
    }

    protected String escape(char n) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        String string = new String() + 'X';
        int n2 = n;
        do {
            string = string + cArray[n2 & 0xF];
        } while ((n2 >>= 4) != 0);
        return new String(string + 'X');
    }

    protected String transNS(Property property) {
        return this.nsPrefix(property.getNameSpace()) + ":" + property.getLocalName();
    }

    protected String nsPrefix(String string) {
        return this.nsMap.getProperty(string);
    }

    public Object setProperty(String string, Object object) throws RDFException {
        if (string.equalsIgnoreCase("xmlbase")) {
            String string2 = this.xmlBase;
            this.xmlBase = (String)object;
            return string2;
        }
        if (string.equalsIgnoreCase("longid")) {
            Boolean bl = new Boolean(this.longId);
            this.longId = (Boolean)object;
            return bl;
        }
        throw new RDFException(22);
    }
}

