/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.common;

import com.hp.hpl.mesa.rdf.jena.common.RDFDefaultErrorHandler;
import com.hp.hpl.mesa.rdf.jena.model.AnonId;
import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.RDFError;
import com.hp.hpl.mesa.rdf.jena.model.RDFErrorHandler;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.RDFWriter;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import com.hp.hpl.mesa.rdf.jena.model.StmtIterator;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class NTripleWriter
implements RDFWriter {
    RDFErrorHandler errorHandler = new RDFDefaultErrorHandler();
    private static boolean[] okURIChars = new boolean[128];

    public void write(Model model, Writer writer, String string) throws RDFException {
        try {
            PrintWriter printWriter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
            StmtIterator stmtIterator = model.listStatements();
            Statement statement = null;
            while (stmtIterator.hasNext()) {
                statement = stmtIterator.next();
                NTripleWriter.writeResource(statement.getSubject(), printWriter);
                printWriter.print(" ");
                NTripleWriter.writeResource(statement.getPredicate(), printWriter);
                printWriter.print(" ");
                NTripleWriter.writeNode(statement.getObject(), printWriter);
                printWriter.println(" .");
            }
            printWriter.flush();
        }
        catch (Exception exception) {
            this.errorHandler.error(exception);
        }
    }

    public Object setProperty(String string, Object object) throws RDFException {
        throw new RDFException(22);
    }

    public void setNsPrefix(String string, String string2) {
    }

    public RDFErrorHandler setErrorHandler(RDFErrorHandler rDFErrorHandler) {
        RDFErrorHandler rDFErrorHandler2 = this.errorHandler;
        this.errorHandler = rDFErrorHandler;
        return rDFErrorHandler2;
    }

    public static void write(Model model, PrintWriter printWriter) throws IOException, RDFException {
        StmtIterator stmtIterator = model.listStatements();
        Statement statement = null;
        while (stmtIterator.hasNext()) {
            statement = stmtIterator.next();
            NTripleWriter.writeResource(statement.getSubject(), printWriter);
            printWriter.print(" ");
            NTripleWriter.writeResource(statement.getPredicate(), printWriter);
            printWriter.print(" ");
            NTripleWriter.writeNode(statement.getObject(), printWriter);
            printWriter.println(" .");
        }
    }

    protected static void writeResource(Resource resource, PrintWriter printWriter) throws RDFException {
        if (resource.isAnon()) {
            printWriter.print(NTripleWriter.anonName(resource.getId()));
        } else {
            printWriter.print("<");
            NTripleWriter.writeURIString(resource.getURI(), printWriter);
            printWriter.print(">");
        }
    }

    private static void writeURIString(String string, PrintWriter printWriter) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c < okURIChars.length && okURIChars[c]) {
                printWriter.print(c);
            } else {
                String string2 = Integer.toHexString(c).toUpperCase();
                int n2 = 4 - string2.length();
                printWriter.print("\\u");
                while (n2 > 0) {
                    printWriter.print("0");
                    --n2;
                }
                printWriter.print(string2);
            }
            ++n;
        }
    }

    private static void writeString(String string, PrintWriter printWriter) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\\' || c == '\"') {
                printWriter.print('\\');
                printWriter.print(c);
            } else if (c == '\n') {
                printWriter.print("\\n");
            } else if (c == '\r') {
                printWriter.print("\\r");
            } else if (c == '\t') {
                printWriter.print("\\t");
            } else if (c >= ' ' && c < '\u007f') {
                printWriter.print(c);
            } else {
                String string2 = Integer.toHexString(c).toUpperCase();
                int n2 = 4 - string2.length();
                printWriter.print("\\u");
                while (n2 > 0) {
                    printWriter.print("0");
                    --n2;
                }
                printWriter.print(string2);
            }
            ++n;
        }
    }

    protected static void writeLiteral(Literal literal, PrintWriter printWriter) {
        String string;
        try {
            string = literal.getString();
        }
        catch (RDFException rDFException) {
            throw new RDFError(rDFException);
        }
        if (literal.getWellFormed()) {
            printWriter.print("xml");
        }
        printWriter.print('\"');
        NTripleWriter.writeString(string, printWriter);
        printWriter.print('\"');
        String string2 = literal.getLanguage();
        if (string2 != null && !string2.equals("")) {
            printWriter.print("-" + string2);
        }
    }

    protected static void writeNode(RDFNode rDFNode, PrintWriter printWriter) throws RDFException {
        if (rDFNode instanceof Literal) {
            NTripleWriter.writeLiteral((Literal)rDFNode, printWriter);
        } else {
            NTripleWriter.writeResource((Resource)rDFNode, printWriter);
        }
    }

    protected static String anonName(AnonId anonId) {
        String string = "_:A";
        String string2 = anonId.toString();
        int n = 0;
        while (n < string2.length()) {
            char c = string2.charAt(n);
            string = c == 'X' ? string + "XX" : (Character.isLetterOrDigit(c) ? string + c : string + "X" + Integer.toHexString(c) + "X");
            ++n;
        }
        return string;
    }

    static {
        int n = 32;
        while (n < 127) {
            NTripleWriter.okURIChars[n] = true;
            ++n;
        }
        NTripleWriter.okURIChars[60] = false;
        NTripleWriter.okURIChars[62] = false;
        NTripleWriter.okURIChars[92] = false;
    }
}

