/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query.test;

import com.hp.hpl.jena.rdf.query.Query;
import com.hp.hpl.jena.rdf.query.QueryEngine;
import com.hp.hpl.jena.rdf.query.QueryResults;
import com.hp.hpl.jena.rdf.query.QueryResultsFormatter;
import com.hp.hpl.jena.rdf.query.ResultBinding;
import com.hp.hpl.mesa.rdf.jena.mem.ModelMem;
import com.hp.hpl.mesa.rdf.jena.model.Bag;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class QueryTestProgrammatic
extends TestSuite {
    static final String testSetName = "RDQL - Query - Programmtic";
    public static boolean dumpModel = false;
    public static boolean verbose = false;

    public static TestSuite suite() {
        return new QueryTestProgrammatic(testSetName);
    }

    private QueryTestProgrammatic(String string) {
        super(string);
        try {
            Model model = QueryTestProgrammatic.makeModel1();
            Model model2 = QueryTestProgrammatic.makeModel2();
            this.addTest((Test)new TestProgrammatic("RDQL-Test-Prog-1", model, "SELECT ?x, ?z WHERE (?x, ?a, ?b), (?b, ?y, ?z)"));
            this.addTest((Test)new TestProgrammatic("RDQL-Test-Prog-2", model, "SELECT ?z WHERE (?x, ?y, ?z) AND ?z == 1"));
            this.addTest((Test)new TestProgrammatic("RDQL-Test-Prog-3", model, "SELECT ?z WHERE (<http://never/r-1>, <http://never/p-0>, ?z)"));
            this.addTest((Test)new TestProgrammatic("RDQL-Test-Prog-4", model2, "SELECT ?x, ?a, ?b, ?y, ?z WHERE (?x, ?a, ?b), (?b, ?y, ?z)"));
            this.addTest((Test)new TestProgrammatic("RDQL-Test-Prog-5", model2, "SELECT ?z WHERE (?x, ?y, ?z) AND ?z == 1"));
            this.addTest((Test)new TestProgrammatic("RDQL-Test-Prog-6", model2, "SELECT ?z WHERE (<http://never/r-1>, <http://never/p-0>, ?z)"));
            ResultBinding resultBinding = new ResultBinding();
            resultBinding.add("x", model.createResource("http://never/r-1"));
            resultBinding.add("y", model.createResource("http://never/p-1"));
            this.addTest((Test)new TestQueryTemplate("RDQL-Test-Template-1", model, null, "SELECT * WHERE (?x, ?y, ?z)", model.size()));
            this.addTest((Test)new TestQueryTemplate("RDQL-Test-Template-2", model, resultBinding, "SELECT * WHERE (?x, ?y, ?z)", 1L));
        }
        catch (Exception exception) {
            System.err.println("Problems making RDQL test");
            exception.printStackTrace(System.err);
            return;
        }
    }

    public static Model makeModel1() throws Exception {
        ModelMem modelMem = new ModelMem();
        int n = 0;
        while (n < 2) {
            int n2 = 0;
            while (n2 < 2) {
                modelMem.add(modelMem.createResource("http://never/r-" + n), modelMem.createProperty("http://never/p-" + n2), n + n2);
                ++n2;
            }
            ++n;
        }
        Bag bag = modelMem.createBag("http://never/bag");
        bag.add("11");
        bag.add("22");
        modelMem.add(modelMem.createResource("http://never/path"), modelMem.createProperty("http://never/path"), modelMem.createResource("http://never/r-0"));
        return modelMem;
    }

    public static Model makeModel2() throws Exception {
        Model model = QueryTestProgrammatic.makeModel1();
        Resource resource = model.createResource();
        Resource resource2 = model.createResource();
        model.add(resource, model.createProperty("http://never/p-anon-1"), "p-anon-1");
        model.add(resource2, model.createProperty("http://never/p-anon-2"), "p-anon-2");
        model.add(resource, model.createProperty("http://never/p-anon-1-2"), resource2);
        return model;
    }

    static class TestQueryTemplate
    extends TestCase {
        Model model;
        String queryString;
        ResultBinding binding;
        long numResults;

        TestQueryTemplate(String string, Model model, ResultBinding resultBinding, String string2, long l) {
            super(string);
            this.model = model;
            this.queryString = string2;
            this.binding = resultBinding;
            this.numResults = l;
        }

        protected void runTest() throws Throwable {
            if (verbose) {
                System.out.println();
                System.out.println("Query:");
                System.out.println(this.queryString);
            }
            Query query = new Query(this.queryString);
            query.setSource(this.model);
            QueryEngine queryEngine = new QueryEngine(query);
            QueryResults queryResults = queryEngine.exec(this.binding);
            long l = 0L;
            while (queryResults.hasNext()) {
                ResultBinding resultBinding = (ResultBinding)queryResults.next();
                if (resultBinding == null) {
                    throw new Exception("TestQueryTemplate: found null result binding");
                }
                ++l;
            }
            queryEngine.close();
            if (l != this.numResults) {
                throw new Exception("TestQueryTemplate: mismatch in counts.  Expected " + this.numResults + ".  Got " + l + "  Query: " + this.queryString);
            }
        }
    }

    static class TestProgrammatic
    extends TestCase {
        Model model;
        String queryString;

        TestProgrammatic(String string, Model model, String string2) {
            super(string);
            this.model = model;
            this.queryString = string2;
        }

        protected void runTest() throws Throwable {
            if (verbose) {
                System.out.println();
                System.out.println("Query:");
                System.out.println(this.queryString);
            }
            Query query = new Query(this.queryString);
            query.setSource(this.model);
            QueryEngine queryEngine = new QueryEngine(query);
            QueryResults queryResults = queryEngine.exec();
            QueryResultsFormatter queryResultsFormatter = new QueryResultsFormatter(queryResults);
            queryResultsFormatter.consume();
        }
    }
}

