/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query;

import com.hp.hpl.jena.rdf.query.Printable;
import com.hp.hpl.jena.rdf.query.QueryPrintUtils;
import com.hp.hpl.jena.rdf.query.Settable;
import com.hp.hpl.jena.rdf.query.ValueException;
import java.io.PrintWriter;

public class WorkingVar
implements Printable,
Settable,
Cloneable {
    boolean isSet = false;
    boolean isInt = false;
    boolean isBoolean = false;
    boolean isDouble = false;
    boolean isURI = false;
    boolean isString = false;
    long valInt;
    boolean valBoolean;
    double valDouble;
    String valString;
    String valURI;

    public WorkingVar() {
        this.unset();
    }

    private void unset() {
        this.isSet = false;
        if (this.isString) {
            this.valString = null;
        }
        if (this.isURI) {
            this.valURI = null;
        }
        this.isInt = false;
        this.isBoolean = false;
        this.isDouble = false;
        this.isURI = false;
        this.isString = false;
    }

    public void setInt(long l) {
        this.unset();
        this.isSet = true;
        this.isInt = true;
        this.valInt = l;
    }

    public void setDouble(double d) {
        this.unset();
        this.isSet = true;
        this.isDouble = true;
        this.valDouble = d;
    }

    public void setBoolean(boolean bl) {
        this.unset();
        this.isSet = true;
        this.isBoolean = true;
        this.valBoolean = bl;
    }

    public void setString(String string) {
        this.unset();
        this.isSet = true;
        this.isString = true;
        this.valString = string;
    }

    public void setURI(String string) {
        this.unset();
        this.isSet = true;
        this.isURI = true;
        this.valURI = string;
    }

    public boolean isNumber() {
        this.forceInt();
        if (!this.isInt) {
            this.forceDouble();
        }
        return this.isSet && (this.isInt || this.isDouble);
    }

    public boolean isInt() {
        this.forceInt();
        return this.isSet && this.isInt;
    }

    public boolean isDouble() {
        this.forceDouble();
        return this.isSet && this.isDouble;
    }

    public boolean isBoolean() {
        return this.isSet && this.isBoolean;
    }

    public boolean isString() {
        return this.isSet && this.isString;
    }

    public boolean isURI() {
        return this.isSet && this.isURI;
    }

    private void forceInt() {
        if (!this.isSet || this.isInt || !this.isString) {
            return;
        }
        try {
            this.valInt = Long.parseLong(this.valString);
            this.isInt = true;
            this.isDouble = true;
            this.valDouble = this.valInt;
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    private void forceDouble() {
        if (!this.isSet || this.isDouble || !this.isString) {
            return;
        }
        try {
            this.valDouble = Double.parseDouble(this.valString);
            this.isDouble = true;
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
    }

    public long getInt() {
        this.forceInt();
        if (!this.isSet || !this.isInt) {
            throw new ValueException("Not an int: " + this);
        }
        return this.valInt;
    }

    public double getDouble() {
        this.forceDouble();
        if (!this.isSet || !this.isDouble) {
            throw new ValueException("Not a long: " + this);
        }
        return this.valDouble;
    }

    public boolean getBoolean() {
        if (!this.isSet || !this.isBoolean) {
            throw new ValueException("Not a boolean: " + this);
        }
        return this.valBoolean;
    }

    public String getString() {
        if (!this.isSet) {
            return "<<unset>>";
        }
        if (this.isInt) {
            return Long.toString(this.valInt);
        }
        if (this.isDouble) {
            return Double.toString(this.valDouble);
        }
        if (this.isURI) {
            return this.valURI;
        }
        if (this.isBoolean) {
            return this.valBoolean ? "true" : "false";
        }
        if (this.isString) {
            return this.valString;
        }
        return "<<unknown>>";
    }

    public String getURI() {
        if (!this.isSet || !this.isURI) {
            throw new ValueException("Not a URI: " + this);
        }
        return this.valURI;
    }

    public String asInfixString() {
        return this.asQuotedString();
    }

    public String asQuotedString() {
        if (!this.isSet) {
            return "<<unset>>";
        }
        if (this.isInt) {
            return Long.toString(this.valInt);
        }
        if (this.isDouble) {
            return Double.toString(this.valDouble);
        }
        if (this.isURI) {
            return "<" + this.valURI + ">";
        }
        if (this.isBoolean) {
            return this.valBoolean ? "true" : "false";
        }
        if (this.isString) {
            return "\"" + this.valString + "\"";
        }
        return "<<unknown>>";
    }

    public String asPrefixString() {
        return this.asStringWithType();
    }

    private String asStringWithType() {
        if (!this.isSet) {
            return "<<unset>>";
        }
        if (this.isInt) {
            return "int:" + Long.toString(this.valInt);
        }
        if (this.isDouble) {
            return "long:" + Double.toString(this.valDouble);
        }
        if (this.isURI) {
            return "URI:" + this.valURI;
        }
        if (this.isBoolean) {
            return "boolean:" + (this.valBoolean ? "true" : "false");
        }
        if (this.isString) {
            return "string:" + this.valString;
        }
        return "<<unknown>>";
    }

    public void print(PrintWriter printWriter, int n) {
        QueryPrintUtils.indent(printWriter, n);
        printWriter.println(this.asPrefixString());
    }

    public String asUnquotedString() {
        return this.getString();
    }

    public String valueString() {
        return this.getString();
    }

    public String toString() {
        return this.getString();
    }
}

