/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query;

import com.hp.hpl.jena.rdf.query.QueryResults;
import com.hp.hpl.jena.rdf.query.QueryResultsMem;
import com.hp.hpl.jena.rdf.query.RDQL_InternalErrorException;
import com.hp.hpl.jena.rdf.query.ResultBinding;
import com.hp.hpl.jena.rdf.query.Value;
import java.io.PrintWriter;
import java.util.Iterator;

public class QueryResultsFormatter {
    QueryResults queryResults;
    QueryResultsMem all = null;
    int numRows = -2;
    int numCols = -2;
    int[] colWidths = null;
    static final String notThere = "<<unset>>";

    public QueryResultsFormatter(QueryResults queryResults) {
        this.queryResults = queryResults;
    }

    public int numColumns() {
        return this.queryResults.getResultVars().size();
    }

    public int numRows() {
        return this.numRows;
    }

    private void colWidths() {
        if (this.all == null) {
            this.all = new QueryResultsMem(this.queryResults);
        }
        this.numCols = this.queryResults.getResultVars().size();
        this.numRows = 0;
        this.colWidths = new int[this.numCols];
        int n = 0;
        while (n < this.numCols) {
            this.colWidths[n] = ((String)this.queryResults.getResultVars().get(n)).length();
            ++n;
        }
        while (this.all.hasNext()) {
            ++this.numRows;
            ResultBinding resultBinding = (ResultBinding)this.all.next();
            int n2 = -1;
            Iterator iterator = this.queryResults.getResultVars().iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = (String)iterator.next();
                Value value = resultBinding.getValue(string2);
                String string3 = string = value == null ? notThere : value.asQuotedString();
                if (this.colWidths[++n2] >= string.length()) continue;
                this.colWidths[n2] = string.length();
            }
        }
        this.all.reset();
    }

    public void close() {
        this.queryResults.close();
        this.queryResults = null;
        this.all = null;
        this.colWidths = null;
    }

    public void dump(PrintWriter printWriter, boolean bl) {
        if (this.queryResults.getResultVars().size() == 0) {
            printWriter.println("# ==== No variables ====");
            printWriter.flush();
            return;
        }
        boolean bl2 = true;
        printWriter.println("# Variables:");
        Iterator iterator = this.queryResults.getResultVars().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            printWriter.print("?" + string + " ");
            bl2 = false;
        }
        printWriter.println(".");
        printWriter.println("# Data:");
        printWriter.flush();
        if (bl) {
            this.dumpAligned(printWriter);
        } else {
            this.dumpRaw(printWriter);
        }
    }

    private void dumpRaw(PrintWriter printWriter) {
        this.numCols = this.queryResults.getResultVars().size();
        QueryResults queryResults = this.queryResults;
        while (queryResults.hasNext()) {
            ResultBinding resultBinding = (ResultBinding)queryResults.next();
            Iterator iterator = this.queryResults.getResultVars().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Value value = resultBinding.getValue(string);
                String string2 = value == null ? notThere : value.asQuotedString();
                printWriter.print("?");
                printWriter.print(string);
                printWriter.print(" ");
                printWriter.print(string2);
                printWriter.print(" ");
            }
            printWriter.println(".");
        }
        this.queryResults.close();
    }

    private void dumpAligned(PrintWriter printWriter) {
        Object object;
        if (this.all == null) {
            this.all = new QueryResultsMem(this.queryResults);
        }
        if (this.colWidths == null) {
            this.colWidths();
        }
        String[] stringArray = new String[this.numCols];
        int n = 0;
        int n2 = 0;
        while (n2 < this.numCols) {
            stringArray[n2] = object = (String)this.queryResults.getResultVars().get(n2);
            n += this.colWidths[n2];
            ++n2;
        }
        object = this.all;
        while (object.hasNext()) {
            ResultBinding resultBinding = (ResultBinding)object.next();
            int n4 = 0;
            while (n4 < this.numCols) {
                StringBuffer stringBuffer = new StringBuffer(120);
                String string = (String)this.queryResults.getResultVars().get(n4);
                stringBuffer.append('?');
                stringBuffer.append(string);
                stringBuffer.append(' ');
                Value value = resultBinding.getValue(string);
                String string2 = value == null ? notThere : value.asQuotedString();
                int n5 = this.colWidths[n4];
                stringBuffer.append(string2);
                int n6 = 0;
                while (n6 < n5 - string2.length()) {
                    stringBuffer.append(' ');
                    ++n6;
                }
                stringBuffer.append(' ');
                printWriter.print(stringBuffer);
                ++n4;
            }
            printWriter.println(" .");
        }
        this.all.close();
        printWriter.flush();
    }

    public void printAll(PrintWriter printWriter) {
        this.printAll(printWriter, " | ", null);
    }

    public void printAll(PrintWriter printWriter, String string) {
        this.printAll(printWriter, string, null);
    }

    public void printAll(PrintWriter printWriter, String string, String string2) {
        if (this.queryResults.getResultVars().size() == 0) {
            printWriter.println("==== No variables ====");
            printWriter.flush();
            return;
        }
        if (this.all == null) {
            this.all = new QueryResultsMem(this.queryResults);
        }
        if (this.colWidths == null) {
            this.colWidths();
        }
        String[] stringArray = new String[this.numCols];
        int n = 0;
        int n2 = 0;
        while (n2 < this.numCols) {
            String string3;
            stringArray[n2] = string3 = (String)this.queryResults.getResultVars().get(n2);
            n += this.colWidths[n2];
            if (n2 > 0) {
                n += string.length();
            }
            ++n2;
        }
        this.printRow(printWriter, stringArray, string, string2);
        int n4 = 0;
        while (n4 < n) {
            printWriter.print('=');
            ++n4;
        }
        printWriter.println();
        QueryResultsMem queryResultsMem = this.all;
        while (queryResultsMem.hasNext()) {
            ResultBinding resultBinding = (ResultBinding)queryResultsMem.next();
            int n5 = 0;
            while (n5 < this.numCols) {
                String string4;
                String string5 = (String)this.queryResults.getResultVars().get(n5);
                Value value = resultBinding.getValue(string5);
                stringArray[n5] = string4 = value == null ? notThere : value.asQuotedString();
                ++n5;
            }
            this.printRow(printWriter, stringArray, string, string2);
        }
        this.all.reset();
        printWriter.flush();
    }

    private void printRow(PrintWriter printWriter, String[] stringArray, String string, String string2) {
        if (stringArray.length != this.numCols) {
            throw new RDQL_InternalErrorException("QueryResultsFormatter.printRow: Row length (" + stringArray.length + ") != numCols (" + this.numCols + ")");
        }
        int n = 0;
        while (n < this.numCols) {
            String string3 = stringArray[n];
            int n2 = this.colWidths[n];
            StringBuffer stringBuffer = new StringBuffer(120);
            if (n > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(string3);
            int n4 = 0;
            while (n4 < n2 - string3.length()) {
                stringBuffer.append(' ');
                ++n4;
            }
            printWriter.print(stringBuffer);
            ++n;
        }
        if (string2 != null) {
            printWriter.print(string2);
        }
        printWriter.println();
    }

    public void printHTML(PrintWriter printWriter) {
        Object object;
        if (this.all == null) {
            this.all = new QueryResultsMem(this.queryResults);
            this.numRows = this.all.size();
        }
        printWriter.println("<table>");
        printWriter.println("  <tr>");
        int n = 0;
        while (n < this.queryResults.getResultVars().size()) {
            object = (String)this.queryResults.getResultVars().get(n);
            printWriter.print("    <th>");
            printWriter.print((String)object);
            printWriter.print("</th>");
            printWriter.println();
            ++n;
        }
        printWriter.println("  </tr>");
        while (this.all.hasNext()) {
            printWriter.println("  <tr>");
            object = (ResultBinding)this.all.next();
            int n2 = 0;
            while (n2 < this.queryResults.getResultVars().size()) {
                String string = (String)this.queryResults.getResultVars().get(n2);
                Value value = ((ResultBinding)object).getValue(string);
                String string2 = value == null ? notThere : value.toString();
                printWriter.print("    <td>");
                printWriter.print(string2);
                printWriter.print("</td>");
                printWriter.println();
                ++n2;
            }
            printWriter.println("  </tr>");
        }
        printWriter.println("</table>");
        printWriter.flush();
        this.all.reset();
    }

    public void consume() {
        QueryResults queryResults = this.queryResults;
        while (queryResults.hasNext()) {
            ResultBinding resultBinding = (ResultBinding)queryResults.next();
            ResultBinding.ResultBindingIterator resultBindingIterator = resultBinding.iterator();
            while (resultBindingIterator.hasNext()) {
                resultBindingIterator.next();
                String string = resultBindingIterator.varName();
                Value value = resultBindingIterator.value();
            }
        }
    }
}

