/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query;

import com.hp.hpl.jena.rdf.query.Constraint;
import com.hp.hpl.jena.rdf.query.QueryEngine;
import com.hp.hpl.jena.rdf.query.QueryException;
import com.hp.hpl.jena.rdf.query.QueryResults;
import com.hp.hpl.jena.rdf.query.TriplePattern;
import com.hp.hpl.jena.rdf.query.parser.Q_Query;
import com.hp.hpl.jena.rdf.query.parser.RDQLParser;
import com.hp.hpl.jena.util.Log;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Query {
    protected List resultVars = new ArrayList();
    protected List triplePatterns = new ArrayList();
    protected List constraints = new ArrayList();
    protected Map prefixMap = new HashMap();
    protected static Map defaultPrefixMap = new HashMap();
    boolean loggingOn = false;
    Log log = Log.getInstance();
    String sourceURL = null;
    Model source = null;
    public long parseTime = -1L;
    public long buildTime = -1L;
    public long loadTime = -1L;
    public long executeTime = -1L;

    public Query(String string) {
        this();
        Q_Query q_Query = null;
        try {
            long l = 0L;
            this.parseTime = 0L;
            long l2 = 0L;
            long l3 = 0L;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            l2 = System.currentTimeMillis();
            RDQLParser rDQLParser = new RDQLParser(byteArrayInputStream);
            rDQLParser.CompilationUnit();
            this.parseTime = System.currentTimeMillis() - l2;
            if (this.loggingOn) {
                Log.info("Query parse time: " + this.parseTime, "Query", null);
            }
            q_Query = (Q_Query)rDQLParser.top();
            q_Query.phase2(this);
            this.buildTime = System.currentTimeMillis() - this.parseTime - l2;
            if (this.loggingOn) {
                Log.info("Query parse and build time: " + this.buildTime, "Query", null);
            }
        }
        catch (Exception exception) {
            throw new QueryException("Parse error: " + exception);
        }
    }

    public Query() {
    }

    public static QueryResults exec(String string) {
        Query query = new Query(string);
        QueryEngine queryEngine = new QueryEngine(query);
        queryEngine.init();
        return queryEngine.exec();
    }

    public static QueryResults exec(String string, Model model) {
        Query query = new Query(string);
        if (model != null) {
            query.setSource(model);
        }
        QueryEngine queryEngine = new QueryEngine(query);
        queryEngine.init();
        return queryEngine.exec();
    }

    public static QueryResults exec(String string, String string2) {
        Query query = new Query(string);
        query.setSourceURL(string2);
        QueryEngine queryEngine = new QueryEngine(query);
        queryEngine.init();
        return queryEngine.exec();
    }

    public void setSource(Model model) {
        this.source = model;
    }

    public Model getSource() {
        return this.source;
    }

    public void setSourceURL(String string) {
        this.sourceURL = string;
    }

    public String getSourceURL() {
        return this.sourceURL;
    }

    public List getResultVars() {
        return this.resultVars;
    }

    public void addResultVar(String string) {
        if (!this.resultVars.contains(string)) {
            this.resultVars.add(string);
        }
    }

    public void addConstraint(Constraint constraint) {
        this.constraints.add(constraint);
    }

    public void addTriplePattern(TriplePattern triplePattern) {
        this.triplePatterns.add(triplePattern);
    }

    public List getTriplePatterns() {
        return this.triplePatterns;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public Log getLog() {
        return this.log;
    }

    public void setLogging(boolean bl) {
        this.loggingOn = bl;
    }

    public boolean getLogging() {
        return this.loggingOn;
    }

    public void setPrefix(String string, String string2) {
        this.prefixMap.put(string, string2);
    }

    public String getPrefix(String string) {
        String string2 = null;
        if (this.prefixMap != null) {
            string2 = (String)this.prefixMap.get(string);
        }
        if (string2 == null) {
            string2 = (String)defaultPrefixMap.get(string);
        }
        return string2;
    }

    public String toString() {
        Object object;
        Object object2;
        boolean bl;
        StringWriter stringWriter = new StringWriter(512);
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.print("SELECT  ");
        if (this.resultVars.size() == 0) {
            printWriter.print("*");
            printWriter.println();
        } else {
            bl = true;
            object2 = this.resultVars.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                if (!bl) {
                    printWriter.print(", ");
                }
                printWriter.print("?");
                printWriter.print((String)object);
                bl = false;
            }
            printWriter.println();
        }
        if (this.triplePatterns.size() > 0) {
            printWriter.print("WHERE   ");
            bl = true;
            object2 = this.triplePatterns.iterator();
            while (object2.hasNext()) {
                object = (TriplePattern)object2.next();
                if (!bl) {
                    printWriter.print(", ");
                }
                printWriter.print(((TriplePattern)object).toString());
                bl = false;
            }
            printWriter.println();
        }
        if (this.constraints.size() > 0) {
            Iterator iterator = this.constraints.iterator();
            while (iterator.hasNext()) {
                object2 = (Constraint)iterator.next();
                printWriter.print("AND     ");
                printWriter.println(object2.toString());
            }
        }
        if (this.prefixMap.size() > 0) {
            printWriter.println("USING");
            Iterator iterator = this.prefixMap.keySet().iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                object = (String)this.prefixMap.get(object2);
                printWriter.println("    " + (String)object2 + " FOR <" + (String)object + ">");
            }
        }
        printWriter.flush();
        printWriter.close();
        return stringWriter.getBuffer().toString();
    }

    static {
        defaultPrefixMap.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        defaultPrefixMap.put("rdfs", "http://www.w3.org/2000/01/rdf-schema#");
    }
}

