/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.StrToken;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

class ARPString
implements ALiteral {
    private String value;
    private String lang;
    private boolean isWellFormedXML;
    private String parseType;

    ARPString(String string, String string2, String string3) {
        this.value = string;
        this.lang = string2;
        this.isWellFormedXML = true;
        this.parseType = string3;
    }

    ARPString(String string, String string2) {
        this.value = string;
        this.lang = string2;
        this.isWellFormedXML = false;
    }

    ARPString(StrToken strToken, String string) {
        this(strToken.value, string);
    }

    ARPString(Vector vector, String string) {
        this.lang = string;
        this.isWellFormedXML = false;
        this.value = "";
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            this.value = this.value + ((StrToken)iterator.next()).value;
        }
    }

    public String toString() {
        return this.value;
    }

    public ARPString concatenate(ARPString aRPString) {
        if (this.lang.equals(aRPString.lang)) {
            return new ARPString(this.value + aRPString.value, this.lang);
        }
        throw new IllegalArgumentException("ARPStrings can only be concatenated if they have the same xml:lang attribute");
    }

    ARPString quickConcatenate(ARPString aRPString) {
        return new ARPString(this.value + aRPString.value, aRPString.lang);
    }

    public boolean isWellFormedXML() {
        return this.isWellFormedXML;
    }

    public String getParseType() {
        return this.parseType;
    }

    public String getLang() {
        return this.lang;
    }
}

