/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.arp;

import com.hp.hpl.jena.rdf.arp.ALiteral;
import com.hp.hpl.jena.rdf.arp.ARPErrorNumbers;
import com.hp.hpl.jena.rdf.arp.ARPQname;
import com.hp.hpl.jena.rdf.arp.AResource;
import com.hp.hpl.jena.rdf.arp.CharacterModel;
import com.hp.hpl.jena.rdf.arp.CoRoutineDeathException;
import com.hp.hpl.jena.rdf.arp.DefaultErrorHandler;
import com.hp.hpl.jena.rdf.arp.Location;
import com.hp.hpl.jena.rdf.arp.ParseException;
import com.hp.hpl.jena.rdf.arp.ParserSupport;
import com.hp.hpl.jena.rdf.arp.RDFParser;
import com.hp.hpl.jena.rdf.arp.RDFParserConstants;
import com.hp.hpl.jena.rdf.arp.StatementHandler;
import com.hp.hpl.jena.rdf.arp.StrToken;
import com.hp.hpl.jena.rdf.arp.Token;
import com.hp.hpl.jena.rdf.arp.TokenPipe;
import com.hp.hpl.jena.rdf.arp.Warn;
import com.hp.hpl.jena.rdf.arp.WrappedException;
import com.hp.hpl.jena.rdf.arp.XMLContext;
import java.io.IOException;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.utils.XMLCharacterProperties;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLFilterImpl;

class ARPFilter
extends XMLFilterImpl
implements RDFParserConstants,
ARPErrorNumbers,
LexicalHandler {
    private Throwable parsersLastException;
    private Map nodeIdUserData;
    private boolean embedding = true;
    StatementHandler statementHandler = new StatementHandler(){

        public void statement(AResource aResource, AResource aResource2, AResource aResource3) {
        }

        public void statement(AResource aResource, AResource aResource2, ALiteral aLiteral) {
        }
    };
    XMLContext documentContext;
    private TokenPipe pipe;
    private Locator locator;
    static final String rdfns;
    static final String xmlns;
    static final Map rdfnames;
    static final Set knownRDFProperties;
    static final Set knownRDFTypes;
    static final Set knownBadRDFNames;
    private static String[] specialAtts;
    private static String[] specialNameSpaces;
    private static int A_XMLSPACE;
    private static int[] specialAttValues;
    private static int[] defaultErrorMode;
    private int[] errorMode = (int[])defaultErrorMode.clone();

    ARPFilter() {
        super(ARPFilter.saxDriver());
        this.setErrorHandler(new DefaultErrorHandler());
    }

    private static XMLReader saxDriver() {
        return new SAXParser();
    }

    boolean setEmbedding(boolean bl) {
        boolean bl2 = this.embedding;
        this.embedding = bl;
        return bl2;
    }

    /*
     * Loose catch block
     */
    public synchronized void parse(InputSource inputSource) throws IOException, SAXException {
        block33: {
            this.getParent().setFeature("http://xml.org/sax/features/namespaces", true);
            this.getParent().setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            this.getParent().setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.nodeIdUserData = new HashMap();
            String string = inputSource.getSystemId();
            if (string == null) {
                this.warning(100, "Base URI not specified for input file; local references will expand incorrectly.");
            } else {
                string = ParserSupport.truncateXMLBase(string);
            }
            this.documentContext = new XMLContext(string, "");
            this.pipe = new TokenPipe(this);
            this.parsersLastException = null;
            final Thread thread = Thread.currentThread();
            final boolean[] blArray = new boolean[1];
            Thread thread2 = new Thread(){

                public void run() {
                    try {
                        RDFParser rDFParser = new RDFParser(ARPFilter.this.pipe, ARPFilter.this);
                        blArray[0] = false;
                        if (ARPFilter.this.embedding) {
                            rDFParser.embeddedFile(ARPFilter.this.documentContext);
                        } else {
                            rDFParser.rdfFile(ARPFilter.this.documentContext);
                        }
                    }
                    catch (WrappedException wrappedException) {
                        thread.interrupt();
                        ARPFilter.this.parsersLastException = wrappedException;
                    }
                    catch (ParseException parseException) {
                        ARPFilter.this.parsersLastException = parseException;
                        thread.interrupt();
                    }
                    catch (CoRoutineDeathException coRoutineDeathException) {
                    }
                    catch (Exception exception) {
                        System.err.println("ARP - Internal Error: " + ParseException.formatMessage(exception));
                        exception.printStackTrace();
                        ARPFilter.this.parsersLastException = exception;
                        blArray[0] = true;
                        try {
                            ARPFilter.this.getErrorHandler().fatalError(new SAXParseException("ARP internal error", null, exception));
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                        thread.interrupt();
                    }
                    catch (Throwable throwable) {
                        ARPFilter.this.parsersLastException = throwable;
                        thread.interrupt();
                    }
                }
            };
            thread2.start();
            super.parse(inputSource);
            this.pipe.putNextToken(new Token(0, null));
            thread2.join();
            Object var13_6 = null;
            thread2.interrupt();
            try {
                if (!blArray[0]) {
                    this.pipe.putNextToken(new Token(0, null));
                }
                thread2.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.locator = null;
            {
                break block33;
                catch (InterruptedException interruptedException) {
                    Object var13_7 = null;
                    thread2.interrupt();
                    try {
                        if (!blArray[0]) {
                            this.pipe.putNextToken(new Token(0, null));
                        }
                        thread2.join();
                    }
                    catch (InterruptedException interruptedException2) {
                        // empty catch block
                    }
                    this.locator = null;
                    break block33;
                }
                catch (CoRoutineDeathException coRoutineDeathException) {
                    Object var13_8 = null;
                    thread2.interrupt();
                    try {
                        if (!blArray[0]) {
                            this.pipe.putNextToken(new Token(0, null));
                        }
                        thread2.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.locator = null;
                    break block33;
                }
                catch (WrappedException wrappedException) {
                    wrappedException.throwMe();
                    Object var13_9 = null;
                    thread2.interrupt();
                    try {
                        if (!blArray[0]) {
                            this.pipe.putNextToken(new Token(0, null));
                        }
                        thread2.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.locator = null;
                    break block33;
                }
                catch (SAXException sAXException) {
                    this.warning(111, "Failed to parse XML.");
                    throw sAXException;
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Throwable throwable) {
                    System.err.println("ARP - Internal Error: " + throwable.getMessage());
                    throwable.printStackTrace();
                    this.parsersLastException = throwable;
                    Object var13_10 = null;
                    thread2.interrupt();
                    try {
                        if (!blArray[0]) {
                            this.pipe.putNextToken(new Token(0, null));
                        }
                        thread2.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.locator = null;
                }
            }
            catch (Throwable throwable) {
                Object var13_11 = null;
                thread2.interrupt();
                try {
                    if (!blArray[0]) {
                        this.pipe.putNextToken(new Token(0, null));
                    }
                    thread2.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.locator = null;
                throw throwable;
            }
        }
        if (this.parsersLastException != null) {
            if (this.parsersLastException instanceof WrappedException) {
                ((WrappedException)this.parsersLastException).throwMe();
            }
            if (this.parsersLastException instanceof RuntimeException) {
                throw (RuntimeException)this.parsersLastException;
            }
            if (this.parsersLastException instanceof Error) {
                throw (Error)this.parsersLastException;
            }
            if (this.parsersLastException instanceof Exception) {
                if (!(this.parsersLastException instanceof SAXException)) {
                    this.parsersLastException = new SAXException((Exception)this.parsersLastException);
                }
                if (this.parsersLastException instanceof SAXParseException) {
                    this.getErrorHandler().fatalError((SAXParseException)this.parsersLastException);
                } else {
                    throw (SAXException)this.parsersLastException;
                }
            }
            return;
        }
    }

    StatementHandler setStatementHandler(StatementHandler statementHandler) {
        StatementHandler statementHandler2 = this.statementHandler;
        this.statementHandler = statementHandler;
        return statementHandler2;
    }

    private void warning(int n, String string) {
        try {
            this.getErrorHandler().warning(new ParseException(n, string));
        }
        catch (SAXException sAXException) {
            throw new WrappedException(sAXException);
        }
    }

    void setDefaultErrorMode() {
        this.errorMode = (int[])defaultErrorMode.clone();
    }

    void setLaxErrorMode() {
        this.setDefaultErrorMode();
        int n = 100;
        while (n < 200) {
            this.setErrorMode(n, 0);
            ++n;
        }
        this.setErrorMode(112, 1);
    }

    void setStrictErrorMode() {
        this.setStrictErrorMode(0);
    }

    void setStrictErrorMode(int n) {
        this.setDefaultErrorMode();
        int n2 = 1;
        while (n2 < 100) {
            this.setErrorMode(n2, n);
            ++n2;
        }
        int n4 = 100;
        while (n4 < 200) {
            this.setErrorMode(n4, 2);
            ++n4;
        }
        int n5 = 1;
        int n6 = 2;
        switch (n) {
            case 2: {
                n5 = 2;
                break;
            }
            case 3: {
                n6 = 3;
                n5 = 3;
            }
        }
        this.setErrorMode(112, n5);
        this.setErrorMode(112, n5);
        this.setErrorMode(117, n5);
        this.setErrorMode(106, n5);
        this.setErrorMode(111, n);
        this.setErrorMode(119, n);
        this.setErrorMode(120, n);
        this.setErrorMode(114, n);
        this.setErrorMode(113, n5);
        this.setErrorMode(103, n5);
        this.setErrorMode(118, n);
        this.setErrorMode(122, n5);
        this.setErrorMode(111, n6);
    }

    int setErrorMode(int n, int n2) {
        int n4 = this.errorMode[n];
        block0 : switch (n2) {
            case 0: 
            case 1: {
                if (n >= 200 && n != 202) break;
            }
            case 2: 
            case 3: {
                switch (n) {
                    case 300: {
                        break block0;
                    }
                }
                this.errorMode[n] = n2;
            }
        }
        return n4;
    }

    void parseWarning(int n, Location location, String string) throws ParseException {
        int n2 = this.errorMode[n];
        if (n2 == 0) {
            return;
        }
        ParseException parseException = new ParseException(n, location, string);
        if (n2 == 3) {
            parseException.setFatal(true);
            n2 = 2;
        }
        if (n2 == 2) {
            throw parseException;
        }
        try {
            this.getErrorHandler().warning(parseException);
            return;
        }
        catch (ParseException parseException2) {
            if (parseException2 == parseException) {
                throw parseException2;
            }
            throw new WrappedException(parseException);
        }
        catch (SAXException sAXException) {
            throw new WrappedException(sAXException);
        }
    }

    void parseWarning(Warn warn) throws ParseException {
        this.parseWarning(warn.number, warn.location, warn.msg);
    }

    private void putWarning(int n, Location location, String string) {
        this.pipe.putNextToken(new Warn(n, location, string));
    }

    void setUserData(String string, Object object) {
        this.nodeIdUserData.put(string, object);
    }

    Object getUserData(String string) {
        return this.nodeIdUserData.get(string);
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        super.setDocumentLocator(locator);
    }

    private void doSpecialAtt(int n, int n2, String string, BitSet bitSet, Attributes attributes, Location location) throws SAXException {
        bitSet.set(n);
        if (n2 == A_XMLSPACE) {
            return;
        }
        this.pipe.putNextToken(new ARPQname(n2, location, string, null, attributes.getQName(n)));
        String string2 = attributes.getValue(n);
        if (n2 == 18) {
            if (string2.equals("Resource")) {
                this.pipe.putNextToken(new StrToken(22, location, string2));
            } else if (string2.equals("Collection")) {
                this.pipe.putNextToken(new StrToken(21, location, string2));
            } else if (string2.equals("daml:collection") && this.errorMode[125] != 2) {
                this.pipe.putNextToken(new StrToken(20, location, string2));
            } else {
                this.pipe.putNextToken(new StrToken(19, location, string2));
                if (!string2.equals("Literal")) {
                    this.putWarning(106, location, "Unknown parseType: " + string2);
                }
            }
        } else {
            this.pipe.putNextToken(new StrToken(10, location, string2));
        }
        if (n2 == 23) {
            this.putWarning(199, location, "RDF datatyping not supported in Jena1, Literal treated as untyped.");
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Location location = new Location(this.locator);
        this.putElementQname(string, string2, string3, location);
        BitSet bitSet = new BitSet();
        int n = 0;
        while (n < attributes.getLength()) {
            block12: {
                String string4;
                block13: {
                    String string5 = attributes.getQName(n);
                    if (!string5.startsWith("xmlns")) break block12;
                    string4 = "";
                    if (string5.equals("xmlns")) break block13;
                    if (string5.charAt(5) != ':') break block12;
                    string4 = attributes.getLocalName(n);
                }
                bitSet.set(n);
                this.pipe.putNextToken(new StrToken(25, location, string4));
                this.pipe.putNextToken(new StrToken(10, location, attributes.getValue(n)));
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < specialAtts.length) {
            int n4 = attributes.getIndex(specialNameSpaces[n2], specialAtts[n2]);
            if (n4 != -1) {
                this.doSpecialAtt(n4, specialAttValues[n2], specialNameSpaces[n2], bitSet, attributes, location);
            }
            if (specialNameSpaces[n2] == rdfns && (n4 = attributes.getIndex("", specialAtts[n2])) != -1) {
                this.putWarning(101, location, "Unqualified use of rdf:" + attributes.getLocalName(n4) + " has been deprecated.");
                this.doSpecialAtt(n4, specialAttValues[n2], "", bitSet, attributes, location);
            }
            ++n2;
        }
        int n5 = 0;
        while (n5 < attributes.getLength()) {
            if (!bitSet.get(n5)) {
                String string6 = attributes.getURI(n5);
                String string7 = attributes.getQName(n5);
                if (string7.length() >= 3 && string7.substring(0, 3).toLowerCase().equals("xml")) {
                    this.putWarning(118, location, "XML attribute: " + attributes.getQName(n5) + " is not known and is being discarded.");
                } else {
                    if (string6.equals("")) {
                        this.putWarning(102, location, "Attribute: " + attributes.getLocalName(n5) + ". Unqualified use is deprecated. Assuming namespace: " + string);
                        string6 = string;
                    }
                    this.putAttributeQname(string6, attributes.getLocalName(n5), string7, location);
                    this.pipe.putNextToken(new StrToken(10, location, attributes.getValue(n5)));
                }
            }
            ++n5;
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        Location location = new Location(this.locator);
        this.pipe.putNextToken(new Token(5, location));
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        Location location = new Location(this.locator);
        this.pipe.putNextToken(new StrToken(1, location, new String(cArray, n, n2)));
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    private boolean isMemberProperty(String string) {
        if (string.startsWith("_")) {
            String string2 = string.substring(1);
            if (string2.startsWith("-") || string2.startsWith("0")) {
                return false;
            }
            try {
                Integer.parseInt(string2);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    new BigInteger(string2);
                    return true;
                }
                catch (NumberFormatException numberFormatException2) {
                    return false;
                }
            }
        }
        return false;
    }

    private boolean isKnownRDFProperty(String string) {
        return knownRDFProperties.contains(string);
    }

    private void putElementQname(String string, String string2, String string3, Location location) throws SAXException {
        Warn warn = null;
        if (string.equals(rdfns)) {
            Integer n = (Integer)rdfnames.get(string2);
            if (n == null) {
                if (this.isMemberProperty(string2)) {
                    this.pipe.putNextToken(new ARPQname(17, location, string, string2, string3));
                    return;
                }
                if (!knownRDFTypes.contains(string2) && !this.isKnownRDFProperty(string2)) {
                    warn = knownBadRDFNames.contains(string2) ? new Warn(205, location, "Creating statement(s) for syntactic RDF element: '<rdf:" + string2 + "'.") : new Warn(113, location, "Creating statement(s) for unknown RDF element: '<rdf:" + string2 + "'.");
                }
            } else {
                this.pipe.putNextToken(new ARPQname(n, location, string, string2, string3));
                return;
            }
        }
        this.pipe.putNextToken(new ARPQname(15, location, string, string2, string3));
        if (warn != null) {
            this.pipe.putNextToken(warn);
        }
    }

    private void putAttributeQname(String string, String string2, String string3, Location location) throws SAXException {
        if (string.equals(rdfns)) {
            if (this.isMemberProperty(string2)) {
                this.pipe.putNextToken(new ARPQname(13, location, string, string2, string3));
                return;
            }
            if (!this.isKnownRDFProperty(string2)) {
                if (knownBadRDFNames.contains(string2)) {
                    this.putWarning(206, location, "Creating statement for inappropriate RDF property: 'rdf:" + string2 + "'.");
                } else {
                    this.putWarning(103, location, "Creating statement for unknown RDF property: 'rdf:" + string2 + "'.");
                }
            }
        }
        this.pipe.putNextToken(new ARPQname(12, location, string, string2, string3));
    }

    public void endEntity(String string) {
    }

    public void endDTD() {
    }

    public void startDTD(String string, String string2, String string3) {
    }

    public void endCDATA() {
    }

    public void startCDATA() {
    }

    public void comment(char[] cArray, int n, int n2) {
        Location location = new Location(this.locator);
        this.pipe.putNextToken(new StrToken(2, location, new String(cArray, n, n2)));
    }

    public void startEntity(String string) {
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        Location location = new Location(this.locator);
        this.pipe.putNextToken(new StrToken(3, location, string2 == null ? string : string + " " + string2));
    }

    static {
        XMLCharacterProperties.initCharFlags();
        CharacterModel.isFullyNormalizedConstruct("make the linkage error happen early");
        rdfns = "http://www.w3.org/1999/02/22-rdf-syntax-ns#".intern();
        xmlns = "http://www.w3.org/XML/1998/namespace".intern();
        rdfnames = new HashMap();
        rdfnames.put("Description", new Integer(6));
        rdfnames.put("RDF", new Integer(4));
        rdfnames.put("li", new Integer(16));
        knownRDFProperties = new HashSet();
        knownRDFTypes = knownRDFProperties;
        knownRDFTypes.add("Bag");
        knownRDFTypes.add("Seq");
        knownRDFTypes.add("Alt");
        knownRDFTypes.add("Property");
        knownRDFProperties.add("type");
        knownRDFTypes.add("Statement");
        knownRDFProperties.add("subject");
        knownRDFProperties.add("predicate");
        knownRDFProperties.add("object");
        knownRDFProperties.add("value");
        knownBadRDFNames = new HashSet();
        knownBadRDFNames.add("ID");
        knownBadRDFNames.add("about");
        knownBadRDFNames.add("aboutEach");
        knownBadRDFNames.add("aboutEachPrefix");
        knownBadRDFNames.add("resource");
        knownBadRDFNames.add("bagID");
        knownBadRDFNames.add("parseType");
        knownBadRDFNames.add("li");
        knownBadRDFNames.add("type");
        knownBadRDFNames.add("Description");
        knownBadRDFNames.add("nodeID");
        specialAtts = new String[]{"base", "lang", "space", "ID", "about", "nodeID", "resource", "bagID", "datatype", "parseType", "type"};
        specialNameSpaces = new String[]{xmlns, xmlns, xmlns, rdfns, rdfns, rdfns, rdfns, rdfns, rdfns, rdfns, rdfns};
        A_XMLSPACE = -1;
        specialAttValues = new int[]{26, 27, A_XMLSPACE, 7, 8, 9, 24, 11, 23, 18, 14};
        defaultErrorMode = new int[400];
        int n = 0;
        while (n < defaultErrorMode.length) {
            ARPFilter.defaultErrorMode[n] = n / 100;
            ++n;
        }
    }
}

