/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3.test;

import com.hp.hpl.jena.n3.N3JenaWriter;
import com.hp.hpl.jena.n3.test.N3ExternalTestsCom;
import com.hp.hpl.mesa.rdf.jena.common.ModelMatcher;
import com.hp.hpl.mesa.rdf.jena.mem.ModelMem;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class N3JenaWriterTests
extends N3ExternalTestsCom {
    static final String uriBase = "http://host/base/";

    public static TestSuite suite() {
        return new N3JenaWriterTests();
    }

    public N3JenaWriterTests() {
        this("n3-writer-tests");
    }

    public N3JenaWriterTests(String string) {
        super("N3 Jena Writer tests", string);
    }

    protected void makeTest(String string, String string2) {
        String string3 = string;
        if (this.basedir != null) {
            string = this.basedir + "/" + string;
        }
        if (this.basedir != null && string2 != null && !string2.equals("")) {
            string2 = this.basedir + "/" + string2;
        }
        this.addTest((junit.framework.Test)new Test(string3, string, string2));
    }

    static class Test
    extends TestCase {
        String testName = null;
        String basename = null;
        String inputFile = null;
        String resultsFile = null;
        Reader data = null;

        Test(String string, String string2, String string3) {
            super("N3 Jena Writer test: " + string);
            this.testName = string;
            this.inputFile = string2;
            this.resultsFile = string3;
        }

        protected void runTest() throws Throwable {
            try {
                this.data = N3ExternalTestsCom.makeReader(new FileInputStream(this.inputFile));
            }
            catch (IOException iOException) {
                Assert.fail((String)("File does not exist: " + this.inputFile));
                return;
            }
            ModelMem modelMem = new ModelMem();
            modelMem.read(this.data, N3JenaWriterTests.uriBase, "N3");
            StringWriter stringWriter = new StringWriter();
            N3JenaWriter n3JenaWriter = new N3JenaWriter();
            n3JenaWriter.write((Model)modelMem, stringWriter, N3JenaWriterTests.uriBase);
            stringWriter.close();
            StringReader stringReader = new StringReader(stringWriter.toString());
            ModelMem modelMem2 = new ModelMem();
            modelMem2.read(stringReader, N3JenaWriterTests.uriBase, "N3");
            if (!ModelMatcher.equals(modelMem, modelMem2)) {
                Assert.fail((String)("Models don't match: " + this.testName));
            }
        }
    }
}

