/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.n3;

import antlr.collections.AST;
import com.hp.hpl.jena.n3.AntlrUtils;
import com.hp.hpl.jena.n3.N3EventPrinter;
import com.hp.hpl.jena.n3.N3Parser;
import com.hp.hpl.jena.n3.N3ParserEventHandler;
import com.hp.hpl.jena.vocabulary.DAMLVocabulary;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import java.util.HashMap;
import java.util.Map;

public class N3toRDF
implements N3ParserEventHandler {
    public static boolean VERBOSE = false;
    Model model;
    Map prefixMap = new HashMap();
    Map resourceRef = new HashMap();
    Map propertyRef = new HashMap();
    String NS_rdf = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    String NS_rdfs = "http://www.w3.org/2000/01/rdf-schema#";
    String NS_DAML = "http://www.daml.org/2001/03/daml+oil#";
    DAMLVocabulary damlVocab = DAML_OIL.getInstance();
    String NS_W3_log = "http://www.w3.org/2000/10/swap/log#";
    String base = null;
    final String anonPrefix = "_";
    private Map bNodeMap = new HashMap();

    public N3toRDF(Model model, String string) {
        this.model = model;
        this.base = string;
        if (VERBOSE) {
            System.out.println("N3toRDF: " + this.base);
        }
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void error(Exception exception, String string) {
        throw new RuntimeException(string);
    }

    public void error(String string) {
        this.error(null, string);
    }

    public void warning(Exception exception, String string) {
        throw new RuntimeException(string);
    }

    public void warning(String string) {
        this.warning(null, string);
    }

    public void deprecated(Exception exception, String string) {
        throw new RuntimeException(string);
    }

    public void deprecated(String string) {
        this.deprecated(null, string);
    }

    public void startFormula(int n, String string) {
        this.error("Line " + n + ": N3toRDF: All statement are asserted - no formulae");
    }

    public void endFormula(int n, String string) {
    }

    public void directive(int n, AST aST, AST[] aSTArray, String string) {
        if (aST.getType() == 17) {
            if (aSTArray[0].getType() != 6) {
                this.error("Line " + n + ": N3toRDF: Prefix directive does not start with a prefix! " + aSTArray[0].getText() + "[" + N3Parser.getTokenNames()[aSTArray[0].getType()] + "]");
                return;
            }
            String string2 = aSTArray[0].getText();
            if (string2.endsWith(":")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (aSTArray[1].getType() != 34) {
                this.error("Line " + n + ": N3toRDF: Prefix directive does not supply a URIref! " + aSTArray[1].getText());
                return;
            }
            String string3 = aSTArray[1].getText();
            if (string3.equals("")) {
                string3 = this.base;
            }
            if (string3.equals("#")) {
                string3 = this.base + "#";
            }
            if (VERBOSE) {
                System.out.println(string2 + " => " + string3);
            }
            this.prefixMap.put(string2, string3);
            return;
        }
        this.warning("Line " + n + ": N3toRDF: Directive not recongized and ignored: " + aST.getText());
    }

    public void quad(int n, AST aST, AST aST2, AST aST3, String string) {
        if (string != null) {
            this.error("Line " + n + ": N3toRDF: All statement are asserted - no formulae");
        }
        try {
            Object object;
            int n2 = aST2.getType();
            String string2 = aST2.getText();
            switch (n2) {
                case 23: {
                    string2 = this.NS_W3_log + "implies";
                    break;
                }
                case 42: {
                    string2 = this.NS_W3_log + "means";
                    break;
                }
                case 24: {
                    string2 = this.NS_W3_log + "implies";
                    AST aST4 = aST3;
                    aST3 = aST;
                    aST = aST4;
                    break;
                }
                case 22: {
                    string2 = this.damlVocab.equivalentTo().getURI();
                    break;
                }
                case 12: {
                    string2 = this.NS_rdf + "type";
                    break;
                }
                case 6: 
                case 15: 
                case 34: {
                    break;
                }
                default: {
                    this.error("Line " + n + ": N3toRDF: Shouldn't see " + N3EventPrinter.formatSlot(aST2) + " at this point!");
                }
            }
            Property property = null;
            if (n2 == 6) {
                object = new ExpandedQName(n, string2);
                property = this.model.createProperty(((ExpandedQName)object).firstPart, ((ExpandedQName)object).secondPart);
            } else {
                if (string2.equals("")) {
                    string2 = this.base;
                }
                property = this.model.createProperty(string2);
            }
            object = this.createNode(n, aST);
            if (object instanceof Literal) {
                this.error("Line " + n + ": N3toRDF: Subject can't be a literal");
            }
            RDFNode rDFNode = this.createNode(n, aST3);
            Statement statement = this.model.createStatement((Resource)object, property, rDFNode);
            if (VERBOSE) {
                System.out.println("Statement: " + statement);
            }
            this.model.add(statement);
        }
        catch (RDFException rDFException) {
            this.error("Line " + n + ": RDFException: " + rDFException);
        }
    }

    private RDFNode createNode(int n, AST aST) throws RDFException {
        String string = aST.getText();
        switch (aST.getType()) {
            case 15: {
                AST aST2 = aST.getFirstChild();
                return this.model.createLiteral(string);
            }
            case 6: {
                if (string.startsWith("_:") && !this.prefixMap.containsKey("_")) {
                    if (!this.bNodeMap.containsKey(string)) {
                        this.bNodeMap.put(string, this.model.createResource());
                    }
                    return (Resource)this.bNodeMap.get(string);
                }
                ExpandedQName expandedQName = new ExpandedQName(n, string);
                string = expandedQName.expansion;
            }
            case 34: {
                if (string.equals("")) {
                    return this.model.createResource(this.base);
                }
                if (string.equals("#")) {
                    return this.model.createResource(this.base + "#");
                }
                return this.model.createResource(string);
            }
            case 4: {
                if (!this.bNodeMap.containsKey(string)) {
                    this.bNodeMap.put(string, this.model.createResource());
                }
                return (Resource)this.bNodeMap.get(string);
            }
        }
        this.error("Line " + n + ": N3toRDF: Can't map to a resource or literal: " + AntlrUtils.ast(aST));
        return null;
    }

    class ExpandedQName {
        public String qname;
        public String firstPart;
        public String secondPart;
        public String expansion;

        ExpandedQName(int n, String string) {
            this.qname = string;
            int n2 = this.qname.indexOf(58);
            String string2 = this.qname.substring(0, n2);
            if (!N3toRDF.this.prefixMap.containsKey(string2)) {
                N3toRDF.this.error("Line " + n + ": N3toRDF: Undefined qname: " + this.qname);
            }
            this.secondPart = this.qname.substring(n2 + 1);
            this.firstPart = (String)N3toRDF.this.prefixMap.get(string2);
            this.expansion = this.firstPart + this.secondPart;
        }
    }
}

