/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.daml.common;

import com.hp.hpl.jena.daml.DAMLCommon;
import com.hp.hpl.jena.daml.DAMLList;
import com.hp.hpl.jena.daml.DAMLModel;
import com.hp.hpl.jena.daml.common.DAMLCommonImpl;
import com.hp.hpl.jena.util.Log;
import com.hp.hpl.jena.vocabulary.DAMLVocabulary;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import java.util.Iterator;

public class DAMLListImpl
extends DAMLCommonImpl
implements DAMLList {
    public DAMLListImpl(String string, DAMLModel dAMLModel, DAMLVocabulary dAMLVocabulary) {
        super(string, dAMLModel, dAMLVocabulary);
        this.setRDFType(this.getVocabulary().List());
    }

    public DAMLListImpl(String string, String string2, DAMLModel dAMLModel, DAMLVocabulary dAMLVocabulary) {
        super(string, string2, dAMLModel, dAMLVocabulary);
        this.setRDFType(this.getVocabulary().List());
    }

    public void add(DAMLCommon dAMLCommon) {
        if (this.isEmpty()) {
            this.setFirst(dAMLCommon);
            this.setRestNil();
        } else {
            DAMLList dAMLList = this.findLast();
            DAMLList dAMLList2 = (DAMLList)this.getDAMLModel().createDAMLValue(null, this.getVocabulary().List(), this.getVocabulary());
            dAMLList2.setFirst(dAMLCommon);
            dAMLList2.setRestNil();
            dAMLList.setRest(dAMLList2);
        }
    }

    public void remove(DAMLCommon dAMLCommon) {
        DAMLListImpl dAMLListImpl = null;
        DAMLList dAMLList = this;
        while (!dAMLList.isEmpty() && !dAMLList.getFirst().equals(dAMLCommon)) {
            dAMLListImpl = dAMLList;
            dAMLList = dAMLList.getRest();
        }
        if (!dAMLList.isEmpty()) {
            if (dAMLListImpl == null) {
                DAMLList dAMLList2 = this.getRest();
                if (dAMLList2.isEmpty()) {
                    this.removeAll(this.getVocabulary().first());
                    this.removeAll(this.getVocabulary().rest());
                } else {
                    this.replaceProperty(this.getVocabulary().first(), dAMLList2.getFirst());
                    this.replaceProperty(this.getVocabulary().rest(), dAMLList2.getRest());
                    dAMLList2.remove();
                }
            } else {
                dAMLListImpl.setRest(dAMLList.getRest());
                dAMLList.remove();
            }
        }
    }

    public Iterator getAll() {
        return new DAMLListIterator(this);
    }

    public DAMLCommon getFirst() {
        return (DAMLCommon)this.getFirstResource();
    }

    public DAMLList getRest() {
        Resource resource = this.getRestResource();
        if (this.isNil(resource)) {
            return this.getVocabulary().nil();
        }
        if (resource instanceof DAMLList) {
            return (DAMLList)resource;
        }
        Log.severe("Badly formed list: rest of list should be type List, found " + resource);
        return null;
    }

    public int getCount() {
        int n = 0;
        Iterator iterator = this.getAll();
        while (iterator.hasNext()) {
            ++n;
            iterator.next();
        }
        return n;
    }

    public boolean isEmpty() {
        try {
            return this.equals(this.getNil()) || !this.hasProperty(this.getVocabulary().first()) && !this.hasProperty(this.getVocabulary().rest());
        }
        catch (RDFException rDFException) {
            Log.severe("RDF exception " + rDFException, rDFException);
            throw new RuntimeException("RDF Exception " + rDFException);
        }
    }

    public void setFirst(DAMLCommon dAMLCommon) {
        this.setPropertyValue(this.getVocabulary().first(), dAMLCommon);
    }

    public void setRest(DAMLList dAMLList) {
        this.setPropertyValue(this.getVocabulary().rest(), dAMLList);
    }

    public void setRestNil() {
        this.setRest(this.getVocabulary().nil());
    }

    public DAMLList cons(DAMLCommon dAMLCommon) {
        DAMLListImpl dAMLListImpl = new DAMLListImpl(null, this.getDAMLModel(), this.getVocabulary());
        dAMLListImpl.setFirst(dAMLCommon);
        dAMLListImpl.setRest(this);
        return dAMLListImpl;
    }

    public DAMLList getNil() {
        return this.getVocabulary().nil();
    }

    public boolean isNil(Resource resource) {
        return resource.equals(this.getVocabulary().nil());
    }

    public DAMLList findLast() {
        if (this.getRestResource().equals(this.getNil())) {
            return this;
        }
        return this.getRest().findLast();
    }

    public DAMLCommon getItem(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Element " + n + " of a list is not defined");
        }
        int n2 = n;
        DAMLList dAMLList = this;
        while (!dAMLList.isEmpty()) {
            if (n2 == 1) {
                return dAMLList.getFirst();
            }
            dAMLList = dAMLList.getRest();
            --n2;
        }
        throw new IllegalArgumentException("Tried to getItem( " + n + " ) of a list without that many elements");
    }

    protected Resource getRestResource() {
        try {
            return (Resource)this.getPropertyValue(this.getVocabulary().rest());
        }
        catch (RuntimeException runtimeException) {
            Log.debug("rdf error: " + runtimeException, runtimeException);
            throw runtimeException;
        }
    }

    protected Resource getFirstResource() {
        return (Resource)this.getPropertyValue(this.getVocabulary().first());
    }

    Object getKey() {
        return DAML_OIL.List.getURI();
    }

    protected class DAMLListIterator
    implements Iterator {
        private DAMLList m_list = null;

        public DAMLListIterator(DAMLList dAMLList) {
            this.m_list = dAMLList;
        }

        public boolean hasNext() {
            return this.m_list != null && !this.m_list.isEmpty();
        }

        public Object next() {
            Resource resource = ((DAMLListImpl)this.m_list).getFirstResource();
            this.m_list = this.m_list.getRest();
            return resource;
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove operation not supported on DAML lists");
        }
    }
}

