/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.daml.common;

import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.DAML_OIL_2000_12;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDF;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDFS;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;

public class DAMLHierarchy {
    private static DAMLHierarchy s_instance = new DAMLHierarchy();
    public Resource[][] DAML_STANDARD_CLASS_HIERARCHY = new Resource[][]{{DAML_OIL.Class, RDFS.Class}, {DAML_OIL.Datatype, RDFS.Class}, {DAML_OIL.Restriction, DAML_OIL.Class}, {DAML_OIL.ObjectProperty, RDF.Property}, {DAML_OIL.DatatypeProperty, RDF.Property}, {DAML_OIL.TransitiveProperty, DAML_OIL.ObjectProperty}, {DAML_OIL.UnambiguousProperty, DAML_OIL.ObjectProperty}, {DAML_OIL.UniqueProperty, RDF.Property}, {DAML_OIL.List, RDF.Seq}, {DAML_OIL_2000_12.Disjoint, DAML_OIL_2000_12.List}, {DAML_OIL_2000_12.TransitiveProperty, RDF.Property}, {DAML_OIL_2000_12.UniqueProperty, RDF.Property}, {DAML_OIL_2000_12.UnambiguousProperty, RDF.Property}, {DAML_OIL_2000_12.List, RDF.Seq}};
    public Resource[][] DAML_STANDARD_EQUIVALENCES = new Resource[][]{{DAML_OIL.subClassOf, RDFS.subClassOf}, {DAML_OIL.Literal, RDFS.Literal}, {DAML_OIL.Property, RDF.Property}, {DAML_OIL.type, RDF.type}, {DAML_OIL.value, RDF.value}, {DAML_OIL.subPropertyOf, RDFS.subPropertyOf}, {DAML_OIL.domain, RDFS.domain}, {DAML_OIL.range, RDFS.range}, {DAML_OIL.label, RDFS.label}, {DAML_OIL.comment, RDFS.comment}, {DAML_OIL.seeAlso, RDFS.seeAlso}, {DAML_OIL.isDefinedBy, RDFS.isDefinedBy}, {DAML_OIL_2000_12.subPropertyOf, RDFS.subPropertyOf}, {DAML_OIL_2000_12.Class, RDFS.Class}, {DAML_OIL_2000_12.Literal, RDFS.Literal}, {DAML_OIL_2000_12.Property, RDF.Property}, {DAML_OIL_2000_12.type, RDF.type}, {DAML_OIL_2000_12.value, RDF.value}, {DAML_OIL_2000_12.subClassOf, RDFS.subClassOf}, {DAML_OIL_2000_12.domain, RDFS.domain}, {DAML_OIL_2000_12.range, RDFS.range}, {DAML_OIL_2000_12.label, RDFS.label}, {DAML_OIL_2000_12.comment, RDFS.comment}, {DAML_OIL_2000_12.seeAlso, RDFS.seeAlso}, {DAML_OIL_2000_12.isDefinedBy, RDFS.isDefinedBy}};
    public Property[] TRANSITIVE_PROPERTIES = new Property[]{DAML_OIL.subClassOf, DAML_OIL.subPropertyOf, DAML_OIL.sameClassAs, DAML_OIL.sameIndividualAs, DAML_OIL.samePropertyAs, DAML_OIL.equivalentTo, DAML_OIL_2000_12.subClassOf, DAML_OIL_2000_12.subPropertyOf, DAML_OIL_2000_12.sameClassAs, DAML_OIL_2000_12.sameIndividualAs, DAML_OIL_2000_12.samePropertyAs, DAML_OIL_2000_12.equivalentTo, RDFS.subClassOf, RDFS.subPropertyOf};
    protected Hashtable m_classHierarchyMap = new Hashtable();
    protected boolean m_initialised = false;
    protected Hashtable m_equivalenceMap = new Hashtable();
    protected Hashtable m_transitiveProperties = new Hashtable();

    private DAMLHierarchy() {
    }

    public static DAMLHierarchy getInstance() {
        return s_instance;
    }

    public boolean isDAMLSubClassOf(String string, String string2) {
        if (string == null || string2 == null || string.length() == 0 || string2.length() == 0) {
            return false;
        }
        this.initialiseMaps();
        String string3 = (String)this.m_classHierarchyMap.get(string);
        if (string2.equals(string3)) {
            return true;
        }
        return string3 == null ? false : this.isDAMLSubClassOf(string3, string2);
    }

    public boolean isTransitiveProperty(Resource resource) {
        return resource instanceof Property && this.m_transitiveProperties.containsKey(resource);
    }

    public Iterator getEquivalentValues(Resource resource) {
        this.initialiseMaps();
        LinkedList linkedList = (LinkedList)this.m_equivalenceMap.get(resource);
        return linkedList == null ? new LinkedList().iterator() : linkedList.iterator();
    }

    private void initialiseMaps() {
        if (!this.m_initialised) {
            LinkedList linkedList;
            int n = 0;
            while (n < this.DAML_STANDARD_CLASS_HIERARCHY.length) {
                String string = this.DAML_STANDARD_CLASS_HIERARCHY[n][0].getURI();
                linkedList = this.DAML_STANDARD_CLASS_HIERARCHY[n][1].getURI();
                this.m_classHierarchyMap.put(string, linkedList);
                ++n;
            }
            int n2 = 0;
            while (n2 < this.DAML_STANDARD_EQUIVALENCES.length) {
                linkedList = (LinkedList)this.m_equivalenceMap.get(this.DAML_STANDARD_EQUIVALENCES[n2][0]);
                if (linkedList == null) {
                    linkedList = new LinkedList();
                    this.m_equivalenceMap.put(this.DAML_STANDARD_EQUIVALENCES[n2][0], linkedList);
                }
                linkedList.add(this.DAML_STANDARD_EQUIVALENCES[n2][1]);
                linkedList = (LinkedList)this.m_equivalenceMap.get(this.DAML_STANDARD_EQUIVALENCES[n2][1]);
                if (linkedList == null) {
                    linkedList = new LinkedList();
                    this.m_equivalenceMap.put(this.DAML_STANDARD_EQUIVALENCES[n2][1], linkedList);
                }
                linkedList.add(this.DAML_STANDARD_EQUIVALENCES[n2][0]);
                ++n2;
            }
            int n4 = 0;
            while (n4 < this.TRANSITIVE_PROPERTIES.length) {
                this.m_transitiveProperties.put(this.TRANSITIVE_PROPERTIES[n4], Boolean.TRUE);
                ++n4;
            }
            this.m_initialised = true;
        }
    }
}

