/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.swing.JOptionPane;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.IsaViz.ConfigManager;
import org.w3c.IsaViz.Editor;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

class XMLManager {
    Editor application;
    DOMParser parser;

    XMLManager(Editor editor) {
        this.application = editor;
    }

    Document parse(String string, boolean bl) {
        try {
            this.parser = new DOMParser();
            this.parser.setFeature("http://xml.org/sax/features/validation", bl);
            this.parser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", bl);
            this.parser.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", false);
            try {
                this.parser.parse(string);
            }
            catch (SAXException sAXException) {
                this.application.errorMessages.append("XMLManager.parse(" + string + "): " + sAXException + "\n");
                JOptionPane.showMessageDialog(Editor.cmp, "The parsing might not be complete (The file is probably not well-formed XML).\n Some nodes and edges might be missing from the graph because of an error (check error log) in file " + string);
                this.application.reportError = true;
            }
            catch (IOException iOException) {
                this.application.errorMessages.append("XMLManager.parse(" + string + "): " + iOException + "\n");
                JOptionPane.showMessageDialog(Editor.cmp, "The parsing might not be complete (The file is probably not well-formed XML).\n Some nodes and edges might be missing from the graph because of an error (check error log) in file " + string);
                this.application.reportError = true;
            }
            Document document = this.parser.getDocument();
            document.normalize();
            return document;
        }
        catch (Exception exception) {
            this.application.errorMessages.append("XMLManager.parse(" + string + "): " + exception + "\n");
            JOptionPane.showMessageDialog(Editor.cmp, "The parsing might not be complete (The file is probably not well-formed XML).\n Some nodes and edges might be missing from the graph because of an error (check error log) in file " + string);
            this.application.reportError = true;
            return null;
        }
    }

    void serialize(Document document, File file) {
        if (file != null && document != null) {
            XMLSerializer xMLSerializer = new XMLSerializer();
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), ConfigManager.ENCODING);
                xMLSerializer.setOutputCharStream((Writer)outputStreamWriter);
                xMLSerializer.setOutputFormat(new OutputFormat(document, ConfigManager.ENCODING, true));
                xMLSerializer.serialize(document);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

