/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.w3c.IsaViz.ConfigManager;
import org.w3c.IsaViz.Editor;

class URLPanel
extends JFrame
implements ActionListener,
KeyListener {
    JButton load;
    JComboBox cbb;
    int whichReader = 0;
    Editor application;
    boolean merge = false;

    public URLPanel(Editor editor, String string, int n, boolean bl) {
        this.application = editor;
        this.whichReader = n;
        this.merge = bl;
        this.cbb = new JComboBox(ConfigManager.lastURLs);
        this.cbb.setEditable(true);
        this.cbb.setMaximumRowCount(5);
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        container.setLayout(gridBagLayout);
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 90, 100);
        gridBagLayout.setConstraints(this.cbb, gridBagConstraints);
        this.cbb.getEditor().getEditorComponent().addKeyListener(this);
        container.add(this.cbb);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 13;
        this.load = new JButton("Load");
        this.load.addActionListener(this);
        this.load.addKeyListener(this);
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 10, 0);
        gridBagLayout.setConstraints(this.load, gridBagConstraints);
        container.add(this.load);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                URLPanel.this.dispose();
            }
        };
        this.addWindowListener(windowAdapter);
        this.setTitle(string);
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dimension.width / 2 - 300, dimension.height / 2 - 25);
        this.setSize(600, 50);
        this.setVisible(true);
        this.cbb.getEditor().getEditorComponent().requestFocus();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = (String)this.cbb.getSelectedItem();
        this.application.cfgMngr.addLastURL(string);
        if (actionEvent.getSource() == this.load) {
            try {
                URL uRL = new URL(string);
                if (this.merge) {
                    this.application.mergeRDF(uRL, this.whichReader);
                } else {
                    this.application.loadRDF(uRL, this.whichReader);
                }
            }
            catch (MalformedURLException malformedURLException) {
                JOptionPane.showMessageDialog(this, malformedURLException.toString());
            }
            this.dispose();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            String string = keyEvent.getSource() == this.cbb.getEditor().getEditorComponent() ? (String)this.cbb.getEditor().getItem() : (String)this.cbb.getSelectedItem();
            this.application.cfgMngr.addLastURL(string);
            try {
                URL uRL = new URL(string);
                if (this.merge) {
                    this.application.mergeRDF(uRL, this.whichReader);
                } else {
                    this.application.loadRDF(uRL, this.whichReader);
                }
            }
            catch (MalformedURLException malformedURLException) {
                JOptionPane.showMessageDialog(this, malformedURLException.toString());
            }
            this.dispose();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }
}

