/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.w3c.IsaViz.ConfigManager;
import org.w3c.IsaViz.Editor;
import org.w3c.IsaViz.ILiteral;
import org.w3c.IsaViz.INode;
import org.w3c.IsaViz.IProperty;
import org.w3c.IsaViz.IResource;
import org.w3c.IsaViz.NSTableModel;
import org.w3c.IsaViz.PRTableModel;
import org.w3c.IsaViz.Utils;

class TablePanel
extends JFrame
implements ActionListener,
KeyListener,
MouseListener,
ChangeListener {
    Editor application;
    JTabbedPane tabbedPane;
    JScrollPane sp1;
    JScrollPane sp2;
    JTable nsTable;
    DefaultTableModel nsTableModel;
    JButton addNSBt;
    JButton remNSBt;
    JTextField nsPrefTf;
    JTextField nsURITf;
    JTable prTable;
    JButton addPRBt;
    JButton remPRBt;
    JButton loadPRBt;
    JTextField nsPrpTf;
    JTextField lnPrpTf;
    JPanel rsPane;
    JPanel outerRsPane;
    JLabel resourceLb;
    JLabel bckBt;
    IResource[] browserList = new IResource[Editor.MAX_BRW_LIST_SIZE];
    int brwIndex = 0;
    TableModelListener l1 = new TableModelListener(){

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getType() != -1) {
                int n = tableModelEvent.getFirstRow();
                int n2 = tableModelEvent.getColumn();
                TablePanel.this.application.updateNamespaceBinding(n, n2, (String)TablePanel.this.nsTableModel.getValueAt(n, 0), (String)TablePanel.this.nsTableModel.getValueAt(n, 1), (Boolean)TablePanel.this.nsTableModel.getValueAt(n, 2), tableModelEvent.getType());
            }
        }
    };
    TableModelListener l2 = new TableModelListener(){

        public void tableChanged(TableModelEvent tableModelEvent) {
            if (tableModelEvent.getType() != -1) {
                // empty if block
            }
        }
    };
    static /* synthetic */ Class class$java$lang$Boolean;

    TablePanel(Editor editor, int n, int n2, int n3, int n4) {
        this.application = editor;
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(this);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        this.nsTableModel = new NSTableModel(0, 3);
        this.nsTableModel.addTableModelListener(this.l1);
        this.nsTable = new JTable(this.nsTableModel);
        this.nsTable.setSelectionMode(0);
        TableColumn tableColumn = this.nsTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(n3 / 100 * 20);
        tableColumn.setHeaderValue("Prefix");
        tableColumn = this.nsTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(n3 / 100 * 70);
        tableColumn.setHeaderValue("URI");
        tableColumn = this.nsTable.getColumnModel().getColumn(2);
        tableColumn.setPreferredWidth(n3 / 100 * 10);
        tableColumn.setHeaderValue("Display Prefix");
        TableCellRenderer tableCellRenderer = this.nsTable.getDefaultRenderer(class$java$lang$Boolean == null ? (class$java$lang$Boolean = TablePanel.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        tableColumn.setCellRenderer(tableCellRenderer);
        TableCellEditor tableCellEditor = this.nsTable.getDefaultEditor(class$java$lang$Boolean == null ? (class$java$lang$Boolean = TablePanel.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        tableColumn.setCellEditor(tableCellEditor);
        this.sp1 = new JScrollPane(this.nsTable);
        this.sp1.setVerticalScrollBarPolicy(22);
        this.sp1.setHorizontalScrollBarPolicy(30);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.buildConstraints(gridBagConstraints, 0, 0, 5, 1, 100, 99);
        gridBagLayout.setConstraints(this.sp1, gridBagConstraints);
        jPanel.add(this.sp1);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.nsPrefTf = new JTextField();
        this.nsPrefTf.addKeyListener(this);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 25, 1);
        gridBagLayout.setConstraints(this.nsPrefTf, gridBagConstraints);
        jPanel.add(this.nsPrefTf);
        this.nsURITf = new JTextField();
        this.nsURITf.addKeyListener(this);
        this.buildConstraints(gridBagConstraints, 1, 1, 1, 1, 75, 0);
        gridBagLayout.setConstraints(this.nsURITf, gridBagConstraints);
        jPanel.add(this.nsURITf);
        gridBagConstraints.fill = 0;
        this.addNSBt = new JButton("Add NS Binding");
        this.addNSBt.setFont(Editor.tinyFont);
        this.addNSBt.addActionListener(this);
        this.addNSBt.addKeyListener(this);
        this.buildConstraints(gridBagConstraints, 2, 1, 1, 1, 7, 0);
        gridBagLayout.setConstraints(this.addNSBt, gridBagConstraints);
        jPanel.add(this.addNSBt);
        gridBagConstraints.anchor = 10;
        this.remNSBt = new JButton("Remove Selected");
        this.remNSBt.setFont(Editor.tinyFont);
        this.remNSBt.addActionListener(this);
        this.remNSBt.addKeyListener(this);
        this.buildConstraints(gridBagConstraints, 3, 1, 1, 1, 6, 0);
        gridBagLayout.setConstraints(this.remNSBt, gridBagConstraints);
        jPanel.add(this.remNSBt);
        this.tabbedPane.addTab("Namespaces", jPanel);
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        jPanel2.setLayout(gridBagLayout2);
        PRTableModel pRTableModel = new PRTableModel(0, 3);
        pRTableModel.addTableModelListener(this.l2);
        this.prTable = new JTable(pRTableModel);
        this.prTable.setSelectionMode(0);
        TableColumn tableColumn2 = this.prTable.getColumnModel().getColumn(0);
        tableColumn2.setPreferredWidth(n3 / 100 * 50);
        tableColumn2.setHeaderValue("Namespace");
        tableColumn2 = this.prTable.getColumnModel().getColumn(1);
        tableColumn2.setPreferredWidth(n3 / 100 * 15);
        tableColumn2.setHeaderValue("Prefix");
        tableColumn2 = this.prTable.getColumnModel().getColumn(2);
        tableColumn2.setPreferredWidth(n3 / 100 * 35);
        tableColumn2.setHeaderValue("Property name");
        this.sp2 = new JScrollPane(this.prTable);
        this.sp2.setVerticalScrollBarPolicy(22);
        this.sp2.setHorizontalScrollBarPolicy(30);
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.anchor = 10;
        this.buildConstraints(gridBagConstraints2, 0, 0, 5, 1, 100, 99);
        gridBagLayout2.setConstraints(this.sp2, gridBagConstraints2);
        jPanel2.add(this.sp2);
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 17;
        this.nsPrpTf = new JTextField();
        this.nsPrpTf.addKeyListener(this);
        this.buildConstraints(gridBagConstraints2, 0, 1, 1, 1, 40, 1);
        gridBagLayout2.setConstraints(this.nsPrpTf, gridBagConstraints2);
        jPanel2.add(this.nsPrpTf);
        this.lnPrpTf = new JTextField();
        this.lnPrpTf.addKeyListener(this);
        this.buildConstraints(gridBagConstraints2, 1, 1, 1, 1, 40, 0);
        gridBagLayout2.setConstraints(this.lnPrpTf, gridBagConstraints2);
        jPanel2.add(this.lnPrpTf);
        gridBagConstraints2.fill = 0;
        this.addPRBt = new JButton("Add Property");
        this.addPRBt.setFont(Editor.tinyFont);
        this.addPRBt.addActionListener(this);
        this.addPRBt.addKeyListener(this);
        this.buildConstraints(gridBagConstraints2, 2, 1, 1, 1, 20, 0);
        gridBagLayout2.setConstraints(this.addPRBt, gridBagConstraints2);
        jPanel2.add(this.addPRBt);
        gridBagConstraints2.anchor = 17;
        this.remPRBt = new JButton("Remove Selected");
        this.remPRBt.setFont(Editor.tinyFont);
        this.remPRBt.addActionListener(this);
        this.remPRBt.addKeyListener(this);
        this.buildConstraints(gridBagConstraints2, 3, 1, 1, 1, 10, 0);
        gridBagLayout2.setConstraints(this.remPRBt, gridBagConstraints2);
        jPanel2.add(this.remPRBt);
        gridBagConstraints2.anchor = 13;
        this.loadPRBt = new JButton("Load Properties...");
        this.loadPRBt.setFont(Editor.tinyFont);
        this.loadPRBt.addActionListener(this);
        this.loadPRBt.addKeyListener(this);
        this.buildConstraints(gridBagConstraints2, 4, 1, 1, 1, 10, 0);
        gridBagLayout2.setConstraints(this.loadPRBt, gridBagConstraints2);
        jPanel2.add(this.loadPRBt);
        this.tabbedPane.addTab("Property Types", jPanel2);
        ListSelectionModel listSelectionModel = this.prTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!listSelectionModel.isSelectionEmpty()) {
                    int n = listSelectionModel.getMinSelectionIndex();
                    TablePanel.this.application.setSelectedPropertyConstructor((String)TablePanel.this.prTable.getModel().getValueAt(n, 0), (String)TablePanel.this.prTable.getModel().getValueAt(n, 2));
                }
            }
        });
        this.outerRsPane = new JPanel();
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        this.outerRsPane.setLayout(gridBagLayout3);
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.anchor = 17;
        this.resourceLb = new JLabel();
        this.resourceLb.setFont(Editor.swingFont);
        this.buildConstraints(gridBagConstraints3, 0, 0, 1, 1, 50, 1);
        gridBagLayout3.setConstraints(this.resourceLb, gridBagConstraints3);
        this.outerRsPane.add(this.resourceLb);
        gridBagConstraints3.fill = 0;
        gridBagConstraints3.anchor = 13;
        this.bckBt = new JLabel("Back");
        this.buildConstraints(gridBagConstraints3, 1, 0, 1, 1, 50, 1);
        gridBagLayout3.setConstraints(this.bckBt, gridBagConstraints3);
        this.bckBt.addMouseListener(this);
        this.outerRsPane.add(this.bckBt);
        this.rsPane = new JPanel();
        JScrollPane jScrollPane = new JScrollPane(this.rsPane);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(5);
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.anchor = 10;
        this.buildConstraints(gridBagConstraints3, 0, 1, 2, 1, 100, 99);
        gridBagLayout3.setConstraints(jScrollPane, gridBagConstraints3);
        this.outerRsPane.add(jScrollPane);
        this.tabbedPane.addTab("Property Browser", this.outerRsPane);
        Container container = this.getContentPane();
        container.add(this.tabbedPane);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Editor.cmp.showTablesMn.setSelected(false);
            }
        };
        this.addWindowListener(windowAdapter);
        this.setTitle("Definitions");
        this.pack();
        this.setLocation(n, n2);
        this.setSize(n3, n4);
    }

    void updatePropertyBrowser(INode iNode, boolean bl) {
        this.rsPane.removeAll();
        if (iNode != null && iNode instanceof IResource) {
            IResource iResource = (IResource)iNode;
            if (bl) {
                int n = Utils.getFirstEmptyIndex(this.browserList);
                if (n == -1) {
                    Utils.eraseFirstAddNewElem(this.browserList, iResource);
                    this.brwIndex = this.browserList.length - 1;
                } else {
                    this.browserList[n] = iResource;
                    this.brwIndex = n;
                }
            }
            String string = iResource.getIdent();
            if (iResource.getLabel() != null) {
                string = string + " (" + iResource.getLabel() + ")";
            }
            this.resourceLb.setText(string);
            this.resourceLb.setForeground(ConfigManager.darkerPastelBlue);
            Vector vector = iResource.getOutgoingPredicates();
            if (vector != null) {
                GridBagLayout gridBagLayout = new GridBagLayout();
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.fill = 2;
                gridBagConstraints.anchor = 17;
                this.rsPane.setLayout(gridBagLayout);
                int n = 0;
                int n2 = 0;
                int n3 = 1;
                int n4 = 1;
                int n5 = 50;
                int n6 = 100 / vector.size();
                int n7 = 0;
                while (n7 < vector.size()) {
                    IProperty iProperty = (IProperty)vector.elementAt(n7);
                    String string2 = this.application.getNSBinding(iProperty.getNamespace());
                    JLabel jLabel = new JLabel(string2 != null ? string2 + ":" + iProperty.getLocalname() : iProperty.getIdent());
                    jLabel.setFont(Editor.swingFont);
                    this.buildConstraints(gridBagConstraints, n, n2, n3, n4, n5, 1);
                    gridBagLayout.setConstraints(jLabel, gridBagConstraints);
                    this.rsPane.add(jLabel);
                    Component component = this.getSwingRepresentation(iProperty.object);
                    component.setFont(Editor.swingFont);
                    this.buildConstraints(gridBagConstraints, ++n, n2, n3, n4, n5, 0);
                    gridBagLayout.setConstraints(component, gridBagConstraints);
                    this.rsPane.add(component);
                    n = 0;
                    ++n2;
                    ++n7;
                }
                JLabel jLabel = new JLabel();
                this.buildConstraints(gridBagConstraints, n, n2, 2, 1, 100, 99);
                gridBagLayout.setConstraints(jLabel, gridBagConstraints);
                this.rsPane.add(jLabel);
            } else {
                this.rsPane.add(new JLabel("No property is associated to this resource."));
            }
        } else {
            this.resourceLb.setText("");
        }
        this.outerRsPane.paintAll(this.outerRsPane.getGraphics());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser;
        int n;
        Object object = actionEvent.getSource();
        if (object == this.addNSBt) {
            this.checkAndAddNS(this.nsPrefTf.getText(), this.nsURITf.getText());
        } else if (object == this.addPRBt) {
            this.checkAndAddProperty(this.nsPrpTf.getText(), this.lnPrpTf.getText());
        } else if (object == this.remNSBt) {
            int n2 = this.nsTable.getSelectedRow();
            if (n2 != -1) {
                this.application.removeNamespaceBinding(n2);
            }
        } else if (object == this.remPRBt) {
            int n3 = this.prTable.getSelectedRow();
            if (n3 != -1) {
                this.application.removePropertyConstructor(n3);
            }
        } else if (object == this.loadPRBt && (n = (jFileChooser = new JFileChooser(Editor.lastImportRDFDir != null ? Editor.lastImportRDFDir : Editor.rdfDir)).showOpenDialog(this)) == 0) {
            this.application.loadPropertyTypes(jFileChooser.getSelectedFile());
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            int n;
            Object object = keyEvent.getSource();
            if (object == this.addNSBt || object == this.nsPrefTf || object == this.nsURITf) {
                this.checkAndAddNS(this.nsPrefTf.getText(), this.nsURITf.getText());
            } else if (object == this.addPRBt || object == this.nsPrpTf || object == this.lnPrpTf) {
                this.checkAndAddProperty(this.nsPrpTf.getText(), this.lnPrpTf.getText());
            } else if (object == this.remNSBt) {
                int n2 = this.nsTable.getSelectedRow();
                if (n2 != -1) {
                    this.application.removeNamespaceBinding(n2);
                }
            } else if (object == this.remPRBt && (n = this.prTable.getSelectedRow()) != -1) {
                this.application.removePropertyConstructor(n);
            }
        }
    }

    public Component getSwingRepresentation(INode iNode) {
        if (iNode instanceof IResource) {
            String string;
            final IResource iResource = (IResource)iNode;
            if (iResource.isAnon()) {
                string = "(AR) ";
                if (Editor.SHOW_ANON_ID) {
                    string = string + iResource.getIdent();
                }
            } else {
                string = "(R) " + iResource.getIdent();
            }
            final JLabel jLabel = new JLabel(string);
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    int n = mouseEvent.getModifiers();
                    if ((n & 0x10) == 16) {
                        TablePanel.this.updatePropertyBrowser(iResource, true);
                    } else if ((n & 4) == 4) {
                        Editor.vsm.centerOnGlyph(iResource.getGlyph(), Editor.vsm.getActiveCamera(), 500);
                    }
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    jLabel.setForeground(ConfigManager.darkerPastelBlue);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    jLabel.setForeground(Color.black);
                }
            };
            jLabel.addMouseListener(mouseAdapter);
            return jLabel;
        }
        if (iNode instanceof ILiteral) {
            final ILiteral iLiteral = (ILiteral)iNode;
            final JLabel jLabel = new JLabel("(L) " + iLiteral.getValue());
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    int n = mouseEvent.getModifiers();
                    if ((n & 4) == 4) {
                        Editor.vsm.centerOnGlyph(iLiteral.getGlyph(), Editor.vsm.getActiveCamera(), 500);
                    }
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                }

                public void mouseClicked(MouseEvent mouseEvent) {
                }

                public void mouseEntered(MouseEvent mouseEvent) {
                    jLabel.setForeground(ConfigManager.darkerPastelBlue);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    jLabel.setForeground(Color.black);
                }
            };
            jLabel.addMouseListener(mouseAdapter);
            return jLabel;
        }
        return new JLabel("Unknown kind of object - unable to display " + iNode.toString());
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if (mouseEvent.getSource() == this.bckBt && (n & 0x10) == 16 && this.brwIndex > 0) {
            this.browserList[this.brwIndex] = null;
            --this.brwIndex;
            this.updatePropertyBrowser(this.browserList[this.brwIndex], false);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        ((JLabel)mouseEvent.getSource()).setForeground(ConfigManager.darkerPastelBlue);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        ((JLabel)mouseEvent.getSource()).setForeground(Color.black);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.tabbedPane.getSelectedIndex() == 2) {
            this.updatePropertyBrowser(Editor.lastSelectedItem, true);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    void resetNamespaceTable() {
        int n = this.nsTableModel.getRowCount() - 1;
        while (n >= 0) {
            this.nsTableModel.removeRow(n);
            --n;
        }
    }

    void resetPropertyTable() {
        int n = ((DefaultTableModel)this.prTable.getModel()).getRowCount() - 1;
        while (n >= 0) {
            ((DefaultTableModel)this.prTable.getModel()).removeRow(n);
            --n;
        }
    }

    void resetBrowser() {
        Utils.resetArray(this.browserList);
        this.updatePropertyBrowser(null, false);
    }

    void checkAndAddNS(String string, String string2) {
        if (string2.length() > 0) {
            boolean bl;
            String string3 = "";
            if (string.length() > 0) {
                String string4 = string3 = string.endsWith(":") ? string.substring(0, string.length() - 1) : string;
            }
            if (bl = this.application.addNamespaceBinding(string3, string2, new Boolean(false), false, false)) {
                this.nsPrefTf.setText("");
                this.nsURITf.setText("");
                this.nsPrefTf.requestFocus();
            }
        }
    }

    void checkAndAddProperty(String string, String string2) {
        if (this.application.addPropertyType(string, string2, false)) {
            this.nsPrpTf.setText("");
            this.lnPrpTf.setText("");
            this.nsPrpTf.requestFocus();
        }
    }

    void updateSwingFont() {
        this.resourceLb.setFont(Editor.swingFont);
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

