/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import javax.swing.UIManager;

public class SplashWindow
extends JWindow
implements Runnable,
MouseListener {
    Thread runView;
    boolean interesting;
    String imagePath = "";
    int duration = 4000;
    boolean periodBringToFront;
    JProgressBar jpb;
    JScrollPane sp;
    JTextArea txtInfo;

    public SplashWindow(int n, String string, boolean bl, Frame frame) {
        super(frame != null ? frame : null);
        if (n == 0) {
            this.interesting = true;
        } else {
            this.interesting = false;
            this.duration = n;
        }
        this.imagePath = string;
        this.periodBringToFront = bl;
        Color color = (Color)UIManager.get("ProgressBar.foreground");
        Color color2 = (Color)UIManager.get("ProgressBar.background");
        UIManager.put("ProgressBar.foreground", Color.black);
        UIManager.put("ProgressBar.background", Color.white);
        this.jpb = new JProgressBar();
        UIManager.put("ProgressBar.foreground", color);
        UIManager.put("ProgressBar.background", color2);
        this.jpb.setMinimum(0);
        this.jpb.setMaximum(100);
        this.jpb.setStringPainted(false);
        Container container = this.getContentPane();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        container.setBackground(Color.white);
        container.setLayout(gridBagLayout);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/" + this.imagePath));
        JPanel jPanel = new JPanel();
        jPanel.addMouseListener(this);
        jPanel.setBackground(Color.white);
        jPanel.add(new JLabel(imageIcon));
        jPanel.setPreferredSize(new Dimension(320, 240));
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 65);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        container.add(jPanel);
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 100, 5);
        gridBagLayout.setConstraints(this.jpb, gridBagConstraints);
        container.add(this.jpb);
        this.txtInfo = new JTextArea("");
        this.sp = new JScrollPane(this.txtInfo);
        this.sp.setVerticalScrollBarPolicy(22);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 100, 25);
        gridBagLayout.setConstraints(this.sp, gridBagConstraints);
        container.add(this.sp);
        container.doLayout();
        Dimension dimension = toolkit.getScreenSize();
        int n2 = imageIcon.getIconWidth();
        int n3 = imageIcon.getIconHeight();
        this.setLocation((dimension.width - n2) / 2, (dimension.height - n3) / 2);
        this.setSize(n2, n3 + 60);
        this.txtInfo.setFont(new Font("Dialog", 0, 9));
        this.txtInfo.setBackground(Color.white);
        this.txtInfo.setLineWrap(true);
        this.txtInfo.setWrapStyleWord(true);
        this.txtInfo.setEditable(false);
        this.setVisible(true);
        this.start();
    }

    public void destroy() {
        if (this.isShowing()) {
            this.setVisible(false);
            this.dispose();
        }
        this.stop();
    }

    public void start() {
        this.runView = new Thread(this);
        this.runView.start();
    }

    public synchronized void stop() {
        this.runView = null;
        this.notify();
    }

    public void run() {
        this.txtInfo.append("JVM version: " + System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version"));
        this.txtInfo.append("\nOS type: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + "/" + System.getProperty("os.arch") + " " + System.getProperty("sun.cpu.isalist"));
        this.txtInfo.append("\n-----------------");
        this.txtInfo.append("\nDirectory information");
        this.txtInfo.append("\nJava Classpath: " + System.getProperty("java.class.path"));
        this.txtInfo.append("\nJava directory: " + System.getProperty("java.home"));
        this.txtInfo.append("\nLaunching from: " + System.getProperty("user.dir"));
        this.txtInfo.append("\n-----------------");
        this.txtInfo.append("\nUser informations");
        this.txtInfo.append("\nUser name: " + System.getProperty("user.name"));
        this.txtInfo.append("\nUser home directory: " + System.getProperty("user.home"));
        while (this.duration > 0) {
            if (this.periodBringToFront) {
                this.toFront();
            }
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.duration -= 50;
        }
        while (this.jpb.getValue() < 100) {
            if (this.periodBringToFront) {
                this.toFront();
            }
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!this.interesting) {
            if (this.isShowing()) {
                this.setVisible(false);
                this.dispose();
            }
            this.stop();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.interesting) {
            this.interesting = true;
        } else {
            if (this.isShowing()) {
                this.setVisible(false);
                this.dispose();
            }
            this.stop();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void setProgressBarValue(int n) {
        this.jpb.setValue(n);
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }
}

