/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class PrintUtilities
extends JPanel
implements Printable {
    private BufferedImage bufferedImage;

    public PrintUtilities(BufferedImage bufferedImage) {
        this.bufferedImage = bufferedImage;
    }

    public void print() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = new PageFormat();
        pageFormat.setOrientation(0);
        printerJob.setPrintable(this, pageFormat);
        if (printerJob.printDialog()) {
            try {
                printerJob.print();
            }
            catch (PrinterException printerException) {
                JOptionPane.showMessageDialog(null, "Error while printing", "Error", 0);
                System.err.println("** Error printing: " + printerException);
                printerException.printStackTrace();
            }
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n2 = this.bufferedImage.getWidth();
        int n3 = this.bufferedImage.getHeight();
        double d = pageFormat.getImageableHeight();
        double d2 = pageFormat.getImageableWidth();
        if (n >= 1) {
            return 1;
        }
        this.setSize(new Dimension(n2, n3));
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.translate(pageFormat.getImageableWidth() / 2.0, pageFormat.getImageableHeight() / 2.0);
        Dimension dimension = this.getSize();
        double d3 = Math.min(pageFormat.getImageableWidth() / (double)dimension.width, pageFormat.getImageableHeight() / (double)dimension.height);
        if (d3 < 1.0) {
            graphics2D.scale(d3, d3);
        }
        graphics2D.translate((double)(-dimension.width) / 2.0, (double)(-dimension.height) / 2.0);
        this.setOpaque(true);
        this.paint(graphics2D);
        return 0;
    }

    public void paint(Graphics graphics) {
        if (this.getSize().width <= 0 || this.getSize().height <= 0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.bufferedImage != null) {
            graphics2D.drawImage((Image)this.bufferedImage, 0, 0, this);
        }
    }
}

