/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.svg;

import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.Utilities;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Transparent;
import com.xerox.VTM.glyphs.VCircle;
import com.xerox.VTM.glyphs.VCircleST;
import com.xerox.VTM.glyphs.VEllipse;
import com.xerox.VTM.glyphs.VEllipseST;
import com.xerox.VTM.glyphs.VPath;
import com.xerox.VTM.glyphs.VRectangleOr;
import com.xerox.VTM.glyphs.VRectangleOrST;
import com.xerox.VTM.glyphs.VText;
import com.xerox.VTM.svg.SVGStyle;
import java.awt.Color;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SVGReader {
    static long xoffset = 0L;
    static long yoffset = 0L;

    public static void setPositionOffset(long l, long l2) {
        xoffset = l;
        yoffset = l2;
    }

    public static LongPoint getPositionOffset() {
        return new LongPoint(xoffset, yoffset);
    }

    public static boolean checkSVGPath(String string) {
        boolean bl = true;
        byte[] byArray = string.getBytes();
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != 32 && byArray[n] != 45 && (byArray[n] < 48 || byArray[n] > 57) && byArray[n] != 67 && byArray[n] != 72 && byArray[n] != 76 && byArray[n] != 77 && byArray[n] != 81 && byArray[n] != 86 && byArray[n] != 99 && byArray[n] != 104 && byArray[n] != 108 && byArray[n] != 109 && byArray[n] != 113 && byArray[n] != 118 && byArray[n] != 44) {
                bl = false;
                System.err.println("SVG Path: char '" + string.substring(n, n + 1) + "' not supported");
                break;
            }
            ++n;
        }
        return bl;
    }

    private static void processNextSVGPathCommand(StringBuffer stringBuffer, VPath vPath, StringBuffer stringBuffer2) {
        if (stringBuffer.length() > 0) {
            block0 : switch (stringBuffer.charAt(0)) {
                case 'M': {
                    stringBuffer.deleteCharAt(0);
                    long l = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                    long l2 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                    vPath.jump(l, -l2, true);
                    stringBuffer2.setCharAt(0, 'M');
                    break;
                }
                case 'm': {
                    stringBuffer.deleteCharAt(0);
                    long l = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                    long l3 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                    vPath.jump(l, -l3, false);
                    stringBuffer2.setCharAt(0, 'm');
                    break;
                }
                case 'L': {
                    stringBuffer.deleteCharAt(0);
                    long l = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                    long l4 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                    vPath.addSegment(l, -l4, true);
                    stringBuffer2.setCharAt(0, 'L');
                    break;
                }
                case 'l': {
                    stringBuffer.deleteCharAt(0);
                    long l = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                    long l5 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                    vPath.addSegment(l, -l5, false);
                    stringBuffer2.setCharAt(0, 'l');
                    break;
                }
                case 'H': {
                    stringBuffer.deleteCharAt(0);
                    long l = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                    vPath.addSegment(l, 0L, true);
                    stringBuffer2.setCharAt(0, 'H');
                    break;
                }
                case 'h': {
                    stringBuffer.deleteCharAt(0);
                    long l = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                    vPath.addSegment(l, 0L, false);
                    stringBuffer2.setCharAt(0, 'h');
                    break;
                }
                case 'V': {
                    stringBuffer.deleteCharAt(0);
                    long l = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                    vPath.addSegment(0L, -l, true);
                    stringBuffer2.setCharAt(0, 'V');
                    break;
                }
                case 'v': {
                    stringBuffer.deleteCharAt(0);
                    long l = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                    vPath.addSegment(0L, -l, false);
                    stringBuffer2.setCharAt(0, 'v');
                    break;
                }
                case 'C': {
                    stringBuffer.deleteCharAt(0);
                    long l = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                    long l6 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                    long l7 = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                    long l8 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                    long l9 = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                    long l10 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                    vPath.addCbCurve(l9, -l10, l, -l6, l7, -l8, true);
                    stringBuffer2.setCharAt(0, 'C');
                    break;
                }
                case 'c': {
                    stringBuffer.deleteCharAt(0);
                    long l = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                    long l11 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                    long l12 = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                    long l13 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                    long l14 = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                    long l15 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                    vPath.addCbCurve(l14, -l15, l, -l11, l12, -l13, false);
                    stringBuffer2.setCharAt(0, 'c');
                    break;
                }
                case 'Q': {
                    stringBuffer.deleteCharAt(0);
                    long l = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                    long l16 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                    long l17 = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                    long l18 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                    vPath.addQdCurve(l17, -l18, l, -l16, true);
                    stringBuffer2.setCharAt(0, 'Q');
                    break;
                }
                case 'q': {
                    stringBuffer.deleteCharAt(0);
                    long l = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                    long l19 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                    long l20 = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                    long l21 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                    vPath.addQdCurve(l20, -l21, l, -l19, false);
                    stringBuffer2.setCharAt(0, 'q');
                    break;
                }
                default: {
                    switch (stringBuffer2.charAt(0)) {
                        case 'M': {
                            long l = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                            long l22 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                            vPath.jump(l, -l22, true);
                            break block0;
                        }
                        case 'm': {
                            long l = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                            long l23 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                            vPath.jump(l, -l23, false);
                            break block0;
                        }
                        case 'L': {
                            long l = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                            long l24 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                            vPath.addSegment(l, -l24, true);
                            break block0;
                        }
                        case 'l': {
                            long l = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                            long l25 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                            vPath.addSegment(l, -l25, false);
                            break block0;
                        }
                        case 'H': {
                            long l = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                            vPath.addSegment(l, 0L, true);
                            break block0;
                        }
                        case 'h': {
                            long l = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                            vPath.addSegment(l, 0L, false);
                            break block0;
                        }
                        case 'V': {
                            long l = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                            vPath.addSegment(0L, -l, true);
                            break block0;
                        }
                        case 'v': {
                            long l = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                            vPath.addSegment(0L, -l, false);
                            break block0;
                        }
                        case 'C': {
                            long l = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                            long l26 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                            long l27 = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                            long l28 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                            long l29 = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                            long l30 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                            vPath.addCbCurve(l29, -l30, l, -l26, l27, -l28, true);
                            break block0;
                        }
                        case 'c': {
                            long l = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                            long l31 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                            long l32 = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                            long l33 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                            long l34 = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                            long l35 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                            vPath.addCbCurve(l34, -l35, l, -l31, l32, -l33, false);
                            break block0;
                        }
                        case 'Q': {
                            long l = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                            long l36 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                            long l37 = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                            long l38 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                            vPath.addQdCurve(l37, -l38, l, -l36, true);
                            break block0;
                        }
                        case 'q': {
                            long l = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                            long l39 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                            long l40 = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
                            long l41 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
                            vPath.addQdCurve(l40, -l41, l, -l39, false);
                        }
                    }
                }
            }
        }
    }

    public static Color getColor(String string) {
        try {
            if (string.startsWith("rgb(")) {
                StringTokenizer stringTokenizer = new StringTokenizer(string.substring(4, string.length() - 1), ",");
                String[] stringArray = new String[stringTokenizer.countTokens()];
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray[n++] = stringTokenizer.nextToken();
                }
                if (stringArray[0].endsWith("%")) {
                    float f = new Float(stringArray[0].substring(0, stringArray[0].length() - 1)).floatValue() / 100.0f;
                    float f2 = new Float(stringArray[1].substring(0, stringArray[1].length() - 1)).floatValue() / 100.0f;
                    float f3 = new Float(stringArray[2].substring(0, stringArray[2].length() - 1)).floatValue() / 100.0f;
                    return new Color(f, f2, f3);
                }
                int n2 = new Float(stringArray[0]).intValue();
                int n3 = new Float(stringArray[1]).intValue();
                int n4 = new Float(stringArray[2]).intValue();
                return new Color(n2, n3, n4);
            }
            if (string.startsWith("#")) {
                String string2 = string.length() == 4 ? string.substring(1, 2) + string.substring(1, 2) + string.substring(2, 3) + string.substring(2, 3) + string.substring(3, 4) + string.substring(3, 4) : string.substring(1, string.length());
                int n = Integer.parseInt(string2.substring(0, 2), 16);
                int n5 = Integer.parseInt(string2.substring(2, 4), 16);
                int n6 = Integer.parseInt(string2.substring(4, 6), 16);
                return new Color(n, n5, n6);
            }
            Color color = Utilities.getColorByKeyword(string);
            if (color != null) {
                return color;
            }
            return Color.white;
        }
        catch (Exception exception) {
            System.err.println("Error: SVGReader.getColor(): " + exception);
            return Color.white;
        }
    }

    public static SVGStyle getStyle(String string) {
        int n;
        Object object;
        String[] stringArray = null;
        if (string != null) {
            object = new StringTokenizer(string, ";");
            stringArray = new String[((StringTokenizer)object).countTokens()];
            n = 0;
            while (((StringTokenizer)object).hasMoreTokens()) {
                stringArray[n++] = ((StringTokenizer)object).nextToken();
            }
        }
        if (stringArray != null) {
            object = new SVGStyle();
            n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].startsWith("fill:")) {
                    ((SVGStyle)object).setFillColor(SVGReader.getColor(stringArray[n].substring(5, stringArray[n].length())));
                } else if (stringArray[n].startsWith("stroke:")) {
                    ((SVGStyle)object).setBorderColor(SVGReader.getColor(stringArray[n].substring(7, stringArray[n].length())));
                } else if (stringArray[n].startsWith("fill-opacity:")) {
                    ((SVGStyle)object).setAlphaTransparencyValue(new Float(stringArray[n].substring(13, stringArray[n].length())));
                }
                ++n;
            }
            return object;
        }
        return null;
    }

    public static void translateSVGPolygon(String string, Vector vector) {
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.length() > 0) {
            Utilities.delLeadingSpaces(stringBuffer);
            SVGReader.processNextSVGCoords(stringBuffer, vector);
        }
    }

    private static void processNextSVGCoords(StringBuffer stringBuffer, Vector vector) {
        if (stringBuffer.length() > 0) {
            long l = (long)SVGReader.getNextNumber(stringBuffer) + xoffset;
            long l2 = (long)SVGReader.getNextNumber(stringBuffer) + yoffset;
            vector.add(new LongPoint(l, l2));
        }
    }

    private static void seekSecondCoord(StringBuffer stringBuffer) {
        Utilities.delLeadingSpaces(stringBuffer);
        while (stringBuffer.length() > 0 && (Character.isWhitespace(stringBuffer.charAt(0)) || stringBuffer.charAt(0) == ',')) {
            stringBuffer.deleteCharAt(0);
        }
    }

    static int getNextNumber(StringBuffer stringBuffer) {
        int n = 0;
        SVGReader.seekSecondCoord(stringBuffer);
        StringBuffer stringBuffer2 = new StringBuffer();
        while (stringBuffer.length() > 0 && (Character.isDigit(stringBuffer.charAt(0)) || stringBuffer.charAt(0) == '-')) {
            stringBuffer2.append(stringBuffer.charAt(0));
            stringBuffer.deleteCharAt(0);
        }
        if (stringBuffer2.length() > 0) {
            n = Integer.valueOf(stringBuffer2.toString());
        }
        return n;
    }

    public static boolean isRectangle(Vector vector) {
        if (vector.size() == 4 || vector.size() == 5) {
            LongPoint longPoint = (LongPoint)vector.elementAt(0);
            LongPoint longPoint2 = (LongPoint)vector.elementAt(1);
            LongPoint longPoint3 = (LongPoint)vector.elementAt(2);
            LongPoint longPoint4 = (LongPoint)vector.elementAt(3);
            return longPoint2.x == longPoint3.x && longPoint.y == longPoint2.y && longPoint3.y == longPoint4.y && longPoint.x == longPoint4.x;
        }
        return false;
    }

    public static VEllipse createEllipse(Element element) {
        VEllipse vEllipse;
        long l = Long.valueOf(element.getAttribute("cx")) + xoffset;
        long l2 = Long.valueOf(element.getAttribute("cy")) + yoffset;
        long l3 = Long.valueOf(element.getAttribute("rx"));
        long l4 = Long.valueOf(element.getAttribute("ry"));
        if (element.hasAttribute("style")) {
            SVGStyle sVGStyle = SVGReader.getStyle(element.getAttribute("style"));
            if (sVGStyle.hasTransparencyInformation()) {
                vEllipse = new VEllipseST(l, -l2, 0.0f, l3, l4, sVGStyle.getFillColor());
                ((Transparent)((Object)vEllipse)).setTransparencyValue(sVGStyle.getAlphaTransparencyValue());
            } else {
                vEllipse = new VEllipse(l, -l2, 0.0f, l3, l4, sVGStyle.getFillColor());
            }
            Color color = sVGStyle.getBorderColor();
            float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3]);
            vEllipse.setHSVbColor(fArray[0], fArray[1], fArray[2]);
        } else {
            vEllipse = new VEllipse(l, -l2, 0.0f, l3, l4, Color.white);
        }
        return vEllipse;
    }

    public static VCircle createCircle(Element element) {
        VCircle vCircle;
        long l = Long.valueOf(element.getAttribute("cx")) + xoffset;
        long l2 = Long.valueOf(element.getAttribute("cy")) + yoffset;
        long l3 = Long.valueOf(element.getAttribute("r"));
        if (element.hasAttribute("style")) {
            SVGStyle sVGStyle = SVGReader.getStyle(element.getAttribute("style"));
            if (sVGStyle.hasTransparencyInformation()) {
                vCircle = new VCircleST(l, -l2, 0.0f, l3, sVGStyle.getFillColor());
                ((Transparent)((Object)vCircle)).setTransparencyValue(sVGStyle.getAlphaTransparencyValue());
            } else {
                vCircle = new VCircle(l, -l2, 0.0f, l3, sVGStyle.getFillColor());
            }
            Color color = sVGStyle.getBorderColor();
            float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3]);
            vCircle.setHSVbColor(fArray[0], fArray[1], fArray[2]);
        } else {
            vCircle = new VCircle(l, -l2, 0.0f, l3, Color.white);
        }
        return vCircle;
    }

    public static VText createText(Element element) {
        VText vText;
        String string;
        long l = Integer.valueOf(element.getAttribute("x")).longValue() + xoffset;
        long l2 = Integer.valueOf(element.getAttribute("y")).longValue() + yoffset;
        String string2 = string = element.getFirstChild() == null ? "" : element.getFirstChild().getNodeValue();
        if (element.hasAttribute("style")) {
            SVGStyle sVGStyle = SVGReader.getStyle(element.getAttribute("style"));
            vText = new VText(l, -l2, 0.0f, sVGStyle.getBorderColor(), string);
        } else {
            vText = new VText(l, -l2, 0.0f, Color.black, string);
        }
        return vText;
    }

    public static VRectangleOr createRectangleFromPolygon(Element element) {
        Vector vector = new Vector();
        SVGReader.translateSVGPolygon(element.getAttribute("points"), vector);
        if (SVGReader.isRectangle(vector)) {
            VRectangleOr vRectangleOr;
            LongPoint longPoint = (LongPoint)vector.elementAt(0);
            LongPoint longPoint2 = (LongPoint)vector.elementAt(1);
            LongPoint longPoint3 = (LongPoint)vector.elementAt(2);
            LongPoint longPoint4 = (LongPoint)vector.elementAt(3);
            long l = Math.abs(longPoint4.y - longPoint.y);
            long l2 = Math.abs(longPoint2.x - longPoint.x);
            long l3 = longPoint.x - l2 / 2L;
            long l4 = longPoint.y + l / 2L;
            if (element.hasAttribute("style")) {
                SVGStyle sVGStyle = SVGReader.getStyle(element.getAttribute("style"));
                if (sVGStyle.hasTransparencyInformation()) {
                    vRectangleOr = new VRectangleOrST(l3, -l4, 0.0f, l2 / 2L, l / 2L, sVGStyle.getFillColor(), 0.0f);
                    ((Transparent)((Object)vRectangleOr)).setTransparencyValue(sVGStyle.getAlphaTransparencyValue());
                } else {
                    vRectangleOr = new VRectangleOr(l3, -l4, 0.0f, l2 / 2L, l / 2L, sVGStyle.getFillColor(), 0.0f);
                }
                Color color = sVGStyle.getBorderColor();
                float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3]);
                vRectangleOr.setHSVbColor(fArray[0], fArray[1], fArray[2]);
            } else {
                vRectangleOr = new VRectangleOr(l3, -l4, 0.0f, l2 / 2L, l / 2L, Color.white, 0.0f);
            }
            return vRectangleOr;
        }
        return null;
    }

    public static VRectangleOr createRectangle(Element element) {
        VRectangleOr vRectangleOr;
        long l = Long.valueOf(element.getAttribute("x")) + xoffset;
        long l2 = Long.valueOf(element.getAttribute("y")) + yoffset;
        long l3 = Long.valueOf(element.getAttribute("width")) / 2L;
        long l4 = Long.valueOf(element.getAttribute("height")) / 2L;
        if (element.hasAttribute("style")) {
            SVGStyle sVGStyle = SVGReader.getStyle(element.getAttribute("style"));
            if (sVGStyle.hasTransparencyInformation()) {
                vRectangleOr = new VRectangleOrST(l + l3, -l2 - l4, 0.0f, l3, l4, sVGStyle.getFillColor(), 0.0f);
                ((Transparent)((Object)vRectangleOr)).setTransparencyValue(sVGStyle.getAlphaTransparencyValue());
            } else {
                vRectangleOr = new VRectangleOr(l + l3, -l2 - l4, 0.0f, l3, l4, sVGStyle.getFillColor(), 0.0f);
            }
            Color color = sVGStyle.getBorderColor();
            float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3]);
            vRectangleOr.setHSVbColor(fArray[0], fArray[1], fArray[2]);
        } else {
            vRectangleOr = new VRectangleOr(l + l3, -l2 - l4, 0.0f, l3, l4, Color.white, 0.0f);
        }
        return vRectangleOr;
    }

    public static VPath createPath(Element element, VPath vPath) {
        StringBuffer stringBuffer = new StringBuffer(element.getAttribute("d"));
        if (SVGReader.checkSVGPath(stringBuffer.toString())) {
            StringBuffer stringBuffer2 = new StringBuffer("M");
            while (stringBuffer.length() > 0) {
                Utilities.delLeadingSpaces(stringBuffer);
                SVGReader.processNextSVGPathCommand(stringBuffer, vPath, stringBuffer2);
            }
            if (element.hasAttribute("style")) {
                SVGStyle sVGStyle = SVGReader.getStyle(element.getAttribute("style"));
                Color color = sVGStyle.getBorderColor();
                float[] fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3]);
                vPath.setHSVColor(fArray[0], fArray[1], fArray[2]);
            }
            return vPath;
        }
        return null;
    }

    public static VPath createPath(String string, VPath vPath) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (SVGReader.checkSVGPath(stringBuffer.toString())) {
            StringBuffer stringBuffer2 = new StringBuffer("M");
            while (stringBuffer.length() > 0) {
                Utilities.delLeadingSpaces(stringBuffer);
                SVGReader.processNextSVGPathCommand(stringBuffer, vPath, stringBuffer2);
            }
            return vPath;
        }
        return null;
    }

    public static void load(Document document, VirtualSpaceManager virtualSpaceManager, String string) {
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1) {
                SVGReader.processNode((Element)node, virtualSpaceManager, string);
            }
            ++n;
        }
    }

    private static void processNode(Element element, VirtualSpaceManager virtualSpaceManager, String string) {
        if (element.getTagName().equals("rect")) {
            virtualSpaceManager.addGlyph(SVGReader.createRectangle(element), string);
        } else if (element.getTagName().equals("ellipse")) {
            virtualSpaceManager.addGlyph(SVGReader.createEllipse(element), string);
        } else if (element.getTagName().equals("circle")) {
            virtualSpaceManager.addGlyph(SVGReader.createCircle(element), string);
        } else if (element.getTagName().equals("path")) {
            virtualSpaceManager.addGlyph(SVGReader.createPath(element, new VPath()), string);
        } else if (element.getTagName().equals("text")) {
            virtualSpaceManager.addGlyph(SVGReader.createText(element), string);
        } else if (element.getTagName().equals("polygon")) {
            VRectangleOr vRectangleOr = SVGReader.createRectangleFromPolygon(element);
            if (vRectangleOr != null) {
                virtualSpaceManager.addGlyph(vRectangleOr, string);
            } else {
                System.err.println("Only polygons representing rectangles are supported right now.\nThe following polygon cannot be added the virtual space: " + element.toString());
            }
        } else if (element.getTagName().equals("g")) {
            NodeList nodeList = element.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node.getNodeType() == 1) {
                    SVGReader.processNode((Element)node, virtualSpaceManager, string);
                }
                ++n;
            }
        } else if (element.getTagName().equals("a")) {
            NodeList nodeList = element.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if (node.getNodeType() == 1) {
                    SVGReader.processNode((Element)node, virtualSpaceManager, string);
                }
                ++n;
            }
        } else {
            System.err.println("Unsupported element: " + element.getTagName());
        }
    }
}

