/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.glyphs.VImage;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public class VImageOr
extends VImage {
    public VImageOr(Image image, float f) {
        super(image);
        this.orient = f;
    }

    public VImageOr(long l, long l2, float f, Image image, float f2) {
        super(l, l2, f, image);
        this.orient = f2;
    }

    public void orientTo(float f) {
        this.orient = f;
    }

    public void orientToNS(float f) {
        this.orient = f;
    }

    void computeOrientCoords(int n) {
        float f = -this.pc[n].cw;
        float f2 = -this.pc[n].ch;
        float f3 = this.pc[n].cw;
        float f4 = this.pc[n].ch;
        int[] nArray = new int[]{(int)Math.round((double)f3 * Math.cos(this.orient) + (double)f2 * Math.sin(this.orient) + (double)this.pc[n].cx), (int)Math.round((double)f * Math.cos(this.orient) + (double)f2 * Math.sin(this.orient) + (double)this.pc[n].cx), (int)Math.round((double)f * Math.cos(this.orient) + (double)f4 * Math.sin(this.orient) + (double)this.pc[n].cx), (int)Math.round((double)f3 * Math.cos(this.orient) + (double)f4 * Math.sin(this.orient) + (double)this.pc[n].cx)};
        int[] nArray2 = new int[]{(int)Math.round((double)f2 * Math.cos(this.orient) - (double)f3 * Math.sin(this.orient) + (double)this.pc[n].cy), (int)Math.round((double)f2 * Math.cos(this.orient) - (double)f * Math.sin(this.orient) + (double)this.pc[n].cy), (int)Math.round((double)f4 * Math.cos(this.orient) - (double)f * Math.sin(this.orient) + (double)this.pc[n].cy), (int)Math.round((double)f4 * Math.cos(this.orient) - (double)f3 * Math.sin(this.orient) + (double)this.pc[n].cy)};
        this.pc[n].p = new Polygon(nArray, nArray2, 4);
    }

    boolean coordInside(int n, int n2, int n3) {
        return this.pc[n3].p.contains(n, n2);
    }

    public void project(Camera camera, ViewPanel viewPanel) {
        int n = camera.getIndex();
        this.coef = camera.focal / (camera.focal + camera.altitude);
        this.pc[n].cx = Math.round((float)(this.vx - camera.posx) * this.coef);
        this.pc[n].cy = Math.round((float)(this.vy - camera.posy) * this.coef);
        this.pc[n].cx = viewPanel.getSize().width / 2 + this.pc[n].cx;
        this.pc[n].cy = viewPanel.getSize().height / 2 - this.pc[n].cy;
        if (this.zoomSensitive) {
            this.pc[n].cw = Math.round((float)this.vw * this.coef);
            this.pc[n].ch = Math.round((float)this.vh * this.coef);
        } else {
            this.pc[n].cw = (int)this.vw;
            this.pc[n].ch = (int)this.vh;
        }
        this.computeOrientCoords(n);
    }

    public void draw(Graphics2D graphics2D, int n, int n2, int n3, Stroke stroke, AffineTransform affineTransform) {
        if (this.pc[n3].cw > 1 && this.pc[n3].ch > 1) {
            this.trueCoef = this.zoomSensitive ? this.scaleFactor * this.coef : this.scaleFactor;
            if (Math.abs(this.trueCoef - 1.0f) < 0.01f) {
                this.trueCoef = 1.0f;
            }
            if (this.trueCoef != 1.0f) {
                this.at = AffineTransform.getTranslateInstance(this.pc[n3].cx - this.pc[n3].cw, this.pc[n3].cy - this.pc[n3].ch);
                if (this.orient != 0.0f) {
                    this.at.concatenate(AffineTransform.getRotateInstance(-this.orient, this.pc[n3].cw, this.pc[n3].ch));
                }
                this.at.concatenate(AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef));
                graphics2D.drawImage(this.image, this.at, null);
                if (this.drawBorder == 1) {
                    if (this.pc[n3].prevMouseIn) {
                        graphics2D.setColor(this.borderColor);
                        graphics2D.drawPolygon(this.pc[n3].p);
                    }
                } else if (this.drawBorder == 2) {
                    graphics2D.setColor(this.borderColor);
                    graphics2D.drawPolygon(this.pc[n3].p);
                }
            } else {
                if (this.orient == 0.0f) {
                    graphics2D.drawImage(this.image, this.pc[n3].cx - this.pc[n3].cw, this.pc[n3].cy - this.pc[n3].ch, null);
                } else {
                    this.at = AffineTransform.getTranslateInstance(this.pc[n3].cx - this.pc[n3].cw, this.pc[n3].cy - this.pc[n3].ch);
                    this.at.concatenate(AffineTransform.getRotateInstance(-this.orient, this.pc[n3].cw, this.pc[n3].ch));
                    if (this.trueCoef != 1.0f) {
                        this.at.concatenate(AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef));
                    }
                    graphics2D.drawImage(this.image, this.at, null);
                }
                if (this.drawBorder == 1) {
                    if (this.pc[n3].prevMouseIn) {
                        graphics2D.setColor(this.borderColor);
                        graphics2D.drawPolygon(this.pc[n3].p);
                    }
                } else if (this.drawBorder == 2) {
                    graphics2D.setColor(this.borderColor);
                    graphics2D.drawPolygon(this.pc[n3].p);
                }
            }
        } else {
            graphics2D.fillRect(this.pc[n3].cx, this.pc[n3].cy, 1, 1);
        }
    }
}

