/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.ProjCirImage;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public class VCirImage
extends Glyph {
    long vw;
    long vh;
    long vs;
    float ar;
    AffineTransform at;
    ProjCirImage[] pc;
    Image image;
    float scaleFactor = 1.0f;
    float trueCoef = 1.0f;
    float relCoef = 1.0f;

    public VCirImage(long l, long l2, float f, long l3, Image image, Color color, float f2) {
        this.vx = l;
        this.vy = l2;
        this.vz = f;
        this.vs = l3;
        this.image = image;
        this.ar = (float)this.image.getWidth(null) / (float)this.image.getHeight(null);
        this.size = this.vs;
        this.computeSize();
        this.orient = f2;
        this.setRGBColor(color);
        this.setRGBBorderColor(Color.black);
    }

    public void initCams(int n) {
        this.pc = new ProjCirImage[n];
        int n2 = 0;
        while (n2 < n) {
            this.pc[n2] = new ProjCirImage();
            ++n2;
        }
    }

    public void addCamera(int n) {
        if (this.pc != null) {
            if (n == this.pc.length) {
                ProjCirImage[] projCirImageArray = this.pc;
                this.pc = new ProjCirImage[projCirImageArray.length + 1];
                int n2 = 0;
                while (n2 < projCirImageArray.length) {
                    this.pc[n2] = projCirImageArray[n2];
                    ++n2;
                }
                this.pc[this.pc.length - 1] = new ProjCirImage();
            } else {
                System.err.println("VCirImage:Error while adding camera " + n);
            }
        } else if (n == 0) {
            this.pc = new ProjCirImage[1];
            this.pc[0] = new ProjCirImage();
        } else {
            System.err.println("VCirImage:Error while adding camera " + n);
        }
    }

    public void removeCamera(int n) {
        this.pc[n] = null;
    }

    public void resetMouseIn(int n) {
        if (this.pc[n] != null) {
            this.pc[n].prevMouseIn = false;
        }
    }

    public float getOrient() {
        return this.orient;
    }

    public void orientTo(float f) {
        this.orient = f;
    }

    public void orientToNS(float f) {
        this.orient = f;
    }

    public float getSize() {
        return this.size;
    }

    void computeSize() {
        this.vw = Math.round((double)(this.size * this.ar) / Math.sqrt(Math.pow(this.ar, 2.0) + 1.0));
        this.vh = Math.round((double)this.size / Math.sqrt(Math.pow(this.ar, 2.0) + 1.0));
        this.scaleFactor = (float)((double)this.size / Math.sqrt(Math.pow(this.image.getWidth(null) / 2, 2.0) + Math.pow(this.image.getHeight(null) / 2, 2.0)));
    }

    public void sizeTo(float f) {
        this.size = f;
        this.vs = Math.round(this.size);
        this.computeSize();
    }

    public void sizeToNS(float f) {
        this.size = f;
        this.vs = Math.round(this.size);
        this.computeSize();
    }

    public void reSize(float f) {
        this.size *= f;
        this.vs = Math.round(this.size);
        this.computeSize();
    }

    public void setImage(Image image) {
        this.image = image;
        this.ar = (float)this.image.getWidth(null) / (float)this.image.getHeight(null);
        this.computeSize();
    }

    public Image getImage() {
        return this.image;
    }

    public void setRelativeImageSize(float f) {
        this.relCoef = f;
    }

    public float getRelativeImageSize() {
        return this.relCoef;
    }

    public boolean fillsView(long l, long l2, int n) {
        return Math.sqrt(Math.pow(l - (long)this.pc[n].cx, 2.0) + Math.pow(l2 - (long)this.pc[n].cy, 2.0)) <= (double)this.pc[n].cs && Math.sqrt(Math.pow(this.pc[n].cx, 2.0) + Math.pow(l2 - (long)this.pc[n].cy, 2.0)) <= (double)this.pc[n].cs && Math.sqrt(Math.pow(l - (long)this.pc[n].cx, 2.0) + Math.pow(this.pc[n].cy, 2.0)) <= (double)this.pc[n].cs && Math.sqrt(Math.pow(this.pc[n].cx, 2.0) + Math.pow(this.pc[n].cy, 2.0)) <= (double)this.pc[n].cs;
    }

    boolean coordInside(int n, int n2, int n3) {
        return Math.sqrt(Math.pow(n - this.pc[n3].cx, 2.0) + Math.pow(n2 - this.pc[n3].cy, 2.0)) <= (double)this.pc[n3].cs;
    }

    public int mouseInOut(int n, int n2, int n3) {
        if (this.coordInside(n, n2, n3)) {
            if (!this.pc[n3].prevMouseIn) {
                this.pc[n3].prevMouseIn = true;
                return 1;
            }
            return 0;
        }
        if (this.pc[n3].prevMouseIn) {
            this.pc[n3].prevMouseIn = false;
            return -1;
        }
        return 0;
    }

    public void project(Camera camera, ViewPanel viewPanel) {
        int n = camera.getIndex();
        this.coef = camera.focal / (camera.focal + camera.altitude);
        this.pc[n].cx = Math.round((float)(this.vx - camera.posx) * this.coef);
        this.pc[n].cy = Math.round((float)(this.vy - camera.posy) * this.coef);
        this.pc[n].cx = viewPanel.getSize().width / 2 + this.pc[n].cx;
        this.pc[n].cy = viewPanel.getSize().height / 2 - this.pc[n].cy;
        this.pc[n].cs = Math.round((float)this.vs * this.coef);
        this.pc[n].cw = Math.round((float)this.vw * this.coef * this.relCoef);
        this.pc[n].ch = Math.round((float)this.vh * this.coef * this.relCoef);
    }

    public void draw(Graphics2D graphics2D, int n, int n2, int n3, Stroke stroke, AffineTransform affineTransform) {
        if (this.pc[n3].cs > 1) {
            if (this.filled) {
                graphics2D.setColor(this.color);
                graphics2D.fillOval(this.pc[n3].cx - this.pc[n3].cs, this.pc[n3].cy - this.pc[n3].cs, 2 * this.pc[n3].cs, 2 * this.pc[n3].cs);
            }
            if (this.paintBorder) {
                graphics2D.setColor(this.borderColor);
                if (this.stroke != null) {
                    graphics2D.setStroke(this.stroke);
                    graphics2D.drawOval(this.pc[n3].cx - this.pc[n3].cs, this.pc[n3].cy - this.pc[n3].cs, 2 * this.pc[n3].cs, 2 * this.pc[n3].cs);
                    graphics2D.setStroke(stroke);
                } else {
                    graphics2D.drawOval(this.pc[n3].cx - this.pc[n3].cs, this.pc[n3].cy - this.pc[n3].cs, 2 * this.pc[n3].cs, 2 * this.pc[n3].cs);
                }
            }
            this.trueCoef = this.scaleFactor * this.coef * this.relCoef;
            if (Math.abs(this.trueCoef - 1.0f) < 0.01f) {
                this.trueCoef = 1.0f;
            }
            if (this.trueCoef != 1.0f) {
                this.at = AffineTransform.getTranslateInstance(this.pc[n3].cx - this.pc[n3].cw, this.pc[n3].cy - this.pc[n3].ch);
                if (this.orient != 0.0f) {
                    this.at.concatenate(AffineTransform.getRotateInstance(-this.orient, this.pc[n3].cw, this.pc[n3].ch));
                }
                this.at.concatenate(AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef));
                graphics2D.drawImage(this.image, this.at, null);
            } else if (this.orient == 0.0f) {
                graphics2D.drawImage(this.image, this.pc[n3].cx - this.pc[n3].cw, this.pc[n3].cy - this.pc[n3].ch, null);
            } else {
                this.at = AffineTransform.getTranslateInstance(this.pc[n3].cx - this.pc[n3].cw, this.pc[n3].cy - this.pc[n3].ch);
                this.at.concatenate(AffineTransform.getRotateInstance(-this.orient, this.pc[n3].cw, this.pc[n3].ch));
                if (this.trueCoef != 1.0f) {
                    this.at.concatenate(AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef));
                }
                graphics2D.drawImage(this.image, this.at, null);
            }
        } else {
            graphics2D.fillRect(this.pc[n3].cx, this.pc[n3].cy, 1, 1);
        }
    }
}

