/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.engine;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.engine.View;
import com.xerox.VTM.engine.ViewPanel;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Glyph;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.RenderingHints;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.image.BufferedImage;
import java.awt.image.VolatileImage;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class AccViewPanel
extends ViewPanel
implements Runnable {
    VolatileImage vImg;

    protected BufferedImage getImage() {
        return this.vImg.getSnapshot();
    }

    public AccViewPanel(Vector vector, View view) {
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                if (AccViewPanel.this.isShowing()) {
                    AccViewPanel.this.start();
                } else {
                    AccViewPanel.this.stop();
                }
            }
        });
        this.parent = view;
        this.cams = new Camera[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            this.cams[n] = (Camera)vector.get(n);
            ++n;
        }
        this.setBackground(Color.lightGray);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.start();
        this.setAWTCursor(-1);
        if (this.parent.parent.debug) {
            System.out.println("View refresh time set to " + this.frameTime + "ms");
        }
    }

    public void start() {
        Dimension dimension = this.getSize();
        this.runView = new Thread(this);
        this.runView.setPriority(5);
        this.runView.start();
    }

    public synchronized void stop() {
        this.runView = null;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thread = Thread.currentThread();
        while (this.getSize().width <= 0) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                if (this.parent.parent.debug) {
                    System.err.println("viewpanel.run.runview.sleep " + interruptedException);
                }
                return;
            }
        }
        Graphics graphics = null;
        Graphics graphics2 = null;
        Dimension dimension = this.getSize();
        while (this.runView == thread) {
            if (this.active) {
                Serializable serializable;
                if (this.repaintNow) {
                    GraphicsConfiguration graphicsConfiguration;
                    this.repaintNow = false;
                    this.updateMouseOnly = false;
                    this.d1 = System.currentTimeMillis();
                    serializable = this.getSize();
                    if (serializable.width != dimension.width || serializable.height != dimension.height) {
                        this.vImg = null;
                        if (graphics2 != null) {
                            graphics2.dispose();
                            graphics2 = null;
                        }
                        if (this.parent.parent.debug) {
                            System.out.println("Resizing JPanel: (" + dimension.width + "x" + dimension.height + ") -> (" + serializable.width + "x" + serializable.height + ")");
                        }
                        dimension = serializable;
                        this.updateAntialias = true;
                        this.updateFont = true;
                    }
                    if (this.vImg == null) {
                        graphicsConfiguration = this.getGraphicsConfiguration();
                        this.vImg = graphicsConfiguration.createCompatibleVolatileImage(serializable.width, serializable.height);
                    }
                    if (graphics2 == null) {
                        graphics2 = this.vImg.createGraphics();
                        graphics2.setFont(VirtualSpaceManager.mainFont);
                    }
                    if (this.updateFont) {
                        graphics2.setFont(VirtualSpaceManager.mainFont);
                        this.updateFont = false;
                    }
                    if (this.updateAntialias) {
                        if (this.antialias) {
                            ((Graphics2D)graphics2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        } else {
                            ((Graphics2D)graphics2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                        }
                        this.updateAntialias = false;
                    }
                    graphics = graphics2;
                    graphicsConfiguration = this.getGraphicsConfiguration();
                    int n = this.vImg.validate(graphicsConfiguration);
                    if (n == 2) {
                        this.vImg = graphicsConfiguration.createCompatibleVolatileImage(serializable.width, serializable.height);
                    }
                    this.standardStroke = ((Graphics2D)graphics).getStroke();
                    this.standardTransform = ((Graphics2D)graphics).getTransform();
                    AccViewPanel accViewPanel = this;
                    synchronized (accViewPanel) {
                        Enumeration enumeration;
                        graphics.setPaintMode();
                        ((Graphics2D)graphics).setBackground(this.backColor);
                        graphics.clearRect(0, 0, this.getWidth(), this.getHeight());
                        int n2 = 0;
                        while (n2 < this.cams.length) {
                            if (this.cams[n2] != null && this.cams[n2].enabled) {
                                this.camIndex = this.cams[n2].getIndex();
                                this.uncoef = (this.cams[n2].focal + this.cams[n2].altitude) / this.cams[n2].focal;
                                this.viewW = this.getSize().width;
                                this.viewH = this.getSize().height;
                                this.viewWHu = (long)((float)this.cams[n2].posx + (float)(this.getSize().width / 2) * this.uncoef);
                                this.viewHHu = (long)((float)this.cams[n2].posy + (float)(this.getSize().height / 2) * this.uncoef);
                                this.viewWLu = (long)((float)this.cams[n2].posx - (float)(this.getSize().width / 2) * this.uncoef);
                                this.viewHLu = (long)((float)this.cams[n2].posy - (float)(this.getSize().height / 2) * this.uncoef);
                                this.cams[n2].parentSpace.drawnList.removeAllElements();
                                if (this.parent.detectMultipleFullFills) {
                                    enumeration = this.cams[n2].parentSpace.getVisibleGlyphs().elements();
                                    while (enumeration.hasMoreElements()) {
                                        this.gl = (Glyph)enumeration.nextElement();
                                        if (!this.gl.drawMe(this.viewWHu, this.viewHHu, this.viewWLu, this.viewHLu, this.camIndex)) continue;
                                        this.cams[n2].parentSpace.drawnList.add(this.gl);
                                        this.gl.project(this.cams[n2], this);
                                    }
                                    this.drawnGlyphs = this.cams[n2].parentSpace.getDrawnGlyphs();
                                    this.beginAt = 0;
                                    int n3 = this.drawnGlyphs.size() - 1;
                                    while (n3 >= 0) {
                                        if (((Glyph)this.drawnGlyphs.elementAt(n3)).fillsView(this.viewW, this.viewH, this.cams[n2].getIndex())) {
                                            this.beginAt = n3;
                                            break;
                                        }
                                        --n3;
                                    }
                                    int n4 = this.beginAt;
                                    while (n4 < this.drawnGlyphs.size()) {
                                        this.gl = (Glyph)this.drawnGlyphs.elementAt(n4);
                                        if (this.gl.isVisible()) {
                                            this.gl.draw((Graphics2D)graphics, serializable.width, serializable.height, this.cams[n2].getIndex(), this.standardStroke, this.standardTransform);
                                        }
                                        ++n4;
                                    }
                                } else {
                                    enumeration = this.cams[n2].parentSpace.getVisibleGlyphs().elements();
                                    while (enumeration.hasMoreElements()) {
                                        this.gl = (Glyph)enumeration.nextElement();
                                        if (!this.gl.drawMe(this.viewWHu, this.viewHHu, this.viewWLu, this.viewHLu, this.camIndex)) continue;
                                        Glyph glyph = this.gl;
                                        synchronized (glyph) {
                                            this.gl.project(this.cams[n2], this);
                                            if (this.gl.isVisible()) {
                                                this.gl.draw((Graphics2D)graphics, serializable.width, serializable.height, this.cams[n2].getIndex(), this.standardStroke, this.standardTransform);
                                            }
                                        }
                                        this.cams[n2].parentSpace.drawnList.add(this.gl);
                                    }
                                }
                            }
                            ++n2;
                        }
                        if (this.inside) {
                            block67: {
                                try {
                                    if (this.computeListAtEachRepaint && this.parent.mouse.isSensitive()) {
                                        this.parent.mouse.computeMouseOverList(this.evH, this.cams[this.activeLayer]);
                                    }
                                    this.parent.mouse.unProject(this.cams[this.activeLayer], this);
                                }
                                catch (NullPointerException nullPointerException) {
                                    if (!this.parent.parent.debug) break block67;
                                    System.err.println("viewpanel.run.drawdrag " + nullPointerException);
                                }
                            }
                            graphics.setColor(this.parent.mouse.color);
                            if (this.drawDrag) {
                                graphics.drawLine(this.origDragx, this.origDragy, this.parent.mouse.mx, this.parent.mouse.my);
                            } else if (this.drawRect) {
                                graphics.drawRect(Math.min(this.origDragx, this.parent.mouse.mx), Math.min(this.origDragy, this.parent.mouse.my), Math.max(this.origDragx, this.parent.mouse.mx) - Math.min(this.origDragx, this.parent.mouse.mx), Math.max(this.origDragy, this.parent.mouse.my) - Math.min(this.origDragy, this.parent.mouse.my));
                            }
                            if (this.drawVTMcursor) {
                                enumeration = this;
                                synchronized (enumeration) {
                                    graphics.setXORMode(this.backColor);
                                    this.parent.mouse.draw((Graphics2D)graphics);
                                    this.oldX = this.parent.mouse.mx;
                                    this.oldY = this.parent.mouse.my;
                                }
                            }
                        }
                        if (graphics == graphics2) {
                            this.repaint();
                        }
                        this.d2 = System.currentTimeMillis();
                        this.timeToSleep = (long)this.frameTime - this.d2 + this.d1;
                    }
                    try {
                        Thread.sleep(this.timeToSleep > 10L ? this.timeToSleep : 10L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        if (this.parent.parent.debug) {
                            System.err.println("viewpanel.run.runview.sleep2 " + interruptedException);
                        }
                        return;
                    }
                }
                if (this.updateMouseOnly) {
                    block68: {
                        this.updateMouseOnly = false;
                        this.d1 = System.currentTimeMillis();
                        try {
                            this.parent.mouse.unProject(this.cams[this.activeLayer], this);
                            if (this.computeListAtEachRepaint && this.parent.mouse.isSensitive()) {
                                this.parent.mouse.computeMouseOverList(this.evH, this.cams[this.activeLayer]);
                            }
                        }
                        catch (NullPointerException nullPointerException) {
                            if (!this.parent.parent.debug) break block68;
                            System.err.println("viewpanel.run.drawdrag " + nullPointerException);
                        }
                    }
                    if (this.drawVTMcursor) {
                        serializable = this;
                        synchronized (serializable) {
                            graphics.setXORMode(this.backColor);
                            graphics.setColor(this.parent.mouse.color);
                            graphics.drawLine(this.oldX - 10, this.oldY, this.oldX + 10, this.oldY);
                            graphics.drawLine(this.oldX, this.oldY - 10, this.oldX, this.oldY + 10);
                            graphics.drawLine(this.parent.mouse.mx - 10, this.parent.mouse.my, this.parent.mouse.mx + 10, this.parent.mouse.my);
                            graphics.drawLine(this.parent.mouse.mx, this.parent.mouse.my - 10, this.parent.mouse.mx, this.parent.mouse.my + 10);
                            this.oldX = this.parent.mouse.mx;
                            this.oldY = this.parent.mouse.my;
                        }
                    }
                    this.repaint();
                    this.d2 = System.currentTimeMillis();
                    this.timeToSleep = (long)this.frameTime - this.d2 + this.d1;
                    try {
                        Thread.sleep(this.timeToSleep > 10L ? this.timeToSleep : 10L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        if (this.parent.parent.debug) {
                            System.err.println("viewpanel.run.runview.sleep3 " + interruptedException);
                        }
                        return;
                    }
                }
                try {
                    Thread.sleep(this.frameTime + 20);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    if (this.parent.parent.debug) {
                        System.err.println("viewpanel.run.runview.sleep3 " + interruptedException);
                    }
                    return;
                }
            }
            try {
                Thread.sleep(this.deactiveTime);
            }
            catch (InterruptedException interruptedException) {
                if (this.parent.parent.debug) {
                    System.err.println("viewpanel.run.runview.sleep4 " + interruptedException);
                }
                return;
            }
        }
        if (graphics != null) {
            graphics.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        AccViewPanel accViewPanel = this;
        synchronized (accViewPanel) {
            this.g2 = (Graphics2D)graphics;
            if (this.vImg != null) {
                this.g2.drawImage(this.vImg, 0, 0, this);
            }
        }
    }
}

