/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.w3c.IsaViz.ConfigManager;
import org.w3c.IsaViz.Editor;
import org.w3c.IsaViz.TextViewer;
import org.w3c.IsaViz.Utils;

class PrefWindow
extends JFrame
implements ActionListener,
KeyListener {
    JTabbedPane tabbedPane;
    JButton okPrefs;
    JButton savePrefs;
    JButton brw1;
    JButton brw2;
    JButton brw3;
    JButton brw4;
    JButton brw5;
    JTextField tf1;
    JTextField tf2;
    JTextField tf3;
    JTextField tf4;
    JTextField tf5;
    JCheckBox cb1;
    JRadioButton gr1;
    JRadioButton gr2;
    JRadioButton detectBrowserBt;
    JRadioButton specifyBrowserBt;
    JTextField browserPathTf;
    JTextField browserOptsTf;
    JButton brw6;
    JButton webHelpBt;
    JLabel pathLb;
    JLabel optLb;
    JCheckBox useProxyCb;
    JLabel proxyHostLb;
    JLabel proxyPortLb;
    JTextField proxyHostTf;
    JTextField proxyPortTf;
    JButton proxyHelpBt;
    JTextField tf1a;
    JTextField tf1c;
    JTextField tf2a;
    JCheckBox cb1a;
    JCheckBox cb1b;
    JCheckBox cb1c;
    JRadioButton b1a;
    JRadioButton b2a;
    JTextField spinner;
    JCheckBox saveWindowLayoutCb;
    JCheckBox dispAsLabelCb;
    JComboBox cbb;
    JCheckBox antialiascb;
    Editor application;

    PrefWindow(Editor editor) {
        this.application = editor;
        this.tabbedPane = new JTabbedPane();
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        jPanel.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel("Graph Orientation");
        this.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 34, 10);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.b1a = new JRadioButton("Horizontal");
        this.b2a = new JRadioButton("Vertical");
        buttonGroup.add(this.b1a);
        buttonGroup.add(this.b2a);
        if (Editor.GRAPH_ORIENTATION.equals("LR")) {
            this.b1a.setSelected(true);
        } else {
            this.b2a.setSelected(true);
        }
        this.buildConstraints(gridBagConstraints, 1, 0, 1, 1, 33, 0);
        gridBagLayout.setConstraints(this.b1a, gridBagConstraints);
        jPanel.add(this.b1a);
        this.buildConstraints(gridBagConstraints, 2, 0, 1, 1, 33, 0);
        gridBagLayout.setConstraints(this.b2a, gridBagConstraints);
        jPanel.add(this.b2a);
        JLabel jLabel2 = new JLabel("Default Namespace (without ':')");
        this.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 34, 10);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        this.tf1a = new JTextField(Editor.DEFAULT_NAMESPACE.substring(0, Editor.DEFAULT_NAMESPACE.length() - 1));
        this.buildConstraints(gridBagConstraints, 1, 1, 2, 1, 66, 0);
        gridBagLayout.setConstraints(this.tf1a, gridBagConstraints);
        jPanel.add(this.tf1a);
        JLabel jLabel3 = new JLabel("Anonymous Node Prefix (without ':')");
        this.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 34, 10);
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel.add(jLabel3);
        this.tf2a = new JTextField(Editor.ANON_NODE.substring(0, Editor.ANON_NODE.length() - 1));
        this.buildConstraints(gridBagConstraints, 1, 2, 2, 1, 66, 0);
        gridBagLayout.setConstraints(this.tf2a, gridBagConstraints);
        jPanel.add(this.tf2a);
        this.cb1c = new JCheckBox("Always Include xml:lang in Literals - Default:");
        this.cb1c.setSelected(Editor.ALWAYS_INCLUDE_LANG_IN_LITERALS);
        this.buildConstraints(gridBagConstraints, 0, 3, 2, 1, 67, 10);
        gridBagLayout.setConstraints(this.cb1c, gridBagConstraints);
        jPanel.add(this.cb1c);
        this.tf1c = new JTextField(Editor.DEFAULT_LANGUAGE_IN_LITERALS);
        this.buildConstraints(gridBagConstraints, 2, 3, 1, 1, 33, 0);
        gridBagLayout.setConstraints(this.tf1c, gridBagConstraints);
        jPanel.add(this.tf1c);
        this.cb1a = new JCheckBox("Use Abbreviated RDF Syntax");
        this.cb1a.setSelected(Editor.ABBREV_SYNTAX);
        this.buildConstraints(gridBagConstraints, 0, 4, 3, 1, 100, 10);
        gridBagLayout.setConstraints(this.cb1a, gridBagConstraints);
        jPanel.add(this.cb1a);
        this.cb1b = new JCheckBox("Show Anonymous IDs");
        this.cb1b.setSelected(Editor.SHOW_ANON_ID);
        this.buildConstraints(gridBagConstraints, 0, 5, 3, 1, 100, 10);
        gridBagLayout.setConstraints(this.cb1b, gridBagConstraints);
        jPanel.add(this.cb1b);
        this.dispAsLabelCb = new JCheckBox("Display Label as Resource Text When Available", Editor.DISP_AS_LABEL);
        this.buildConstraints(gridBagConstraints, 0, 6, 3, 1, 100, 10);
        gridBagLayout.setConstraints(this.dispAsLabelCb, gridBagConstraints);
        jPanel.add(this.dispAsLabelCb);
        JLabel jLabel4 = new JLabel("Max. Nb. of Chars. Displayed in Literals");
        this.buildConstraints(gridBagConstraints, 0, 7, 1, 1, 33, 10);
        gridBagLayout.setConstraints(jLabel4, gridBagConstraints);
        jPanel.add(jLabel4);
        this.spinner = new JTextField(String.valueOf(Editor.MAX_LIT_CHAR_COUNT));
        this.spinner.addKeyListener(this);
        this.buildConstraints(gridBagConstraints, 1, 7, 2, 1, 66, 0);
        gridBagLayout.setConstraints(this.spinner, gridBagConstraints);
        jPanel.add(this.spinner);
        this.saveWindowLayoutCb = new JCheckBox("Save/Restore Window Layout at Startup", Editor.SAVE_WINDOW_LAYOUT);
        this.buildConstraints(gridBagConstraints, 0, 8, 3, 1, 100, 10);
        gridBagLayout.setConstraints(this.saveWindowLayoutCb, gridBagConstraints);
        jPanel.add(this.saveWindowLayoutCb);
        this.tabbedPane.addTab("Misc.", jPanel);
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.anchor = 17;
        jPanel2.setLayout(gridBagLayout2);
        JLabel jLabel5 = new JLabel("Temporary directory");
        this.buildConstraints(gridBagConstraints2, 0, 0, 1, 1, 60, 10);
        gridBagLayout2.setConstraints(jLabel5, gridBagConstraints2);
        jPanel2.add(jLabel5);
        this.cb1 = new JCheckBox("Delete temp files on exit");
        this.buildConstraints(gridBagConstraints2, 1, 0, 1, 1, 30, 0);
        gridBagLayout2.setConstraints(this.cb1, gridBagConstraints2);
        if (Editor.dltOnExit) {
            this.cb1.setSelected(true);
        } else {
            this.cb1.setSelected(false);
        }
        this.cb1.addActionListener(this);
        jPanel2.add(this.cb1);
        this.brw1 = new JButton("Browse...");
        this.buildConstraints(gridBagConstraints2, 2, 0, 1, 1, 10, 0);
        gridBagLayout2.setConstraints(this.brw1, gridBagConstraints2);
        this.brw1.addActionListener(this);
        jPanel2.add(this.brw1);
        this.tf1 = new JTextField(Editor.m_TmpDir.toString());
        this.tf1.setEnabled(false);
        this.buildConstraints(gridBagConstraints2, 0, 1, 3, 1, 100, 10);
        gridBagLayout2.setConstraints(this.tf1, gridBagConstraints2);
        jPanel2.add(this.tf1);
        JLabel jLabel6 = new JLabel("Project directory");
        this.buildConstraints(gridBagConstraints2, 0, 2, 2, 1, 90, 10);
        gridBagLayout2.setConstraints(jLabel6, gridBagConstraints2);
        jPanel2.add(jLabel6);
        this.brw2 = new JButton("Browse...");
        this.buildConstraints(gridBagConstraints2, 2, 2, 1, 1, 10, 0);
        gridBagLayout2.setConstraints(this.brw2, gridBagConstraints2);
        this.brw2.addActionListener(this);
        jPanel2.add(this.brw2);
        this.tf2 = new JTextField(Editor.projectDir.toString());
        this.tf2.setEnabled(false);
        this.buildConstraints(gridBagConstraints2, 0, 3, 3, 1, 100, 10);
        gridBagLayout2.setConstraints(this.tf2, gridBagConstraints2);
        jPanel2.add(this.tf2);
        JLabel jLabel7 = new JLabel("RDF directory");
        this.buildConstraints(gridBagConstraints2, 0, 4, 2, 1, 90, 10);
        gridBagLayout2.setConstraints(jLabel7, gridBagConstraints2);
        jPanel2.add(jLabel7);
        this.brw3 = new JButton("Browse...");
        this.buildConstraints(gridBagConstraints2, 2, 4, 1, 1, 10, 0);
        gridBagLayout2.setConstraints(this.brw3, gridBagConstraints2);
        this.brw3.addActionListener(this);
        jPanel2.add(this.brw3);
        this.tf3 = new JTextField(Editor.rdfDir.toString());
        this.tf3.setEnabled(false);
        this.buildConstraints(gridBagConstraints2, 0, 5, 3, 1, 100, 10);
        gridBagLayout2.setConstraints(this.tf3, gridBagConstraints2);
        jPanel2.add(this.tf3);
        JLabel jLabel8 = new JLabel("GraphViz DOT executable");
        this.buildConstraints(gridBagConstraints2, 0, 6, 1, 1, 60, 10);
        gridBagLayout2.setConstraints(jLabel8, gridBagConstraints2);
        jPanel2.add(jLabel8);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout());
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.gr1 = new JRadioButton("1.7.6");
        this.gr2 = new JRadioButton("1.7.11 or later");
        buttonGroup2.add(this.gr1);
        buttonGroup2.add(this.gr2);
        jPanel3.add(this.gr1);
        jPanel3.add(this.gr2);
        if (Editor.GRAPHVIZ_VERSION == 0) {
            this.gr1.setSelected(true);
        } else {
            this.gr2.setSelected(true);
        }
        this.buildConstraints(gridBagConstraints2, 1, 6, 1, 1, 30, 0);
        gridBagLayout2.setConstraints(jPanel3, gridBagConstraints2);
        jPanel2.add(jPanel3);
        this.brw4 = new JButton("Browse...");
        this.buildConstraints(gridBagConstraints2, 2, 6, 1, 1, 10, 0);
        gridBagLayout2.setConstraints(this.brw4, gridBagConstraints2);
        this.brw4.addActionListener(this);
        jPanel2.add(this.brw4);
        this.tf4 = new JTextField(Editor.m_GraphVizPath.toString());
        this.tf4.setEnabled(false);
        this.buildConstraints(gridBagConstraints2, 0, 7, 3, 1, 100, 10);
        gridBagLayout2.setConstraints(this.tf4, gridBagConstraints2);
        jPanel2.add(this.tf4);
        JLabel jLabel9 = new JLabel("GraphViz font directory");
        this.buildConstraints(gridBagConstraints2, 0, 8, 2, 1, 90, 10);
        gridBagLayout2.setConstraints(jLabel9, gridBagConstraints2);
        jPanel2.add(jLabel9);
        this.brw5 = new JButton("Browse...");
        this.buildConstraints(gridBagConstraints2, 2, 8, 1, 1, 10, 0);
        gridBagLayout2.setConstraints(this.brw5, gridBagConstraints2);
        this.brw5.addActionListener(this);
        jPanel2.add(this.brw5);
        this.tf5 = new JTextField(Editor.m_GraphVizFontDir.toString());
        this.tf5.setEnabled(false);
        this.buildConstraints(gridBagConstraints2, 0, 9, 3, 1, 100, 10);
        gridBagLayout2.setConstraints(this.tf5, gridBagConstraints2);
        jPanel2.add(this.tf5);
        this.tabbedPane.addTab("Directories", jPanel2);
        JPanel jPanel4 = new JPanel();
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.anchor = 17;
        jPanel4.setLayout(gridBagLayout3);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        this.detectBrowserBt = new JRadioButton("Automatically Detect Default Browser");
        this.buildConstraints(gridBagConstraints3, 0, 0, 3, 1, 100, 1);
        gridBagLayout3.setConstraints(this.detectBrowserBt, gridBagConstraints3);
        this.detectBrowserBt.addActionListener(this);
        buttonGroup3.add(this.detectBrowserBt);
        jPanel4.add(this.detectBrowserBt);
        this.specifyBrowserBt = new JRadioButton("Specify Browser");
        this.buildConstraints(gridBagConstraints3, 0, 1, 3, 1, 100, 1);
        gridBagLayout3.setConstraints(this.specifyBrowserBt, gridBagConstraints3);
        this.specifyBrowserBt.addActionListener(this);
        buttonGroup3.add(this.specifyBrowserBt);
        jPanel4.add(this.specifyBrowserBt);
        JPanel jPanel5 = new JPanel();
        this.buildConstraints(gridBagConstraints3, 0, 2, 1, 1, 10, 1);
        gridBagLayout3.setConstraints(jPanel5, gridBagConstraints3);
        jPanel4.add(jPanel5);
        this.pathLb = new JLabel("Path");
        this.buildConstraints(gridBagConstraints3, 1, 2, 1, 1, 80, 0);
        gridBagLayout3.setConstraints(this.pathLb, gridBagConstraints3);
        jPanel4.add(this.pathLb);
        this.brw6 = new JButton("Browse...");
        this.buildConstraints(gridBagConstraints3, 2, 2, 1, 1, 10, 0);
        gridBagLayout3.setConstraints(this.brw6, gridBagConstraints3);
        this.brw6.addActionListener(this);
        jPanel4.add(this.brw6);
        this.browserPathTf = new JTextField(Editor.browserPath.toString());
        this.buildConstraints(gridBagConstraints3, 1, 3, 2, 1, 90, 1);
        gridBagLayout3.setConstraints(this.browserPathTf, gridBagConstraints3);
        jPanel4.add(this.browserPathTf);
        this.optLb = new JLabel("Command Line Options");
        this.buildConstraints(gridBagConstraints3, 1, 4, 2, 1, 90, 1);
        gridBagLayout3.setConstraints(this.optLb, gridBagConstraints3);
        jPanel4.add(this.optLb);
        this.browserOptsTf = new JTextField(Editor.browserOptions);
        this.buildConstraints(gridBagConstraints3, 1, 5, 2, 1, 90, 1);
        gridBagLayout3.setConstraints(this.browserOptsTf, gridBagConstraints3);
        jPanel4.add(this.browserOptsTf);
        JPanel jPanel6 = new JPanel();
        this.buildConstraints(gridBagConstraints3, 0, 6, 3, 1, 100, 92);
        gridBagLayout3.setConstraints(jPanel6, gridBagConstraints3);
        jPanel4.add(jPanel6);
        this.webHelpBt = new JButton("Help");
        this.buildConstraints(gridBagConstraints3, 2, 7, 1, 1, 10, 1);
        gridBagLayout3.setConstraints(this.webHelpBt, gridBagConstraints3);
        this.webHelpBt.addActionListener(this);
        jPanel4.add(this.webHelpBt);
        if (Editor.autoDetectBrowser) {
            this.detectBrowserBt.doClick();
        } else {
            this.specifyBrowserBt.doClick();
        }
        this.tabbedPane.addTab("Web Browser", jPanel4);
        JPanel jPanel7 = new JPanel();
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.anchor = 17;
        jPanel7.setLayout(gridBagLayout4);
        this.useProxyCb = new JCheckBox("Use Proxy Server");
        this.buildConstraints(gridBagConstraints4, 0, 0, 2, 1, 100, 1);
        gridBagLayout4.setConstraints(this.useProxyCb, gridBagConstraints4);
        this.useProxyCb.setSelected(Editor.useProxy);
        this.useProxyCb.addActionListener(this);
        jPanel7.add(this.useProxyCb);
        this.proxyHostLb = new JLabel("Hostname:");
        this.proxyHostLb.setEnabled(Editor.useProxy);
        this.buildConstraints(gridBagConstraints4, 0, 1, 1, 1, 80, 1);
        gridBagLayout4.setConstraints(this.proxyHostLb, gridBagConstraints4);
        jPanel7.add(this.proxyHostLb);
        this.proxyPortLb = new JLabel("Port:");
        this.proxyPortLb.setEnabled(Editor.useProxy);
        this.buildConstraints(gridBagConstraints4, 1, 1, 1, 1, 20, 1);
        gridBagLayout4.setConstraints(this.proxyPortLb, gridBagConstraints4);
        jPanel7.add(this.proxyPortLb);
        this.proxyHostTf = new JTextField(Editor.proxyHost);
        this.proxyHostTf.setEnabled(Editor.useProxy);
        this.buildConstraints(gridBagConstraints4, 0, 2, 1, 1, 80, 1);
        gridBagLayout4.setConstraints(this.proxyHostTf, gridBagConstraints4);
        jPanel7.add(this.proxyHostTf);
        this.proxyPortTf = new JTextField(Editor.proxyPort);
        this.proxyPortTf.setEnabled(Editor.useProxy);
        this.buildConstraints(gridBagConstraints4, 1, 2, 1, 1, 20, 1);
        gridBagLayout4.setConstraints(this.proxyPortTf, gridBagConstraints4);
        jPanel7.add(this.proxyPortTf);
        gridBagConstraints4.fill = 1;
        gridBagConstraints4.anchor = 10;
        JPanel jPanel8 = new JPanel();
        this.buildConstraints(gridBagConstraints4, 0, 3, 2, 1, 100, 95);
        gridBagLayout4.setConstraints(jPanel8, gridBagConstraints4);
        jPanel7.add(jPanel8);
        gridBagConstraints4.fill = 0;
        gridBagConstraints4.anchor = 13;
        this.proxyHelpBt = new JButton("Help");
        this.buildConstraints(gridBagConstraints4, 1, 4, 1, 1, 20, 1);
        gridBagLayout4.setConstraints(this.proxyHelpBt, gridBagConstraints4);
        this.proxyHelpBt.addActionListener(this);
        jPanel7.add(this.proxyHelpBt);
        this.tabbedPane.addTab("Proxy", jPanel7);
        JPanel jPanel9 = new JPanel();
        GridBagLayout gridBagLayout5 = new GridBagLayout();
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.anchor = 17;
        jPanel9.setLayout(gridBagLayout5);
        JLabel jLabel10 = new JLabel("Color scheme");
        this.buildConstraints(gridBagConstraints5, 0, 0, 1, 1, 33, 10);
        gridBagLayout5.setConstraints(jLabel10, gridBagConstraints5);
        jPanel9.add(jLabel10);
        Vector<String> vector = new Vector<String>();
        vector.add("default");
        vector.add("b&w");
        this.cbb = new JComboBox(vector);
        this.cbb.setMaximumRowCount(2);
        this.cbb.setSelectedItem(ConfigManager.COLOR_SCHEME);
        this.buildConstraints(gridBagConstraints5, 1, 0, 1, 1, 66, 0);
        gridBagLayout5.setConstraints(this.cbb, gridBagConstraints5);
        jPanel9.add(this.cbb);
        this.antialiascb = new JCheckBox("Antialiasing", Editor.ANTIALIASING);
        this.antialiascb.addActionListener(this);
        this.buildConstraints(gridBagConstraints5, 0, 1, 2, 1, 100, 10);
        gridBagLayout5.setConstraints(this.antialiascb, gridBagConstraints5);
        jPanel9.add(this.antialiascb);
        JPanel jPanel10 = new JPanel();
        this.buildConstraints(gridBagConstraints5, 0, 2, 2, 1, 100, 80);
        gridBagLayout5.setConstraints(jPanel10, gridBagConstraints5);
        jPanel9.add(jPanel10);
        this.tabbedPane.addTab("Rendering", jPanel9);
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout6 = new GridBagLayout();
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.fill = 1;
        gridBagConstraints6.anchor = 17;
        container.setLayout(gridBagLayout6);
        this.buildConstraints(gridBagConstraints6, 0, 0, 3, 1, 100, 90);
        gridBagLayout6.setConstraints(this.tabbedPane, gridBagConstraints6);
        container.add(this.tabbedPane);
        JPanel jPanel11 = new JPanel();
        this.buildConstraints(gridBagConstraints6, 0, 1, 1, 1, 70, 10);
        gridBagLayout6.setConstraints(jPanel11, gridBagConstraints6);
        container.add(jPanel11);
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.anchor = 10;
        this.okPrefs = new JButton("Apply & Close");
        this.buildConstraints(gridBagConstraints6, 1, 1, 1, 1, 15, 10);
        gridBagLayout6.setConstraints(this.okPrefs, gridBagConstraints6);
        this.okPrefs.addActionListener(this);
        container.add(this.okPrefs);
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.anchor = 10;
        this.savePrefs = new JButton("Save");
        this.buildConstraints(gridBagConstraints6, 2, 1, 1, 1, 15, 10);
        gridBagLayout6.setConstraints(this.savePrefs, gridBagConstraints6);
        this.savePrefs.addActionListener(this);
        container.add(this.savePrefs);
        this.tabbedPane.setSelectedIndex(0);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
            }
        };
        this.addWindowListener(windowAdapter);
        this.setTitle("Preferences");
        this.pack();
        this.setLocation(0, 0);
        this.setSize(400, 300);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.brw1) {
            JFileChooser jFileChooser = new JFileChooser(Editor.m_TmpDir);
            jFileChooser.setFileSelectionMode(1);
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                Editor.m_TmpDir = jFileChooser.getSelectedFile();
                this.tf1.setText(Editor.m_TmpDir.toString());
            }
        } else if (object == this.brw2) {
            JFileChooser jFileChooser = new JFileChooser(Editor.projectDir);
            jFileChooser.setFileSelectionMode(1);
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                Editor.projectDir = jFileChooser.getSelectedFile();
                this.tf2.setText(Editor.projectDir.toString());
            }
        } else if (object == this.brw3) {
            JFileChooser jFileChooser = new JFileChooser(Editor.rdfDir);
            jFileChooser.setFileSelectionMode(1);
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                Editor.rdfDir = jFileChooser.getSelectedFile();
                this.tf3.setText(Editor.rdfDir.toString());
            }
        } else if (object == this.brw4) {
            JFileChooser jFileChooser = new JFileChooser(Editor.m_GraphVizPath);
            jFileChooser.setFileSelectionMode(0);
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                Editor.m_GraphVizPath = jFileChooser.getSelectedFile();
                this.tf4.setText(Editor.m_GraphVizPath.toString());
            }
        } else if (object == this.brw5) {
            JFileChooser jFileChooser = new JFileChooser(Editor.m_GraphVizFontDir);
            jFileChooser.setFileSelectionMode(1);
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                Editor.m_GraphVizFontDir = jFileChooser.getSelectedFile();
                this.tf5.setText(Editor.m_GraphVizFontDir.toString());
            }
        } else if (object == this.cb1) {
            Editor.dltOnExit = this.cb1.isSelected();
        } else if (object == this.detectBrowserBt) {
            if (this.detectBrowserBt.isSelected()) {
                Editor.autoDetectBrowser = true;
                this.browserPathTf.setEnabled(false);
                this.brw6.setEnabled(false);
                this.browserOptsTf.setEnabled(false);
                this.pathLb.setEnabled(false);
                this.optLb.setEnabled(false);
            }
        } else if (object == this.specifyBrowserBt) {
            if (this.specifyBrowserBt.isSelected()) {
                Editor.autoDetectBrowser = false;
                this.browserPathTf.setEnabled(true);
                this.brw6.setEnabled(true);
                this.browserOptsTf.setEnabled(true);
                this.pathLb.setEnabled(true);
                this.optLb.setEnabled(true);
            }
        } else if (object == this.brw6) {
            JFileChooser jFileChooser = new JFileChooser(Editor.browserPath);
            jFileChooser.setFileSelectionMode(0);
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                Editor.browserPath = jFileChooser.getSelectedFile();
                this.browserPathTf.setText(Editor.browserPath.toString());
            }
        } else if (object == this.webHelpBt) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            TextViewer textViewer = new TextViewer(new StringBuffer("--------------------------------------\nAUTOMATIC DETECTION\n--------------------------------------\nIsaViz can try to automatically detect your default web browser.\nThis feature is currently supported under Windows and some POSIX environments.\n\n--------------------------------------\nMANUAL CONFIGURATION\n--------------------------------------\nThe Path value should be the full command line path to your browser's main executable file. It can also be just this file's name if its parent directory is in your PATH environment variable.\n\nExamples:\nnetscape\n/usr/bin/netscape\nC:\\Program Files\\Internet Explorer\\IEXPLORE.EXE\n\nThe Command Line Options value is an optional field where you can put command line switches, like -remote for the UNIX version of Netscape that will open URLs in an already existing Netscape process (if it exists)."), "Web Browser Configuration", 0, (dimension.width - 400) / 2, (dimension.height - 300) / 2, 400, 300);
        } else if (object == this.useProxyCb) {
            this.proxyHostLb.setEnabled(this.useProxyCb.isSelected());
            this.proxyPortLb.setEnabled(this.useProxyCb.isSelected());
            this.proxyHostTf.setEnabled(this.useProxyCb.isSelected());
            this.proxyPortTf.setEnabled(this.useProxyCb.isSelected());
        } else if (object == this.proxyHelpBt) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            TextViewer textViewer = new TextViewer(new StringBuffer("If you are behind a firewall, you can manually set the proxy server to access remote resources.\n\nHostname should be the full name of the proxy server.\n\nPort should be the port number used to access external resources. This is a number (default value is 80)."), "Proxy Configuration", 0, (dimension.width - 400) / 2, (dimension.height - 300) / 2, 400, 300);
        } else if (object == this.okPrefs) {
            this.updateVars();
            this.dispose();
        } else if (object == this.savePrefs) {
            this.updateVars();
            this.application.saveConfig();
        } else if (object == this.antialiascb) {
            if (this.antialiascb.isSelected()) {
                JOptionPane.showMessageDialog(this, "Antialiasing requires additional computing resources.\nSetting it ON will noticeably reduce the refresh rate.\nIt is primarily aimed at producing higher quality images when exporting to PNG.");
            }
            this.application.setAntialiasing(this.antialiascb.isSelected());
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 && keyEvent.getSource() == this.spinner && !Utils.isPositiveInteger(this.spinner.getText())) {
            JOptionPane.showMessageDialog(this, this.spinner.getText() + " is not a valid number.");
            this.spinner.setText(String.valueOf(Editor.MAX_LIT_CHAR_COUNT));
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    void updateVars() {
        Editor.GRAPHVIZ_VERSION = this.gr2.isSelected() ? 1 : 0;
        Editor.DEFAULT_NAMESPACE = this.tf1a.getText() + ":";
        Editor.ANON_NODE = this.tf2a.getText() + ":";
        Editor.ALWAYS_INCLUDE_LANG_IN_LITERALS = this.cb1c.isSelected();
        Editor.DEFAULT_LANGUAGE_IN_LITERALS = this.tf1c.getText();
        this.application.setAbbrevSyntax(this.cb1a.isSelected());
        Editor.SAVE_WINDOW_LAYOUT = this.saveWindowLayoutCb.isSelected();
        if (Editor.SHOW_ANON_ID != this.cb1b.isSelected()) {
            this.application.showAnonIds(this.cb1b.isSelected());
        }
        if (Editor.DISP_AS_LABEL != this.dispAsLabelCb.isSelected()) {
            this.application.displayLabels(this.dispAsLabelCb.isSelected());
        }
        try {
            this.application.setMaxLiteralCharCount(new Integer(this.spinner.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, this.spinner.getText() + " is not a valid number.");
        }
        Editor.GRAPH_ORIENTATION = this.b1a.isSelected() ? "LR" : "TB";
        ConfigManager.assignColorsToGraph((String)this.cbb.getSelectedItem());
        Editor.browserPath = new File(this.browserPathTf.getText());
        Editor.browserOptions = this.browserOptsTf.getText();
        ConfigManager.updateProxy(this.useProxyCb.isSelected(), this.proxyHostTf.getText(), this.proxyPortTf.getText());
    }

    void buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4, int n5, int n6) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = n5;
        gridBagConstraints.weighty = n6;
    }
}

