/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.VEllipse;
import com.xerox.VTM.glyphs.VPath;
import com.xerox.VTM.glyphs.VRectangle;
import com.xerox.VTM.glyphs.VText;
import com.xerox.VTM.glyphs.VTriangleOr;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.IsaViz.ConfigManager;
import org.w3c.IsaViz.Editor;
import org.w3c.IsaViz.ILiteral;
import org.w3c.IsaViz.INode;
import org.w3c.IsaViz.IProperty;
import org.w3c.IsaViz.IResource;
import org.w3c.IsaViz.ProgPanel;
import org.w3c.IsaViz.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class ISVManager {
    Editor application;
    Hashtable uniqueIDs2INodes;
    Hashtable inodes2UniqueIDs;
    StringBuffer nextUniqueID;

    ISVManager(Editor editor) {
        this.application = editor;
    }

    public void openProject(File file) {
        ProgPanel progPanel = new ProgPanel("Resetting...", "Loading ISV");
        this.application.reset();
        Editor.lastOpenPrjDir = file.getParentFile();
        progPanel.setPBValue(10);
        progPanel.setLabel("Loading file " + file.toString() + " ...");
        Editor.projectFile = file;
        Editor.vsm.getView("Graph").setCursorIcon(3);
        Editor.vsm.getView("Graph").setStatusBarText("Loading project to " + file.toString() + " ...");
        this.uniqueIDs2INodes = new Hashtable();
        progPanel.setPBValue(20);
        progPanel.setLabel("Parsing...");
        try {
            Element element;
            int n;
            NodeList nodeList;
            Document document = this.application.xmlMngr.parse(file.toString(), true);
            document.normalize();
            Element element2 = document.getDocumentElement();
            progPanel.setPBValue(30);
            progPanel.setLabel("Processing namespace bindings...");
            if (element2.getElementsByTagNameNS(Editor.isavizURI, "nsBindings").getLength() > 0) {
                nodeList = ((Element)element2.getElementsByTagNameNS(Editor.isavizURI, "nsBindings").item(0)).getElementsByTagNameNS(Editor.isavizURI, "nsBinding");
                n = 0;
                while (n < nodeList.getLength()) {
                    element = (Element)nodeList.item(n);
                    this.application.addNamespaceBinding(element.getAttribute("prefix"), element.getAttribute("uri"), new Boolean(element.getAttribute("dispPrefix")), true, true);
                    ++n;
                }
            }
            progPanel.setPBValue(40);
            progPanel.setLabel("Processing property types...");
            if (element2.getElementsByTagNameNS(Editor.isavizURI, "propertyTypes").getLength() > 0) {
                nodeList = ((Element)element2.getElementsByTagNameNS(Editor.isavizURI, "propertyTypes").item(0)).getElementsByTagNameNS(Editor.isavizURI, "propertyType");
                n = 0;
                while (n < nodeList.getLength()) {
                    element = (Element)nodeList.item(n);
                    this.application.addPropertyType(element.getAttribute("ns"), element.getAttribute("name"), true);
                    ++n;
                }
            }
            progPanel.setPBValue(50);
            progPanel.setLabel("Processing resources...");
            if (element2.getElementsByTagNameNS(Editor.isavizURI, "resources").getLength() > 0) {
                nodeList = ((Element)element2.getElementsByTagNameNS(Editor.isavizURI, "resources").item(0)).getElementsByTagNameNS(Editor.isavizURI, "iresource");
                int n2 = 0;
                while (n2 < nodeList.getLength()) {
                    this.createIResourceFromISV((Element)nodeList.item(n2));
                    ++n2;
                }
            }
            progPanel.setPBValue(60);
            progPanel.setLabel("Processing literals...");
            if (element2.getElementsByTagNameNS(Editor.isavizURI, "literals").getLength() > 0) {
                nodeList = ((Element)element2.getElementsByTagNameNS(Editor.isavizURI, "literals").item(0)).getElementsByTagNameNS(Editor.isavizURI, "iliteral");
                int n3 = 0;
                while (n3 < nodeList.getLength()) {
                    this.createILiteralFromISV((Element)nodeList.item(n3));
                    ++n3;
                }
            }
            progPanel.setPBValue(80);
            progPanel.setLabel("Processing properties...");
            if (element2.getElementsByTagNameNS(Editor.isavizURI, "properties").getLength() > 0) {
                nodeList = ((Element)element2.getElementsByTagNameNS(Editor.isavizURI, "properties").item(0)).getElementsByTagNameNS(Editor.isavizURI, "iproperty");
                int n4 = 0;
                while (n4 < nodeList.getLength()) {
                    this.createIPropertyFromISV((Element)nodeList.item(n4));
                    ++n4;
                }
            }
            progPanel.setLabel("Building graphical representation...");
            progPanel.setPBValue(100);
            ConfigManager.assignColorsToGraph();
            this.application.showAnonIds(Editor.SHOW_ANON_ID);
            this.application.showResourceLabels(Editor.DISP_AS_LABEL);
            this.uniqueIDs2INodes = null;
            Editor.vsm.getGlobalView(Editor.vsm.getVirtualSpace("rdfSpace").getCamera(0), 500);
            Editor.vsm.getView("Graph").setStatusBarText("Loading project to " + file.toString() + " ...done");
        }
        catch (Exception exception) {
            this.application.errorMessages.append("An error occured while loading file " + file + "\nThis might not be a valid ISV project file.\n" + exception);
            this.application.reportError = true;
        }
        if (this.application.reportError) {
            Editor.vsm.getView("Graph").setStatusBarText("There were error/warning messages ('Ctrl+E' to display error log)");
            this.application.reportError = false;
        }
        Editor.vsm.getView("Graph").setCursorIcon(-1);
        progPanel.destroy();
    }

    public void saveProject(File file) {
        Editor.projectFile = file;
        Editor.lastSavePrjDir = file.getParentFile();
        Editor.vsm.getView("Graph").setCursorIcon(3);
        Editor.vsm.getView("Graph").setStatusBarText("Saving project to " + file.toString() + " ...");
        DOMImplementationImpl dOMImplementationImpl = new DOMImplementationImpl();
        Document document = dOMImplementationImpl.createDocument(Editor.isavizURI, "isv:project", null);
        Element element = document.getDocumentElement();
        element.setAttribute("xmlns:isv", Editor.isavizURI);
        Element element2 = document.createElementNS(Editor.isavizURI, "isv:nsBindings");
        element.appendChild(element2);
        int n = 0;
        while (n < this.application.tblp.nsTableModel.getRowCount()) {
            if (((String)this.application.tblp.nsTableModel.getValueAt(n, 0)).length() > 0 && ((String)this.application.tblp.nsTableModel.getValueAt(n, 1)).length() > 0) {
                Element element3 = document.createElementNS(Editor.isavizURI, "isv:nsBinding");
                element3.setAttribute("prefix", (String)this.application.tblp.nsTableModel.getValueAt(n, 0));
                element3.setAttribute("uri", (String)this.application.tblp.nsTableModel.getValueAt(n, 1));
                element3.setAttribute("dispPrefix", ((Boolean)this.application.tblp.nsTableModel.getValueAt(n, 2)).toString());
                element2.appendChild(element3);
            }
            ++n;
        }
        Element element4 = document.createElementNS(Editor.isavizURI, "isv:propertyTypes");
        element.appendChild(element4);
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.application.tblp.prTable.getModel();
        int n2 = 0;
        while (n2 < defaultTableModel.getRowCount()) {
            Element element5 = document.createElementNS(Editor.isavizURI, "isv:propertyType");
            element5.setAttribute("ns", (String)defaultTableModel.getValueAt(n2, 0));
            element5.setAttribute("name", (String)defaultTableModel.getValueAt(n2, 2));
            element4.appendChild(element5);
            ++n2;
        }
        this.inodes2UniqueIDs = new Hashtable();
        this.nextUniqueID = new StringBuffer("0");
        Enumeration enumeration = this.application.resourcesByURI.elements();
        while (enumeration.hasMoreElements()) {
            this.inodes2UniqueIDs.put(enumeration.nextElement(), this.nextUniqueID.toString());
            this.incPrjID();
        }
        Enumeration enumeration2 = this.application.literals.elements();
        while (enumeration2.hasMoreElements()) {
            this.inodes2UniqueIDs.put(enumeration2.nextElement(), this.nextUniqueID.toString());
            this.incPrjID();
        }
        Element element6 = document.createElementNS(Editor.isavizURI, "isv:resources");
        element.appendChild(element6);
        Enumeration enumeration3 = this.application.resourcesByURI.elements();
        while (enumeration3.hasMoreElements()) {
            element6.appendChild(((IResource)enumeration3.nextElement()).toISV(document, this));
        }
        Element element7 = document.createElementNS(Editor.isavizURI, "isv:literals");
        element.appendChild(element7);
        Enumeration enumeration4 = this.application.literals.elements();
        while (enumeration4.hasMoreElements()) {
            element7.appendChild(((ILiteral)enumeration4.nextElement()).toISV(document, this));
        }
        Element element8 = document.createElementNS(Editor.isavizURI, "isv:properties");
        element.appendChild(element8);
        Enumeration enumeration5 = this.application.propertiesByURI.elements();
        while (enumeration5.hasMoreElements()) {
            Vector vector = (Vector)enumeration5.nextElement();
            Enumeration enumeration6 = vector.elements();
            while (enumeration6.hasMoreElements()) {
                element8.appendChild(((IProperty)enumeration6.nextElement()).toISV(document, this));
            }
        }
        this.inodes2UniqueIDs = null;
        this.application.xmlMngr.serialize(document, file);
        Editor.vsm.getView("Graph").setStatusBarText("Saving project to " + file.toString() + " ...done");
        if (this.application.reportError) {
            Editor.vsm.getView("Graph").setStatusBarText("There were error/warning messages ('Ctrl+E' to display error log)");
            this.application.reportError = false;
        }
        Editor.vsm.getView("Graph").setCursorIcon(-1);
    }

    protected String getPrjId(Object object) {
        return (String)this.inodes2UniqueIDs.get(object);
    }

    private void incPrjID() {
        byte by;
        boolean bl = false;
        int n = 0;
        while (n < this.nextUniqueID.length()) {
            by = (byte)this.nextUniqueID.charAt(n);
            if (by < 122) {
                this.nextUniqueID.setCharAt(n, (char)Utils.incByte(by));
                bl = true;
                int n2 = 0;
                while (n2 < n) {
                    this.nextUniqueID.setCharAt(n2, '0');
                    ++n2;
                }
                break;
            }
            ++n;
        }
        if (!bl) {
            by = 0;
            while (by < this.nextUniqueID.length()) {
                this.nextUniqueID.setCharAt(by, '0');
                by = (byte)(by + 1);
            }
            this.nextUniqueID.append('0');
        }
    }

    IResource createIResourceFromISV(Element element) {
        boolean bl;
        IResource iResource = null;
        long l = new Long(element.getAttribute("x"));
        long l2 = new Long(element.getAttribute("y"));
        long l3 = new Long(element.getAttribute("w"));
        long l4 = new Long(element.getAttribute("h"));
        VEllipse vEllipse = new VEllipse(l, l2, 0.0f, l3, l4, ConfigManager.resourceColorF);
        boolean bl2 = false;
        if (element.hasAttribute("isAnon")) {
            bl2 = new Boolean(element.getAttribute("isAnon"));
        }
        Editor.vsm.addGlyph((Glyph)vEllipse, "rdfSpace");
        NodeList nodeList = element.getElementsByTagNameNS(Editor.isavizURI, "URIorID");
        if (nodeList.getLength() > 0) {
            String string;
            Element element2 = (Element)nodeList.item(0);
            long l5 = new Long(element2.getAttribute("x"));
            long l6 = new Long(element2.getAttribute("y"));
            if (bl2) {
                string = null;
                if (element2.getElementsByTagNameNS(Editor.isavizURI, "anonID").getLength() > 0) {
                    string = Editor.ANON_NODE + element2.getElementsByTagNameNS(Editor.isavizURI, "anonID").item(0).getFirstChild().getNodeValue();
                }
                iResource = this.application.addAnonymousResource(string);
            } else {
                String string2;
                try {
                    string = element2.getElementsByTagNameNS(Editor.isavizURI, "namespace").item(0).getFirstChild().getNodeValue();
                }
                catch (NullPointerException nullPointerException) {
                    string = Editor.DEFAULT_NAMESPACE;
                }
                try {
                    string2 = element2.getElementsByTagNameNS(Editor.isavizURI, "localname").item(0).getFirstChild().getNodeValue();
                }
                catch (NullPointerException nullPointerException) {
                    string2 = "";
                }
                iResource = this.application.addResource(string, string2);
            }
            string = new VText(l5, l6, 0.0f, ConfigManager.resourceColorTB, iResource.getIdent());
            Editor.vsm.addGlyph((Glyph)string, "rdfSpace");
            iResource.setGlyphText((VText)string);
        } else {
            iResource = new IResource();
        }
        iResource.setGlyph(vEllipse);
        this.uniqueIDs2INodes.put(element.getAttribute("id"), iResource);
        if (element.hasAttribute("commented") && (bl = new Boolean(element.getAttribute("commented")).booleanValue())) {
            this.application.commentNode(iResource, true);
        }
        return iResource;
    }

    ILiteral createILiteralFromISV(Element element) {
        boolean bl;
        ILiteral iLiteral = null;
        long l = new Long(element.getAttribute("x"));
        long l2 = new Long(element.getAttribute("y"));
        long l3 = new Long(element.getAttribute("w"));
        long l4 = new Long(element.getAttribute("h"));
        VRectangle vRectangle = new VRectangle(l, l2, 0.0f, l3, l4, ConfigManager.literalColorF);
        Editor.vsm.addGlyph((Glyph)vRectangle, "rdfSpace");
        NodeList nodeList = element.getElementsByTagNameNS(Editor.isavizURI, "value");
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            long l5 = new Long(element2.getAttribute("x"));
            long l6 = new Long(element2.getAttribute("y"));
            String string = element2.getFirstChild().getNodeValue();
            String string2 = string.length() >= Editor.MAX_LIT_CHAR_COUNT ? string.substring(0, Editor.MAX_LIT_CHAR_COUNT) + " ..." : string;
            boolean bl2 = true;
            if (element2.hasAttribute("escapeXML")) {
                bl2 = new Boolean(element2.getAttribute("escapeXML"));
            }
            VText vText = new VText(l5, l6, 0.0f, ConfigManager.literalColorTB, string2);
            Editor.vsm.addGlyph((Glyph)vText, "rdfSpace");
            iLiteral = this.application.addLiteral(string, null, bl2);
            iLiteral.setGlyphText(vText);
        } else {
            iLiteral = this.application.addLiteral("", null, true);
        }
        if (element.hasAttribute("xml:lang")) {
            iLiteral.setLanguage(element.getAttribute("xml:lang"));
        }
        iLiteral.setGlyph(vRectangle);
        this.uniqueIDs2INodes.put(element.getAttribute("id"), iLiteral);
        if (element.hasAttribute("commented") && (bl = new Boolean(element.getAttribute("commented")).booleanValue())) {
            this.application.commentNode(iLiteral, true);
        }
        return iLiteral;
    }

    IProperty createIPropertyFromISV(Element element) {
        boolean bl;
        INode iNode;
        Object object;
        IProperty iProperty = null;
        Element element2 = (Element)element.getElementsByTagNameNS(Editor.isavizURI, "path").item(0);
        String string = element2.getAttribute("d");
        Element element3 = (Element)element.getElementsByTagNameNS(Editor.isavizURI, "head").item(0);
        long l = new Long(element3.getAttribute("x"));
        long l2 = new Long(element3.getAttribute("y"));
        long l3 = new Long(element3.getAttribute("w"));
        float f = new Float(element3.getAttribute("or")).floatValue();
        VPath vPath = new VPath(0.0f, ConfigManager.propertyColorB, string);
        VTriangleOr vTriangleOr = new VTriangleOr(l, l2, 0.0f, l3, ConfigManager.propertyColorB, f);
        Editor.vsm.addGlyph((Glyph)vTriangleOr, "rdfSpace");
        Editor.vsm.addGlyph((Glyph)vPath, "rdfSpace");
        NodeList nodeList = element.getElementsByTagNameNS(Editor.isavizURI, "uri");
        String string2 = "";
        String string3 = "";
        if (nodeList.getLength() > 0) {
            object = (Element)nodeList.item(0);
            string2 = object.getElementsByTagNameNS(Editor.isavizURI, "namespace").item(0).getFirstChild().getNodeValue();
            string3 = object.getElementsByTagNameNS(Editor.isavizURI, "localname").item(0).getFirstChild().getNodeValue();
            long l4 = new Long(object.getAttribute("x"));
            long l5 = new Long(object.getAttribute("y"));
            String string4 = "";
            boolean bl2 = false;
            int n = 0;
            while (n < this.application.tblp.nsTableModel.getRowCount()) {
                if (((String)this.application.tblp.nsTableModel.getValueAt(n, 1)).equals(string2)) {
                    string4 = (Boolean)this.application.tblp.nsTableModel.getValueAt(n, 2) != false ? (String)this.application.tblp.nsTableModel.getValueAt(n, 0) + ":" + string3 : string2 + string3;
                    bl2 = true;
                    break;
                }
                ++n;
            }
            if (!bl2) {
                string4 = string2 + string3;
            }
            VText vText = new VText(l4, l5, 0.0f, ConfigManager.propertyColorT, string4);
            Editor.vsm.addGlyph((Glyph)vText, "rdfSpace");
            iProperty = this.application.addProperty(string2, string3);
            iProperty.setGlyphText(vText);
        } else {
            iProperty = new IProperty();
        }
        iProperty.setGlyph(vPath, vTriangleOr);
        object = (IResource)this.uniqueIDs2INodes.get(element.getAttribute("sb"));
        iProperty.setSubject((IResource)object);
        ((IResource)object).addOutgoingPredicate(iProperty);
        Object v = this.uniqueIDs2INodes.get(element.getAttribute("ob"));
        if (v instanceof IResource) {
            iNode = (IResource)v;
            iProperty.setObject((IResource)iNode);
            ((IResource)iNode).addIncomingPredicate(iProperty);
        } else {
            iNode = (ILiteral)v;
            iProperty.setObject((ILiteral)iNode);
            ((ILiteral)iNode).setIncomingPredicate(iProperty);
            if (iProperty.getIdent().equals(Editor.RDFS_NAMESPACE_URI + "label")) {
                ((IResource)object).setLabel(((ILiteral)iNode).getValue());
            }
        }
        if (element.hasAttribute("commented") && (bl = new Boolean(element.getAttribute("commented")).booleanValue())) {
            this.application.commentPredicate(iProperty, true);
        }
        return iProperty;
    }
}

