/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.IsaViz;

import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.xerox.VTM.engine.LongPoint;
import com.xerox.VTM.engine.SwingWorker;
import com.xerox.VTM.engine.VirtualSpace;
import com.xerox.VTM.engine.VirtualSpaceManager;
import com.xerox.VTM.glyphs.Glyph;
import com.xerox.VTM.glyphs.VEllipse;
import com.xerox.VTM.glyphs.VPath;
import com.xerox.VTM.glyphs.VRectangle;
import com.xerox.VTM.glyphs.VText;
import com.xerox.VTM.glyphs.VTriangleOr;
import com.xerox.VTM.svg.SVGReader;
import com.xerox.VTM.svg.SVGWriter;
import java.awt.Font;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.w3c.IsaViz.ConfigManager;
import org.w3c.IsaViz.ContMenuManager;
import org.w3c.IsaViz.EditorEvtHdlr;
import org.w3c.IsaViz.GeometryManager;
import org.w3c.IsaViz.IContainer;
import org.w3c.IsaViz.ILiteral;
import org.w3c.IsaViz.INode;
import org.w3c.IsaViz.IProperty;
import org.w3c.IsaViz.IResource;
import org.w3c.IsaViz.ISVCommand;
import org.w3c.IsaViz.ISVCopy;
import org.w3c.IsaViz.ISVCut;
import org.w3c.IsaViz.ISVDelete;
import org.w3c.IsaViz.ISVManager;
import org.w3c.IsaViz.ISVPaste;
import org.w3c.IsaViz.MainCmdPanel;
import org.w3c.IsaViz.NewLitPanel;
import org.w3c.IsaViz.NewResPanel;
import org.w3c.IsaViz.PropertySummary;
import org.w3c.IsaViz.PropsPanel;
import org.w3c.IsaViz.RDFLoader;
import org.w3c.IsaViz.SplashWindow;
import org.w3c.IsaViz.TablePanel;
import org.w3c.IsaViz.TextViewer;
import org.w3c.IsaViz.Utils;
import org.w3c.IsaViz.WebBrowser;
import org.w3c.IsaViz.XMLManager;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class Editor {
    static String isavizURI = "http://www.w3.org/2001/10/IsaViz";
    static String RDFMS_NAMESPACE_PREFIX = "rdf";
    static String RDFMS_NAMESPACE_URI = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    static String RDFS_NAMESPACE_PREFIX = "rdfs";
    static String RDFS_NAMESPACE_URI = "http://www.w3.org/2000/01/rdf-schema#";
    static String DEFAULT_NAMESPACE = "online:";
    static String ANON_NODE = "genid:";
    static String MEMBERSHIP_PROP_CONSTRUCTOR = "_??   (Membership property auto-numbering: _1, _2, ...)";
    static String DEFAULT_LANGUAGE_IN_LITERALS = "en";
    static boolean ALWAYS_INCLUDE_LANG_IN_LITERALS = false;
    static boolean ABBREV_SYNTAX = false;
    static boolean SHOW_ANON_ID = false;
    static boolean DISP_AS_LABEL = false;
    static int MAX_LIT_CHAR_COUNT = 40;
    static String GRAPH_ORIENTATION = "LR";
    static int GRAPHVIZ_VERSION = 0;
    JFileChooser fc;
    static File cfgFile;
    static String argFile;
    static File projectFile;
    static String tmpRdfFile;
    static File m_GraphVizPath;
    static File m_GraphVizFontDir;
    static File m_TmpDir;
    static File projectDir;
    static File lastOpenPrjDir;
    static File lastSavePrjDir;
    static File rdfDir;
    static File lastImportRDFDir;
    static File lastExportRDFDir;
    static boolean dltOnExit;
    static int MAX_BRW_LIST_SIZE;
    static int UNDO_SIZE;
    static boolean SAVE_WINDOW_LAYOUT;
    static final String mainVirtualSpace = "rdfSpace";
    static final String mainView = "Graph";
    static final String resEllipseType = "resG";
    static final String resTextType = "resT";
    static final String propPathType = "prdG";
    static final String propHeadType = "prdH";
    static final String propTextType = "prdT";
    static final String litRectType = "litG";
    static final String litTextType = "litT";
    static int ARROW_HEAD_SIZE;
    static Font smallFont;
    static Font tinyFont;
    static String vtmFontName;
    static int vtmFontSize;
    static Font vtmFont;
    static boolean ANTIALIASING;
    static VirtualSpaceManager vsm;
    EditorEvtHdlr eeh;
    RDFLoader rdfLdr;
    XMLManager xmlMngr;
    ISVManager isvMngr;
    ConfigManager cfgMngr;
    GeometryManager geomMngr;
    ContMenuManager ctmnMngr;
    ISVCommand[] undoStack;
    int undoIndex;
    MainCmdPanel cmp;
    TablePanel tblp;
    PropsPanel propsp;
    static WebBrowser webBrowser;
    static boolean autoDetectBrowser;
    static File browserPath;
    static String browserOptions;
    static boolean useProxy;
    static String proxyHost;
    static String proxyPort;
    Hashtable resourcesByURI;
    Hashtable propertiesByURI;
    Vector literals;
    StringBuffer nextAnonID = new StringBuffer("0");
    Vector selectedResources = new Vector();
    Vector selectedLiterals = new Vector();
    Vector selectedPredicates = new Vector();
    static INode lastSelectedItem;
    Vector copiedResources = new Vector();
    Vector copiedLiterals = new Vector();
    Vector copiedPredicates = new Vector();
    Model rdfModel;
    String selectedPropertyConstructorNS;
    String selectedPropertyConstructorLN;
    int searchIndex = 0;
    String lastSearchedString = "";
    Vector matchingList = new Vector();
    INode lastMatchingEntity = null;
    StringBuffer errorMessages;
    boolean reportError;

    public Editor() {
        SplashWindow splashWindow = new SplashWindow(2000, "images/IsavizSplash.gif", false);
        File file = new File(System.getProperty("user.home") + "/isaviz.cfg");
        cfgFile = file.exists() ? file : new File("isaviz.cfg");
        vsm = new VirtualSpaceManager();
        vsm.setMainFont(vtmFont);
        this.cfgMngr = new ConfigManager(this);
        this.geomMngr = new GeometryManager(this);
        this.isvMngr = new ISVManager(this);
        this.ctmnMngr = new ContMenuManager(this);
        splashWindow.setProgressBarValue(10);
        ConfigManager.initLookAndFeel();
        splashWindow.setProgressBarValue(20);
        this.cfgMngr.initWindows();
        splashWindow.setProgressBarValue(30);
        this.xmlMngr = new XMLManager(this);
        splashWindow.setProgressBarValue(40);
        this.resourcesByURI = new Hashtable();
        splashWindow.setProgressBarValue(50);
        this.propertiesByURI = new Hashtable();
        splashWindow.setProgressBarValue(60);
        this.literals = new Vector();
        this.errorMessages = new StringBuffer();
        this.reportError = false;
        this.undoStack = new ISVCommand[UNDO_SIZE];
        this.undoIndex = -1;
        splashWindow.setProgressBarValue(70);
        ConfigManager.assignColorsToGraph();
        splashWindow.setProgressBarValue(80);
        this.cfgMngr.initConfig();
        splashWindow.setProgressBarValue(90);
        this.cfgMngr.layoutWindows();
        splashWindow.setProgressBarValue(100);
        cfgFile = new File(System.getProperty("user.home") + "/isaviz.cfg");
        if (m_TmpDir.exists()) {
            if (argFile != null) {
                if (argFile.endsWith(".isv")) {
                    this.isvMngr.openProject(new File(argFile));
                } else if (argFile.endsWith(".n3")) {
                    this.loadRDF(new File(argFile), RDFLoader.NTRIPLE_READER);
                } else {
                    this.loadRDF(new File(argFile), RDFLoader.RDF_XML_READER);
                }
            } else {
                vsm.getGlobalView(vsm.getVirtualSpace(mainVirtualSpace).getCamera(0), 100);
            }
        } else {
            JOptionPane.showMessageDialog(this.cmp, "You need to select a temporary directory for IsaViz\nin the Directories tab of the Preferences Panel, or some functions will not work properly.\nThe current directory (" + m_TmpDir + ") does not exist.");
        }
    }

    void promptReset() {
        Object[] objectArray = new Object[]{"Yes", "No"};
        int n = JOptionPane.showOptionDialog(null, "You are about to reset your project.\nAre you sure you want to continue?", "Warning", -1, 2, null, objectArray, objectArray[0]);
        if (n == 0) {
            vsm.getView(mainView).setStatusBarText("New project");
            this.reset();
        }
    }

    public void reset() {
        if (this.rdfLdr != null) {
            this.rdfLdr.reset();
        }
        projectFile = null;
        this.propsp.reset();
        this.matchingList = new Vector();
        this.resourcesByURI.clear();
        this.propertiesByURI.clear();
        this.literals.removeAllElements();
        this.resetNamespaceBindings();
        this.resetPropertyConstructors();
        this.resetPropertyBrowser();
        this.reportError = false;
        this.rdfModel = null;
        this.nextAnonID = new StringBuffer("0");
        this.resetSelected();
        this.resetCopied();
        lastSelectedItem = null;
        Utils.resetArray(this.undoStack);
        this.undoIndex = -1;
        this.cmp.enableUndo(false);
        this.geomMngr.resetLastResizer();
        vsm.destroyGlyphsInSpace(mainVirtualSpace);
        SVGReader.setPositionOffset((long)0L, (long)0L);
        vsm.repaintNow();
    }

    void resetSelected() {
        this.selectedResources.removeAllElements();
        this.selectedLiterals.removeAllElements();
        this.selectedPredicates.removeAllElements();
    }

    void resetCopied() {
        this.copiedResources.removeAllElements();
        this.copiedLiterals.removeAllElements();
        this.copiedPredicates.removeAllElements();
        this.cmp.enablePaste(false);
    }

    void resetNamespaceBindings() {
        this.tblp.resetNamespaceTable();
        this.addNamespaceBinding(RDFMS_NAMESPACE_PREFIX, RDFMS_NAMESPACE_URI, new Boolean(false), true, false);
        this.addNamespaceBinding(RDFS_NAMESPACE_PREFIX, RDFS_NAMESPACE_URI, new Boolean(false), true, false);
    }

    void resetPropertyConstructors() {
        this.tblp.resetPropertyTable();
        this.initRDFMSProperties();
        this.initRDFSProperties();
    }

    void resetPropertyBrowser() {
        this.tblp.resetBrowser();
    }

    void openProject() {
        this.fc = new JFileChooser(lastOpenPrjDir != null ? lastOpenPrjDir : projectDir);
        int n = this.fc.showOpenDialog(this.cmp);
        if (n == 0) {
            this.errorMessages.append("-----Loading ISV project-----\n");
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    Editor.this.isvMngr.openProject(Editor.this.fc.getSelectedFile());
                    return null;
                }
            };
            swingWorker.start();
        }
    }

    void saveProject() {
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                Editor.this.isvMngr.saveProject(projectFile);
                return null;
            }
        };
        swingWorker.start();
    }

    void saveProjectAs() {
        this.fc = new JFileChooser(lastSavePrjDir != null ? lastSavePrjDir : projectDir);
        int n = this.fc.showSaveDialog(this.cmp);
        if (n == 0) {
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    Editor.this.isvMngr.saveProject(Editor.this.fc.getSelectedFile());
                    return null;
                }
            };
            swingWorker.start();
        }
    }

    String nextAnonymousID() {
        this.incAnonID();
        while (this.resourcesByURI.containsKey(ANON_NODE + this.nextAnonID)) {
            this.incAnonID();
        }
        return ANON_NODE + this.nextAnonID;
    }

    private void incAnonID() {
        byte by;
        boolean bl = false;
        int n = 0;
        while (n < this.nextAnonID.length()) {
            by = (byte)this.nextAnonID.charAt(n);
            if (by < 122) {
                this.nextAnonID.setCharAt(n, (char)Utils.incByte(by));
                bl = true;
                int n2 = 0;
                while (n2 < n) {
                    this.nextAnonID.setCharAt(n2, '0');
                    ++n2;
                }
                break;
            }
            ++n;
        }
        if (!bl) {
            by = 0;
            while (by < this.nextAnonID.length()) {
                this.nextAnonID.setCharAt(by, '0');
                by = (byte)(by + 1);
            }
            this.nextAnonID.append('0');
        }
    }

    public void loadRDF(final File file, final int n) {
        if (m_GraphVizPath.exists()) {
            this.reset();
            this.errorMessages.append("-----Importing RDF-----\n");
            lastImportRDFDir = file.getParentFile();
            if (this.rdfLdr == null) {
                this.rdfLdr = new RDFLoader(this);
            }
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    vsm.getView(Editor.mainView).setCursorIcon(3);
                    Editor.this.rdfLdr.load(file, n);
                    vsm.getView(Editor.mainView).setCursorIcon(-1);
                    return null;
                }
            };
            swingWorker.start();
        } else {
            JOptionPane.showMessageDialog(this.cmp, "The current location of GraphViz/dot (" + m_GraphVizPath + ") is not valid.\nGo to the Directories tab in Preferences and browse\nto the location of your dot executable file (dot or dot.exe)");
        }
    }

    public void loadRDF(final URL uRL, final int n) {
        if (m_GraphVizPath.exists()) {
            this.reset();
            this.errorMessages.append("-----Importing RDF-----\n");
            if (this.rdfLdr == null) {
                this.rdfLdr = new RDFLoader(this);
            }
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    vsm.getView(Editor.mainView).setCursorIcon(3);
                    Editor.this.rdfLdr.load(uRL, n);
                    vsm.getView(Editor.mainView).setCursorIcon(-1);
                    return null;
                }
            };
            swingWorker.start();
        } else {
            JOptionPane.showMessageDialog(this.cmp, "The current location of GraphViz/dot (" + m_GraphVizPath + ") is not valid.\nGo to the Directories tab in Preferences and browse\nto the location of your dot executable file (dot or dot.exe)");
        }
    }

    public void mergeRDF(final File file, final int n) {
        if (m_GraphVizPath.exists()) {
            lastImportRDFDir = file.getParentFile();
            this.errorMessages.append("-----Merging-----\n");
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    vsm.getView(Editor.mainView).setCursorIcon(3);
                    Editor.this.generateJenaModel();
                    try {
                        Editor.this.rdfModel.add(Editor.this.rdfLdr.merge(file, n));
                    }
                    catch (RDFException rDFException) {
                        Editor.this.errorMessages.append("Editor.mergeRDF() " + (Object)((Object)rDFException) + "\n");
                        Editor.this.reportError = true;
                    }
                    File file2 = Utils.createTempFile(m_TmpDir.toString(), "mrg", ".rdf");
                    boolean bl = ABBREV_SYNTAX;
                    ABBREV_SYNTAX = true;
                    Editor.this.rdfLdr.save(Editor.this.rdfModel, file2);
                    if (!bl) {
                        ABBREV_SYNTAX = false;
                    }
                    Editor.this.reset();
                    Editor.this.rdfLdr.load(file2, 0);
                    if (dltOnExit && file2 != null) {
                        file2.delete();
                    }
                    vsm.getView(Editor.mainView).setCursorIcon(-1);
                    return null;
                }
            };
            swingWorker.start();
        } else {
            JOptionPane.showMessageDialog(this.cmp, "The current location of GraphViz/dot (" + m_GraphVizPath + ") is not valid.\nGo to the Directories tab in Preferences and browse\nto the location of your dot executable file (dot or dot.exe)");
        }
    }

    public void mergeRDF(final URL uRL, final int n) {
        if (m_GraphVizPath.exists()) {
            this.errorMessages.append("-----Merging-----\n");
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    vsm.getView(Editor.mainView).setCursorIcon(3);
                    Editor.this.generateJenaModel();
                    try {
                        Editor.this.rdfModel.add(Editor.this.rdfLdr.merge(uRL, n));
                    }
                    catch (RDFException rDFException) {
                        Editor.this.errorMessages.append("Editor.mergeRDF() " + (Object)((Object)rDFException) + "\n");
                        Editor.this.reportError = true;
                    }
                    File file = Utils.createTempFile(m_TmpDir.toString(), "mrg", ".rdf");
                    boolean bl = ABBREV_SYNTAX;
                    ABBREV_SYNTAX = true;
                    Editor.this.rdfLdr.save(Editor.this.rdfModel, file);
                    if (!bl) {
                        ABBREV_SYNTAX = false;
                    }
                    Editor.this.reset();
                    Editor.this.rdfLdr.load(file, 0);
                    if (dltOnExit) {
                        file.delete();
                    }
                    vsm.getView(Editor.mainView).setCursorIcon(-1);
                    return null;
                }
            };
            swingWorker.start();
        } else {
            JOptionPane.showMessageDialog(this.cmp, "The current location of GraphViz/dot (" + m_GraphVizPath + ") is not valid.\nGo to the Directories tab in Preferences and browse\nto the location of your dot executable file (dot or dot.exe)");
        }
    }

    public void loadPropertyTypes(final File file) {
        if (this.rdfLdr == null) {
            this.rdfLdr = new RDFLoader(this);
        }
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                Editor.this.rdfLdr.loadProperties(file);
                return null;
            }
        };
        swingWorker.start();
    }

    void generateJenaModel() {
        if (this.rdfLdr == null) {
            this.rdfLdr = new RDFLoader(this);
        }
        this.rdfLdr.generateJenaModel();
    }

    public void exportRDF(File file) {
        vsm.getView(mainView).setCursorIcon(3);
        lastExportRDFDir = file.getParentFile();
        if (this.rdfLdr == null) {
            this.rdfLdr = new RDFLoader(this);
        }
        this.rdfLdr.generateJenaModel();
        this.rdfLdr.save(this.rdfModel, file);
        vsm.getView(mainView).setCursorIcon(-1);
    }

    public void exportNTriples(File file) {
        vsm.getView(mainView).setCursorIcon(3);
        lastExportRDFDir = file.getParentFile();
        if (this.rdfLdr == null) {
            this.rdfLdr = new RDFLoader(this);
        }
        this.generateJenaModel();
        this.rdfLdr.saveAsTriples(this.rdfModel, file);
        vsm.getView(mainView).setCursorIcon(-1);
    }

    public void exportPNG(File file) {
        Object object;
        boolean bl = true;
        if (!Utils.javaVersionIs140OrLater()) {
            object = new Object[]{"Yes", "No"};
            int n = JOptionPane.showOptionDialog(null, "This functionality is only available when running IsaViz using a JVM version 1.4.0 or later (it requires the ImageIO API).\nIsaViz detected JVM version " + System.getProperty("java.vm.version") + "\nDo you want to proceed anyway (this will probably cause an error)?", "Warning", -1, 2, null, (Object[])object, object[0]);
            if (n != 0) {
                bl = false;
            }
        }
        if (bl) {
            vsm.getView(mainView).setCursorIcon(3);
            lastExportRDFDir = file.getParentFile();
            vsm.getView(mainView).setStatusBarText("Exporting to PNG " + file.toString() + " ... (This operation can take some time)");
            object = ImageIO.getImageWritersByFormatName("png").next();
            try {
                ((ImageWriter)object).setOutput(ImageIO.createImageOutputStream(file));
                BufferedImage bufferedImage = vsm.getView(mainView).getImage();
                if (bufferedImage != null) {
                    ((ImageWriter)object).write(bufferedImage);
                    ((ImageWriter)object).dispose();
                    vsm.getView(mainView).setStatusBarText("Exporting to PNG " + file.toString() + " ...done");
                } else {
                    JOptionPane.showMessageDialog(this.cmp, "An error occured when retrieving the image.\n Please try again.");
                }
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this.cmp, "Error while exporting to PNG:\n" + iOException);
            }
            vsm.getView(mainView).setCursorIcon(-1);
        }
    }

    public void exportSVG(File file) {
        if (file != null) {
            vsm.getView(mainView).setCursorIcon(3);
            lastExportRDFDir = file.getParentFile();
            vsm.getView(mainView).setStatusBarText("Exporting to SVG " + file.toString() + " ...");
            if (file.exists()) {
                file.delete();
            }
            SVGWriter sVGWriter = new SVGWriter();
            Document document = sVGWriter.exportVirtualSpace(vsm.getVirtualSpace(mainVirtualSpace), (DOMImplementation)new DOMImplementationImpl(), file);
            this.xmlMngr.serialize(document, file);
            vsm.getView(mainView).setStatusBarText("Exporting to SVG " + file.toString() + " ...done");
            vsm.getView(mainView).setCursorIcon(-1);
        }
    }

    public void setAbbrevSyntax(boolean bl) {
        ABBREV_SYNTAX = bl;
    }

    public void displayLabels(boolean bl) {
        DISP_AS_LABEL = bl;
        this.showResourceLabels(DISP_AS_LABEL);
    }

    public void showAnonIds(boolean bl) {
        VirtualSpace virtualSpace = vsm.getVirtualSpace(mainVirtualSpace);
        Enumeration enumeration = this.resourcesByURI.elements();
        while (enumeration.hasMoreElements()) {
            IResource iResource = (IResource)enumeration.nextElement();
            if (!iResource.isAnon()) continue;
            if (bl) {
                virtualSpace.show((Glyph)iResource.getGlyphText());
                continue;
            }
            virtualSpace.hide((Glyph)iResource.getGlyphText());
        }
        SHOW_ANON_ID = bl;
    }

    void showResourceLabels(boolean bl) {
        Vector vector = this.getProperties(RDFS_NAMESPACE_URI + "label");
        if (bl) {
            try {
                int n = 0;
                while (n < vector.size()) {
                    IProperty iProperty = (IProperty)vector.elementAt(n);
                    this.geomMngr.adjustResourceTextAndEllipse(iProperty.subject, iProperty.object.getText());
                    ++n;
                }
            }
            catch (NullPointerException nullPointerException) {}
        } else {
            try {
                int n = 0;
                while (n < vector.size()) {
                    IProperty iProperty = (IProperty)vector.elementAt(n);
                    this.geomMngr.adjustResourceTextAndEllipse(iProperty.subject, iProperty.subject.getIdent());
                    ++n;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    IResource addResource(String string, String string2) {
        IResource iResource = new IResource();
        iResource.setNamespace(string);
        iResource.setLocalname(string2);
        if (!this.resourcesByURI.containsKey(iResource.getIdent())) {
            this.resourcesByURI.put(iResource.getIdent(), iResource);
            return iResource;
        }
        return (IResource)this.resourcesByURI.get(iResource.getIdent());
    }

    IResource addAnonymousResource(String string) {
        IResource iResource = new IResource();
        iResource.setAnon(true);
        if (string != null) {
            iResource.setAnonymousID(string);
        } else {
            iResource.setAnonymousID(this.nextAnonymousID());
        }
        if (!this.resourcesByURI.containsKey(iResource.getIdent())) {
            this.resourcesByURI.put(iResource.getIdent(), iResource);
            return iResource;
        }
        return (IResource)this.resourcesByURI.get(iResource.getIdent());
    }

    IProperty addProperty(String string, String string2) {
        IProperty iProperty = new IProperty();
        iProperty.setNamespace(string);
        iProperty.setLocalname(string2);
        if (this.propertiesByURI.containsKey(iProperty.getIdent())) {
            Vector vector = (Vector)this.propertiesByURI.get(iProperty.getIdent());
            vector.add(iProperty);
        } else {
            Vector<IProperty> vector = new Vector<IProperty>();
            vector.add(iProperty);
            this.propertiesByURI.put(iProperty.getIdent(), vector);
        }
        this.addPropertyType(iProperty.getNamespace(), iProperty.getLocalname(), true);
        return iProperty;
    }

    ILiteral addLiteral(String string, String string2, boolean bl) {
        ILiteral iLiteral = new ILiteral();
        iLiteral.setValue(string);
        if (string2 != null) {
            iLiteral.setLanguage(string2);
        }
        iLiteral.setEscapeXMLChars(bl);
        this.literals.add(iLiteral);
        return iLiteral;
    }

    IResource getResource(String string) {
        IResource iResource = (IResource)this.resourcesByURI.get(string);
        return iResource;
    }

    Vector getProperties(String string) {
        Vector vector = (Vector)this.propertiesByURI.get(string);
        return vector;
    }

    void createNewResource(long l, long l2) {
        IResource iResource = new IResource();
        VEllipse vEllipse = new VEllipse(l, l2, 0.0f, 40L, 18L, ConfigManager.resourceColorF);
        iResource.setGlyph(vEllipse);
        vsm.addGlyph((Glyph)vEllipse, mainVirtualSpace);
        vEllipse.setHSVbColor(ConfigManager.resTBh, ConfigManager.resTBs, ConfigManager.resTBv);
        new NewResPanel(this, iResource);
    }

    void storeResource(IResource iResource, String string, boolean bl) {
        if (string.length() == 0) {
            iResource.setAnon(true);
            iResource.setAnonymousID(this.nextAnonymousID());
        } else if (bl) {
            iResource.setURI(string);
        } else {
            iResource.setNamespace(DEFAULT_NAMESPACE);
            iResource.setLocalname(string);
        }
        VEllipse vEllipse = (VEllipse)iResource.getGlyph();
        VText vText = new VText(vEllipse.vx, vEllipse.vy, 0.0f, ConfigManager.resourceColorTB, iResource.getIdent());
        vsm.addGlyph((Glyph)vText, mainVirtualSpace);
        iResource.setGlyphText(vText);
        Rectangle2D rectangle2D = vsm.getView(mainView).getGraphicsContext().getFontMetrics().getStringBounds(iResource.getIdent(), vsm.getView(mainView).getGraphicsContext());
        vEllipse.setWidth(Math.round(0.6 * rectangle2D.getWidth()));
        if ((double)vEllipse.getWidth() < 1.5 * (double)vEllipse.getHeight()) {
            vEllipse.setWidth(Math.round(1.5 * (double)vEllipse.getHeight()));
        }
        vText.moveTo(vEllipse.vx - (long)rectangle2D.getWidth() / 2L, vEllipse.vy - (long)rectangle2D.getHeight() / 4L);
        if (iResource.isAnon() && !SHOW_ANON_ID) {
            vsm.getVirtualSpace(mainVirtualSpace).hide((Glyph)vText);
        }
        this.resourcesByURI.put(iResource.getIdent(), iResource);
    }

    void cancelNewNode(INode iNode) {
        vsm.getVirtualSpace(mainVirtualSpace).destroyGlyph(iNode.getGlyph());
    }

    void makeAnonymous(IResource iResource) {
        this.resourcesByURI.remove(iResource.getIdent());
        iResource.setAnon(true);
        iResource.setAnonymousID(this.nextAnonymousID());
        this.resourcesByURI.put(iResource.getIdent(), iResource);
        iResource.getGlyphText().setText(iResource.getIdent());
        if (!SHOW_ANON_ID) {
            vsm.getVirtualSpace(mainVirtualSpace).hide((Glyph)iResource.getGlyphText());
        }
    }

    void changeResourceURI(IResource iResource, String string, boolean bl) {
        String string2;
        if (bl) {
            if (!string.equals(iResource.getIdent())) {
                if (!this.resourceAlreadyExists(string)) {
                    this.resourcesByURI.remove(iResource.getIdent());
                    if (iResource.isAnon()) {
                        iResource.setAnon(false);
                        if (!SHOW_ANON_ID) {
                            vsm.getVirtualSpace(mainVirtualSpace).show((Glyph)iResource.getGlyphText());
                        }
                    }
                    iResource.setURI(string);
                    this.resourcesByURI.put(iResource.getIdent(), iResource);
                } else {
                    JOptionPane.showMessageDialog(this.propsp, "A resource with URI " + string + " already exists");
                }
            }
        } else {
            String string3 = string2 = string.startsWith(DEFAULT_NAMESPACE) ? string.substring(DEFAULT_NAMESPACE.length(), string.length()) : string;
            if (!iResource.getIdent().equals(DEFAULT_NAMESPACE + "#" + string2) && !iResource.getIdent().equals(DEFAULT_NAMESPACE + string2)) {
                if (!this.resourceAlreadyExists(DEFAULT_NAMESPACE + "#" + string2)) {
                    this.resourcesByURI.remove(iResource.getIdent());
                    if (iResource.isAnon()) {
                        iResource.setAnon(false);
                        if (!SHOW_ANON_ID) {
                            vsm.getVirtualSpace(mainVirtualSpace).show((Glyph)iResource.getGlyphText());
                        }
                    }
                    iResource.setNamespace(DEFAULT_NAMESPACE);
                    iResource.setLocalname(string2);
                    this.resourcesByURI.put(iResource.getIdent(), iResource);
                } else {
                    JOptionPane.showMessageDialog(this.propsp, "A resource with ID " + string + " already exists");
                }
            }
        }
        this.geomMngr.adjustResourceTextAndEllipse(iResource, iResource.getIdent());
        string2 = iResource.getGlyphText();
        if (!string2.isVisible()) {
            vsm.getVirtualSpace(mainVirtualSpace).show((Glyph)string2);
        }
    }

    boolean resourceAlreadyExists(String string) {
        return this.resourcesByURI.containsKey(string);
    }

    void createNewLiteral(long l, long l2) {
        ILiteral iLiteral = new ILiteral();
        VRectangle vRectangle = new VRectangle(l, l2, 0.0f, 40L, 18L, ConfigManager.literalColorF);
        vsm.addGlyph((Glyph)vRectangle, mainVirtualSpace);
        vRectangle.setHSVbColor(ConfigManager.litTBh, ConfigManager.litTBs, ConfigManager.litTBv);
        iLiteral.setGlyph(vRectangle);
        new NewLitPanel(this, iLiteral);
    }

    void storeLiteral(ILiteral iLiteral, String string, boolean bl, String string2) {
        if (string2.length() > 0) {
            iLiteral.setLanguage(string2);
        }
        iLiteral.setEscapeXMLChars(bl);
        this.setLiteralValue(iLiteral, string);
        this.literals.add(iLiteral);
    }

    void setLiteralValue(ILiteral iLiteral, String string) {
        Object object;
        iLiteral.setValue(string);
        if (string.length() > 0) {
            Object object2 = object = iLiteral.getValue().length() >= MAX_LIT_CHAR_COUNT ? iLiteral.getValue().substring(0, MAX_LIT_CHAR_COUNT) + " ..." : iLiteral.getValue();
            if (iLiteral.getGlyphText() != null) {
                iLiteral.getGlyphText().setText((String)object);
            } else {
                VRectangle vRectangle = (VRectangle)iLiteral.getGlyph();
                VText vText = new VText(vRectangle.vx, vRectangle.vy, 0.0f, iLiteral.isSelected() ? ConfigManager.selectionColorTB : ConfigManager.literalColorTB, (String)object);
                vsm.addGlyph((Glyph)vText, mainVirtualSpace);
                iLiteral.setGlyphText(vText);
                Rectangle2D rectangle2D = vsm.getView(mainView).getGraphicsContext().getFontMetrics().getStringBounds((String)object, vsm.getView(mainView).getGraphicsContext());
                vRectangle.setWidth(Math.round(0.6 * rectangle2D.getWidth()));
                if ((double)vRectangle.getWidth() < 1.5 * (double)vRectangle.getHeight()) {
                    vRectangle.setWidth(Math.round(1.5 * (double)vRectangle.getHeight()));
                }
                vText.moveTo(vRectangle.vx - (long)rectangle2D.getWidth() / 2L, vRectangle.vy - (long)rectangle2D.getHeight() / 4L);
            }
        } else if (iLiteral.getGlyphText() != null) {
            vsm.getVirtualSpace(mainVirtualSpace).destroyGlyph((Glyph)iLiteral.getGlyphText());
            iLiteral.setGlyphText(null);
        }
        object = iLiteral.getIncomingPredicate();
        if (object != null && ((IProperty)object).getNamespace().equals(RDFS_NAMESPACE_URI) && ((IProperty)object).getLocalname().equals("label")) {
            ((IProperty)object).subject.setLabel(iLiteral.getValue());
            if (DISP_AS_LABEL) {
                this.geomMngr.adjustResourceTextAndEllipse(((IProperty)object).subject, ((IProperty)object).subject.getLabel());
            }
        }
    }

    void createNewProperty(IResource iResource, INode iNode, Vector vector) {
        boolean bl = false;
        if (iNode instanceof ILiteral && ((ILiteral)iNode).getIncomingPredicate() != null) {
            bl = true;
            JOptionPane.showMessageDialog(vsm.getActiveView().getFrame(), "This literal is already the object of a statement.");
        }
        if (!bl) {
            long l;
            long l2;
            Object object;
            VEllipse vEllipse;
            INode iNode2;
            IProperty iProperty = this.selectedPropertyConstructorNS.equals(RDFMS_NAMESPACE_URI) && this.selectedPropertyConstructorLN.startsWith(MEMBERSHIP_PROP_CONSTRUCTOR.substring(0, 3)) ? this.addProperty(RDFMS_NAMESPACE_URI, IContainer.nextContainerIndex(iResource)) : this.addProperty(this.selectedPropertyConstructorNS, this.selectedPropertyConstructorLN);
            iProperty.setSubject(iResource);
            iResource.addOutgoingPredicate(iProperty);
            if (iNode instanceof IResource) {
                iNode2 = (IResource)iNode;
                iProperty.setObject((IResource)iNode2);
                ((IResource)iNode2).addIncomingPredicate(iProperty);
            } else {
                iNode2 = (ILiteral)iNode;
                iProperty.setObject((ILiteral)iNode2);
                ((ILiteral)iNode2).setIncomingPredicate(iProperty);
                if (iProperty.getIdent().equals(RDFS_NAMESPACE_URI + "label")) {
                    iResource.setLabel(((ILiteral)iNode2).getValue());
                    iResource.getGlyphText().setText(iResource.getLabel());
                }
            }
            iNode2 = (LongPoint)vector.elementAt(0);
            LongPoint longPoint = (LongPoint)vector.elementAt(1);
            Point2D.Double double_ = new Point2D.Double(((LongPoint)iNode2).x, ((LongPoint)iNode2).y);
            Point2D point2D = Utils.computeStepValue((LongPoint)iNode2, longPoint);
            VEllipse vEllipse2 = (VEllipse)iResource.getGlyph();
            Ellipse2D.Double double_2 = new Ellipse2D.Double(vEllipse2.vx - vEllipse2.getWidth(), vEllipse2.vy - vEllipse2.getHeight(), vEllipse2.getWidth() * 2L, vEllipse2.getHeight() * 2L);
            while (double_2.contains(double_)) {
                ((Point2D)double_).setLocation(((Point2D)double_).getX() + point2D.getX(), ((Point2D)double_).getY() + point2D.getY());
            }
            iNode2.setLocation(Math.round(((Point2D)double_).getX()), Math.round(((Point2D)double_).getY()));
            VPath vPath = new VPath(((LongPoint)iNode2).x, ((LongPoint)iNode2).y, 0.0f, ConfigManager.propertyColorB);
            int n = 1;
            while (n < vector.size() - 2) {
                iNode2 = (LongPoint)vector.elementAt(n);
                longPoint = (LongPoint)vector.elementAt(n + 1);
                vPath.addQdCurve((longPoint.x + ((LongPoint)iNode2).x) / 2L, (longPoint.y + ((LongPoint)iNode2).y) / 2L, ((LongPoint)iNode2).x, ((LongPoint)iNode2).y, true);
                ++n;
            }
            longPoint = (LongPoint)vector.elementAt(vector.size() - 2);
            iNode2 = (LongPoint)vector.lastElement();
            Point2D.Double double_3 = new Point2D.Double(((LongPoint)iNode2).x, ((LongPoint)iNode2).y);
            Point2D point2D2 = Utils.computeStepValue((LongPoint)iNode2, longPoint);
            if (iNode instanceof IResource) {
                vEllipse = (VEllipse)iNode.getGlyph();
                object = new Ellipse2D.Double(vEllipse.vx - vEllipse.getWidth(), vEllipse.vy - vEllipse.getHeight(), vEllipse.getWidth() * 2L, vEllipse.getHeight() * 2L);
                while (((RectangularShape)object).contains(double_3)) {
                    ((Point2D)double_3).setLocation(((Point2D)double_3).getX() + point2D2.getX(), ((Point2D)double_3).getY() + point2D2.getY());
                }
                iNode2.setLocation(Math.round(((Point2D)double_3).getX()), Math.round(((Point2D)double_3).getY()));
            } else {
                vEllipse = (VRectangle)iNode.getGlyph();
                object = new Rectangle2D.Double(vEllipse.vx - vEllipse.getWidth(), vEllipse.vy - vEllipse.getHeight(), vEllipse.getWidth() * 2L, vEllipse.getHeight() * 2L);
                while (((RectangularShape)object).contains(double_3)) {
                    ((Point2D)double_3).setLocation(((Point2D)double_3).getX() + point2D2.getX(), ((Point2D)double_3).getY() + point2D2.getY());
                }
                iNode2.setLocation(Math.round(((Point2D)double_3).getX()), Math.round(((Point2D)double_3).getY()));
            }
            if (vector.size() > 2) {
                vPath.addQdCurve(((LongPoint)iNode2).x, ((LongPoint)iNode2).y, longPoint.x, longPoint.y, true);
            } else {
                vPath.addSegment(((LongPoint)iNode2).x, ((LongPoint)iNode2).y, true);
            }
            vsm.addGlyph((Glyph)vPath, mainVirtualSpace);
            vEllipse = Utils.createPathArrowHead(longPoint, (LongPoint)iNode2, null);
            vsm.addGlyph((Glyph)vEllipse, mainVirtualSpace);
            object = "";
            boolean bl2 = false;
            int n2 = 0;
            while (n2 < this.tblp.nsTableModel.getRowCount()) {
                if (((String)this.tblp.nsTableModel.getValueAt(n2, 1)).equals(this.selectedPropertyConstructorNS)) {
                    object = (Boolean)this.tblp.nsTableModel.getValueAt(n2, 2) != false ? (String)this.tblp.nsTableModel.getValueAt(n2, 0) + ":" + iProperty.getLocalname() : this.selectedPropertyConstructorNS + iProperty.getLocalname();
                    bl2 = true;
                    break;
                }
                ++n2;
            }
            if (!bl2) {
                object = this.selectedPropertyConstructorNS + iProperty.getLocalname();
            }
            if (vector.size() % 2 != 0) {
                l2 = ((LongPoint)vector.elementAt((int)(vector.size() / 2))).x;
                l = ((LongPoint)vector.elementAt((int)(vector.size() / 2))).y;
            } else {
                l2 = (((LongPoint)vector.elementAt((int)(vector.size() / 2))).x + ((LongPoint)vector.elementAt((int)(vector.size() / 2 - 1))).x) / 2L;
                l = (((LongPoint)vector.elementAt((int)(vector.size() / 2))).y + ((LongPoint)vector.elementAt((int)(vector.size() / 2 - 1))).y) / 2L;
            }
            VText vText = new VText(l2, l, 0.0f, ConfigManager.propertyColorT, (String)object);
            vsm.addGlyph((Glyph)vText, mainVirtualSpace);
            iProperty.setGlyph(vPath, (VTriangleOr)vEllipse);
            iProperty.setGlyphText(vText);
        }
    }

    void changePropertyURI(IProperty iProperty, String string, String string2) {
        String string3 = this.getNSURIfromPrefix(string);
        if (string3 == null) {
            string3 = string;
        }
        if (!iProperty.getIdent().equals(string3 + string2)) {
            if (iProperty.getNamespace().equals(RDFS_NAMESPACE_URI) && iProperty.getLocalname().equals("label")) {
                iProperty.subject.setLabel("");
                if (DISP_AS_LABEL) {
                    this.geomMngr.adjustResourceTextAndEllipse(iProperty.subject, iProperty.subject.getIdent());
                }
            }
            if (string3.equals(RDFMS_NAMESPACE_URI) && string2.startsWith(MEMBERSHIP_PROP_CONSTRUCTOR.substring(0, 3))) {
                string2 = IContainer.nextContainerIndex(iProperty.subject);
            } else if (string3.equals(RDFS_NAMESPACE_URI) && string2.equals("label")) {
                iProperty.subject.setLabel(iProperty.object.getText());
                if (DISP_AS_LABEL) {
                    this.geomMngr.adjustResourceTextAndEllipse(iProperty.subject, iProperty.subject.getLabel());
                }
            }
            Vector vector = (Vector)this.propertiesByURI.get(iProperty.getIdent());
            vector.remove(iProperty);
            iProperty.setNamespace(string3);
            iProperty.setLocalname(string2);
            if (this.propertiesByURI.containsKey(iProperty.getIdent())) {
                Vector vector2 = (Vector)this.propertiesByURI.get(iProperty.getIdent());
                vector2.add(iProperty);
            } else {
                Vector<IProperty> vector3 = new Vector<IProperty>();
                vector3.add(iProperty);
                this.propertiesByURI.put(iProperty.getIdent(), vector3);
            }
            if (this.showThisNSAsPrefix(iProperty.getNamespace(), true)) {
                this.updateAPropertyText(iProperty, string + ":" + iProperty.getLocalname());
            } else {
                this.updateAPropertyText(iProperty, iProperty.getIdent());
            }
        }
    }

    static void changePropertySubject(IProperty iProperty, IResource iResource) {
        if (iProperty.getSubject() != null && iProperty.getSubject() != iResource) {
            IResource iResource2 = iProperty.getSubject();
            iResource2.removeOutgoingPredicate(iProperty);
        }
        iProperty.setSubject(iResource);
        iResource.addOutgoingPredicate(iProperty);
    }

    static void changePropertyObject(IProperty iProperty, INode iNode) {
        if (iProperty.getObject() != null && iProperty.getObject() != iNode) {
            INode iNode2 = iProperty.getObject();
            if (iNode2 instanceof ILiteral) {
                ((ILiteral)iNode2).setIncomingPredicate(null);
            } else {
                ((IResource)iNode2).removeIncomingPredicate(iProperty);
            }
        }
        if (iNode instanceof ILiteral) {
            iProperty.setObject((ILiteral)iNode);
            ((ILiteral)iNode).setIncomingPredicate(iProperty);
        } else {
            iProperty.setObject((IResource)iNode);
            ((IResource)iNode).addIncomingPredicate(iProperty);
        }
    }

    void selectResourcesMatching(String string) {
        if (string.length() > 0) {
            Enumeration enumeration = this.resourcesByURI.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (string2.indexOf(string) == -1) continue;
                this.selectResource((IResource)this.resourcesByURI.get(string2), true);
            }
            if (lastSelectedItem != null) {
                this.propsp.updateDisplay(lastSelectedItem);
            }
        }
    }

    void selectPropertiesMatching(String string, String string2) {
        if (string.length() > 0 || string2.length() > 0) {
            String string3 = string;
            if (string.endsWith(":") && (string3 = this.getNSURIfromPrefix(string.substring(0, string.length() - 1))) == null) {
                string3 = "";
            }
            Enumeration enumeration = this.propertiesByURI.elements();
            while (enumeration.hasMoreElements()) {
                Enumeration enumeration2 = ((Vector)enumeration.nextElement()).elements();
                while (enumeration2.hasMoreElements()) {
                    IProperty iProperty = (IProperty)enumeration2.nextElement();
                    if (string3.length() > 0) {
                        if (string2.length() > 0) {
                            if (iProperty.getNamespace().indexOf(string3) == -1 || iProperty.getLocalname().indexOf(string2) == -1) continue;
                            this.selectPredicate(iProperty, true);
                            continue;
                        }
                        if (iProperty.getNamespace().indexOf(string3) == -1) continue;
                        this.selectPredicate(iProperty, true);
                        continue;
                    }
                    if (string2.length() <= 0 || iProperty.getLocalname().indexOf(string2) == -1) continue;
                    this.selectPredicate(iProperty, true);
                }
            }
        }
        if (lastSelectedItem != null) {
            this.propsp.updateDisplay(lastSelectedItem);
        }
    }

    void selectLiteralsMatching(String string) {
        if (string.length() > 0) {
            Enumeration enumeration = this.literals.elements();
            while (enumeration.hasMoreElements()) {
                ILiteral iLiteral = (ILiteral)enumeration.nextElement();
                if (iLiteral.getValue().indexOf(string) == -1) continue;
                this.selectLiteral(iLiteral, true);
            }
            if (lastSelectedItem != null) {
                this.propsp.updateDisplay(lastSelectedItem);
            }
        }
    }

    void selectResource(IResource iResource, boolean bl) {
        if (bl != iResource.isSelected()) {
            iResource.setSelected(bl);
            if (bl) {
                if (!this.selectedResources.contains(iResource)) {
                    this.selectedResources.add(iResource);
                    lastSelectedItem = iResource;
                }
            } else {
                this.selectedResources.remove(iResource);
            }
        }
    }

    void selectPropertiesOfResource(IResource iResource) {
        IProperty iProperty;
        int n;
        Vector vector = iResource.getIncomingPredicates();
        if (vector != null) {
            n = 0;
            while (n < vector.size()) {
                iProperty = (IProperty)vector.elementAt(n);
                this.selectPredicate(iProperty, true);
                ++n;
            }
        }
        if ((vector = iResource.getOutgoingPredicates()) != null) {
            n = 0;
            while (n < vector.size()) {
                iProperty = (IProperty)vector.elementAt(n);
                this.selectPredicate(iProperty, true);
                ++n;
            }
        }
    }

    void selectLiteral(ILiteral iLiteral, boolean bl) {
        if (bl != iLiteral.isSelected()) {
            iLiteral.setSelected(bl);
            if (bl) {
                if (!this.selectedLiterals.contains(iLiteral)) {
                    this.selectedLiterals.add(iLiteral);
                    lastSelectedItem = iLiteral;
                }
            } else {
                this.selectedLiterals.remove(iLiteral);
            }
        }
    }

    void selectPropertiesOfLiteral(ILiteral iLiteral) {
        IProperty iProperty = iLiteral.getIncomingPredicate();
        if (iProperty != null) {
            this.selectPredicate(iProperty, true);
        }
    }

    void selectPredicate(IProperty iProperty, boolean bl) {
        if (bl != iProperty.isSelected()) {
            iProperty.setSelected(bl);
            if (bl) {
                if (!this.selectedPredicates.contains(iProperty)) {
                    this.selectedPredicates.add(iProperty);
                    lastSelectedItem = iProperty;
                }
            } else {
                this.selectedPredicates.remove(iProperty);
            }
        }
    }

    void selectNodesOfProperty(IProperty iProperty) {
        this.selectResource(iProperty.getSubject(), true);
        INode iNode = iProperty.getObject();
        if (iNode instanceof IResource) {
            this.selectResource((IResource)iNode, true);
        } else {
            this.selectLiteral((ILiteral)iNode, true);
        }
    }

    void selectAllNodes() {
        Enumeration enumeration = this.resourcesByURI.elements();
        while (enumeration.hasMoreElements()) {
            this.selectResource((IResource)enumeration.nextElement(), true);
        }
        Enumeration enumeration2 = this.literals.elements();
        while (enumeration2.hasMoreElements()) {
            this.selectLiteral((ILiteral)enumeration2.nextElement(), true);
        }
    }

    void selectAllEdges() {
        Enumeration enumeration = this.propertiesByURI.elements();
        while (enumeration.hasMoreElements()) {
            Enumeration enumeration2 = ((Vector)enumeration.nextElement()).elements();
            while (enumeration2.hasMoreElements()) {
                this.selectPredicate((IProperty)enumeration2.nextElement(), true);
            }
        }
    }

    void unselectLastSelection() {
        this.propsp.reset();
        this.tblp.updatePropertyBrowser(null, false);
        this.unselectAll();
        lastSelectedItem = null;
    }

    void unselectAll() {
        this.propsp.reset();
        int n = this.selectedResources.size() - 1;
        while (n >= 0) {
            this.selectResource((IResource)this.selectedResources.elementAt(n), false);
            --n;
        }
        int n2 = this.selectedLiterals.size() - 1;
        while (n2 >= 0) {
            this.selectLiteral((ILiteral)this.selectedLiterals.elementAt(n2), false);
            --n2;
        }
        int n3 = this.selectedPredicates.size() - 1;
        while (n3 >= 0) {
            this.selectPredicate((IProperty)this.selectedPredicates.elementAt(n3), false);
            --n3;
        }
        if (!this.selectedResources.isEmpty()) {
            System.err.println("Debug: Editor.unselectAll(): selectedResources should be empty");
        }
        if (!this.selectedLiterals.isEmpty()) {
            System.err.println("Debug: Editor.unselectAll(): selectedLiterals should be empty ; size=" + this.selectedLiterals.size());
        }
        if (!this.selectedPredicates.isEmpty()) {
            System.err.println("Debug: Editor.unselectAll(): selectedPredicates should be empty");
        }
        lastSelectedItem = null;
    }

    void deleteResource(IResource iResource) {
        int n;
        Vector vector = iResource.getIncomingPredicates();
        if (vector != null) {
            n = vector.size() - 1;
            while (n >= 0) {
                this.deleteProperty((IProperty)vector.elementAt(n));
                --n;
            }
        }
        if ((vector = iResource.getOutgoingPredicates()) != null) {
            n = vector.size() - 1;
            while (n >= 0) {
                this.deleteProperty((IProperty)vector.elementAt(n));
                --n;
            }
        }
        VirtualSpace virtualSpace = vsm.getVirtualSpace(mainVirtualSpace);
        virtualSpace.destroyGlyph(iResource.getGlyph());
        if (iResource.getGlyphText() != null) {
            virtualSpace.destroyGlyph((Glyph)iResource.getGlyphText());
        }
        this.removeResource(iResource);
    }

    void removeResource(IResource iResource) {
        if (this.resourcesByURI.containsKey(iResource.getIdent())) {
            this.resourcesByURI.remove(iResource.getIdent());
        }
        this.selectResource(iResource, false);
    }

    void deleteLiteral(ILiteral iLiteral) {
        if (iLiteral.getIncomingPredicate() != null) {
            this.deleteProperty(iLiteral.getIncomingPredicate());
        }
        VirtualSpace virtualSpace = vsm.getVirtualSpace(mainVirtualSpace);
        virtualSpace.destroyGlyph(iLiteral.getGlyph());
        if (iLiteral.getGlyphText() != null) {
            virtualSpace.destroyGlyph((Glyph)iLiteral.getGlyphText());
        }
        this.removeLiteral(iLiteral);
    }

    void removeLiteral(ILiteral iLiteral) {
        this.literals.remove(iLiteral);
        this.selectLiteral(iLiteral, false);
    }

    void deleteProperty(IProperty iProperty) {
        INode iNode;
        if (iProperty.getSubject() != null) {
            iNode = iProperty.getSubject();
            ((IResource)iNode).removeOutgoingPredicate(iProperty);
            if (iProperty.getNamespace().equals(RDFS_NAMESPACE_URI) && iProperty.getLocalname().equals("label")) {
                this.geomMngr.adjustResourceTextAndEllipse(iProperty.subject, iProperty.subject.getIdent());
            }
        }
        if (iProperty.getObject() != null) {
            iNode = iProperty.getObject();
            if (iNode instanceof IResource) {
                ((IResource)iNode).removeIncomingPredicate(iProperty);
            } else {
                ((ILiteral)iNode).setIncomingPredicate(null);
            }
        }
        iNode = vsm.getVirtualSpace(mainVirtualSpace);
        iNode.destroyGlyph(iProperty.getGlyph());
        iNode.destroyGlyph((Glyph)iProperty.getGlyphHead());
        if (iProperty.getGlyphText() != null) {
            iNode.destroyGlyph((Glyph)iProperty.getGlyphText());
        }
        this.removeProperty(iProperty);
    }

    void removeProperty(IProperty iProperty) {
        if (this.propertiesByURI.containsKey(iProperty.getIdent())) {
            Vector vector = (Vector)this.propertiesByURI.get(iProperty.getIdent());
            vector.remove(iProperty);
            if (vector.isEmpty()) {
                this.propertiesByURI.remove(iProperty.getIdent());
            }
        }
        this.selectPredicate(iProperty, false);
    }

    void commentNode(INode iNode, boolean bl) {
        if (bl && !iNode.isCommented()) {
            iNode.comment(bl, this);
        } else if (!bl && iNode.isCommented()) {
            iNode.comment(bl, this);
        }
    }

    void commentPredicate(IProperty iProperty, boolean bl) {
        if (bl && !iProperty.isCommented()) {
            iProperty.comment(bl, this);
        } else if (!bl && iProperty.isCommented()) {
            iProperty.comment(bl, this);
        }
    }

    void updateAPropertyText(IProperty iProperty, String string) {
        VText vText = iProperty.getGlyphText();
        if (vText != null) {
            int n = vsm.getActiveCamera().getIndex();
            LongPoint longPoint = vText.getBounds(n);
            long l = vText.vx + longPoint.x / 2L;
            long l2 = vText.vy + longPoint.y / 2L;
            vText.setText(string);
            longPoint = vText.getBounds(n);
            vText.moveTo(l - longPoint.x / 2L, l2 - longPoint.y / 2L);
        }
    }

    boolean addNamespaceBinding(String string, String string2, Boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = false;
        boolean bl5 = false;
        int n = 0;
        while (n < this.tblp.nsTableModel.getRowCount()) {
            if (string.length() > 0 && string.equals((String)this.tblp.nsTableModel.getValueAt(n, 0))) {
                bl4 = true;
                if (!bl2) {
                    JOptionPane.showMessageDialog(this.tblp, "Prefix " + string + " is already assigned to namespace " + (String)this.tblp.nsTableModel.getValueAt(n, 1));
                }
                if (!bl3) {
                    return false;
                }
            }
            if (string2.equals((String)this.tblp.nsTableModel.getValueAt(n, 1))) {
                bl5 = true;
                if (!bl2) {
                    JOptionPane.showMessageDialog(this.tblp, "Namespace URI " + string2 + " is already binded to prefix " + (String)this.tblp.nsTableModel.getValueAt(n, 0));
                }
                if (!bl3) {
                    return false;
                }
                this.tblp.nsTableModel.setValueAt(string, n, 0);
                this.tblp.nsTableModel.setValueAt(bl, n, 2);
                return true;
            }
            ++n;
        }
        if (string.equals(ANON_NODE.substring(0, ANON_NODE.length() - 1)) || string.equals(DEFAULT_NAMESPACE.substring(0, DEFAULT_NAMESPACE.length() - 1))) {
            bl4 = true;
            if (!bl2) {
                JOptionPane.showMessageDialog(this.tblp, "Prefix '" + string + "' is either used as the anonymous node prefix or the base prefix");
            }
        }
        if (!bl4 && !bl5) {
            Vector<Object> vector = new Vector<Object>();
            vector.add(string);
            vector.add(string2);
            vector.add(bl);
            int n2 = 0;
            while (n2 < this.tblp.nsTableModel.getRowCount()) {
                String string3 = (String)this.tblp.nsTableModel.getValueAt(n2, 1);
                if (string3.compareTo(string2) > 0) break;
                ++n2;
            }
            this.tblp.nsTableModel.insertRow(n2, vector);
            this.updatePropertyTabPrefix(string2, string);
            return true;
        }
        return false;
    }

    void removeNamespaceBinding(int n) {
        this.tblp.nsTableModel.removeRow(n);
        String string = (String)this.tblp.nsTableModel.getValueAt(n, 1);
        Enumeration enumeration = this.propertiesByURI.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            Enumeration enumeration2 = ((Vector)this.propertiesByURI.get(string2)).elements();
            while (enumeration2.hasMoreElements()) {
                IProperty iProperty = (IProperty)enumeration2.nextElement();
                this.updateAPropertyText(iProperty, iProperty.getNamespace() + iProperty.getLocalname());
            }
        }
        this.updatePropertyTabPrefix(string, "");
    }

    void updateNamespaceBinding(int n, int n2, String string, String string2, Boolean bl, int n3) {
        if (n2 == 2) {
            if (bl.booleanValue() && string.length() > 0) {
                Enumeration enumeration = this.propertiesByURI.keys();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    if (!string3.startsWith(string2)) continue;
                    Enumeration enumeration2 = ((Vector)this.propertiesByURI.get(string3)).elements();
                    while (enumeration2.hasMoreElements()) {
                        IProperty iProperty = (IProperty)enumeration2.nextElement();
                        this.updateAPropertyText(iProperty, string + ":" + iProperty.getLocalname());
                    }
                }
            } else {
                Enumeration enumeration = this.propertiesByURI.keys();
                while (enumeration.hasMoreElements()) {
                    String string4 = (String)enumeration.nextElement();
                    if (!string4.startsWith(string2)) continue;
                    Enumeration enumeration3 = ((Vector)this.propertiesByURI.get(string4)).elements();
                    while (enumeration3.hasMoreElements()) {
                        IProperty iProperty = (IProperty)enumeration3.nextElement();
                        this.updateAPropertyText(iProperty, iProperty.getIdent());
                    }
                }
            }
        } else if (n2 == 0) {
            if (string.length() > 0) {
                if (bl.booleanValue()) {
                    Enumeration enumeration = this.propertiesByURI.keys();
                    while (enumeration.hasMoreElements()) {
                        String string5 = (String)enumeration.nextElement();
                        if (!string5.startsWith(string2)) continue;
                        Enumeration enumeration4 = ((Vector)this.propertiesByURI.get(string5)).elements();
                        while (enumeration4.hasMoreElements()) {
                            IProperty iProperty = (IProperty)enumeration4.nextElement();
                            this.updateAPropertyText(iProperty, string + ":" + iProperty.getLocalname());
                        }
                    }
                }
                this.updatePropertyTabPrefix(string2, string);
            } else {
                Enumeration enumeration = this.propertiesByURI.keys();
                while (enumeration.hasMoreElements()) {
                    String string6 = (String)enumeration.nextElement();
                    if (!string6.startsWith(string2)) continue;
                    Enumeration enumeration5 = ((Vector)this.propertiesByURI.get(string6)).elements();
                    while (enumeration5.hasMoreElements()) {
                        IProperty iProperty = (IProperty)enumeration5.nextElement();
                        this.updateAPropertyText(iProperty, iProperty.getIdent());
                    }
                }
                this.updatePropertyTabPrefix(string2, string);
            }
        }
    }

    boolean showThisNSAsPrefix(String string, boolean bl) {
        int n = 0;
        while (n < this.tblp.nsTableModel.getRowCount()) {
            if (((String)this.tblp.nsTableModel.getValueAt(n, 1)).equals(string) && bl || ((String)this.tblp.nsTableModel.getValueAt(n, 0)).equals(string) && !bl) {
                return (Boolean)this.tblp.nsTableModel.getValueAt(n, 2);
            }
            ++n;
        }
        return false;
    }

    String getNSBinding(String string) {
        int n = 0;
        while (n < this.tblp.nsTableModel.getRowCount()) {
            if (((String)this.tblp.nsTableModel.getValueAt(n, 1)).equals(string) && ((String)this.tblp.nsTableModel.getValueAt(n, 0)).length() > 0) {
                return (String)this.tblp.nsTableModel.getValueAt(n, 0);
            }
            ++n;
        }
        return null;
    }

    String getNSURIfromPrefix(String string) {
        int n = 0;
        while (n < this.tblp.nsTableModel.getRowCount()) {
            if (((String)this.tblp.nsTableModel.getValueAt(n, 0)).equals(string) && ((String)this.tblp.nsTableModel.getValueAt(n, 1)).length() > 0) {
                return (String)this.tblp.nsTableModel.getValueAt(n, 1);
            }
            ++n;
        }
        return null;
    }

    boolean prefixAlreadyInUse(String string) {
        if (string.length() > 0) {
            int n = 0;
            while (n < this.tblp.nsTableModel.getRowCount()) {
                if (((String)this.tblp.nsTableModel.getValueAt(n, 0)).equals(string)) {
                    return true;
                }
                ++n;
            }
            return string.equals(ANON_NODE.substring(0, ANON_NODE.length() - 1)) || string.equals(DEFAULT_NAMESPACE.substring(0, DEFAULT_NAMESPACE.length() - 1));
        }
        return false;
    }

    boolean addPropertyType(String string, String string2, boolean bl) {
        boolean bl2 = false;
        String string3 = "";
        if (string.length() > 0 && string2.length() > 0) {
            int n;
            Object object;
            if (string.charAt(string.length() - 1) == ':') {
                object = string.substring(0, string.length() - 1);
                n = 0;
                while (n < this.tblp.nsTableModel.getRowCount()) {
                    if (((String)this.tblp.nsTableModel.getValueAt(n, 0)).equals(object)) {
                        string3 = (String)this.tblp.nsTableModel.getValueAt(n, 1);
                        break;
                    }
                    ++n;
                }
                if (string3.length() == 0) {
                    JOptionPane.showMessageDialog(this.tblp, "Prefix " + string + " is not binded to any namespace.");
                    return false;
                }
            } else {
                string3 = string;
            }
            object = (DefaultTableModel)this.tblp.prTable.getModel();
            n = 0;
            while (n < ((DefaultTableModel)object).getRowCount()) {
                if (((String)((DefaultTableModel)object).getValueAt(n, 2)).equals(string2) && ((String)((DefaultTableModel)object).getValueAt(n, 0)).equals(string3)) {
                    bl2 = true;
                    if (!bl) {
                        JOptionPane.showMessageDialog(this.tblp, "Property " + string3 + string2 + " is already defined.");
                    }
                    return false;
                }
                ++n;
            }
            if (!bl2) {
                int n2;
                String string4 = this.getNSBinding(string3);
                Vector<String> vector = new Vector<String>();
                vector.add(string3);
                vector.add(string4 == null ? "" : string4);
                vector.add(string2);
                if (string2.charAt(0) == '_' && Character.isDigit(string2.charAt(1))) {
                    int n3 = ((DefaultTableModel)object).getRowCount();
                    int n4 = ((DefaultTableModel)object).getRowCount() - 1;
                    while (n4 > 0) {
                        String string5 = (String)((DefaultTableModel)object).getValueAt(n4, 2);
                        if (!((String)((DefaultTableModel)object).getValueAt(n4, 0)).equals(RDFMS_NAMESPACE_URI) || string5.charAt(0) != '_' || !Character.isDigit(string5.charAt(1))) {
                            n3 = n4 + 1;
                            break;
                        }
                        --n4;
                    }
                    n2 = n3;
                    while (n2 < ((DefaultTableModel)object).getRowCount()) {
                        String string6 = ((String)((DefaultTableModel)object).getValueAt(n2, 0)).concat((String)((DefaultTableModel)object).getValueAt(n2, 2));
                        if (string6.compareTo(string3 + string2) > 0) break;
                        ++n2;
                    }
                    this.tblp.prTable.clearSelection();
                    this.selectedPropertyConstructorNS = RDFMS_NAMESPACE_URI;
                    this.selectedPropertyConstructorLN = MEMBERSHIP_PROP_CONSTRUCTOR;
                } else {
                    n2 = 0;
                    while (n2 < ((DefaultTableModel)object).getRowCount()) {
                        String string7 = ((String)((DefaultTableModel)object).getValueAt(n2, 0)).concat((String)((DefaultTableModel)object).getValueAt(n2, 2));
                        if (string7.compareTo(string3 + string2) > 0) break;
                        ++n2;
                    }
                }
                ((DefaultTableModel)object).insertRow(n2, vector);
                return true;
            }
            return false;
        }
        return false;
    }

    void removePropertyConstructor(int n) {
        boolean bl = false;
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.tblp.prTable.getModel();
        String string = (String)defaultTableModel.getValueAt(n, 0) + (String)defaultTableModel.getValueAt(n, 2);
        Enumeration enumeration = this.propertiesByURI.keys();
        while (enumeration.hasMoreElements()) {
            if (!((String)enumeration.nextElement()).equals(string)) continue;
            bl = true;
            break;
        }
        if (bl) {
            Object[] objectArray = new Object[]{"Yes", "No"};
            int n2 = JOptionPane.showOptionDialog(null, "At least one property in the model is of this type.\n Are you sure you want to remove the type from the list of types?\n(This will not remove the properties from the current model, but just the entry in this list).", "Warning", -1, 2, null, objectArray, objectArray[0]);
            if (n2 == 0) {
                defaultTableModel.removeRow(n);
            }
        } else {
            defaultTableModel.removeRow(n);
        }
    }

    void updatePropertyTabPrefix(String string, String string2) {
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.tblp.prTable.getModel();
        int n = 0;
        while (n < defaultTableModel.getRowCount()) {
            if (((String)defaultTableModel.getValueAt(n, 0)).equals(string)) {
                defaultTableModel.setValueAt(string2, n, 1);
            }
            ++n;
        }
    }

    void initRDFMSProperties() {
        this.addPropertyType(RDFMS_NAMESPACE_URI, "li", true);
        this.addPropertyType(RDFMS_NAMESPACE_URI, MEMBERSHIP_PROP_CONSTRUCTOR, true);
        this.addPropertyType(RDFMS_NAMESPACE_URI, "object", true);
        this.addPropertyType(RDFMS_NAMESPACE_URI, "predicate", true);
        this.addPropertyType(RDFMS_NAMESPACE_URI, "subject", true);
        this.addPropertyType(RDFMS_NAMESPACE_URI, "type", true);
        this.addPropertyType(RDFMS_NAMESPACE_URI, "value", true);
    }

    void initRDFSProperties() {
        this.addPropertyType(RDFS_NAMESPACE_URI, "comment", true);
        this.addPropertyType(RDFS_NAMESPACE_URI, "domain", true);
        this.addPropertyType(RDFS_NAMESPACE_URI, "isDefinedBy", true);
        this.addPropertyType(RDFS_NAMESPACE_URI, "label", true);
        this.addPropertyType(RDFS_NAMESPACE_URI, "range", true);
        this.addPropertyType(RDFS_NAMESPACE_URI, "seeAlso", true);
        this.addPropertyType(RDFS_NAMESPACE_URI, "subClassOf", true);
        this.addPropertyType(RDFS_NAMESPACE_URI, "subPropertyOf", true);
    }

    void setSelectedPropertyConstructor(String string, String string2) {
        this.selectedPropertyConstructorNS = string;
        this.selectedPropertyConstructorLN = string2;
    }

    Vector getAllPropertyNS() {
        Vector<String> vector = new Vector<String>();
        TableModel tableModel = this.tblp.prTable.getModel();
        int n = 0;
        while (n < tableModel.getRowCount()) {
            String string = (String)tableModel.getValueAt(n, 0);
            String string2 = this.getNSBinding(string);
            if (string2 != null) {
                string = string2;
            }
            if (!vector.contains(string)) {
                vector.add(string);
            }
            ++n;
        }
        return vector;
    }

    Vector getProperties4NS(String string) {
        Vector<Object> vector = new Vector<Object>();
        TableModel tableModel = this.tblp.prTable.getModel();
        int n = 0;
        while (n < tableModel.getRowCount()) {
            String string2;
            if (((String)tableModel.getValueAt(n, 0)).equals(string) || (string2 = this.getNSBinding((String)tableModel.getValueAt(n, 0))) != null && string2.equals(string)) {
                vector.add(tableModel.getValueAt(n, 2));
            }
            ++n;
        }
        return vector;
    }

    public void setAnonymousNodePrefix(String string) {
        ANON_NODE = string;
    }

    public String getAnonymousNodePrefix() {
        return ANON_NODE;
    }

    public void setDefaultNamespace(String string) {
        DEFAULT_NAMESPACE = string;
    }

    public String getDefaultNamespace() {
        return DEFAULT_NAMESPACE;
    }

    void showTablePanel(boolean bl) {
        ConfigManager.showNSWindow = bl;
        if (ConfigManager.showNSWindow) {
            this.tblp.show();
        } else {
            this.tblp.hide();
        }
    }

    void showPropsPanel(boolean bl) {
        ConfigManager.showEditWindow = bl;
        if (ConfigManager.showEditWindow) {
            this.propsp.show();
        } else {
            this.propsp.hide();
        }
    }

    void setMaxLiteralCharCount(int n) {
        if (n != MAX_LIT_CHAR_COUNT) {
            MAX_LIT_CHAR_COUNT = n;
            int n2 = 0;
            while (n2 < this.literals.size()) {
                ILiteral iLiteral = (ILiteral)this.literals.elementAt(n2);
                String string = iLiteral.getValue().length() >= MAX_LIT_CHAR_COUNT ? iLiteral.getValue().substring(0, MAX_LIT_CHAR_COUNT) + " ..." : iLiteral.getValue();
                iLiteral.getGlyphText().setText(string);
                ++n2;
            }
        }
    }

    void setMode(int n) {
        if (n != 11) {
            this.geomMngr.destroyLastResizer();
        }
        this.eeh.mode = n;
    }

    void updatePropertyBrowser(INode iNode) {
        if (ConfigManager.showNSWindow && this.tblp.tabbedPane.getSelectedIndex() == 2) {
            this.tblp.updatePropertyBrowser(iNode, true);
        }
    }

    void quickSearch(String string) {
        if (string.length() > 0) {
            Vector vector;
            if (!string.toLowerCase().equals(this.lastSearchedString)) {
                this.lastSearchedString = string.toLowerCase();
                this.searchIndex = -1;
                this.matchingList.removeAllElements();
                vector = vsm.getVirtualSpace(mainVirtualSpace).getVisibleGlyphs();
                int n = 0;
                while (n < vector.size()) {
                    if (((Glyph)vector.elementAt(n)).getText() != null && ((Glyph)vector.elementAt(n)).getText().toLowerCase().indexOf(this.lastSearchedString) != -1) {
                        this.matchingList.add(vector.elementAt(n));
                    }
                    ++n;
                }
            }
            if (this.matchingList.size() > 0) {
                if (this.searchIndex < this.matchingList.size() - 1) {
                    ++this.searchIndex;
                } else {
                    vsm.getActiveView().setStatusBarText("Reached end of list, going back to the beginning");
                    this.searchIndex = 0;
                }
                vector = (Glyph)this.matchingList.elementAt(this.searchIndex);
                if (this.lastMatchingEntity != null) {
                    this.resetINodeColors(this.lastMatchingEntity);
                }
                this.lastMatchingEntity = (INode)vector.getOwner();
                vector.setHSVColor(ConfigManager.srhTh, ConfigManager.srhTs, ConfigManager.srhTv);
                vsm.centerOnGlyph((Glyph)vector, vsm.getVirtualSpace(mainVirtualSpace).getCamera(0), 400);
            }
        }
    }

    void resetQuickSearch() {
        this.searchIndex = -1;
        this.lastSearchedString = "";
        this.matchingList.removeAllElements();
        if (this.lastMatchingEntity != null) {
            this.resetINodeColors(this.lastMatchingEntity);
            this.lastMatchingEntity = null;
        }
    }

    void resetINodeColors(INode iNode) {
        if (this.lastMatchingEntity.isSelected()) {
            this.lastMatchingEntity.getGlyphText().setHSVColor(ConfigManager.selTh, ConfigManager.selTs, ConfigManager.selTv);
        } else if (this.lastMatchingEntity.isCommented()) {
            this.lastMatchingEntity.getGlyphText().setHSVColor(ConfigManager.comTh, ConfigManager.comTs, ConfigManager.comTv);
        } else if (this.lastMatchingEntity instanceof IResource) {
            this.lastMatchingEntity.getGlyphText().setHSVColor(ConfigManager.resTBh, ConfigManager.resTBs, ConfigManager.resTBv);
        } else if (this.lastMatchingEntity instanceof IProperty) {
            this.lastMatchingEntity.getGlyphText().setHSVColor(ConfigManager.prpTh, ConfigManager.prpTs, ConfigManager.prpTv);
        } else {
            this.lastMatchingEntity.getGlyphText().setHSVColor(ConfigManager.litTBh, ConfigManager.litTBs, ConfigManager.litTBv);
        }
    }

    void cutSelection() {
        if (lastSelectedItem != null) {
            this.propsp.reset();
            this.resetCopied();
            ISVCut iSVCut = new ISVCut(this, this.selectedPredicates, this.selectedResources, this.selectedLiterals);
            iSVCut._do();
            this.addCmdToUndoStack(iSVCut);
            this.cmp.enablePaste(true);
        }
    }

    void copySelection() {
        if (lastSelectedItem != null) {
            this.resetCopied();
            ISVCopy iSVCopy = new ISVCopy(this, this.selectedPredicates, this.selectedResources, this.selectedLiterals);
            iSVCopy._do();
            this.cmp.enablePaste(true);
        }
    }

    void pasteSelection(long l, long l2) {
        ISVPaste iSVPaste = new ISVPaste(this, this.copiedPredicates, this.copiedResources, this.copiedLiterals, l, l2);
        iSVPaste._do();
        this.addCmdToUndoStack(iSVPaste);
    }

    void deleteSelectedEntities() {
        if (lastSelectedItem != null) {
            IProperty iProperty;
            this.propsp.reset();
            int n = 0;
            while (n < this.selectedResources.size()) {
                Enumeration enumeration;
                Vector vector = ((IResource)this.selectedResources.elementAt(n)).getIncomingPredicates();
                if (vector != null) {
                    enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        iProperty = (IProperty)enumeration.nextElement();
                        if (iProperty.isSelected()) continue;
                        this.selectPredicate(iProperty, true);
                    }
                }
                if ((vector = ((IResource)this.selectedResources.elementAt(n)).getOutgoingPredicates()) != null) {
                    enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        iProperty = (IProperty)enumeration.nextElement();
                        if (iProperty.isSelected()) continue;
                        this.selectPredicate(iProperty, true);
                    }
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < this.selectedLiterals.size()) {
                iProperty = ((ILiteral)this.selectedLiterals.elementAt(n2)).getIncomingPredicate();
                if (iProperty != null && !iProperty.isSelected()) {
                    this.selectPredicate(iProperty, true);
                }
                ++n2;
            }
            ISVDelete iSVDelete = new ISVDelete(this, this.selectedPredicates, this.selectedResources, this.selectedLiterals);
            iSVDelete._do();
            this.addCmdToUndoStack(iSVDelete);
        }
    }

    void undo() {
        if (this.undoIndex >= 0) {
            this.undoStack[this.undoIndex]._undo();
            this.undoStack[this.undoIndex] = null;
            --this.undoIndex;
            if (this.undoIndex < 0) {
                this.undoIndex = -1;
                this.cmp.enableUndo(false);
            }
        }
    }

    void addCmdToUndoStack(ISVCommand iSVCommand) {
        int n = Utils.getFirstEmptyIndex(this.undoStack);
        if (n == -1) {
            Utils.eraseFirstAddNewElem(this.undoStack, iSVCommand);
            this.undoIndex = this.undoStack.length - 1;
        } else {
            this.undoStack[n] = iSVCommand;
            this.undoIndex = n;
        }
        this.cmp.enableUndo(true);
    }

    void displayRawRDFXMLFile() {
        try {
            if (this.rdfLdr == null) {
                this.rdfLdr = new RDFLoader(this);
            }
            this.rdfLdr.generateJenaModel();
            StringBuffer stringBuffer = this.rdfLdr.serialize(this.rdfModel);
            TextViewer textViewer = new TextViewer(stringBuffer, "Raw RDF/XML Viewer", 0);
        }
        catch (Exception exception) {
            System.err.println("Error: Editor.displayRawFile: " + exception);
        }
    }

    void reLayoutGraph() {
        Object[] objectArray = new Object[]{"Yes", "No"};
        int n = JOptionPane.showOptionDialog(null, "This will call GraphViz/DOT to compute a new layout for the model.\nThe new layout might be completely different from the current one, and you will not be able to undo this operation.\nDo you want to proceed?", "Warning", -1, 2, null, objectArray, objectArray[0]);
        if (n == 0) {
            File file = Utils.createTempFile(m_TmpDir.toString(), "tmp", ".rdf");
            file.delete();
            this.exportRDF(file);
            this.reset();
            this.loadRDF(file, RDFLoader.RDF_XML_READER);
        }
    }

    void displayResOutgoingPredicates(IResource iResource) {
        new PropertySummary(iResource, this);
    }

    void showErrorMessages() {
        new TextViewer(this.errorMessages, "Error log", 1000);
        vsm.getView(mainView).setStatusBarText("");
    }

    void showPrjSummary() {
        Object object;
        int n = 0;
        Enumeration enumeration = this.propertiesByURI.elements();
        while (enumeration.hasMoreElements()) {
            object = ((Vector)enumeration.nextElement()).elements();
            while (object.hasMoreElements()) {
                object.nextElement();
                ++n;
            }
        }
        object = projectFile == null ? "" : projectFile.toString();
        JOptionPane.showMessageDialog(this.cmp, "Project File: " + (String)object + "\n" + "Number of resources: " + this.resourcesByURI.size() + "\n" + "Number of literals: " + this.literals.size() + "\n" + "Number of statements: " + n);
    }

    void displayURLinBrowser(IResource iResource) {
        if (!iResource.isAnon()) {
            if (webBrowser == null) {
                webBrowser = new WebBrowser(this);
            }
            webBrowser.show(iResource.getIdent());
        } else {
            vsm.getActiveView().setStatusBarText("Anonymous resources do not have a URI");
        }
    }

    void alwaysUpdateViews(boolean bl) {
        vsm.setRepaintPolicy(bl);
    }

    void setAntialiasing(boolean bl) {
        ANTIALIASING = bl;
        vsm.getView(mainView).setAntialiasing(ANTIALIASING);
    }

    void saveConfig() {
        this.cfgMngr.saveConfig();
    }

    public void exit() {
        this.cfgMngr.saveURLs();
        System.exit(0);
    }

    void summary() {
        System.out.println("Resources " + this.resourcesByURI.size());
        System.out.println("Literals " + this.literals.size());
        int n = 0;
        Enumeration enumeration = this.propertiesByURI.elements();
        while (enumeration.hasMoreElements()) {
            Enumeration enumeration2 = ((Vector)enumeration.nextElement()).elements();
            while (enumeration2.hasMoreElements()) {
                enumeration2.nextElement();
                ++n;
            }
        }
        System.out.println("Properties " + n);
    }

    void nsBindings() {
        System.out.println("Namespace bindings");
        int n = 0;
        while (n < this.tblp.nsTableModel.getRowCount()) {
            System.out.println("p=" + this.tblp.nsTableModel.getValueAt(n, 0) + " uri=" + this.tblp.nsTableModel.getValueAt(n, 1) + " disp=" + this.tblp.nsTableModel.getValueAt(n, 2));
            ++n;
        }
    }

    void printClipboard() {
        int n;
        System.out.println("Clipboard");
        System.out.print("[");
        if (!this.copiedResources.isEmpty()) {
            n = 0;
            while (n < this.copiedResources.size() - 1) {
                System.out.print(this.copiedResources.elementAt(n).toString() + ",");
                ++n;
            }
            System.out.println(this.copiedResources.lastElement().toString() + "]");
        }
        if (!this.copiedLiterals.isEmpty()) {
            System.out.print("[");
            n = 0;
            while (n < this.copiedLiterals.size() - 1) {
                System.out.print(this.copiedLiterals.elementAt(n).toString() + ",");
                ++n;
            }
            System.out.println(this.copiedLiterals.lastElement().toString() + "]");
        }
        if (!this.copiedPredicates.isEmpty()) {
            System.out.print("[");
            n = 0;
            while (n < this.copiedPredicates.size() - 1) {
                System.out.print(this.copiedPredicates.elementAt(n).toString() + ",");
                ++n;
            }
            System.out.println(this.copiedPredicates.lastElement().toString() + "]");
        }
    }

    public static void commandLineHelp() {
        System.out.println("Usage : ");
        System.out.println("  java org.w3c.IsaView [options] [file_name.isv|file_name.rdf]");
        System.out.println("  Options:");
        System.out.println("          -I  launch IsaViz in Internal Frames mode (your operating system will only manage one IsaViz window)");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 2) {
            Editor.commandLineHelp();
        } else if (stringArray.length == 2) {
            argFile = stringArray[2];
            if (stringArray[1].equals("-I")) {
                ConfigManager.internalFrames = true;
            } else {
                Editor.commandLineHelp();
            }
        } else if (stringArray.length == 1) {
            argFile = stringArray[0];
        }
        Editor editor = new Editor();
    }

    static {
        tmpRdfFile = "tmp/serial.rdf";
        m_GraphVizPath = new File("C:\\ATT\\Graphviz\\bin\\dot.exe");
        m_GraphVizFontDir = new File("C:\\ATT\\Graphviz");
        m_TmpDir = new File("tmp");
        projectDir = new File("projects");
        lastOpenPrjDir = null;
        lastSavePrjDir = null;
        rdfDir = new File("export");
        lastImportRDFDir = null;
        lastExportRDFDir = null;
        dltOnExit = true;
        MAX_BRW_LIST_SIZE = 10;
        UNDO_SIZE = 5;
        SAVE_WINDOW_LAYOUT = false;
        ARROW_HEAD_SIZE = 5;
        smallFont = new Font("Dialog", 0, 10);
        tinyFont = new Font("Dialog", 0, 9);
        vtmFontName = "Dialog";
        vtmFontSize = 10;
        vtmFont = new Font(vtmFontName, 0, vtmFontSize);
        ANTIALIASING = false;
        autoDetectBrowser = true;
        browserPath = new File("");
        browserOptions = "";
        useProxy = false;
        proxyHost = "";
        proxyPort = "80";
    }
}

