/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.common;

import com.hp.hpl.mesa.rdf.jena.common.ContNodeIteratorFactoryImpl;
import com.hp.hpl.mesa.rdf.jena.common.ContainerI;
import com.hp.hpl.mesa.rdf.jena.common.LiteralImpl;
import com.hp.hpl.mesa.rdf.jena.common.ModelI;
import com.hp.hpl.mesa.rdf.jena.common.NodeIteratorFactory;
import com.hp.hpl.mesa.rdf.jena.common.ResourceImpl;
import com.hp.hpl.mesa.rdf.jena.model.Container;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.NodeIterator;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import com.hp.hpl.mesa.rdf.jena.vocabulary.RDF;

public class ContainerImpl
extends ResourceImpl
implements Container,
ContainerI {
    static NodeIteratorFactory iteratorFactory = new ContNodeIteratorFactoryImpl();

    public ContainerImpl(Model model) throws RDFException {
        super(model);
    }

    public ContainerImpl(String string, Model model) throws RDFException {
        super(string, model);
    }

    public ContainerImpl(Resource resource, Model model) throws RDFException {
        super(resource, model);
    }

    public Container add(RDFNode rDFNode) throws RDFException {
        int n = this.size();
        this.addProperty(RDF.li(n + 1), rDFNode);
        return this;
    }

    public Container add(boolean bl) throws RDFException {
        return this.add(new LiteralImpl(bl));
    }

    public Container add(long l) throws RDFException {
        return this.add(new LiteralImpl(l));
    }

    public Container add(char c) throws RDFException {
        return this.add(new LiteralImpl(c));
    }

    public Container add(float f) throws RDFException {
        return this.add(new LiteralImpl(f));
    }

    public Container add(double d) throws RDFException {
        return this.add(new LiteralImpl(d));
    }

    public Container add(String string) throws RDFException {
        return this.add(new LiteralImpl(string));
    }

    public Container add(String string, String string2) throws RDFException {
        return this.add(new LiteralImpl(string, string2));
    }

    public Container add(Object object) throws RDFException {
        return this.add(new LiteralImpl(object));
    }

    public boolean contains(RDFNode rDFNode) throws RDFException {
        return ((ModelI)((Object)this.model)).containerContains(this, rDFNode);
    }

    public boolean contains(boolean bl) throws RDFException {
        return this.contains(new LiteralImpl(bl));
    }

    public boolean contains(long l) throws RDFException {
        return this.contains(new LiteralImpl(l));
    }

    public boolean contains(char c) throws RDFException {
        return this.contains(new LiteralImpl(c));
    }

    public boolean contains(float f) throws RDFException {
        return this.contains(new LiteralImpl(f));
    }

    public boolean contains(double d) throws RDFException {
        return this.contains(new LiteralImpl(d));
    }

    public boolean contains(String string) throws RDFException {
        return this.contains(new LiteralImpl(string));
    }

    public boolean contains(String string, String string2) throws RDFException {
        return this.contains(new LiteralImpl(string, string2));
    }

    public boolean contains(Object object) throws RDFException {
        return this.contains(new LiteralImpl(object));
    }

    public NodeIterator iterator() throws RDFException {
        return ((ModelI)((Object)this.model)).listContainerMembers(this, iteratorFactory);
    }

    public int size() throws RDFException {
        return ((ModelI)((Object)this.model)).containerSize(this);
    }

    public Container remove(Statement statement) throws RDFException {
        int n = this.size();
        Statement statement2 = null;
        if (statement.getPredicate().getOrdinal() == n) {
            this.model.remove(statement);
        } else {
            statement2 = this.model.getProperty(this, RDF.li(n));
            statement.set(statement2.getObject());
            this.model.remove(statement2);
        }
        if (this.size() != n - 1) {
            throw new RDFException(17);
        }
        return this;
    }

    public Container remove(int n, RDFNode rDFNode) throws RDFException {
        this.remove(this.model.createStatement((Resource)this, RDF.li(n), rDFNode));
        return this;
    }
}

