/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.bdb;

import com.hp.hpl.jena.util.Log;
import com.hp.hpl.mesa.rdf.jena.bdb.BDBException;
import com.hp.hpl.mesa.rdf.jena.bdb.ByteSerializer;
import com.hp.hpl.mesa.rdf.jena.common.NsIteratorImpl;
import com.hp.hpl.mesa.rdf.jena.common.ResIteratorImpl;
import com.hp.hpl.mesa.rdf.jena.common.StatementImpl;
import com.hp.hpl.mesa.rdf.jena.common.Store;
import com.hp.hpl.mesa.rdf.jena.common.StoreCom;
import com.hp.hpl.mesa.rdf.jena.model.ClosableIterator;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.NsIterator;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFError;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.ResIterator;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import com.sleepycat.db.Db;
import com.sleepycat.db.DbEnv;
import com.sleepycat.db.DbException;
import com.sleepycat.db.DbMemoryException;
import com.sleepycat.db.DbTxn;
import com.sleepycat.db.Dbc;
import com.sleepycat.db.Dbt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

abstract class _StoreBdb
extends StoreCom
implements Store {
    protected static final int MAGICNUMBER = 0xBDB0BDB;
    Db db0;
    Db db1;
    Db db2;
    Db db3;
    Model model = null;
    protected static String envDir;
    protected File lockFile;
    boolean open;
    int size;
    boolean stmtAdded;
    boolean stmtDeleted;
    String filename;
    Configuration configuration = new Configuration();
    protected static DbEnv dbEnv;

    public _StoreBdb(String string, String string2, Model model) throws BDBException {
        this.configuration.magicNumber = 0xBDB0BDB;
        this.configuration.version = 1;
        this.configuration.size = 0;
        this.model = model;
        this.filename = string2;
        this.createEnv(string);
        this.openDb(string2);
        this.size = this.readConfig() == 0 ? this.configuration.size : -1;
        this.configuration.size = -1;
        this.writeConfig(this.configuration);
        this.open = true;
    }

    public synchronized void close() {
        block5: {
            try {
                if (!this.open) break block5;
                this.configuration.size = this.size;
                try {
                    this.writeConfig(this.configuration);
                }
                catch (BDBException bDBException) {
                    Log.warning("Failed to update size when closing database", "_StoreDb", "close", bDBException);
                }
                if (!this.lockFile.delete()) {
                    Log.warning("failed to delete lock file", "_StoreDb", "close()");
                }
                this.db0.close(0);
                this.db1.close(0);
                this.db2.close(0);
                this.db3.close(0);
            }
            catch (DbException dbException) {
                Log.warning("Exception whilst closing database", "_StoreDb", "close()", dbException);
            }
        }
        this.open = false;
    }

    protected DbEnv createEnv(String string) throws BDBException {
        envDir = string == null ? System.getProperty("com.hp.hpl.mesa.rdf.jena.bdbenv", "/Jena/RDF/bdb") : string;
        File file = new File(envDir);
        if (file.exists()) {
            if (!file.isDirectory()) {
                Log.severe("BDB env is not a directory", "StoreDb", "createEnv");
                throw new BDBException(101);
            }
        } else if (!file.mkdirs()) {
            Log.severe("Cannot create DBD env directory", "StoreDb", "createEnv");
            throw new BDBException(102);
        }
        try {
            dbEnv = new MyDbEnv(0);
            dbEnv.open(file.getAbsolutePath(), Db.DB_CREATE | Db.DB_INIT_MPOOL, 0);
        }
        catch (Exception exception) {
            Log.severe("failed to open Berkeley DB environment", "StoreDb", "createEnv", exception);
            throw new RDFError(exception);
        }
        return dbEnv;
    }

    protected void openDb(String string) throws BDBException {
        try {
            this.lockFile = new File(envDir + "/" + string + ".lck");
            if (!this.lockFile.createNewFile()) {
                throw new BDBException(103);
            }
            this.lockFile.deleteOnExit();
        }
        catch (IOException iOException) {
            Log.severe("lockfile error", this.getClass().getName(), "openDb", iOException);
            throw new RDFError(iOException);
        }
        try {
            this.db0 = new Db(dbEnv, 0);
            this.db0.open(string, "config", 3, Db.DB_CREATE, 0);
            this.db1 = new Db(dbEnv, 0);
            this.db1.set_flags(Db.DB_DUPSORT);
            this.db1.open(string, "SP->O", 1, Db.DB_CREATE, 0);
            this.db2 = new Db(dbEnv, 0);
            this.db2.set_flags(Db.DB_DUPSORT);
            this.db2.open(string, "PO->S", 1, Db.DB_CREATE, 0);
            this.db3 = new Db(dbEnv, 0);
            this.db3.set_flags(Db.DB_DUPSORT);
            this.db3.open(string, "OS->P", 1, Db.DB_CREATE, 0);
        }
        catch (Exception exception) {
            Log.severe("failed to open Berkeley DB database", "_StoreDb", "openDb", exception);
            throw new BDBException(104);
        }
    }

    protected int readConfig() throws BDBException {
        int n;
        byte[] byArray = new byte[4];
        Dbt dbt = new Dbt(byArray);
        dbt.set_ulen(4);
        dbt.set_recno_key_data(1);
        dbt.set_flags(Db.DB_DBT_USERMEM);
        byte[] byArray2 = this.configToBytes(this.configuration);
        Dbt dbt2 = new Dbt(byArray2);
        dbt2.set_ulen(byArray2.length);
        dbt2.set_flags(Db.DB_DBT_USERMEM);
        try {
            n = this.db0.get(null, dbt, dbt2, 0);
        }
        catch (DbException dbException) {
            Log.severe("failed to read DB configuration record", this.getClass().getName(), "readConfig", dbException);
            throw new RDFError((Exception)((Object)dbException));
        }
        this.configuration = this.configFromBytes(dbt2.get_data());
        return n;
    }

    protected void writeConfig(Configuration configuration) throws BDBException {
        byte[] byArray = new byte[4];
        Dbt dbt = new Dbt(byArray);
        dbt.set_ulen(4);
        dbt.set_recno_key_data(1);
        dbt.set_flags(Db.DB_DBT_USERMEM);
        byte[] byArray2 = this.configToBytes(configuration);
        Dbt dbt2 = new Dbt(byArray2);
        dbt2.set_ulen(byArray2.length);
        dbt2.set_flags(Db.DB_DBT_USERMEM);
        try {
            this.db0.put(null, dbt, dbt2, 0);
        }
        catch (DbException dbException) {
            throw new BDBException((Exception)((Object)dbException));
        }
    }

    protected byte[] configToBytes(Configuration configuration) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(configuration.magicNumber);
            dataOutputStream.writeInt(configuration.version);
            dataOutputStream.writeInt(configuration.size);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            Log.severe("Failed to convert configuration to bytes", "_StoreDb", "configToBytes", iOException);
            throw new RDFError(iOException);
        }
    }

    protected Configuration configFromBytes(byte[] byArray) throws BDBException {
        Configuration configuration = new Configuration();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            configuration.magicNumber = dataInputStream.readInt();
            if (configuration.magicNumber != 0xBDB0BDB) {
                throw new BDBException(105);
            }
            configuration.version = dataInputStream.readInt();
            configuration.size = dataInputStream.readInt();
            return configuration;
        }
        catch (IOException iOException) {
            throw new BDBException(106);
        }
    }

    protected synchronized void add(Statement statement, DbTxn dbTxn) {
        byte[] byArray = null;
        byte[] byArray2 = ByteSerializer.toBytes(statement.getSubject());
        byte[] byArray3 = ByteSerializer.toBytes(statement.getPredicate());
        byte[] byArray4 = ByteSerializer.toBytes(statement.getObject());
        try {
            byArray = this.concat(byArray2, byArray3);
            Dbt dbt = new Dbt(byArray);
            dbt.set_ulen(byArray.length);
            dbt.set_flags(Db.DB_DBT_USERMEM);
            Dbt dbt2 = new Dbt(byArray4);
            dbt2.set_ulen(byArray4.length);
            dbt.set_flags(Db.DB_DBT_USERMEM);
            if (this.db1.put(dbTxn, dbt, dbt2, Db.DB_NODUPDATA) != -30996) {
                byArray = this.concat(byArray3, byArray4);
                dbt = new Dbt(byArray);
                dbt.set_ulen(byArray.length);
                dbt.set_flags(Db.DB_DBT_USERMEM);
                dbt2 = new Dbt(byArray2);
                dbt2.set_ulen(byArray2.length);
                dbt2.set_flags(Db.DB_DBT_USERMEM);
                this.db2.put(dbTxn, dbt, dbt2, Db.DB_NODUPDATA);
                byArray = this.concat(byArray4, byArray2);
                dbt = new Dbt(byArray);
                dbt.set_ulen(byArray.length);
                dbt.set_flags(Db.DB_DBT_USERMEM);
                dbt2 = new Dbt(byArray3);
                dbt2.set_ulen(byArray3.length);
                dbt2.set_flags(Db.DB_DBT_USERMEM);
                this.db3.put(dbTxn, dbt, dbt2, Db.DB_NODUPDATA);
                this.stmtAdded = true;
            }
        }
        catch (DbException dbException) {
            Log.severe("Failed to add statement", "StoreDb", "add", dbException);
            throw new RDFError((Exception)((Object)dbException));
        }
    }

    protected synchronized void remove(Statement statement, DbTxn dbTxn) {
        byte[] byArray = ByteSerializer.toBytes(statement.getSubject());
        byte[] byArray2 = ByteSerializer.toBytes(statement.getPredicate());
        byte[] byArray3 = ByteSerializer.toBytes(statement.getObject());
        this.remove(this.db1, this.concat(byArray, byArray2), byArray3, dbTxn);
        this.remove(this.db2, this.concat(byArray2, byArray3), byArray, dbTxn);
        this.remove(this.db3, this.concat(byArray3, byArray), byArray2, dbTxn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void remove(Db db, byte[] byArray, byte[] byArray2, DbTxn dbTxn) {
        Dbc dbc = null;
        try {
            try {
                dbc = db.cursor(dbTxn, 0);
                Dbt dbt = new Dbt(byArray);
                dbt.set_flags(Db.DB_DBT_USERMEM);
                dbt.set_ulen(byArray.length);
                Dbt dbt2 = new Dbt(byArray2);
                dbt2.set_flags(Db.DB_DBT_USERMEM);
                dbt2.set_ulen(byArray2.length);
                if (dbc.get(dbt, dbt2, Db.DB_GET_BOTH) != -30990) {
                    this.stmtDeleted = true;
                    dbc.del(0);
                }
            }
            catch (DbException dbException) {
                Log.severe("remove statement failed", "StoreDb", "remove(Db, byte[], byte[])", dbException);
                throw new RDFError((Exception)((Object)dbException));
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (dbc == null) throw throwable;
                dbc.close();
                throw throwable;
            }
            catch (DbException dbException) {
                Log.severe("failed to close cursor", "StoreDb", "remove(Db, byte[], byte[])", dbException);
                throw new RDFError((Exception)((Object)dbException));
            }
        }
        try {}
        catch (DbException dbException) {
            Log.severe("failed to close cursor", "StoreDb", "remove(Db, byte[], byte[])", dbException);
            throw new RDFError((Exception)((Object)dbException));
        }
        if (dbc == null) return;
        dbc.close();
    }

    public synchronized int size() throws RDFException {
        Iterator iterator = this.list();
        this.size = 0;
        while (iterator.hasNext()) {
            ++this.size;
            iterator.next();
        }
        return this.size;
    }

    public synchronized boolean contains(Statement statement) throws RDFException {
        byte[] byArray = ByteSerializer.toBytes(statement.getSubject());
        byte[] byArray2 = ByteSerializer.toBytes(statement.getPredicate());
        RDFNode rDFNode = statement.getObject();
        Iterator iterator = this.listFullKey(this.db1, this.concat(byArray, byArray2), 4);
        boolean bl = false;
        while (iterator.hasNext()) {
            if (!((Statement)iterator.next()).getObject().equals(rDFNode)) continue;
            bl = true;
            break;
        }
        ((ClosableIterator)iterator).close();
        return bl;
    }

    public synchronized boolean contains(Resource resource, Property property) throws RDFException {
        byte[] byArray = ByteSerializer.toBytes(resource);
        byte[] byArray2 = ByteSerializer.toBytes(property);
        try {
            byte[] byArray3 = this.concat(byArray, byArray2);
            Dbt dbt = new Dbt(byArray3);
            dbt.set_flags(Db.DB_DBT_USERMEM);
            dbt.set_ulen(byArray3.length);
            byte[] byArray4 = new byte[]{};
            Dbt dbt2 = new Dbt(byArray4);
            dbt2.set_flags(Db.DB_DBT_USERMEM | Db.DB_DBT_PARTIAL);
            dbt2.set_ulen(byArray4.length);
            return this.db1.get(null, dbt, dbt2, 0) != -30990;
        }
        catch (DbException dbException) {
            Log.severe("check for presence failed", "StoreDb", "contains(Resource, Property)", dbException);
            throw new RDFError((Exception)((Object)dbException));
        }
    }

    public synchronized Iterator list() throws RDFException {
        return new Lookup(this.db1, this, new byte[0], 4, Db.DB_FIRST, Db.DB_NEXT);
    }

    public synchronized Iterator list(Resource resource, Property property, RDFNode rDFNode) throws RDFException {
        int n = 0;
        if (resource != null) {
            n |= 1;
        }
        if (property != null) {
            n |= 2;
        }
        if (rDFNode != null) {
            n |= 4;
        }
        switch (n) {
            case 0: {
                return this.list();
            }
            case 1: {
                return this.listBySubject(resource);
            }
            case 2: {
                return this.listByPredicate(property);
            }
            case 4: {
                return this.listByObject(rDFNode);
            }
            case 3: {
                return this.listFullKey(this.db1, this.concat(ByteSerializer.toBytes(resource), ByteSerializer.toBytes(property)), 4);
            }
            case 5: {
                return this.listFullKey(this.db3, this.concat(ByteSerializer.toBytes(rDFNode), ByteSerializer.toBytes(resource)), 2);
            }
            case 6: {
                return this.listFullKey(this.db2, this.concat(ByteSerializer.toBytes(property), ByteSerializer.toBytes(rDFNode)), 1);
            }
            case 7: {
                HashSet<StatementImpl> hashSet = new HashSet<StatementImpl>();
                StatementImpl statementImpl = new StatementImpl(resource, property, rDFNode, this.model);
                if (this.contains(statementImpl)) {
                    hashSet.add(statementImpl);
                }
                return hashSet.iterator();
            }
        }
        return null;
    }

    protected Iterator listFullKey(Db db, byte[] byArray, int n) {
        return new Lookup(db, this, byArray, n, Db.DB_SET, Db.DB_NEXT_DUP);
    }

    protected Iterator listPartialKey(Db db, RDFNode rDFNode, int n) {
        return new LookupPartialKey(db, this, rDFNode, n, Db.DB_SET_RANGE, Db.DB_NEXT);
    }

    public synchronized Iterator listBySubject(Resource resource) {
        return this.listPartialKey(this.db1, resource, 4);
    }

    public synchronized Iterator listByPredicate(Property property) {
        return this.listPartialKey(this.db2, property, 1);
    }

    public synchronized Iterator listByObject(RDFNode rDFNode) {
        return this.listPartialKey(this.db3, rDFNode, 2);
    }

    public synchronized ResIterator listSubjects() {
        return new ResIteratorImpl(new LookupUniqSubj(this), null);
    }

    public synchronized NsIterator listNameSpaces() {
        return new NsIteratorImpl(new LookupUniqNs(this), null);
    }

    protected byte[] concat(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        boolean bl = false;
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    static {
        dbEnv = null;
    }

    class MyDbEnv
    extends DbEnv {
        MyDbEnv(int n) {
            super(n);
        }

        public void finalize() {
            try {
                super.close(0);
            }
            catch (DbException dbException) {
                Log.warning("Error on closing DbEnv", "MyDbEnv", "finalize", dbException);
            }
        }
    }

    protected class LookupUniqNs
    extends Lookup {
        LookupUniqNs(_StoreBdb _StoreBdb3) {
            super(_StoreBdb3.db2, _StoreBdb3, new byte[0], 1, Db.DB_FIRST, Db.DB_NEXT_NODUP);
        }

        public Object next() throws NoSuchElementException {
            Statement statement = (Statement)super.next();
            return statement.getPredicate().getNameSpace();
        }

        protected boolean filter() {
            Property property = (Property)this.n1;
            if (this.filterVar != null && property.getNameSpace().equals(((Property)this.filterVar).getNameSpace())) {
                return true;
            }
            this.filterVar = this.n1;
            return false;
        }
    }

    protected class LookupUniqSubj
    extends Lookup {
        LookupUniqSubj(_StoreBdb _StoreBdb3) {
            super(_StoreBdb3.db1, _StoreBdb3, new byte[0], 4, Db.DB_FIRST, Db.DB_NEXT_NODUP);
        }

        public Object next() throws NoSuchElementException {
            Statement statement = (Statement)super.next();
            return statement.getSubject();
        }

        protected boolean filter() {
            if (this.filterVar != null && this.n1.equals(this.filterVar)) {
                return true;
            }
            this.filterVar = this.n1;
            return false;
        }
    }

    protected class LookupPartialKey
    extends Lookup {
        LookupPartialKey(Db db, _StoreBdb _StoreBdb3, RDFNode rDFNode, int n, int n2, int n3) {
            super(db, _StoreBdb3, rDFNode, n, n2, n3);
        }

        protected boolean endCondition() {
            return !this.n1.equals(this.nKey);
        }
    }

    protected class Lookup
    implements ClosableIterator {
        Db db;
        _StoreBdb store;
        int vx = 0;
        RDFNode nKey = null;
        Dbt key;
        Dbt val;
        Dbc cur;
        boolean open = false;
        int flagN;
        RDFNode n1;
        RDFNode n2;
        RDFNode n3;
        boolean more;
        RDFNode filterVar = null;
        Statement stmt;
        byte[] keydata;
        byte[] valdata;

        Lookup(Db db, _StoreBdb _StoreBdb3, RDFNode rDFNode, int n, int n2, int n3) {
            this.nKey = rDFNode;
            this.init(db, _StoreBdb3, ByteSerializer.toBytes(rDFNode), n, n2, n3);
        }

        Lookup(Db db, _StoreBdb _StoreBdb3, byte[] byArray, int n, int n2, int n3) {
            this.init(db, _StoreBdb3, byArray, n, n2, n3);
        }

        protected void init(Db db, _StoreBdb _StoreBdb2, byte[] byArray, int n, int n2, int n3) {
            this.db = db;
            this.store = _StoreBdb2;
            this.vx = n;
            this.flagN = n3;
            try {
                this.cur = db.cursor(null, 0);
                this.open = true;
                this.key = new Dbt(byArray);
                this.key.set_flags(Db.DB_DBT_USERMEM);
                this.key.set_ulen(byArray.length);
                this.keydata = byArray;
                this.valdata = new byte[0];
                this.val = new Dbt(this.valdata);
                this.val.set_flags(Db.DB_DBT_USERMEM);
                this.val.set_ulen(0);
                this.getNext(n2);
            }
            catch (NoSuchElementException noSuchElementException) {
                this.more = false;
            }
            catch (DbException dbException) {
                throw new RDFError((Exception)((Object)dbException));
            }
        }

        public void close() {
            if (this.open && this.store.open) {
                try {
                    _StoreBdb _StoreBdb2 = this.store;
                    synchronized (_StoreBdb2) {
                        this.cur.close();
                    }
                    this.open = false;
                }
                catch (DbException dbException) {
                    Log.warning("Finalizer failed", "Lookup", "finalize()", dbException);
                }
            }
        }

        public void finalize() {
            this.close();
        }

        public boolean hasNext() {
            return this.more;
        }

        public Object next() throws NoSuchElementException {
            if (!this.more) {
                throw new NoSuchElementException();
            }
            try {
                switch (this.vx) {
                    case 1: {
                        this.stmt = new StatementImpl((Resource)this.n3, (Property)this.n1, this.n2, _StoreBdb.this.model);
                        break;
                    }
                    case 2: {
                        this.stmt = new StatementImpl((Resource)this.n2, (Property)this.n3, this.n1, _StoreBdb.this.model);
                        break;
                    }
                    case 4: {
                        this.stmt = new StatementImpl((Resource)this.n1, (Property)this.n2, this.n3, _StoreBdb.this.model);
                    }
                }
                this.getNext(this.flagN);
                return this.stmt;
            }
            catch (Exception exception) {
                Log.severe("unexpected exception", "Lookup", "next", exception);
                throw new RDFError(exception);
            }
        }

        public void remove() throws UnsupportedOperationException, IllegalStateException {
        }

        protected void getNext(int n) {
            int n2 = 0;
            do {
                int n3 = 0;
                while (n3 < 3) {
                    try {
                        n2 = this.cur.get(this.key, this.val, n);
                        break;
                    }
                    catch (DbMemoryException dbMemoryException) {
                        if (n3 == 2) {
                            Log.severe("failed to read record", this.getClass().getName(), "getNext", dbMemoryException);
                            throw new RDFError((Exception)((Object)dbMemoryException));
                        }
                        int n4 = this.key.get_size();
                        if (n4 > this.key.get_ulen()) {
                            this.keydata = new byte[n4];
                            System.arraycopy(this.key.get_data(), 0, this.keydata, 0, this.key.get_ulen());
                            this.key.set_data(this.keydata);
                            this.key.set_ulen(n4);
                        }
                        if ((n4 = this.val.get_size()) > this.val.get_ulen()) {
                            this.valdata = new byte[n4];
                            this.val.set_data(this.valdata);
                            this.val.set_ulen(n4);
                        }
                    }
                    catch (DbException dbException) {
                        Log.severe("failed to read next record", this.getClass().getName(), "getNext", dbException);
                        throw new RDFError((Exception)((Object)dbException));
                    }
                    ++n3;
                }
                if (n2 != -30990) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.key.get_data());
                    DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                    try {
                        this.n1 = ByteSerializer.fromData(dataInputStream, _StoreBdb.this.model);
                        this.n2 = ByteSerializer.fromData(dataInputStream, _StoreBdb.this.model);
                        byteArrayInputStream = new ByteArrayInputStream(this.val.get_data());
                        dataInputStream = new DataInputStream(byteArrayInputStream);
                        this.n3 = ByteSerializer.fromData(dataInputStream, _StoreBdb.this.model);
                    }
                    catch (IOException iOException) {
                        Log.severe("failed to deserialize record", this.getClass().getName(), "getNext", iOException);
                        throw new RDFError(iOException);
                    }
                    this.more = !this.endCondition();
                    continue;
                }
                this.more = false;
                try {
                    this.cur.close();
                }
                catch (DbException dbException) {
                    Log.severe("failed to close cursor", this.getClass().getName(), "getNext", dbException);
                    throw new RDFError((Exception)((Object)dbException));
                }
                this.open = false;
            } while (this.more && this.filter());
        }

        protected boolean endCondition() {
            return false;
        }

        protected boolean filter() {
            return false;
        }
    }

    class Configuration {
        int magicNumber;
        int version;
        int size;

        Configuration() {
        }
    }
}

