/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query.parser;

import com.hp.hpl.jena.rdf.query.Environment;
import com.hp.hpl.jena.rdf.query.Query;
import com.hp.hpl.jena.rdf.query.QueryException;
import com.hp.hpl.jena.rdf.query.QueryFormatUtils;
import com.hp.hpl.jena.rdf.query.Settable;
import com.hp.hpl.jena.rdf.query.Value;
import com.hp.hpl.jena.rdf.query.WorkingVar;
import com.hp.hpl.jena.rdf.query.parser.Expr;
import com.hp.hpl.jena.rdf.query.parser.ExprBoolean;
import com.hp.hpl.jena.rdf.query.parser.RDQLParser;
import com.hp.hpl.jena.rdf.query.parser.SimpleNode;
import java.io.PrintWriter;

class Q_StringNotEqual
extends SimpleNode
implements Expr,
ExprBoolean {
    Expr left;
    Expr right;
    private String printName = "str!=";
    private String opSymbol = "ne";

    Q_StringNotEqual(int n) {
        super(n);
    }

    Q_StringNotEqual(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    public Value eval(Query query, Environment environment) {
        Value value = this.left.eval(query, environment);
        Value value2 = this.right.eval(query, environment);
        String string = value.toString();
        String string2 = value2.toString();
        Settable settable = value instanceof Settable ? (Settable)value : (value2 instanceof Settable ? (Settable)value2 : new WorkingVar());
        boolean bl = !string.equals(string2);
        settable.setBoolean(bl);
        return settable;
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 2) {
            throw new QueryException("Q_StringNotEqual: Wrong number of children: " + n);
        }
        this.left = (Expr)((Object)this.jjtGetChild(0));
        this.right = (Expr)((Object)this.jjtGetChild(1));
    }

    public String asInfixString() {
        return QueryFormatUtils.asInfixString2(this.left, this.right, this.printName, this.opSymbol);
    }

    public String asPrefixString() {
        return QueryFormatUtils.asPrefixString(this.left, this.right, this.printName, this.opSymbol);
    }

    public void print(PrintWriter printWriter, int n) {
        QueryFormatUtils.print(printWriter, this.left, this.right, this.printName, this.opSymbol, n);
    }

    public String toString() {
        return this.asInfixString();
    }
}

