/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.query.parser;

import com.hp.hpl.jena.rdf.query.Environment;
import com.hp.hpl.jena.rdf.query.EvalTypeException;
import com.hp.hpl.jena.rdf.query.Query;
import com.hp.hpl.jena.rdf.query.QueryException;
import com.hp.hpl.jena.rdf.query.QueryFormatUtils;
import com.hp.hpl.jena.rdf.query.Settable;
import com.hp.hpl.jena.rdf.query.Value;
import com.hp.hpl.jena.rdf.query.WorkingVar;
import com.hp.hpl.jena.rdf.query.parser.Expr;
import com.hp.hpl.jena.rdf.query.parser.ExprNumeric;
import com.hp.hpl.jena.rdf.query.parser.RDQLParser;
import com.hp.hpl.jena.rdf.query.parser.SimpleNode;
import java.io.PrintWriter;

class Q_Add
extends SimpleNode
implements Expr,
ExprNumeric {
    Expr left;
    Expr right;
    private String printName = "add";
    private String opSymbol = "+";

    Q_Add(int n) {
        super(n);
    }

    Q_Add(RDQLParser rDQLParser, int n) {
        super(rDQLParser, n);
    }

    public Value eval(Query query, Environment environment) {
        int n = this.jjtGetNumChildren();
        Value value = this.left.eval(query, environment);
        Value value2 = this.right.eval(query, environment);
        if (!value.isNumber()) {
            throw new EvalTypeException("Q_Add: Wanted a number: " + value);
        }
        if (!value2.isNumber()) {
            throw new EvalTypeException("Q_Add: Wanted a number: " + value2);
        }
        Settable settable = value instanceof Settable ? (Settable)value : (value2 instanceof Settable ? (Settable)value2 : new WorkingVar());
        if (value.isInt() && value2.isInt()) {
            settable.setInt(value.getInt() + value2.getInt());
        } else {
            settable.setLong(value.getLong() + value2.getLong());
        }
        return settable;
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 2) {
            throw new QueryException("Q_Add: Wrong number of children: " + n);
        }
        this.left = (Expr)((Object)this.jjtGetChild(0));
        this.right = (Expr)((Object)this.jjtGetChild(1));
    }

    public String asInfixString() {
        return QueryFormatUtils.asInfixString2(this.left, this.right, this.printName, this.opSymbol);
    }

    public String asPrefixString() {
        return QueryFormatUtils.asPrefixString(this.left, this.right, this.printName, this.opSymbol);
    }

    public void print(PrintWriter printWriter, int n) {
        QueryFormatUtils.print(printWriter, this.left, this.right, this.printName, this.opSymbol, n);
    }

    public String toString() {
        return this.asInfixString();
    }
}

